/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.activity;

import java.util.Stack;
import org.eclipse.birt.report.model.activity.AbstractElementRecord;
import org.eclipse.birt.report.model.activity.ActivityRecord;
import org.eclipse.birt.report.model.activity.CompoundRecord;
import org.eclipse.birt.report.model.activity.FilterEventsCompoundRecord;
import org.eclipse.birt.report.model.activity.RecordTask;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.TransactionOption;
import org.eclipse.birt.report.model.api.command.ElementDeletedEvent;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.ReferencableStructure;

public class NotificationRecordTask
extends RecordTask {
    private Module root = null;
    private NotificationEvent event = null;
    private boolean filtered = false;

    public NotificationRecordTask(DesignElement target, NotificationEvent event) {
        super(target);
        this.event = event;
        this.root = target.getRoot();
    }

    public NotificationRecordTask(DesignElement target, NotificationEvent event, Module rootElement) {
        super(target);
        this.event = event;
        this.root = rootElement;
    }

    public NotificationRecordTask(ReferencableStructure target, NotificationEvent event) {
        super(target);
        this.event = event;
    }

    public void setFiltered(boolean filtered) {
        this.filtered = filtered;
    }

    public boolean isFiltered() {
        return this.filtered;
    }

    public NotificationEvent getEvent() {
        return this.event;
    }

    protected final boolean holdNotificationForFilterEventRecord(Stack<CompoundRecord> transStack) {
        CompoundRecord cr;
        return transStack != null && !transStack.isEmpty() && (cr = transStack.peek()) instanceof FilterEventsCompoundRecord;
    }

    protected final boolean holdNotification(ActivityRecord record, Stack<CompoundRecord> transStack) {
        if (record instanceof AbstractElementRecord) {
            CompoundRecord cr;
            TransactionOption options;
            if (transStack != null && !transStack.isEmpty() && (options = (cr = transStack.peek()).getOptions()) != null && options.getSendTime() != 0) {
                return true;
            }
        } else if (record instanceof CompoundRecord) {
            CompoundRecord cr = (CompoundRecord)record;
            TransactionOption options = cr.getOptions();
            if (options != null) {
                if (options.getSendTime() == 2 && transStack != null && !transStack.isEmpty()) {
                    return true;
                }
            } else if (transStack != null && !transStack.isEmpty()) {
                int i = transStack.size() - 1;
                while (i >= 0) {
                    CompoundRecord trans = (CompoundRecord)transStack.get(i);
                    options = trans.getOptions();
                    if (options != null && options.getSendTime() != 0) {
                        return true;
                    }
                    --i;
                }
            }
        }
        return false;
    }

    @Override
    public void doTask(ActivityRecord record, Stack<CompoundRecord> transStack) {
        if (this.holdNotificationForFilterEventRecord(transStack) || !(record instanceof FilterEventsCompoundRecord) && this.holdNotification(record, transStack)) {
            return;
        }
        if (this.getTarget() instanceof DesignElement) {
            Module theRoot;
            DesignElement elementTarget = (DesignElement)this.getTarget();
            Module module = theRoot = this.root == null ? elementTarget.getRoot() : this.root;
            if (!this.filtered && theRoot != null) {
                elementTarget.broadcast(this.event, theRoot);
            }
            if (this.event instanceof ElementDeletedEvent) {
                elementTarget.clearListeners();
            }
        } else if (this.getTarget() instanceof ReferencableStructure) {
            if (!this.filtered) {
                ((ReferencableStructure)this.getTarget()).broadcast(this.event);
            }
        } else assert (false);
    }
}

