/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.pdf;

import com.ibm.icu.util.ULocale;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfICCBased;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.color.ICC_Profile;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.ITOCTree;
import org.eclipse.birt.report.engine.api.TOCNode;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.emitter.pdf.PDFPage;
import org.eclipse.birt.report.engine.emitter.pdf.TOCHandler;
import org.eclipse.birt.report.engine.i18n.EngineResourceHandle;
import org.eclipse.birt.report.engine.internal.util.BundleVersionUtil;
import org.eclipse.birt.report.engine.ir.Expression;
import org.eclipse.birt.report.engine.layout.emitter.IPage;
import org.eclipse.birt.report.engine.layout.emitter.IPageDevice;

public class PDFPageDevice
implements IPageDevice {
    private static final String PDF_VERSION_1_3 = "1.3";
    private static final String PDF_VERSION_1_4 = "1.4";
    private static final String PDF_VERSION_1_5 = "1.5";
    private static final String PDF_VERSION_1_6 = "1.6";
    private static final String PDF_VERSION_1_7 = "1.7";
    private static final String PDF_CONFORMANCE_STANDARD = "PDF.Standard";
    private static final String PDF_CONFORMANCE_X32002 = "PDF.X32002";
    private static final String PDF_CONFORMANCE_A1A = "PDF.A1A";
    private static final String PDF_CONFORMANCE_A1B = "PDF.A1B";
    private static final String PDF_ICC_PROFILE_DEFAULT = "sRGB IEC61966-2.1";
    private static final String PDF_ICC_COLOR_RGB = "RGB";
    private static final String PDF_ICC_COLOR_CMYK = "CMYK";
    protected Document doc;
    protected PdfWriter writer;
    protected IReportContext context;
    protected IReportContent report;
    protected static Logger logger = Logger.getLogger(PDFPageDevice.class.getName());
    protected PDFPage currentPage;
    protected HashMap<Float, PdfTemplate> templateMap;
    protected HashMap<String, PdfTemplate> imageCache;
    protected static String[] versionInfo = new String[]{BundleVersionUtil.getBundleVersion((String)"org.eclipse.birt.report.engine")};
    protected static final int MAX_PAGE_WIDTH = 14400000;
    protected static final int MAX_PAGE_HEIGHT = 14400000;
    private static final String PDF_PREPEND_DOCUMENTS = "PdfEmitter.PrependDocumentList";
    private static final String PREPEND_PROPERTY_NAME = "PrependList";
    private static final String PDF_APPEND_DOCUMENTS = "PdfEmitter.AppendDocumentList";
    private static final String APPEND_PROPERTY_NAME = "AppendList";
    private static final String PDF_VERSION = "PdfEmitter.Version";
    private static final String PDF_CONFORMANCE = "PdfEmitter.Conformance";
    private static final String PDF_ICC_PROFILE_EXTERNAL_FILE = "PdfEmitter.IccProfileFile";
    private static final String PDF_ICC_COLOR_TYPE = "PdfEmitter.IccColorType";
    private static final String PDFA_ADD_DOCUMENT_TITLE = "PdfEmitter.PDFA.AddDocumentTitle";
    private static final String PDFA_FALLBACK_FONT = "PdfEmitter.PDFA.FallbackFont";
    protected Map<String, Expression> userProperties;
    private char pdfVersion;
    private int pdfConformance;
    private boolean isPdfAFormat;
    private boolean addPdfADocumentTitle;
    private String defaultFontPdfA;

    public PDFPageDevice(OutputStream output, String title, String author, String subject, String description, IReportContext context, IReportContent report) {
        block21: {
            this.doc = null;
            this.writer = null;
            this.currentPage = null;
            this.templateMap = new HashMap();
            this.imageCache = new HashMap();
            this.pdfVersion = (char)48;
            this.pdfConformance = 0;
            this.isPdfAFormat = false;
            this.addPdfADocumentTitle = false;
            this.defaultFontPdfA = null;
            this.context = context;
            this.report = report;
            this.doc = new Document();
            try {
                String list;
                this.writer = PdfWriter.getInstance((Document)this.doc, (OutputStream)new BufferedOutputStream(output));
                EngineResourceHandle handle = new EngineResourceHandle(ULocale.forLocale((Locale)context.getLocale()));
                this.userProperties = report.getDesign().getUserProperties();
                this.setPdfVersion();
                this.setPdfConformance();
                this.setDefaultFontPdfA();
                if (!this.isPdfAFormat) {
                    this.writer.setFullCompression();
                    this.writer.setRgbTransparencyBlending(true);
                }
                String creator = handle.getMessage("PDFCreator", (Object[])versionInfo);
                this.doc.addCreator(creator);
                if (author != null) {
                    this.doc.addAuthor(author);
                }
                if ((!this.isPdfAFormat || this.addPdfADocumentTitle) && title != null) {
                    this.doc.addTitle(title);
                }
                if (subject != null) {
                    this.doc.addSubject(subject);
                    this.doc.addKeywords(subject);
                }
                if (description != null) {
                    this.doc.addHeader("Description", description);
                }
                ArrayList<InputStream> pdfs = new ArrayList<InputStream>();
                if (this.userProperties == null) break block21;
                Expression listObject = this.userProperties.get(PREPEND_PROPERTY_NAME);
                if (this.userProperties.containsKey(PDF_PREPEND_DOCUMENTS)) {
                    listObject = this.userProperties.get(PDF_PREPEND_DOCUMENTS);
                }
                if (listObject == null) break block21;
                Expression exp = listObject;
                Object result = context.evaluate(exp);
                if (result instanceof String && (list = (String)result) != null && list.length() > 0) {
                    String[] stringArray = list.split(",");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        try {
                            String fileName = s.trim();
                            File f = new File(fileName);
                            if (f.exists()) {
                                FileInputStream fis = new FileInputStream(f);
                                pdfs.add(fis);
                            } else {
                                URL url = context.getResource(fileName);
                                BufferedInputStream is = new BufferedInputStream(url.openStream());
                                pdfs.add(is);
                            }
                        }
                        catch (Exception e) {
                            logger.log(Level.WARNING, e.getMessage(), e);
                        }
                        ++n2;
                    }
                }
                if (result instanceof ArrayList) {
                    ArrayList pdfList = (ArrayList)result;
                    for (String fileName : pdfList) {
                        try {
                            File f = new File(fileName);
                            if (f.exists()) {
                                FileInputStream fis = new FileInputStream(f);
                                pdfs.add(fis);
                                continue;
                            }
                            URL url = context.getResource(fileName);
                            BufferedInputStream is = new BufferedInputStream(url.openStream());
                            pdfs.add(is);
                        }
                        catch (Exception e) {
                            logger.log(Level.WARNING, e.getMessage(), e);
                        }
                    }
                }
                if (pdfs.size() > 0) {
                    if (!this.doc.isOpen()) {
                        this.doc.open();
                    }
                    this.concatPDFs(pdfs, false);
                }
            }
            catch (DocumentException | BirtException be) {
                logger.log(Level.SEVERE, be.getMessage(), be);
            }
        }
    }

    public PDFPageDevice(OutputStream output) {
        this.doc = null;
        this.writer = null;
        this.currentPage = null;
        this.templateMap = new HashMap();
        this.imageCache = new HashMap();
        this.pdfVersion = (char)48;
        this.pdfConformance = 0;
        this.isPdfAFormat = false;
        this.addPdfADocumentTitle = false;
        this.defaultFontPdfA = null;
        this.doc = new Document();
        try {
            this.writer = PdfWriter.getInstance((Document)this.doc, (OutputStream)new BufferedOutputStream(output));
        }
        catch (DocumentException de) {
            logger.log(Level.SEVERE, de.getMessage(), de);
        }
    }

    public void setPDFTemplate(Float key, PdfTemplate totalPageTemplate) {
        this.templateMap.put(key, totalPageTemplate);
    }

    public HashMap<Float, PdfTemplate> getTemplateMap() {
        return this.templateMap;
    }

    public PdfTemplate getPDFTemplate(Float key) {
        return this.templateMap.get(key);
    }

    public boolean hasTemplate(Float key) {
        return this.templateMap.containsKey(key);
    }

    public HashMap<String, PdfTemplate> getImageCache() {
        return this.imageCache;
    }

    public void close() throws Exception {
        if (!this.doc.isOpen()) {
            this.doc.open();
        }
        ArrayList<InputStream> pdfs = new ArrayList<InputStream>();
        Map userProperties = this.report.getDesign().getUserProperties();
        if (userProperties != null) {
            Object listObject = userProperties.get(APPEND_PROPERTY_NAME);
            if (userProperties.containsKey(PDF_APPEND_DOCUMENTS)) {
                listObject = userProperties.get(PDF_APPEND_DOCUMENTS);
            }
            if (listObject != null) {
                String list;
                Expression exp = (Expression)listObject;
                Object result = this.context.evaluate(exp);
                if (result instanceof String && (list = (String)result) != null && list.length() > 0) {
                    String[] stringArray = list.split(",");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        try {
                            String fileName = s.trim();
                            File f = new File(fileName);
                            if (f.exists()) {
                                FileInputStream fis = new FileInputStream(f);
                                pdfs.add(fis);
                            } else {
                                URL url = this.context.getResource(fileName);
                                BufferedInputStream is = new BufferedInputStream(url.openStream());
                                pdfs.add(is);
                            }
                        }
                        catch (Exception e) {
                            logger.log(Level.WARNING, e.getMessage(), e);
                        }
                        ++n2;
                    }
                }
                if (result instanceof ArrayList) {
                    ArrayList pdfList = (ArrayList)result;
                    for (String fileName : pdfList) {
                        try {
                            File f = new File(fileName);
                            if (f.exists()) {
                                FileInputStream fis = new FileInputStream(f);
                                pdfs.add(fis);
                                continue;
                            }
                            URL url = this.context.getResource(fileName);
                            BufferedInputStream is = new BufferedInputStream(url.openStream());
                            pdfs.add(is);
                        }
                        catch (Exception e) {
                            logger.log(Level.WARNING, e.getMessage(), e);
                        }
                    }
                }
                if (pdfs.size() > 0) {
                    this.concatPDFs(pdfs, false);
                }
            }
        }
        if (this.isPdfAFormat) {
            this.setPdfIccXmp();
        }
        this.writer.setPageEmpty(false);
        if (this.doc.isOpen()) {
            this.doc.close();
        }
    }

    public IPage newPage(int width, int height, Color backgroundColor) {
        int w = Math.min(width, 14400000);
        int h = Math.min(height, 14400000);
        this.currentPage = this.createPDFPage(w, h);
        this.currentPage.drawBackgroundColor(backgroundColor, 0, 0, w, h);
        return this.currentPage;
    }

    protected PDFPage createPDFPage(int pageWidth, int pageHeight) {
        return new PDFPage(pageWidth, pageHeight, this.doc, this.writer, this);
    }

    public void createTOC(Set<String> bookmarks) {
        if (!this.doc.isOpen()) {
            return;
        }
        if (bookmarks.isEmpty()) {
            this.writer.setViewerPreferences(64);
            return;
        }
        ULocale ulocale = null;
        Locale locale = this.context.getLocale();
        ulocale = locale == null ? ULocale.getDefault() : ULocale.forLocale((Locale)locale);
        ITOCTree tocTree = this.report.getTOCTree("pdf", ulocale);
        if (tocTree == null) {
            this.writer.setViewerPreferences(64);
        } else {
            TOCNode rootNode = tocTree.getRoot();
            if (rootNode == null || rootNode.getChildren().isEmpty()) {
                this.writer.setViewerPreferences(64);
            } else {
                this.writer.setViewerPreferences(128);
                TOCHandler tocHandler = new TOCHandler(rootNode, this.writer.getDirectContent().getRootOutline(), bookmarks);
                tocHandler.createTOC();
            }
        }
    }

    protected TOCHandler createTOCHandler(TOCNode root, PdfOutline outline, Set<String> bookmarks) {
        return new TOCHandler(root, outline, bookmarks);
    }

    public void concatPDFs(List<InputStream> streamOfPDFFiles, boolean paginate) {
        Document document = this.doc;
        try {
            List<InputStream> pdfs = streamOfPDFFiles;
            ArrayList<PdfReader> readers = new ArrayList<PdfReader>();
            int totalPages = 0;
            for (InputStream pdf : pdfs) {
                PdfReader pdfReader = new PdfReader(pdf);
                readers.add(pdfReader);
                int n = pdfReader.getNumberOfPages();
                totalPages += n;
            }
            PdfWriter writer = this.writer;
            BaseFont bf = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false);
            PdfContentByte cb = writer.getDirectContent();
            int currentPageNumber = 0;
            int pageOfCurrentReaderPDF = 0;
            for (PdfReader pdfReader : readers) {
                while (pageOfCurrentReaderPDF < pdfReader.getNumberOfPages()) {
                    ++currentPageNumber;
                    Rectangle sourcePageSize = pdfReader.getPageSize(++pageOfCurrentReaderPDF);
                    document.setPageSize(sourcePageSize);
                    document.newPage();
                    PdfImportedPage page = writer.getImportedPage(pdfReader, pageOfCurrentReaderPDF);
                    cb.addTemplate((PdfTemplate)page, 0.0f, 0.0f);
                    if (!paginate) continue;
                    cb.beginText();
                    cb.setFontAndSize(bf, 9.0f);
                    cb.showTextAligned(1, currentPageNumber + " of " + totalPages, 520.0f, 5.0f, 0.0f);
                    cb.endText();
                }
                pageOfCurrentReaderPDF = 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setPdfVersion() {
        if (this.userProperties != null && this.userProperties.containsKey(PDF_VERSION)) {
            String userPdfVersion = this.userProperties.get(PDF_VERSION).toString();
            this.setPdfVersion(userPdfVersion);
        }
    }

    public void setPdfVersion(String version) {
        switch (version) {
            case "1.3": {
                this.pdfVersion = (char)51;
                break;
            }
            case "1.4": {
                this.pdfVersion = (char)51;
                break;
            }
            case "1.5": {
                this.pdfVersion = (char)51;
                break;
            }
            case "1.6": {
                this.pdfVersion = (char)51;
                break;
            }
            case "1.7": {
                this.pdfVersion = (char)55;
            }
        }
        if (this.pdfVersion != '0') {
            this.writer.setAtLeastPdfVersion(this.pdfVersion);
        }
    }

    public String getPdfVersion() {
        switch (this.pdfVersion) {
            case '3': {
                return PDF_VERSION_1_3;
            }
            case '4': {
                return PDF_VERSION_1_4;
            }
            case '5': {
                return PDF_VERSION_1_5;
            }
            case '6': {
                return PDF_VERSION_1_6;
            }
            case '7': {
                return PDF_VERSION_1_7;
            }
        }
        return PDF_VERSION_1_5;
    }

    private void setPdfConformance() {
        String pdfaUseTitleOverwrite;
        block14: {
            String userPdfConformance;
            if (this.userProperties == null || !this.userProperties.containsKey(PDF_CONFORMANCE)) break block14;
            switch (userPdfConformance = this.userProperties.get(PDF_CONFORMANCE).toString().toUpperCase()) {
                case "PDF.X32002": {
                    this.pdfConformance = 2;
                    this.isPdfAFormat = false;
                    break;
                }
                case "PDF.A1A": {
                    this.pdfConformance = 3;
                    this.isPdfAFormat = true;
                    break;
                }
                case "PDF.A1B": {
                    this.pdfConformance = 4;
                    this.isPdfAFormat = true;
                    break;
                }
                default: {
                    this.pdfConformance = 0;
                    this.isPdfAFormat = false;
                }
            }
            this.setPdfConformance(this.pdfConformance);
        }
        if (this.userProperties != null && this.userProperties.containsKey(PDFA_ADD_DOCUMENT_TITLE) && (pdfaUseTitleOverwrite = this.userProperties.get(PDFA_ADD_DOCUMENT_TITLE).toString().toLowerCase()).equals("true")) {
            this.addPdfADocumentTitle = true;
        }
    }

    public void setPdfConformance(int pdfConformance) {
        this.writer.setPDFXConformance(pdfConformance);
        this.writer.setTagged();
    }

    public String getPdfConformance() {
        switch (this.pdfConformance) {
            case 2: {
                return PDF_CONFORMANCE_X32002;
            }
            case 3: {
                return PDF_CONFORMANCE_A1A;
            }
            case 4: {
                return PDF_CONFORMANCE_A1B;
            }
        }
        return PDF_CONFORMANCE_STANDARD;
    }

    public boolean isPdfAFormat() {
        return this.isPdfAFormat;
    }

    private void setPdfIccXmp() {
        try {
            PdfDictionary outi = new PdfDictionary(PdfName.OUTPUTINTENT);
            outi.put(PdfName.OUTPUTCONDITIONIDENTIFIER, (PdfObject)new PdfString(PDF_ICC_PROFILE_DEFAULT));
            outi.put(PdfName.INFO, (PdfObject)new PdfString(PDF_ICC_PROFILE_DEFAULT));
            outi.put(PdfName.S, (PdfObject)PdfName.GTS_PDFA1);
            boolean iccProfileExternal = false;
            ICC_Profile iccProfile = null;
            File iccFile = null;
            String fullFileNameIcc = "";
            if (this.userProperties != null && this.userProperties.containsKey(PDF_ICC_PROFILE_EXTERNAL_FILE)) {
                fullFileNameIcc = this.userProperties.get(PDF_ICC_PROFILE_EXTERNAL_FILE).toString().trim();
                try {
                    iccFile = new File(fullFileNameIcc);
                    if (!iccFile.exists()) {
                        URL url = this.context.getResource(fullFileNameIcc);
                        iccFile = new File(url.toURI());
                    }
                    iccProfileExternal = true;
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, e.getMessage(), e);
                }
            }
            int colorSpace = 1000;
            String iccColorType = PDF_ICC_COLOR_RGB;
            if (this.userProperties != null && this.userProperties.containsKey(PDF_ICC_COLOR_TYPE) && (iccColorType = this.userProperties.get(PDF_ICC_COLOR_TYPE).toString().toUpperCase().trim()).equals(PDF_ICC_COLOR_CMYK)) {
                colorSpace = 9;
            }
            iccProfile = iccProfileExternal ? ICC_Profile.getInstance(iccFile.getAbsolutePath()) : ICC_Profile.getInstance(colorSpace);
            PdfICCBased iccPdf = new PdfICCBased(iccProfile);
            iccPdf.remove(PdfName.ALTERNATE);
            outi.put(PdfName.DESTOUTPUTPROFILE, (PdfObject)this.writer.addToBody((PdfObject)iccPdf).getIndirectReference());
            this.writer.getExtraCatalog().put(PdfName.OUTPUTINTENTS, (PdfObject)new PdfArray((PdfObject)outi));
        }
        catch (Exception icce) {
            logger.log(Level.WARNING, icce.getMessage(), icce);
        }
        try {
            this.writer.createXmpMetadata();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
    }

    private void setDefaultFontPdfA() {
        if (this.userProperties != null && this.userProperties.containsKey(PDFA_FALLBACK_FONT)) {
            String defaultFont;
            this.defaultFontPdfA = defaultFont = this.userProperties.get(PDFA_FALLBACK_FONT).toString();
        }
    }

    public void setDefaultFontPdfA(String defaultFont) {
        this.defaultFontPdfA = defaultFont;
    }

    public String getDefaultFontPdfA() {
        return this.defaultFontPdfA;
    }
}

