/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.lib.editors;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.designer.internal.ui.editors.IRelatedFileChangeResolve;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.LibrarySaveChangeEvent;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.views.IReportResourceChangeEvent;
import org.eclipse.birt.report.designer.ui.views.IReportResourceSynchronizer;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ModuleUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class LibraryFileChangeResolve
implements IRelatedFileChangeResolve {
    protected static final Logger logger = Logger.getLogger(LibraryFileChangeResolve.class.getName());

    public boolean acceptType(int type) {
        return type == 2;
    }

    public boolean isReload(IReportResourceChangeEvent event, ModuleHandle owner) {
        return ModuleUtil.isInclude((ModuleHandle)owner, (String)((LibrarySaveChangeEvent)event).getFileName());
    }

    public boolean isReset(IReportResourceChangeEvent event, ModuleHandle owner) {
        return owner.getFileName().equals(((LibrarySaveChangeEvent)event).getFileName());
    }

    public void notifySaveFile(ModuleHandle owner) {
        IReportResourceSynchronizer synchronizer;
        if (owner instanceof LibraryHandle && (synchronizer = ReportPlugin.getDefault().getResourceSynchronizerService()) != null) {
            synchronizer.notifyResourceChanged((IReportResourceChangeEvent)new LibrarySaveChangeEvent((Object)owner, null, 2, owner.getFileName()));
        }
    }

    public boolean reload(ModuleHandle owner) {
        if (owner.needsSave()) {
            MessageDialog md = new MessageDialog(UIUtil.getDefaultShell(), Messages.getString((String)"MultiPageReportEditor.ConfirmVersion.Dialog.Title"), null, Messages.getString((String)"MultiPageReportEditor.ConfirmVersion.Dialog.SaveAndReloadMessage"), 6, new String[]{Messages.getString((String)"MultiPageReportEditor.SaveButton"), Messages.getString((String)"MultiPageReportEditor.CancelButton")}, 0);
            switch (md.open()) {
                case 0: {
                    try {
                        owner.save();
                    }
                    catch (IOException e) {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                    UIUtil.reloadModuleHandleLibraries((ModuleHandle)owner);
                    return true;
                }
            }
            return false;
        }
        if (MessageDialog.openConfirm((Shell)UIUtil.getDefaultShell(), (String)Messages.getString((String)"MultiPageReportEditor.ConfirmVersion.Dialog.Title"), (String)Messages.getString((String)"MultiPageReportEditor.ConfirmVersion.Dialog.ReloadMessage"))) {
            UIUtil.reloadModuleHandleLibraries((ModuleHandle)owner);
            return true;
        }
        return false;
    }

    public boolean reset() {
        return MessageDialog.openConfirm((Shell)UIUtil.getDefaultShell(), (String)Messages.getString((String)"MultiPageReportEditor.ConfirmVersion.Dialog.Title"), (String)Messages.getString((String)"MultiPageReportEditor.ConfirmVersion.Dialog.ResetMessage"));
    }
}

