/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.html.buffer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.emitter.ContentEmitterUtil;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.layout.ILayoutPageHandler;
import org.eclipse.birt.report.engine.layout.html.HTMLLayoutContext;
import org.eclipse.birt.report.engine.layout.html.buffer.AbstractNode;
import org.eclipse.birt.report.engine.layout.html.buffer.ContainerBufferNode;
import org.eclipse.birt.report.engine.layout.html.buffer.IContainerNode;
import org.eclipse.birt.report.engine.layout.html.buffer.INode;
import org.eclipse.birt.report.engine.layout.html.buffer.IPageBuffer;
import org.eclipse.birt.report.engine.layout.html.buffer.LeafBufferNode;
import org.eclipse.birt.report.engine.layout.html.buffer.PageHintGenerator;
import org.eclipse.birt.report.engine.layout.html.buffer.PageNode;
import org.eclipse.birt.report.engine.presentation.TableColumnHint;

public class HTMLPageBuffer
implements IPageBuffer {
    protected IContainerNode currentNode;
    protected PageHintGenerator generator;
    protected HTMLLayoutContext context;
    protected boolean isRepeated = false;
    protected boolean finished = false;
    protected ArrayList columnHints = new ArrayList();
    protected HashSet tableIds = new HashSet();

    public HTMLPageBuffer(HTMLLayoutContext context) {
        this.context = context;
        this.generator = new PageHintGenerator();
    }

    @Override
    public void startContainer(IContent content, boolean isFirst, IContentEmitter emitter, boolean visible) throws BirtException {
        int type = content.getContentType();
        switch (type) {
            case 9: 
            case 14: {
                boolean first = isFirst && !this.isRepeated;
                ContainerBufferNode bandNode = new ContainerBufferNode(content, emitter, this.generator, visible);
                this.setup(bandNode, first);
                this.currentNode = bandNode;
                break;
            }
            case 1: {
                ContainerBufferNode cellNode = new ContainerBufferNode(content, emitter, this.generator, visible);
                this.setup(cellNode, isFirst);
                if (this.currentNode.isStarted()) {
                    cellNode.start();
                }
                this.currentNode = cellNode;
                break;
            }
            case 7: {
                PageNode pageNode = new PageNode(content, emitter, this.generator, visible);
                this.setup(pageNode, isFirst);
                this.currentNode = pageNode;
                break;
            }
            case 10: {
                this.tableIds.add(content.getInstanceID().toUniqueString());
            }
            default: {
                ContainerBufferNode node = new ContainerBufferNode(content, emitter, this.generator, visible);
                this.setup(node, isFirst);
                this.currentNode = node;
            }
        }
    }

    protected boolean isParentStarted() {
        IContainerNode parentNode = this.currentNode.getParent();
        if (parentNode != null) {
            return parentNode.isStarted();
        }
        return false;
    }

    @Override
    public void startContent(IContent content, IContentEmitter emitter, boolean visible) throws BirtException {
        if (this.isRepeated || !visible && !this.currentNode.isStarted()) {
            LeafBufferNode leafNode = new LeafBufferNode(content, emitter, this.generator, visible);
            this.setup(leafNode, true);
        } else {
            LeafBufferNode leafNode = new LeafBufferNode(content, emitter, this.generator, visible);
            this.setup(leafNode, true);
            this.currentNode.start();
            if (visible) {
                ContentEmitterUtil.startContent(content, emitter);
            }
            this.generator.start(content, true);
            this.generator.end(content, true);
            this.currentNode.removeChildren();
        }
    }

    @Override
    public void endContainer(IContent content, boolean finished, IContentEmitter emitter, boolean visible) throws BirtException {
        int type = content.getContentType();
        switch (type) {
            case 9: 
            case 14: {
                boolean isFinished = finished && !this.isRepeated;
                this._endContainer(content, isFinished, emitter, visible);
                break;
            }
            case 7: {
                this.endPage(content, finished, emitter);
                break;
            }
            case 8: {
                boolean isFinished = finished && !this.isRepeated;
                this.endRow(content, finished, emitter, visible);
                break;
            }
            case 1: {
                this.endCell(content, finished, emitter, visible);
                break;
            }
            default: {
                this._endContainer(content, finished, emitter, visible);
            }
        }
    }

    private void _endContainer(IContent content, boolean finished, IContentEmitter emitter, boolean visible) throws BirtException {
        ((AbstractNode)((Object)this.currentNode)).setFinished(finished);
        if (this.currentNode.isStarted()) {
            this.currentNode.end();
        } else if (finished && !this.isRepeated) {
            if (visible) {
                this.currentNode.flush();
            } else if (this.isParentStarted()) {
                this.currentNode.flush();
            }
        }
        this.currentNode = this.currentNode.getParent();
        if (this.currentNode != null && finished && !this.isRepeated) {
            if (visible) {
                this.currentNode.removeChildren();
            } else if (this.isParentStarted() && ((ContainerBufferNode)this.currentNode).isVisible) {
                this.currentNode.removeChildren();
            }
        }
    }

    protected void endRow(IContent content, boolean finished, IContentEmitter emitter, boolean visible) throws BirtException {
        ((AbstractNode)((Object)this.currentNode)).setFinished(finished);
        if (this.currentNode.isStarted()) {
            this.currentNode.end();
        } else if (!this.isRepeated) {
            if (finished) {
                if (visible) {
                    this.currentNode.flush();
                } else if (this.isParentStarted()) {
                    this.currentNode.flush();
                }
            } else if (this.allCellFinished((ContainerBufferNode)this.currentNode)) {
                this.currentNode.flush();
            }
        }
        this.currentNode = this.currentNode.getParent();
        if (this.currentNode != null && finished && !this.isRepeated) {
            if (visible) {
                this.currentNode.removeChildren();
            } else if (this.isParentStarted() && ((ContainerBufferNode)this.currentNode).isVisible) {
                this.currentNode.removeChildren();
            }
        }
    }

    private boolean allCellFinished(ContainerBufferNode node) {
        if (node.children.size() > 0) {
            for (AbstractNode cell : node.children) {
                if (cell.finished) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected void endCell(IContent content, boolean finished, IContentEmitter emitter, boolean visible) throws BirtException {
        AbstractNode current = (AbstractNode)((Object)this.currentNode);
        if (!current.isFirst) {
            current.setFinished(false);
        } else {
            current.setFinished(finished);
        }
        if (this.currentNode.isStarted()) {
            this.currentNode.end();
        } else if (finished) {
            // empty if block
        }
        this.currentNode = this.currentNode.getParent();
    }

    public void endPage(IContent content, boolean finished, IContentEmitter emitter) throws BirtException {
        ((AbstractNode)((Object)this.currentNode)).setFinished(finished);
        if (this.currentNode.isStarted()) {
            this.context.getPageHintManager().generatePageRowHints(this.getTableKeys());
            this.currentNode.end();
            this.pageBreakEvent();
            if (!finished) {
                this.context.setPageNumber(this.context.getPageNumber() + 1L);
                this.context.setPageCount(this.context.getPageCount() + 1L);
            }
        } else {
            this.context.setEmptyPage(true);
            if (finished) {
                if (this.context.getPageNumber() == 1L) {
                    this.currentNode.flush();
                    this.pageBreakEvent();
                } else {
                    this.context.setPageNumber(this.context.getPageNumber() - 1L);
                    this.context.setPageCount(this.context.getPageCount() - 1L);
                }
            }
        }
        this.finished = true;
        this.generator.reset();
        this.context.getPageHintManager().clearPageHint();
        this.currentNode = null;
    }

    protected Collection<String> getTableKeys() {
        HashSet<String> keys = new HashSet<String>();
        for (String tableId : this.tableIds) {
            String key = this.context.getPageHintManager().getHintMapKey(tableId);
            keys.add(key);
        }
        return keys;
    }

    protected void pageBreakEvent() {
        this.context.getPageHintManager().setPageHint(this.generator.getPageHint());
        long pageNumber = this.context.getPageNumber();
        ILayoutPageHandler pageHandler = this.context.getLayoutEngine().getPageHandler();
        if (pageHandler != null) {
            pageHandler.onPage(pageNumber, this.context);
        }
    }

    private void setup(AbstractNode node, boolean isFirst) {
        node.setFirst(isFirst);
        if (this.currentNode != null) {
            node.setParent(this.currentNode);
            this.currentNode.addChild(node);
        }
    }

    @Override
    public boolean isRepeated() {
        return this.isRepeated;
    }

    @Override
    public void setRepeated(boolean isRepeated) {
        this.isRepeated = isRepeated;
    }

    @Override
    public void flush() throws BirtException {
    }

    @Override
    public boolean finished() {
        return this.finished;
    }

    @Override
    public void closePage(INode[] nodeList) throws BirtException {
        int length = nodeList.length;
        if (length > 0) {
            int i = 0;
            while (i < length) {
                AbstractNode node = (AbstractNode)nodeList[i];
                this.endContainer(node.content, false, node.emitter, true);
                ++i;
            }
        }
        this.finished = true;
    }

    @Override
    public void openPage(INode[] nodeList) throws BirtException {
        int length = nodeList.length;
        if (length > 0) {
            int i = length - 1;
            while (i >= 0) {
                AbstractNode node = (AbstractNode)nodeList[i];
                this.startContainer(node.content, false, node.emitter, true);
                --i;
            }
        }
    }

    @Override
    public INode[] getNodeStack() {
        ArrayList<IContainerNode> nodeList = new ArrayList<IContainerNode>();
        if (this.currentNode != null) {
            nodeList.add(this.currentNode);
            IContainerNode parent = this.currentNode.getParent();
            while (parent != null) {
                nodeList.add(parent);
                parent = parent.getParent();
            }
        }
        INode[] list = new INode[nodeList.size()];
        nodeList.toArray(list);
        return list;
    }

    @Override
    public void addTableColumnHint(TableColumnHint hint) {
        this.context.getPageHintManager().addTableColumnHint(hint);
    }
}

