/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.report.engine.data.dte.BlankResultSet;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.StyledItemExecutor;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.IQueryResultSet;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;

public abstract class QueryItemExecutor
extends StyledItemExecutor {
    protected boolean rsetEmpty;

    protected QueryItemExecutor(ExecutorManager manager, int type) {
        super(manager, type);
    }

    protected void closeQuery() {
        if (this.rset != null) {
            this.rset.close();
            this.rset = null;
            this.context.setResultSets(this.parentRsets);
        }
    }

    protected void executeQuery() {
        this.rset = null;
        boolean useCache = this.design.useCachedResult();
        IDataQueryDefinition query = this.design.getQuery();
        IBaseResultSet parentRset = this.getParentResultSet();
        this.context.setResultSet(parentRset);
        if (query != null) {
            try {
                this.context.getProgressMonitor().onProgress(5, (int)this.design.getID());
                this.rset = (IQueryResultSet)this.context.executeQuery(parentRset, query, this.design.getHandle(), useCache);
                this.context.setResultSet(this.rset);
                this.context.getProgressMonitor().onProgress(6, (int)this.design.getID());
                if (this.rset != null) {
                    this.rsetEmpty = !this.rset.next();
                }
            }
            catch (BirtException ex) {
                this.rsetEmpty = true;
                this.context.addException(this.getDesign(), ex);
            }
        }
    }

    protected void createQueryForShowIfBlank() {
        BlankResultSet blankRset = new BlankResultSet(this.rset);
        this.rset = blankRset;
        this.context.setResultSet(this.rset);
        this.rsetEmpty = false;
    }

    protected void accessQuery(ReportItemDesign design, IContentEmitter emitter) {
    }

    @Override
    public void close() throws BirtException {
        this.rset = null;
        this.rsetEmpty = false;
        super.close();
    }
}

