/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import java.util.Iterator;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.report.data.adapter.api.DataAdapterUtil;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.engine.api.impl.DatasetPreviewTask;
import org.eclipse.birt.report.engine.api.impl.ReportEngine;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSetParameterHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;

public class OutParameterPreviewTask
extends DatasetPreviewTask {
    public static final String PREFIX_OUTPUTPARAMETER = "outputParams";

    protected OutParameterPreviewTask(ReportEngine engine) {
        super(engine);
    }

    protected QueryDefinition constructQuery(DataSetHandle dataset, DataRequestSession session) throws BirtException {
        QueryDefinition query = super.constructQuery(dataset, session);
        query.getBindings().clear();
        PropertyHandle propertyHandle = dataset.getPropertyHandle("parameters");
        int paramsSize = propertyHandle.getListValue().size();
        Iterator paramIter = propertyHandle.iterator();
        int n = 1;
        while (n <= paramsSize) {
            DataSetParameterHandle paramDefn = (DataSetParameterHandle)paramIter.next();
            if (paramDefn.isOutput()) {
                String bindingName = paramDefn.getName();
                Binding binding = new Binding(bindingName);
                binding.setExpression((IBaseExpression)new ScriptExpression("outputParams[\"" + paramDefn.getName() + "\"]"));
                binding.setDataType(DataAdapterUtil.adaptModelDataType((String)paramDefn.getDataType()));
                query.addBinding((IBinding)binding);
            }
            ++n;
        }
        return query;
    }
}

