/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.data.IColumnBinding;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.core.script.ScriptExpression;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.CompiledExpression;
import org.eclipse.birt.data.engine.expression.ExprEvaluateUtil;
import org.eclipse.birt.data.engine.expression.ExpressionCompilerUtil;
import org.eclipse.birt.data.engine.impl.DataSetRuntime;
import org.eclipse.birt.data.engine.impl.GroupComputedColumn;
import org.eclipse.birt.data.engine.impl.util.DirectedGraph;
import org.eclipse.birt.data.engine.impl.util.DirectedGraphEdge;
import org.eclipse.birt.data.engine.impl.util.GraphNode;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.eclipse.birt.data.engine.odi.IResultObjectEvent;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;

public class ComputedColumnHelper
implements IResultObjectEvent {
    private ComputedColumnHelperInstance dataSetInstance;
    private ComputedColumnHelperInstance resultSetInstance;
    private ComputedColumnHelperInstance availableModeInstance;
    private ComputedColumnHelperInstance currentModel;
    private List allCC;
    private int mode;
    private static Logger logger = Logger.getLogger(ComputedColumnHelper.class.getName());
    private boolean suppressException;

    ComputedColumnHelper(DataSetRuntime dataSet, List dataSetCCList, List resultSetCCList, ScriptContext cx) throws DataException {
        Object[] params = new Object[]{dataSet, dataSetCCList, resultSetCCList};
        logger.entering(ComputedColumnHelper.class.getName(), "ComputedColumnHelper", params);
        this.allCC = new ArrayList();
        this.allCC.addAll(dataSetCCList);
        this.allCC.addAll(resultSetCCList);
        this.dataSetInstance = new ComputedColumnHelperInstance(dataSet, dataSetCCList, DataSetRuntime.Mode.DataSet, cx);
        this.resultSetInstance = new ComputedColumnHelperInstance(dataSet, resultSetCCList, DataSetRuntime.Mode.Query, cx);
        ArrayList availableCCList = new ArrayList();
        this.getAvailableComputedList(this.getComputedNameList(dataSetCCList), dataSetCCList, availableCCList);
        this.availableModeInstance = new ComputedColumnHelperInstance(dataSet, availableCCList, DataSetRuntime.Mode.DataSet, cx);
        this.currentModel = this.dataSetInstance;
        this.suppressException = false;
        logger.exiting(ComputedColumnHelper.class.getName(), "ComputedColumnHelper");
    }

    public void suppressException(boolean suppressException) {
        this.suppressException = suppressException;
    }

    private ComputedColumnHelperInstance getCurrentInstance() {
        return this.currentModel;
    }

    @Override
    public boolean process(IResultObject resultObject, int rowIndex) throws DataException {
        if (this.mode == 2) {
            this.dataSetInstance.process(resultObject, rowIndex);
            this.resultSetInstance.process(resultObject, rowIndex);
        } else if (this.getCurrentInstance() != null) {
            return this.getCurrentInstance().process(resultObject, rowIndex);
        }
        return true;
    }

    public boolean isComputedColumnExist(int model) {
        if (model == 0) {
            return this.dataSetInstance.getComputedColumnList().size() > 0;
        }
        if (model == 1) {
            return this.resultSetInstance.getComputedColumnList().size() > 0;
        }
        if (model == 2) {
            return this.allCC.size() > 0;
        }
        return false;
    }

    public List getComputedColumnList() {
        if (this.getCurrentInstance() != null) {
            return this.getCurrentInstance().getComputedColumnList();
        }
        return this.allCC;
    }

    public void setRePrepare(boolean rePrepare) {
        if (this.getCurrentInstance() != null) {
            this.getCurrentInstance().setRePrepare(rePrepare);
        }
    }

    public void setModel(int model) {
        this.mode = model;
        this.currentModel = model == 0 ? this.dataSetInstance : (model == 1 ? this.resultSetInstance : (model == 5 ? this.availableModeInstance : null));
    }

    private List getComputedNameList(List dataSetCCList) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < dataSetCCList.size()) {
            IComputedColumn column = (IComputedColumn)dataSetCCList.get(i);
            result.add(column.getName());
            ++i;
        }
        return result;
    }

    public void removeAvailableComputedColumn(IComputedColumn ccol) {
        this.getComputedColumnList().remove(ccol);
        if (this.getCurrentInstance() == null) {
            this.dataSetInstance.remove(ccol.getName());
        }
    }

    private void getAvailableComputedList(List refernceNameList, List dataSetCCList, List result) throws DataException {
        try {
            int i = 0;
            while (i < dataSetCCList.size()) {
                IComputedColumn column = (IComputedColumn)dataSetCCList.get(i);
                if (refernceNameList.contains(column.getName()) && !ExpressionCompilerUtil.hasAggregationInExpr(column.getExpression()) && column.getAggregateFunction() == null) {
                    List referedList = ExpressionUtil.extractColumnExpressions((String)((IScriptExpression)column.getExpression()).getText());
                    if (referedList.size() == 0) {
                        result.add(column);
                    } else {
                        ArrayList<String> newList = new ArrayList<String>();
                        int j = 0;
                        while (j < referedList.size()) {
                            IColumnBinding binding = (IColumnBinding)referedList.get(j);
                            String name = binding.getResultSetColumnName();
                            newList.add(name);
                            ++j;
                        }
                        if (!this.hasAggregation(newList, dataSetCCList)) {
                            result.add(column);
                        }
                    }
                }
                ++i;
            }
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean hasAggregation(List nameList, List dataSetCCList) throws DataException {
        try {
            int k = 0;
            while (k < nameList.size()) {
                IComputedColumn column = null;
                int i = 0;
                while (i < dataSetCCList.size()) {
                    column = (IComputedColumn)dataSetCCList.get(i);
                    if (column.getName() != null && column.getName().equals(nameList.get(k))) break;
                    column = null;
                    ++i;
                }
                if (column != null) {
                    if (ExpressionCompilerUtil.hasAggregationInExpr(column.getExpression()) || column.getAggregateFunction() != null) {
                        return true;
                    }
                    List referedList = ExpressionUtil.extractColumnExpressions((String)((IScriptExpression)column.getExpression()).getText());
                    ArrayList<String> newList = new ArrayList<String>();
                    int j = 0;
                    while (j < referedList.size()) {
                        IColumnBinding binding = (IColumnBinding)referedList.get(j);
                        String name = binding.getResultSetColumnName();
                        newList.add(name);
                        ++j;
                    }
                    return this.hasAggregation(newList, dataSetCCList);
                }
                ++k;
            }
            return false;
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
    }

    private class ComputedColumnHelperInstance {
        private DataSetRuntime dataSet;
        private DataSetRuntime.Mode mode;
        private List ccList;
        private List<String> removedCCName;
        private IComputedColumn[] computedColumn;
        private Map<String, String> columnReferenceMap = new HashMap<String, String>();
        private int[] columnIndexArray;
        private boolean isPrepared;
        private ScriptContext cx;

        public ComputedColumnHelperInstance(DataSetRuntime dataSet, List computedColumns, DataSetRuntime.Mode mode, ScriptContext cx) throws DataException {
            this.ccList = new ArrayList();
            this.removedCCName = new ArrayList<String>();
            int i = 0;
            while (i < computedColumns.size()) {
                this.ccList.add(computedColumns.get(i));
                ++i;
            }
            this.isPrepared = false;
            this.dataSet = dataSet;
            this.mode = mode;
            this.cx = cx.newContext((Object)this.dataSet.getScriptScope());
        }

        void remove(String colName) {
            this.removedCCName.add(colName);
        }

        public List getComputedColumnList() {
            return this.ccList;
        }

        public boolean isRemoved(String colName) {
            int i = 0;
            while (i < this.removedCCName.size()) {
                if (colName.equals(this.removedCCName.get(i))) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public boolean process(IResultObject resultObject, int rowIndex) throws DataException {
            logger.entering(ComputedColumnHelper.class.getName(), "process");
            assert (resultObject != null);
            IResultClass resultClass = resultObject.getResultClass();
            if (!this.isPrepared) {
                this.prepare(resultClass);
            }
            if (this.computedColumn.length == 0) {
                logger.exiting(ComputedColumnHelper.class.getName(), "process");
                return true;
            }
            IResultIterator cachedIterator = this.dataSet.getResultSet();
            this.dataSet.setRowObject(resultObject, true);
            this.dataSet.setCurrentRowIndex(rowIndex);
            DataSetRuntime.Mode temp = this.dataSet.getMode();
            this.dataSet.setMode(this.mode);
            try {
                int i = 0;
                while (i < this.computedColumn.length) {
                    if (!this.isAggrComputedColumn(this.computedColumn[i]) && !this.isRemoved(this.computedColumn[i].getName())) {
                        if (this.computedColumn[i].getExpression() != null) {
                            Object value;
                            block25: {
                                value = null;
                                try {
                                    String columnName = this.columnReferenceMap.get(this.computedColumn[i].getName());
                                    if (columnName != null) {
                                        if (resultObject != null) {
                                            value = resultObject.getFieldValue(columnName);
                                        }
                                    } else if (this.computedColumn[i].getExpression().getHandle() != null && this.computedColumn[i].getExpression().getHandle() instanceof CompiledExpression) {
                                        value = ExprEvaluateUtil.evaluateCompiledExpression((CompiledExpression)this.computedColumn[i].getExpression().getHandle(), resultObject, rowIndex, this.dataSet.getScriptScope(), this.cx);
                                    } else {
                                        IScriptExpression expr = (IScriptExpression)this.computedColumn[i].getExpression();
                                        String exprText = expr.getText();
                                        if (exprText != null) {
                                            if (expr.getHandle() == null) {
                                                expr.setHandle(this.cx.compile(expr.getScriptId(), null, 0, exprText));
                                            }
                                            value = expr.getHandle() != null && expr.getHandle() instanceof CompiledExpression ? ExprEvaluateUtil.evaluateCompiledExpression((CompiledExpression)expr.getHandle(), resultObject, rowIndex, this.dataSet.getScriptScope(), this.cx) : ScriptEvalUtil.evalExpr(expr, this.cx, ScriptExpression.defaultID, 0);
                                        }
                                    }
                                    if (this.computedColumn[i] instanceof GroupComputedColumn) {
                                        try {
                                            value = ((GroupComputedColumn)this.computedColumn[i]).calculate(value);
                                        }
                                        catch (BirtException e) {
                                            throw DataException.wrap(e);
                                        }
                                    }
                                    value = DataTypeUtil.convert((Object)value, (Class)resultClass.getFieldValueClass(this.columnIndexArray[i]));
                                }
                                catch (BirtException e) {
                                    if (ComputedColumnHelper.this.suppressException) break block25;
                                    String fieldName = resultClass.getFieldName(this.columnIndexArray[i]);
                                    if (fieldName != null && fieldName.startsWith("_{$TEMP_")) {
                                        throw new DataException("data.engine.ScriptResult.WrongSystemComputedColumn", e);
                                    }
                                    if (resultClass.wasAnyType(this.columnIndexArray[i])) {
                                        throw new DataException("data.engine.possibleMixedDataTypeInColumn", e);
                                    }
                                    throw new DataException("data.engine.CompCol.FailRetrieveValueComputedColumn", (Throwable)e, resultClass.getFieldName(this.columnIndexArray[i]));
                                }
                            }
                            resultObject.setCustomFieldValue(this.columnIndexArray[i], value);
                        } else {
                            throw new DataException("data.engine.BadCompColExpr", resultObject.getResultClass().getFieldName(this.columnIndexArray[i]));
                        }
                    }
                    ++i;
                }
            }
            finally {
                this.dataSet.setMode(temp);
            }
            logger.exiting(ComputedColumnHelper.class.getName(), "process");
            if (cachedIterator != null) {
                this.dataSet.setResultSet(cachedIterator, true);
            }
            return true;
        }

        private boolean isAggrComputedColumn(IComputedColumn cc) {
            return cc.getAggregateFunction() != null;
        }

        public void setRePrepare(boolean rePrepare) {
            this.isPrepared = !rePrepare;
        }

        private void prepare(IResultClass resultClass) throws DataException {
            assert (resultClass != null);
            ArrayList<Integer> cmptList = new ArrayList<Integer>();
            HashMap<String, IComputedColumn> nameToComptCol = new HashMap<String, IComputedColumn>();
            int i = 0;
            while (i < this.ccList.size()) {
                IComputedColumn cmptdColumn = (IComputedColumn)this.ccList.get(i);
                int cmptdColumnIdx = resultClass.getFieldIndex(cmptdColumn.getName());
                if (cmptdColumnIdx >= 1 && resultClass.isCustomField(cmptdColumnIdx)) {
                    cmptList.add(i);
                    nameToComptCol.put(cmptdColumn.getName(), cmptdColumn);
                }
                ++i;
            }
            int size = cmptList.size();
            this.columnIndexArray = new int[size];
            this.computedColumn = new IComputedColumn[size];
            int cmptColPos = 0;
            HashSet<DirectedGraphEdge> edges = new HashSet<DirectedGraphEdge>();
            int i2 = 0;
            while (i2 < size) {
                int pos = (Integer)cmptList.get(i2);
                IComputedColumn cmptdColumn = (IComputedColumn)this.ccList.get(pos);
                List<String> referencedBindings = ExpressionCompilerUtil.extractColumnExpression(cmptdColumn.getExpression(), "row");
                boolean existReference = false;
                for (String name : referencedBindings) {
                    if (!nameToComptCol.containsKey(name)) continue;
                    edges.add(new DirectedGraphEdge(new GraphNode(cmptdColumn.getName()), new GraphNode(name)));
                    existReference = true;
                }
                if (!existReference) {
                    this.computedColumn[cmptColPos] = cmptdColumn;
                    this.columnIndexArray[cmptColPos] = resultClass.getFieldIndex(cmptdColumn.getName());
                    ++cmptColPos;
                }
                ++i2;
            }
            GraphNode[] nodes = null;
            try {
                nodes = new DirectedGraph(edges).flattenNodesByDependency();
            }
            catch (DirectedGraph.CycleFoundException e) {
                throw new DataException("data.engine.ComputedColumnCycle", e.getNode().getValue());
            }
            Object[] objectArray = nodes;
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                String name;
                GraphNode node = objectArray[n2];
                name = (String)node.getValue();
                boolean isAdded = false;
                int i3 = 0;
                while (i3 < cmptColPos) {
                    if (name.equals(this.computedColumn[i3].getName())) {
                        isAdded = true;
                        break;
                    }
                    ++i3;
                }
                if (!isAdded) {
                    IComputedColumn cmptdColumn;
                    this.computedColumn[cmptColPos] = cmptdColumn = (IComputedColumn)nameToComptCol.get(name);
                    this.columnIndexArray[cmptColPos] = resultClass.getFieldIndex(cmptdColumn.getName());
                    ++cmptColPos;
                }
                ++n2;
            }
            this.columnReferenceMap.clear();
            objectArray = this.computedColumn;
            n = this.computedColumn.length;
            n2 = 0;
            while (n2 < n) {
                Object cc = objectArray[n2];
                String exprText = null;
                if (cc.getExpression() instanceof IScriptExpression) {
                    exprText = ((IScriptExpression)cc.getExpression()).getText();
                }
                if (exprText != null) {
                    String columnName = null;
                    try {
                        columnName = ExpressionUtil.getColumnName((String)exprText);
                    }
                    catch (BirtException e) {
                        throw DataException.wrap(e);
                    }
                    if (columnName != null) {
                        this.columnReferenceMap.put(cc.getName(), columnName);
                    }
                }
                ++n2;
            }
            this.isPrepared = true;
        }
    }
}

