/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.editors.commands;

import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.commands.AbstractCrosstabCommand;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabAdaptUtil;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabHandleAdapter;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;

public class CreateMeasureViewCommand
extends AbstractCrosstabCommand {
    private CrosstabHandleAdapter handleAdpter;
    private MeasureHandle measureHandle;
    private static final String NAME = Messages.getString("CreateMeasureViewCommand.TransName");

    public CreateMeasureViewCommand(CrosstabHandleAdapter handleAdpter, MeasureHandle measureHandle) {
        super((DesignElementHandle)measureHandle);
        this.handleAdpter = handleAdpter;
        this.measureHandle = measureHandle;
        this.setLabel(NAME);
    }

    public boolean canExecute() {
        return true;
    }

    public void execute() {
        this.transStart(NAME);
        CrosstabReportItemHandle reportHandle = (CrosstabReportItemHandle)this.handleAdpter.getCrosstabItemHandle();
        try {
            if (reportHandle.getCube() == null) {
                reportHandle.setCube(CrosstabAdaptUtil.getCubeHandle((DesignElementHandle)this.measureHandle));
            }
            CrosstabAdaptUtil.addMeasureHandle(reportHandle, this.measureHandle, 0);
        }
        catch (SemanticException e) {
            this.rollBack();
            ExceptionUtil.handle((Throwable)e);
            return;
        }
        this.transEnd();
    }
}

