/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.viewer.utilities;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.birt.report.viewer.ViewerPlugin;
import org.eclipse.birt.report.viewer.utilities.LogUtil;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.util.resource.URLResourceFactory;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.osgi.framework.Bundle;

public class ViewerWebServer {
    private static final String JETTY_HOME = "jetty.home";
    private static final String JETTY_BASE = "jetty.base";
    private static final String JETTY_HOST = "jetty.http.host";
    private static final String JETTY_PORT = "jetty.http.port";
    private static final String JETTY_FOLDER_NAME = "jetty";
    private static final String JETTY_HOME_FOLDER_NAME = "home";
    private static final String JETTY_BASE_FOLDER_NAME = "base";
    private static String[] configFiles = new String[]{"/etc/jetty.xml", "/etc/jetty-http.xml", "/etc/jetty-deploy.xml"};
    public static final String VIEWER_WEB_SERVER_ID = "org.eclipse.birt.report.viewer.server";
    private String host;
    private int port;
    private Server server;

    static {
        URLResourceFactory urlResourceFactory = new URLResourceFactory();
        ResourceFactory.registerResourceFactory((String)"bundleresource", (ResourceFactory)urlResourceFactory);
        ResourceFactory.registerResourceFactory((String)"bundleentry", (ResourceFactory)urlResourceFactory);
    }

    public ViewerWebServer(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public void start() {
        LogUtil.logInfo("BIRT Server starting", null);
        if (this.port > 0) {
            try {
                this.server = ViewerWebServer.startAndConfigure(this.host, this.port);
                LogUtil.logInfo(String.format("BIRT HTTP Server listening to: %s:%s", this.host, this.port), null);
            }
            catch (Exception e) {
                LogUtil.logError("Error while initialzing http server.", e);
            }
        } else {
            LogUtil.logError(String.format("Could not start BIRT server. HTTP port configuration: \"%s\"", this.port), null);
        }
    }

    private static Server startAndConfigure(String httpListenOnAddress, int httpServerPort) throws Exception {
        Bundle bundle = ViewerPlugin.getDefault().getBundle();
        String jettyBase = "jetty/home";
        ArrayList<URL> resolvedXmlPaths = new ArrayList<URL>();
        String[] stringArray = configFiles;
        int n = configFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String xmlFile = stringArray[n2];
            URL url = bundle.getEntry(jettyBase + xmlFile);
            URL fileURL = FileLocator.toFileURL((URL)url);
            if (fileURL != null) {
                resolvedXmlPaths.add(fileURL);
            }
            ++n2;
        }
        URL jettyHomeUrl = bundle.getEntry("jetty/home");
        URL jettyHomeFileUrl = FileLocator.toFileURL((URL)jettyHomeUrl);
        URL jettyBaseUrl = bundle.getEntry("jetty/base");
        URL jettyBaseFileUrl = FileLocator.toFileURL((URL)jettyBaseUrl);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(JETTY_HOST, httpListenOnAddress);
        properties.put(JETTY_PORT, String.valueOf(httpServerPort));
        properties.put(JETTY_HOME, jettyHomeFileUrl.toString());
        properties.put(JETTY_BASE, jettyBaseFileUrl.toString());
        HashMap idMap = new HashMap();
        ClassLoader currentContextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(ViewerWebServer.class.getClassLoader());
        Throwable throwable = null;
        Object var13_16 = null;
        try (ResourceFactory.Closeable resourceFactory = ResourceFactory.closeable();){
            for (URL resolvedXmlPath : resolvedXmlPaths) {
                Resource xmlResource = resourceFactory.newResource(resolvedXmlPath);
                XmlConfiguration configuration = new XmlConfiguration(xmlResource);
                configuration.getIdMap().putAll(idMap);
                configuration.getProperties().putAll(properties);
                configuration.configure();
                idMap.putAll(configuration.getIdMap());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Thread.currentThread().setContextClassLoader(currentContextClassLoader);
        Server server = (Server)idMap.get("Server");
        server.start();
        return server;
    }

    public void stop() {
        if (this.server != null) {
            try {
                this.server.stop();
                this.server = null;
            }
            catch (Exception e) {
                LogUtil.logError("Could not stop BIRT server.", e);
            }
        }
    }

    public Server getServer() {
        return this.server;
    }
}

