/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.viewer.utilities;

import java.net.URI;
import java.net.URL;
import java.util.function.Supplier;
import org.apache.tomcat.InstanceManager;
import org.apache.tomcat.SimpleInstanceManager;
import org.eclipse.birt.report.viewer.utilities.ViewerWebServer;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jetty.ee8.webapp.Configuration;
import org.eclipse.jetty.ee8.webapp.WebAppClassLoader;
import org.eclipse.jetty.ee8.webapp.WebAppContext;
import org.eclipse.jetty.ee8.webapp.WebXmlConfiguration;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.osgi.framework.Bundle;

public class ViewerWebApp {
    private Bundle bundle;
    private String webAppPath;
    private String contextPath;
    private String encoding;
    private Server server;
    private WebAppContext webAppContext;

    ViewerWebApp(Server server, Bundle bundle, String webAppPath, String contextPath, String encoding) {
        this.server = server;
        this.bundle = bundle;
        this.webAppPath = webAppPath;
        this.contextPath = contextPath;
        this.encoding = encoding;
    }

    public void start() throws Exception {
        Handler handler;
        this.webAppContext = new WebAppContext();
        this.webAppContext.setContextPath(this.contextPath);
        WebXmlConfiguration servletsConfiguration = new WebXmlConfiguration();
        this.webAppContext.addConfiguration(new Configuration[]{servletsConfiguration});
        this.webAppContext.setAttribute(InstanceManager.class.getName(), (Object)new SimpleInstanceManager());
        URL webAppUrl = this.bundle.getEntry(this.webAppPath);
        URL webDescriptorUrl = this.bundle.getEntry(this.webAppPath + "/WEB-INF/web-viewer.xml");
        if (webAppUrl != null && webDescriptorUrl != null) {
            URI resolvedWebAppUrl = FileLocator.resolve((URL)webAppUrl).toURI().normalize();
            URI resolvedWebDescriptorUrl = FileLocator.resolve((URL)webDescriptorUrl).toURI().normalize();
            this.webAppContext.setBaseResourceAsString(resolvedWebAppUrl.toString());
            this.webAppContext.setDescriptor(resolvedWebDescriptorUrl.toString());
        }
        if (this.encoding != null) {
            System.setProperty("org.eclipse.jetty.util.UrlEncoding.charset", this.encoding);
            System.setProperty("org.eclipse.jetty.util.URI.charset", this.encoding);
        }
        if ((handler = this.server.getHandler()) instanceof ContextHandlerCollection) {
            ContextHandlerCollection contextHandlerCollection = (ContextHandlerCollection)handler;
            contextHandlerCollection.addHandler((Supplier)this.webAppContext);
        }
        this.webAppContext.setClassLoader(ViewerWebServer.class.getClassLoader());
        WebAppClassLoader.runWithServerClassAccess(() -> {
            this.webAppContext.start();
            return null;
        });
    }

    public void stop() throws Exception {
        if (this.webAppContext != null) {
            this.webAppContext.stop();
            Handler handler = this.server.getHandler();
            if (handler instanceof ContextHandlerCollection) {
                ContextHandlerCollection contextHandlerCollection = (ContextHandlerCollection)handler;
                contextHandlerCollection.removeHandler(this.webAppContext.get());
            }
            this.webAppContext = null;
        }
    }
}

