/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi;

import org.eclipse.jetty.deploy.App;
import org.eclipse.jetty.deploy.bindings.StandardDeployer;
import org.eclipse.jetty.deploy.graph.Node;
import org.eclipse.jetty.osgi.OSGiApp;
import org.eclipse.jetty.osgi.util.EventSender;
import org.eclipse.jetty.server.Server;

public class OSGiDeployer
extends StandardDeployer {
    private Server _server;

    public OSGiDeployer(Server server) {
        this._server = server;
    }

    public void processBinding(Node node, App app) throws Exception {
        if (!(app instanceof OSGiApp)) {
            this.doProcessBinding(node, app);
        } else {
            EventSender.getInstance().send("org/osgi/service/web/DEPLOYING", ((OSGiApp)app).getBundle(), app.getContextPath());
            try {
                this.doProcessBinding(node, app);
                ((OSGiApp)app).registerAsOSGiService();
                EventSender.getInstance().send("org/osgi/service/web/DEPLOYED", ((OSGiApp)app).getBundle(), app.getContextPath());
            }
            catch (Exception e) {
                EventSender.getInstance().send("org/osgi/service/web/FAILED", ((OSGiApp)app).getBundle(), app.getContextPath());
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doProcessBinding(Node node, App app) throws Exception {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        ClassLoader cl = (ClassLoader)this._server.getAttribute("org.eclipse.jetty.osgi.server.classLoader");
        Thread.currentThread().setContextClassLoader(cl);
        try {
            super.processBinding(node, app);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }
}

