/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.junit.runtime;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.internal.junit.runner.RemoteTestRunner;
import org.eclipse.pde.internal.junit.runtime.MultiBundleClassLoader;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.wiring.BundleWiring;

public class RemotePluginTestRunner
extends RemoteTestRunner {
    private String fTestPluginName;
    private ClassLoader fLoaderClassLoader;

    public static void main(String[] args) {
        RemotePluginTestRunner testRunner = new RemotePluginTestRunner();
        testRunner.init(args);
        ClassLoader currentTCCL = Thread.currentThread().getContextClassLoader();
        if (RemotePluginTestRunner.isJUnit5(args)) {
            Thread.currentThread().setContextClassLoader(RemotePluginTestRunner.createJUnit5PluginClassLoader(testRunner.getTestPluginName()));
        }
        testRunner.run();
        if (RemotePluginTestRunner.isJUnit5(args)) {
            Thread.currentThread().setContextClassLoader(currentTCCL);
        }
    }

    private static ClassLoader createJUnit5PluginClassLoader(String testPluginName) {
        Bundle testBundle = Platform.getBundle((String)testPluginName);
        if (testBundle == null) {
            throw new IllegalArgumentException("Bundle \"" + testPluginName + "\" not found. Possible causes include missing dependencies, too restrictive version ranges, or a non-matching required execution environment.");
        }
        Bundle junit5RuntimeBundle = Platform.getBundle((String)"org.eclipse.jdt.junit5.runtime");
        List<Bundle> platformEngineBundles = RemotePluginTestRunner.findTestEngineBundles();
        platformEngineBundles.add(testBundle);
        if (junit5RuntimeBundle != null) {
            platformEngineBundles.add(junit5RuntimeBundle);
        }
        return new MultiBundleClassLoader(platformEngineBundles);
    }

    private static List<Bundle> findTestEngineBundles() {
        BundleContext bundleContext = FrameworkUtil.getBundle(RemotePluginTestRunner.class).getBundleContext();
        ArrayList<Bundle> engineBundles = new ArrayList<Bundle>();
        Bundle[] bundleArray = bundleContext.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            try {
                BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
                Collection listResources = bundleWiring.listResources("META-INF/services", "org.junit.platform.engine.TestEngine", 2);
                if (!listResources.isEmpty()) {
                    engineBundles.add(bundle);
                }
            }
            catch (Exception exception) {}
            ++n2;
        }
        return engineBundles;
    }

    protected ClassLoader getTestClassLoader() {
        String pluginId = this.getTestPluginName();
        return this.getClassLoader(pluginId);
    }

    public ClassLoader getClassLoader(String bundleId) {
        Bundle bundle = Platform.getBundle((String)bundleId);
        if (bundle == null) {
            throw new IllegalArgumentException("Bundle \"" + bundleId + "\" not found. Possible causes include missing dependencies, too restrictive version ranges, or a non-matching required execution environment.");
        }
        return new BundleClassLoader(bundle);
    }

    public void init(String[] args) {
        this.readPluginArgs(args);
        if (RemotePluginTestRunner.isJUnit5(args)) {
            ClassLoader currentTCCL = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(new MultiBundleClassLoader(RemotePluginTestRunner.findTestEngineBundles()));
                this.defaultInit(args);
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentTCCL);
            }
            return;
        }
        this.defaultInit(args);
    }

    private static boolean isJUnit5(String[] args) {
        if (RemotePluginTestRunner.indexOf(args, "-runasjunit5"::equalsIgnoreCase) <= -1) {
            if (RemotePluginTestRunner.indexOf(args, "org.eclipse.jdt.internal.junit5.runner.JUnit5TestLoader"::equals) <= -1) {
                return false;
            }
        }
        return true;
    }

    public void readPluginArgs(String[] args) {
        this.fTestPluginName = RemotePluginTestRunner.getArgumentValue(args, "-testpluginname");
        String loaderPlugin = RemotePluginTestRunner.getArgumentValue(args, "-loaderpluginname");
        if (loaderPlugin != null) {
            this.fLoaderClassLoader = this.getClassLoader(loaderPlugin);
        }
        if (this.getTestPluginName() == null) {
            throw new IllegalArgumentException("Parameter -testpluginnname not specified.");
        }
        if (this.fLoaderClassLoader == null) {
            this.fLoaderClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
        }
    }

    protected Class<?> loadTestLoaderClass(String className) throws ClassNotFoundException {
        return this.fLoaderClassLoader.loadClass(className);
    }

    static String getArgumentValue(String[] arguments, String key) {
        int index = RemotePluginTestRunner.indexOf(arguments, key::equalsIgnoreCase);
        return index >= 0 && index + 1 < arguments.length ? arguments[index + 1] : null;
    }

    private static int indexOf(String[] args, Predicate<String> isKey) {
        int i = 0;
        while (i < args.length) {
            if (isKey.test(args[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String getTestPluginName() {
        return this.fTestPluginName;
    }

    static class BundleClassLoader
    extends ClassLoader {
        private final Bundle bundle;

        public BundleClassLoader(Bundle target) {
            this.bundle = target;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            return this.bundle.loadClass(name);
        }

        @Override
        protected URL findResource(String name) {
            return this.bundle.getResource(name);
        }

        @Override
        protected Enumeration<URL> findResources(String name) throws IOException {
            return this.bundle.getResources(name);
        }
    }
}

