/*******************************************************************************
 * Copyright (c) 2004 Actuate Corporation.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * https://www.eclipse.org/legal/epl-2.0/.
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 *
 * Contributors:
 *  Actuate Corporation  - initial API and implementation
 *******************************************************************************/

package org.eclipse.birt.report.model.api.metadata;

import org.eclipse.birt.report.model.api.ModelException;
import org.eclipse.birt.report.model.i18n.MessageConstants;
import org.eclipse.birt.report.model.metadata.MetaDataParserException;

/**
 * Exception thrown if an error occurs when reading the meta-data description
 * file or the building the meta-data description.
 */

public class MetaDataReaderException extends ModelException {

	/**
	 * Comment for <code>serialVersionUID</code>.
	 */

	private static final long serialVersionUID = -6052803773978695357L;

	private MetaDataParserException e = null;

	/**
	 * Indicates there are ROM errors.
	 */

	public final static String DESIGN_EXCEPTION_META_DATA_ERROR = MessageConstants.META_DATA_READER_EXCEPTION_META_DATA_ERROR;

	/**
	 * Constructs the meta-data reader exception with the error code and the caused
	 * parser exception.
	 *
	 * @param errCode used to retrieve a piece of externalized message displayed to
	 *                end user
	 * @param cause   the nested exception
	 */
	public MetaDataReaderException(String errCode, MetaDataParserException cause) {
		super(PLUGIN_ID, errCode, null, null, cause);
		assert cause != null;
		this.e = cause;
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see java.lang.Throwable#getLocalizedMessage()
	 */

	@Override
	public String getLocalizedMessage() {
		return e.getLocalizedMessage();
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see java.lang.Throwable#getMessage()
	 */

	@Override
	public String getMessage() {
		return getLocalizedMessage();
	}
}
