/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.format.popup.axis;

import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Scale;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.AbstractScaleSheet;
import org.eclipse.swt.widgets.Composite;

public class AxisScaleSheet
extends AbstractScaleSheet {
    private Axis axis;
    private int axisAngleType;
    private Axis defAxis;

    public AxisScaleSheet(String title, ChartWizardContext context, Axis axis, int axisAngleType, Axis defAxis) {
        super(title, context);
        this.axis = axis;
        this.axisAngleType = axisAngleType;
        this.defAxis = defAxis;
    }

    protected Axis getAxisForProcessing() {
        return this.axis;
    }

    @Override
    protected Composite getComponent(Composite parent) {
        Composite comp = super.getComponent(parent);
        this.btnShowOutside.setVisible(!this.getAxisForProcessing().isSetType() || this.getValueType() == 1);
        return comp;
    }

    @Override
    protected Scale getScale() {
        return this.getAxisForProcessing().getScale();
    }

    @Override
    protected int getValueType() {
        if (this.getAxisForProcessing().getType() == AxisType.TEXT_LITERAL) {
            return 0;
        }
        if (this.getAxisForProcessing().getType() == AxisType.DATE_TIME_LITERAL) {
            return 2;
        }
        return 1;
    }

    @Override
    protected void setState() {
        boolean bEnabled = !(this.getAxisForProcessing().isSetCategoryAxis() && this.getAxisForProcessing().isCategoryAxis() || this.getAxisForProcessing().isSetType() && this.getAxisForProcessing().getType() == AxisType.TEXT_LITERAL);
        this.setState(bEnabled);
        if (this.axisAngleType != 2) {
            this.btnShowOutside.setEnabled(false);
            this.btnShowOutside.setSelectionState(2);
            this.getScale().setShowOutside(false);
        } else {
            this.getScale().setAutoExpand(true);
            this.btnAutoExpand.setSelectionState(1);
        }
        boolean bAxisX = this.axisAngleType == 1;
        boolean bEnableAutoExpand = !(!this.btnStepAuto.getSelection() || !bAxisX || this.getAxisForProcessing().isSetType() && this.getAxisForProcessing().getType() == AxisType.TEXT_LITERAL || this.getAxisForProcessing().isSetCategoryAxis() && this.getAxisForProcessing().isCategoryAxis());
        this.btnAutoExpand.setEnabled(bEnableAutoExpand);
        if (!(this.getAxisForProcessing().isSetType() && this.getAxisForProcessing().getType() != AxisType.LINEAR_LITERAL || !this.getAxisForProcessing().isSetCategoryAxis() && this.getAxisForProcessing().isCategoryAxis())) {
            if (!this.getAxisForProcessing().getScale().isSetStepNumber()) {
                this.btnFactor.setEnabled(true);
                if (this.btnFactor.getSelection()) {
                    this.txtFactor.setEnabled(true);
                } else {
                    this.txtFactor.setEnabled(false);
                }
            }
            if (this.btnFactor.getSelection()) {
                this.btnStepNumber.setEnabled(false);
                this.spnStepNumber.setEnabled(false);
                this.lblMax.setEnabled(false);
                this.txtScaleMax.setEnabled(false);
            }
        }
    }

    @Override
    protected Scale getDefaultVauleScale() {
        return this.defAxis.getScale();
    }
}

