/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.actions;

import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.jface.action.Action;

public class ChangeRulerUnitAction
extends Action {
    private String value = "";

    public ChangeRulerUnitAction(String value, String displayName) {
        this.value = value;
        this.setText(displayName);
        this.setChecked(this.isCheckValue());
    }

    public void run() {
        if (Policy.TRACING_ACTIONS) {
            System.out.println("Change ruler unit action >> Run ...");
        }
        try {
            this.getReportDesignHandle().setDefaultUnits(this.value);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
    }

    private boolean isCheckValue() {
        if (this.value == null) {
            return false;
        }
        return this.value.equals(this.getReportDesignHandle().getDefaultUnits());
    }

    private ModuleHandle getReportDesignHandle() {
        return SessionHandleAdapter.getInstance().getReportDesignHandle();
    }
}

