/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dnd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.CellHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.core.model.schematic.ListBandProxy;
import org.eclipse.birt.report.designer.core.model.schematic.TableHandleAdapter;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetUIUtil;
import org.eclipse.birt.report.designer.internal.ui.dialogs.DataSetBindingSelector;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ReportElementEditPart;
import org.eclipse.birt.report.designer.internal.ui.expressions.IExpressionConverter;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtendedDataModelUIAdapterHelper;
import org.eclipse.birt.report.designer.internal.ui.extension.IExtendedDataModelUIAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.DataUtil;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.ExpressionUtility;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.newelement.DesignElementFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.DNDUtil;
import org.eclipse.birt.report.designer.util.IVirtualValidator;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColumnHintHandle;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DerivedDataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.FormatValueHandle;
import org.eclipse.birt.report.model.api.FreeFormHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.JointDataSetHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.ListingHandle;
import org.eclipse.birt.report.model.api.MasterPageHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.VariableElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.Action;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.elements.structures.FormatValue;
import org.eclipse.birt.report.model.api.elements.structures.TOC;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;
import org.eclipse.birt.report.model.util.ModelUtil;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class InsertInLayoutUtil {
    protected static GroupHandle getGroupHandle(Object target) {
        DesignElementHandle handle = null;
        if (target instanceof CellHandle) {
            handle = ((CellHandle)target).getContainer().getContainer();
        } else if (target instanceof ListBandProxy) {
            handle = ((ListBandProxy)target).getElemtHandle();
        }
        if (handle instanceof GroupHandle) {
            return (GroupHandle)handle;
        }
        return null;
    }

    protected static ReportItemHandle getGroupContainer(Object target) {
        GroupHandle group = InsertInLayoutUtil.getGroupHandle(target);
        if (group != null && group.getContainer() instanceof ReportItemHandle) {
            return (ReportItemHandle)group.getContainer();
        }
        return null;
    }

    public static DesignElementHandle performInsert(Object insertObj, Object target, Object targetParent) throws SemanticException {
        Assert.isNotNull((Object)insertObj);
        Assert.isNotNull((Object)target);
        if (insertObj instanceof DataSetHandle) {
            return InsertInLayoutUtil.performInsertDataSet((DataSetHandle)insertObj);
        }
        if (insertObj instanceof ResultSetColumnHandle) {
            return InsertInLayoutUtil.performInsertDataSetColumn((ResultSetColumnHandle)insertObj, target, targetParent);
        }
        if (insertObj instanceof MeasureHandle) {
            return InsertInLayoutUtil.performInsertLinkedDataModelMeasure((MeasureHandle)insertObj, target, (ReportItemHandle)targetParent);
        }
        if (insertObj instanceof ScalarParameterHandle) {
            return InsertInLayoutUtil.performInsertParameter((ScalarParameterHandle)insertObj);
        }
        if (insertObj instanceof VariableElementHandle) {
            return InsertInLayoutUtil.performInsertVariable((VariableElementHandle)insertObj);
        }
        if (insertObj instanceof String) {
            return InsertInLayoutUtil.performInsertString((String)insertObj, target);
        }
        if (insertObj instanceof Object[]) {
            return InsertInLayoutUtil.performMultiInsert((Object[])insertObj, target, targetParent);
        }
        if (insertObj instanceof IStructuredSelection) {
            return InsertInLayoutUtil.performMultiInsert(((IStructuredSelection)insertObj).toArray(), target, targetParent);
        }
        return null;
    }

    public static DesignElementHandle performInsert(Object insertObj, EditPart editPart) throws SemanticException {
        Assert.isNotNull((Object)insertObj);
        Assert.isNotNull((Object)editPart);
        return InsertInLayoutUtil.performInsert(insertObj, editPart.getModel(), editPart.getParent().getModel());
    }

    protected static DesignElementHandle performMultiInsert(Object[] array, Object target, Object targetParent) throws SemanticException {
        DesignElementHandle result = null;
        MultiItemsExpandRule rule = new MultiItemsExpandRule(array, target);
        if (rule.canInsert()) {
            Object[] positions = (Object[])rule.getInsertPosition();
            if (positions != null) {
                int i = 0;
                while (i < array.length) {
                    DesignElementHandle newObj = InsertInLayoutUtil.performInsert(array[i], positions[i], targetParent);
                    if (i == rule.getFocusIndex()) {
                        result = newObj;
                    } else {
                        DNDUtil.addElementHandle((Object)positions[i], (DesignElementHandle)newObj);
                        if (newObj instanceof DesignElementHandle) {
                            DEUtil.setDefaultTheme((DesignElementHandle)newObj);
                        }
                    }
                    ++i;
                }
            }
        } else if (array.length != 0) {
            result = InsertInLayoutUtil.performInsert(array[0], target, targetParent);
        }
        return result;
    }

    public static DataItemHandle performInsertParameter(ScalarParameterHandle model) throws SemanticException {
        DataItemHandle dataHandle = DesignElementFactory.getInstance().newDataItem(null);
        ComputedColumn bindingColumn = StructureFactory.newComputedColumn((DesignElementHandle)dataHandle, (String)model.getName());
        ExpressionUtility.setBindingColumnExpression(model, bindingColumn);
        String paramType = model.getDataType();
        if ("dateTime".equals(paramType)) {
            paramType = "date-time";
        }
        if ("multi-value".endsWith(model.getParamType())) {
            bindingColumn.setDataType("javaObject");
        } else {
            bindingColumn.setDataType(paramType);
        }
        dataHandle.addColumnBinding(bindingColumn, false);
        dataHandle.setResultSetColumn(bindingColumn.getName());
        return dataHandle;
    }

    public static DataItemHandle performInsertVariable(VariableElementHandle model) throws SemanticException {
        DataItemHandle dataHandle = DesignElementFactory.getInstance().newDataItem(null);
        ComputedColumn bindingColumn = StructureFactory.newComputedColumn((DesignElementHandle)dataHandle, (String)model.getName());
        bindingColumn.setExpression(DEUtil.getExpression((Object)model));
        String paramType = "string";
        bindingColumn.setDataType(paramType);
        dataHandle.addColumnBinding(bindingColumn, false);
        dataHandle.setResultSetColumn(bindingColumn.getName());
        return dataHandle;
    }

    private static GroupHandle addGroupHandle(TableHandle tableHandle, ResultSetColumnHandle model, DataItemHandle dataHandle, int index) throws SemanticException {
        String columnName = model.getColumnName();
        DesignElementFactory factory = DesignElementFactory.getInstance(tableHandle.getModuleHandle());
        TableGroupHandle groupHandle = factory.newTableGroup();
        int columnCount = tableHandle.getColumnCount();
        groupHandle.getHeader().add((DesignElementHandle)factory.newTableRow(columnCount));
        groupHandle.getFooter().add((DesignElementHandle)factory.newTableRow(columnCount));
        groupHandle.setName(columnName);
        groupHandle.setExpressionProperty("keyExpr", new Expression((Object)ExpressionUtility.getColumnExpression(columnName, ExpressionUtility.getExpressionConverter(UIUtil.getDefaultScriptType())), UIUtil.getDefaultScriptType()));
        TOC toc = StructureFactory.createTOC();
        toc.setExpressionProperty("expressionValue", new Expression((Object)ExpressionUtility.getColumnExpression(columnName, ExpressionUtility.getExpressionConverter(UIUtil.getDefaultScriptType())), UIUtil.getDefaultScriptType()));
        groupHandle.addTOC(toc);
        RowHandle rowHandle = (RowHandle)groupHandle.getHeader().get(0);
        CellHandle cellHandle = null;
        if (index >= 0 && index < rowHandle.getCells().getCount()) {
            cellHandle = (CellHandle)rowHandle.getCells().get(index);
        }
        if (cellHandle == null) {
            cellHandle = (CellHandle)rowHandle.getCells().get(0);
        }
        cellHandle.getContent().add((DesignElementHandle)dataHandle);
        SlotHandle header = tableHandle.getHeader();
        if (header != null && header.getCount() > 0) {
            CellHandle newTarget = null;
            if (index >= 0) {
                newTarget = (CellHandle)HandleAdapterFactory.getInstance().getTableHandleAdapter((Object)tableHandle).getCell(1, index + 1, false);
            }
            if (newTarget == null) {
                newTarget = (CellHandle)HandleAdapterFactory.getInstance().getTableHandleAdapter((Object)tableHandle).getCell(1, 1, false);
            }
            if (newTarget != null && newTarget.getContent().getCount() == 0) {
                LabelHandle label = DesignElementFactory.getInstance().newLabel(null);
                label.setText(UIUtil.getColumnDisplayName(model));
                newTarget.addElement((DesignElementHandle)label, 0);
            }
        }
        return groupHandle;
    }

    protected static DesignElementHandle performInsertDataSetColumn(ResultSetColumnHandle model, Object target, Object targetParent) throws SemanticException {
        TableHandle tableHandle;
        DataItemHandle dataHandle = DesignElementFactory.getInstance().newDataItem(null);
        DataSetHandle dataSet = InsertInLayoutUtil.getDataSet(model);
        if (targetParent instanceof TableHandle && (tableHandle = (TableHandle)targetParent).isSummaryTable()) {
            InsertInLayoutUtil.setDataSet((ReportItemHandle)tableHandle, dataSet);
            InsertInLayoutUtil.setDataItemAction(model, dataHandle);
            if ("dimension".equals(UIUtil.getColumnAnalysis(model))) {
                ComputedColumn bindingColumn = StructureFactory.newComputedColumn((DesignElementHandle)tableHandle, (String)model.getColumnName());
                bindingColumn.setDataType(model.getDataType());
                ExpressionUtility.setBindingColumnExpression(model, bindingColumn);
                bindingColumn.setDisplayName(UIUtil.getColumnDisplayName(model));
                String displayKey = UIUtil.getColumnDisplayNameKey(model);
                if (displayKey != null) {
                    bindingColumn.setDisplayNameID(displayKey);
                }
                tableHandle.addColumnBinding(bindingColumn, false);
                dataHandle.setResultSetColumn(model.getColumnName());
                SlotHandle slotHandle = tableHandle.getGroups();
                for (Object o : slotHandle.getContents()) {
                    CellHandle cellTarget;
                    GroupHandle group = (GroupHandle)o;
                    if (!group.getName().equals(model.getColumnName())) continue;
                    if (target instanceof CellHandle && (cellTarget = (CellHandle)target).getContent().getCount() == 0) {
                        return dataHandle;
                    }
                    return null;
                }
                int index = -1;
                if (target instanceof CellHandle) {
                    CellHandle cellTarget = (CellHandle)target;
                    CellHandleAdapter cellAdapter = HandleAdapterFactory.getInstance().getCellHandleAdapter((Object)cellTarget);
                    index = cellAdapter.getColumnNumber();
                }
                return InsertInLayoutUtil.addGroupHandle(tableHandle, model, dataHandle, index - 1);
            }
            if ("attribute".equals(UIUtil.getColumnAnalysis(model))) {
                DataSetHandle dataset = InsertInLayoutUtil.getDataSet(model);
                String str = UIUtil.getAnalysisColumn(model);
                String type = "";
                ResultSetColumnHandle newResultColumn = null;
                if (str != null) {
                    List<ColumnHintHandle> columnHints = DataUtil.getColumnHints(dataset);
                    ColumnHintHandle temp = null;
                    int i = 0;
                    while (i < columnHints.size()) {
                        ColumnHintHandle columnHintHandle = columnHints.get(i);
                        if (str.equals(columnHintHandle.getColumnName()) || str.equals(columnHintHandle.getAlias())) {
                            temp = columnHintHandle;
                            break;
                        }
                        ++i;
                    }
                    if (temp == null) {
                        return dataHandle;
                    }
                    List columnList = DataUtil.getColumnList(dataset);
                    int i2 = 0;
                    while (i2 < columnList.size()) {
                        ResultSetColumnHandle resultSetColumn = (ResultSetColumnHandle)columnList.get(i2);
                        if (temp != null && (temp.getAlias().equals(resultSetColumn.getColumnName()) || temp.getColumnName().equals(resultSetColumn.getColumnName()))) {
                            newResultColumn = resultSetColumn;
                            break;
                        }
                        ++i2;
                    }
                    for (ColumnHintHandle columnHint : columnHints) {
                        if (!str.equals(columnHint.getColumnName()) && !str.equals(columnHint.getAlias())) continue;
                        type = columnHint.getAnalysis();
                        break;
                    }
                    if ("dimension".equals(type)) {
                        boolean hasGroup = false;
                        SlotHandle slotHandle = tableHandle.getGroups();
                        for (Object o : slotHandle.getContents()) {
                            GroupHandle group = (GroupHandle)o;
                            if (!group.getName().equals(temp.getColumnName()) && !group.getName().equals(temp.getAlias())) continue;
                            hasGroup = true;
                        }
                        if (!hasGroup) {
                            ComputedColumn bindingColumn = StructureFactory.newComputedColumn((DesignElementHandle)tableHandle, (String)model.getColumnName());
                            bindingColumn.setDataType(model.getDataType());
                            ExpressionUtility.setBindingColumnExpression(model, bindingColumn);
                            bindingColumn.setDisplayName(UIUtil.getColumnDisplayName(model));
                            String displayKey = UIUtil.getColumnDisplayNameKey(model);
                            if (displayKey != null) {
                                bindingColumn.setDisplayNameID(displayKey);
                            }
                            tableHandle.addColumnBinding(bindingColumn, false);
                            dataHandle.setResultSetColumn(model.getColumnName());
                            bindingColumn = StructureFactory.newComputedColumn((DesignElementHandle)tableHandle, (String)newResultColumn.getColumnName());
                            bindingColumn.setDataType(newResultColumn.getDataType());
                            ExpressionUtility.setBindingColumnExpression(newResultColumn, bindingColumn);
                            bindingColumn.setDisplayName(UIUtil.getColumnDisplayName(newResultColumn));
                            displayKey = UIUtil.getColumnDisplayNameKey(newResultColumn);
                            if (displayKey != null) {
                                bindingColumn.setDisplayNameID(displayKey);
                            }
                            tableHandle.addColumnBinding(bindingColumn, false);
                            int index = -1;
                            if (target instanceof CellHandle) {
                                CellHandle cellTarget = (CellHandle)target;
                                CellHandleAdapter cellAdapter = HandleAdapterFactory.getInstance().getCellHandleAdapter((Object)cellTarget);
                                index = cellAdapter.getColumnNumber();
                            }
                            return InsertInLayoutUtil.addGroupHandle(tableHandle, newResultColumn, dataHandle, index - 1);
                        }
                    }
                }
                if (target instanceof CellHandle) {
                    ComputedColumn column = StructureFactory.newComputedColumn((DesignElementHandle)tableHandle, (String)model.getColumnName());
                    column.setDataType(model.getDataType());
                    ExpressionUtility.setBindingColumnExpression(model, column);
                    ComputedColumnHandle binding = DEUtil.addColumn((DesignElementHandle)tableHandle, (ComputedColumn)column, (boolean)false);
                    dataHandle.setResultSetColumn(binding.getName());
                    InsertInLayoutRule rule = new LabelAddRule(target);
                    if (rule.canInsert()) {
                        LabelHandle label = DesignElementFactory.getInstance().newLabel(null);
                        label.setText(UIUtil.getColumnDisplayName(model));
                        rule.insert(label);
                    }
                    if ((rule = new GroupKeySetRule(target, model)).canInsert()) {
                        rule.insert(model);
                    }
                    return dataHandle;
                }
            } else if ("measure".equals(UIUtil.getColumnAnalysis(model))) {
                CellHandle cellHandle = (CellHandle)target;
                ComputedColumn column = StructureFactory.newComputedColumn((DesignElementHandle)tableHandle, (String)model.getColumnName());
                ExpressionUtility.setBindingColumnExpression(model, column);
                column.setDataType(model.getDataType());
                ComputedColumnHandle binding = DEUtil.addColumn((DesignElementHandle)tableHandle, (ComputedColumn)column, (boolean)false);
                DesignElementHandle group = cellHandle.getContainer().getContainer();
                if (group instanceof GroupHandle) {
                    binding.setAggregateOn(((GroupHandle)group).getName());
                } else {
                    binding.setAggregateOn(null);
                }
                if ("integer".equals(model.getDataType()) || "float".equals(model.getDataType()) || "decimal".equals(model.getDataType())) {
                    binding.setAggregateFunction("sum");
                } else {
                    binding.setAggregateFunction("max");
                }
                dataHandle.setResultSetColumn(binding.getName());
                InsertInLayoutUtil.formatDataHandle(dataHandle, model);
                InsertInLayoutRule rule = new LabelAddRule(target);
                if (rule.canInsert()) {
                    LabelHandle label = DesignElementFactory.getInstance().newLabel(null);
                    label.setText(UIUtil.getColumnDisplayName(model));
                    rule.insert(label);
                }
                if ((rule = new GroupKeySetRule(target, model)).canInsert()) {
                    rule.insert(model);
                }
                return dataHandle;
            }
        }
        dataHandle.setResultSetColumn(model.getColumnName());
        InsertInLayoutUtil.formatDataHandle(dataHandle, model);
        if (targetParent instanceof ReportItemHandle) {
            ComputedColumn bindingColumn;
            ReportItemHandle container = (ReportItemHandle)targetParent;
            ReportItemHandle root = DEUtil.getBindingRoot((DesignElementHandle)container);
            if (root == null) {
                if ((container = DEUtil.getListingContainer((DesignElementHandle)container)) == null) {
                    bindingColumn = InsertInLayoutUtil.createBindingColumn(target, (ReportItemHandle)dataHandle, model);
                    InsertInLayoutUtil.setDataSet((ReportItemHandle)dataHandle, dataSet);
                    dataHandle.addColumnBinding(bindingColumn, false);
                } else {
                    bindingColumn = InsertInLayoutUtil.createBindingColumn(target, container, model);
                    InsertInLayoutUtil.setDataSet(container, dataSet);
                    container.addColumnBinding(bindingColumn, false);
                }
            } else if (root.getDataSet() == dataSet || InsertInLayoutUtil.getAdapter() != null && root.getDataSet() != null && InsertInLayoutUtil.getAdapter().resolveExtendedData((DesignElementHandle)root.getDataSet()).equals(InsertInLayoutUtil.getAdapter().resolveExtendedData((DesignElementHandle)dataSet))) {
                container = DEUtil.getBindingHolder((DesignElementHandle)container);
                bindingColumn = InsertInLayoutUtil.createBindingColumn(target, container, model);
                container.addColumnBinding(bindingColumn, false);
            } else {
                ListingHandle listingHandle = DEUtil.getListingContainer((DesignElementHandle)container);
                if (listingHandle != null && DEUtil.getBindingRoot((DesignElementHandle)listingHandle) == root && DEUtil.getBindingHolder((DesignElementHandle)listingHandle) != listingHandle) {
                    ComputedColumn bindingColumn2 = InsertInLayoutUtil.createBindingColumn(target, (ReportItemHandle)listingHandle, model);
                    InsertInLayoutUtil.setDataSet((ReportItemHandle)listingHandle, dataSet);
                    listingHandle.addColumnBinding(bindingColumn2, false);
                }
            }
        } else {
            ComputedColumn bindingColumn = StructureFactory.newComputedColumn((DesignElementHandle)dataHandle, (String)model.getColumnName());
            bindingColumn.setDataType(model.getDataType());
            ExpressionUtility.setBindingColumnExpression(model, bindingColumn);
            bindingColumn.setDisplayName(UIUtil.getColumnDisplayName(model));
            String displayKey = UIUtil.getColumnDisplayNameKey(model);
            if (displayKey != null) {
                bindingColumn.setDisplayNameID(displayKey);
            }
            if (target instanceof DesignElementHandle && ExpressionUtil.hasAggregation((String)bindingColumn.getExpression())) {
                String groupType = DEUtil.getGroupControlType((DesignElementHandle)((DesignElementHandle)target));
                if (groupType.equals("group")) {
                    bindingColumn.setAggregateOn(((GroupHandle)DEUtil.getGroups((DesignElementHandle)((DesignElementHandle)target)).get(0)).getName());
                } else if (groupType.equals("listing")) {
                    bindingColumn.setAggregateOn(null);
                }
            }
            dataHandle.addColumnBinding(bindingColumn, false);
            InsertInLayoutUtil.setDataSet((ReportItemHandle)dataHandle, dataSet);
        }
        InsertInLayoutUtil.setDataItemAction(model, dataHandle);
        InsertInLayoutRule rule = new LabelAddRule(target);
        if (rule.canInsert()) {
            LabelHandle label = DesignElementFactory.getInstance().newLabel(null);
            label.setText(UIUtil.getHeadColumnDisplayName(model));
            String displayKey = UIUtil.getColumnHeaderDisplayNameKey(model);
            if (displayKey == null) {
                displayKey = UIUtil.getColumnDisplayNameKey(model);
            }
            if (displayKey != null) {
                label.setTextKey(displayKey);
            }
            rule.insert(label);
        }
        if ((rule = new GroupKeySetRule(target, model)).canInsert()) {
            rule.insert(model);
        }
        return dataHandle;
    }

    private static String getComputedColumnName(ReportItemHandle tableHandle, MeasureHandle model, GroupHandle group) {
        return String.valueOf(model.getName()) + (group == null ? "_All" : "_" + group.getName());
    }

    protected static DesignElementHandle performInsertLinkedDataModelMeasure(MeasureHandle model, Object target, ReportItemHandle tableHandle) throws SemanticException {
        DataItemHandle dataHandle = DesignElementFactory.getInstance().newDataItem(null);
        InsertInLayoutUtil.setDataItemAction(model, dataHandle);
        InsertInLayoutUtil.formatDataHandle(dataHandle, model);
        GroupHandle group = InsertInLayoutUtil.getGroupHandle(target);
        String bindingName = InsertInLayoutUtil.getComputedColumnName(tableHandle, model, group);
        ComputedColumn bindingColumn = StructureFactory.newComputedColumn((DesignElementHandle)tableHandle, (String)bindingName);
        bindingColumn.setDataType(model.getDataType());
        String defaultScriptType = UIUtil.getDefaultScriptType();
        IExpressionConverter converter = ExpressionUtility.getExpressionConverter(defaultScriptType);
        String expression = null;
        boolean isOnlySupportJS = false;
        if (converter != null && !isOnlySupportJS) {
            expression = converter.getMeasureExpression(model.getName());
        } else {
            defaultScriptType = "javascript";
            expression = ExpressionUtil.createJSMeasureExpression((String)model.getName());
        }
        Expression bindingExpression = new Expression((Object)expression, defaultScriptType);
        bindingColumn.setExpressionProperty("expression", bindingExpression);
        bindingColumn.setDisplayName(model.getDisplayName());
        String displayKey = model.getDisplayNameKey();
        if (displayKey != null) {
            bindingColumn.setDisplayNameID(displayKey);
        }
        bindingColumn.setAggregateOn(group == null ? "All" : group.getName());
        tableHandle.addColumnBinding(bindingColumn, false);
        dataHandle.setResultSetColumn(bindingName);
        InsertInLayoutRule rule = new LabelAddRule(target);
        if (rule.canInsert()) {
            LabelHandle label = DesignElementFactory.getInstance().newLabel(null);
            label.setText(InsertInLayoutUtil.getLabelText((ReportElementHandle)model));
            rule.insert(label);
        }
        if ((rule = new GroupKeySetRule(target, model)).canInsert()) {
            rule.insert(model);
        }
        return dataHandle;
    }

    private static String getLabelText(ReportElementHandle handle) {
        if (handle.getDisplayName() != null) {
            return handle.getDisplayName();
        }
        return handle.getName();
    }

    private static void setDataItemAction(MeasureHandle model, DataItemHandle dataHandle) {
        ActionHandle actionHandle = model.getActionHandle();
        if (actionHandle != null) {
            ArrayList<IStructure> source = new ArrayList<IStructure>();
            source.add(actionHandle.getStructure());
            ArrayList newAction = ModelUtil.cloneStructList(source);
            try {
                dataHandle.setAction((Action)newAction.get(0));
            }
            catch (SemanticException semanticException) {
                // empty catch block
            }
        }
    }

    private static void setDataItemAction(ResultSetColumnHandle model, DataItemHandle dataHandle) {
        ActionHandle actionHandle = UIUtil.getColumnAction(model);
        if (actionHandle != null) {
            ArrayList<IStructure> source = new ArrayList<IStructure>();
            source.add(actionHandle.getStructure());
            ArrayList newAction = ModelUtil.cloneStructList(source);
            try {
                dataHandle.setAction((Action)newAction.get(0));
            }
            catch (SemanticException semanticException) {
                // empty catch block
            }
        }
    }

    private static ComputedColumn createBindingColumn(Object target, ReportItemHandle bindingHolder, ResultSetColumnHandle model) {
        ComputedColumn bindingColumn = StructureFactory.newComputedColumn((DesignElementHandle)bindingHolder, (String)model.getColumnName());
        bindingColumn.setDataType(model.getDataType());
        ExpressionUtility.setBindingColumnExpression(model, bindingColumn);
        bindingColumn.setDisplayName(UIUtil.getColumnDisplayName(model));
        String displayKey = UIUtil.getColumnDisplayNameKey(model);
        if (displayKey != null) {
            bindingColumn.setDisplayNameID(displayKey);
        }
        if (target instanceof DesignElementHandle && ExpressionUtil.hasAggregation((String)bindingColumn.getExpression())) {
            String groupType = DEUtil.getGroupControlType((DesignElementHandle)((DesignElementHandle)target));
            if (groupType.equals("group")) {
                bindingColumn.setAggregateOn(((GroupHandle)DEUtil.getGroups((DesignElementHandle)((DesignElementHandle)target)).get(0)).getName());
            } else if (groupType.equals("listing")) {
                bindingColumn.setAggregateOn(null);
            }
        }
        return bindingColumn;
    }

    protected static DesignElementHandle performInsertString(String expression, Object target) throws SemanticException {
        DataItemHandle dataHandle = DesignElementFactory.getInstance().newDataItem(null);
        dataHandle.setResultSetColumn(expression);
        LabelAddRule rule = new LabelAddRule(target);
        if (rule.canInsert()) {
            LabelHandle label = DesignElementFactory.getInstance().newLabel(null);
            label.setText(expression);
            rule.insert(label);
        }
        return dataHandle;
    }

    protected static TableHandle performInsertDataSet(DataSetHandle model) throws SemanticException {
        DataSetBindingSelector selector = new DataSetBindingSelector(UIUtil.getDefaultShell(), Messages.getString((String)"DataSetBindingSelectorPage.Title"));
        selector.setDatasetHandle(model);
        selector.setValidateEmptyResults(true);
        if (selector.open() == 0) {
            Object[] datasetInfo = (Object[])selector.getResult();
            Object[] selectedColumns = (Object[])datasetInfo[1];
            ResultSetColumnHandle[] columns = new ResultSetColumnHandle[selectedColumns.length];
            int i = 0;
            while (i < selectedColumns.length) {
                columns[i] = (ResultSetColumnHandle)selectedColumns[i];
                ++i;
            }
            TableHandle tableHandle = DesignElementFactory.getInstance().newTableItem(null, columns.length);
            InsertInLayoutUtil.setInitWidth(tableHandle);
            InsertInLayoutUtil.insertToCell(model, tableHandle, tableHandle.getHeader(), columns, true);
            InsertInLayoutUtil.insertToCell(model, tableHandle, tableHandle.getDetail(), columns, false);
            InsertInLayoutUtil.setDataSet((ReportItemHandle)tableHandle, model);
            return tableHandle;
        }
        return null;
    }

    public static boolean handleValidateInsertToLayout(Object insertObj, EditPart targetPart) {
        if (targetPart == null) {
            return false;
        }
        if (insertObj instanceof Object[]) {
            Object[] array = (Object[])insertObj;
            if (!InsertInLayoutUtil.checkSameDataSetInMultiColumns(array) || !InsertInLayoutUtil.checkContainContainMulitItem(array, targetPart.getModel())) {
                return false;
            }
            int i = 0;
            while (i < array.length) {
                if (!InsertInLayoutUtil.handleValidateInsertToLayout(array[i], targetPart)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (insertObj instanceof IStructuredSelection) {
            return InsertInLayoutUtil.handleValidateInsertToLayout(((IStructuredSelection)insertObj).toArray(), targetPart);
        }
        if (insertObj instanceof DataSetHandle) {
            return InsertInLayoutUtil.isHandleValid((DesignElementHandle)((DataSetHandle)insertObj)) && InsertInLayoutUtil.handleValidateDataSet(targetPart);
        }
        if (insertObj instanceof ResultSetColumnHandle) {
            return InsertInLayoutUtil.handleValidateDataSetColumn((ResultSetColumnHandle)insertObj, targetPart);
        }
        if (insertObj instanceof LabelHandle) {
            return InsertInLayoutUtil.handleValidateLabel((LabelHandle)insertObj, targetPart);
        }
        if (insertObj instanceof ScalarParameterHandle) {
            return InsertInLayoutUtil.isHandleValid((DesignElementHandle)((ScalarParameterHandle)insertObj)) && InsertInLayoutUtil.handleValidateParameter(targetPart);
        }
        if (insertObj instanceof MeasureHandle) {
            Object target = targetPart.getModel();
            GroupHandle group = InsertInLayoutUtil.getGroupHandle(target);
            if (group != null) {
                return true;
            }
            if (target instanceof CellHandle) {
                DesignElementHandle container = ((CellHandle)target).getContainer();
                if (container instanceof RowHandle) {
                    RowHandle row = (RowHandle)container;
                    SlotHandle slotHandle = row.getContainerSlotHandle();
                    int slotId = slotHandle.getSlotID();
                    return slotId != 2;
                }
            } else if (target instanceof ListBandProxy) {
                int type = ((ListBandProxy)target).getType();
                return type != 3;
            }
        }
        return false;
    }

    private static boolean handleValidateLabel(LabelHandle handle, EditPart targetPart) {
        Object obj;
        if (targetPart.getModel() instanceof IAdaptable && (obj = ((IAdaptable)targetPart.getModel()).getAdapter(DesignElementHandle.class)) instanceof ExtendedItemHandle) {
            return ((ExtendedItemHandle)obj).canContain(DEUtil.getDefaultContentName((Object)obj), (DesignElementHandle)handle);
        }
        return false;
    }

    private static boolean checkContainContainMulitItem(Object[] objects, Object slotHandle) {
        SlotHandle handle = null;
        if (slotHandle instanceof SlotHandle) {
            handle = (SlotHandle)slotHandle;
        }
        return handle == null || objects == null || objects.length <= 1 || handle.getDefn().isMultipleCardinality();
    }

    protected static boolean checkSameDataSetInMultiColumns(Object[] array) {
        if (array == null) {
            return false;
        }
        DataSetHandle dataSet = null;
        int i = 0;
        while (i < array.length) {
            if (array[i] instanceof ResultSetColumnHandle) {
                DataSetHandle currDataSet = InsertInLayoutUtil.getDataSet((ResultSetColumnHandle)array[i]);
                if (currDataSet == null) {
                    return false;
                }
                if (dataSet == null) {
                    dataSet = currDataSet;
                } else if (dataSet != currDataSet) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    protected static boolean handleValidateDataSetDropContainer(EditPart dropPart) {
        if (dropPart.getParent() == null) {
            return false;
        }
        Object container = dropPart.getParent().getModel();
        return container instanceof GridHandle || container instanceof TableHandle || container instanceof FreeFormHandle || container instanceof ListHandle || dropPart.getModel() instanceof ModuleHandle;
    }

    protected static boolean handleValidateDataSetColumnDropContainer(EditPart dropPart) {
        if (dropPart.getParent() == null) {
            return false;
        }
        Object container = dropPart.getParent().getModel();
        return container instanceof GridHandle || container instanceof TableHandle || container instanceof FreeFormHandle || container instanceof ListHandle || container instanceof MasterPageHandle || dropPart.getModel() instanceof ModuleHandle;
    }

    protected static boolean handleValidateMeasureDropContainer(MeasureHandle measure, EditPart dropPart) {
        if (dropPart.getModel() instanceof IVirtualValidator) {
            return ((IVirtualValidator)dropPart.getModel()).handleValidate((Object)measure);
        }
        return false;
    }

    protected static boolean handleValidateDimensionDropContainer(DimensionHandle dimension, EditPart dropPart) {
        if (dropPart.getModel() instanceof IVirtualValidator) {
            return ((IVirtualValidator)dropPart.getModel()).handleValidate((Object)dimension);
        }
        return false;
    }

    protected static boolean handleValidateParameterDropContainer(EditPart dropPart) {
        if (dropPart.getParent() == null) {
            return false;
        }
        Object container = dropPart.getParent().getModel();
        return container instanceof GridHandle || container instanceof TableHandle || container instanceof FreeFormHandle || container instanceof ListHandle || dropPart.getModel() instanceof ModuleHandle;
    }

    protected static boolean handleValidateDataSet(EditPart target) {
        return InsertInLayoutUtil.handleValidateDataSetDropContainer(target) && DNDUtil.handleValidateTargetCanContainType((Object)target.getModel(), (String)"Table");
    }

    protected static boolean handleValidateDimension(DimensionHandle insertObj, EditPart target) {
        return InsertInLayoutUtil.handleValidateDimensionDropContainer(insertObj, target);
    }

    protected static boolean handleValidateMeasure(MeasureHandle insertObj, EditPart target) {
        return InsertInLayoutUtil.handleValidateMeasureDropContainer(insertObj, target);
    }

    protected static boolean handleValidateDataSetColumn(ResultSetColumnHandle insertObj, EditPart target) {
        if (InsertInLayoutUtil.handleValidateDataSetColumnDropContainer(target) && DNDUtil.handleValidateTargetCanContainType((Object)target.getModel(), (String)"Data")) {
            if (target.getModel() instanceof ModuleHandle || InsertInLayoutUtil.isMasterPageHeaderOrFooter(target.getModel())) {
                return true;
            }
            DesignElementHandle handle = (DesignElementHandle)target.getParent().getModel();
            if (handle instanceof TableHandle && target.getModel() instanceof CellHandle && ((TableHandle)handle).isSummaryTable()) {
                TableHandle tableHandle = (TableHandle)handle;
                CellHandle cellHandle = (CellHandle)target.getModel();
                if ("dimension".equals(UIUtil.getColumnAnalysis(insertObj))) {
                    if (cellHandle.getContent().getCount() == 0) {
                        return true;
                    }
                    return !InsertInLayoutUtil.hasGroup(tableHandle, insertObj.getColumnName());
                }
                if ("attribute".equals(UIUtil.getColumnAnalysis(insertObj))) {
                    String str = UIUtil.getAnalysisColumn(insertObj);
                    DataSetHandle dataset = InsertInLayoutUtil.getDataSet(insertObj);
                    String type = "";
                    if (str != null) {
                        List<ColumnHintHandle> columnHints = DataUtil.getColumnHints(dataset);
                        for (ColumnHintHandle columnHint : columnHints) {
                            if (!str.equals(columnHint.getColumnName()) && !str.equals(columnHint.getAlias())) continue;
                            type = columnHint.getAnalysis();
                            break;
                        }
                        if ("dimension".equals(type)) {
                            GroupHandle findGroup = null;
                            SlotHandle slotHandle = tableHandle.getGroups();
                            for (Object o : slotHandle.getContents()) {
                                GroupHandle group = (GroupHandle)o;
                                if (!group.getName().equals(str)) continue;
                                findGroup = group;
                            }
                            if (findGroup == null) {
                                return true;
                            }
                            return cellHandle.getContainer().getContainer() == findGroup;
                        }
                        if (type != null && !type.equals("")) {
                            SlotHandle slotHandle = cellHandle.getContainer().getContainerSlotHandle();
                            return slotHandle.equals(tableHandle.getHeader()) || slotHandle.equals(tableHandle.getFooter());
                        }
                    } else {
                        SlotHandle slotHandle = cellHandle.getContainer().getContainerSlotHandle();
                        return slotHandle == tableHandle.getHeader() || slotHandle == tableHandle.getFooter();
                    }
                }
            }
            if (handle instanceof ReportItemHandle) {
                ListingHandle bindingHolder = DEUtil.getListingContainer((DesignElementHandle)handle);
                DataSetHandle itsDataSet = ((ReportItemHandle)handle).getDataSet();
                DataSetHandle dataSet = null;
                ReportItemHandle bindingRoot = DEUtil.getBindingRoot((DesignElementHandle)handle);
                if (bindingRoot != null) {
                    dataSet = bindingRoot.getDataSet();
                }
                if (itsDataSet == null && (bindingHolder == null || !bindingHolder.getColumnBindings().iterator().hasNext()) || InsertInLayoutUtil.getDataSet(insertObj).equals(dataSet)) {
                    return true;
                }
                if (ExtendedDataModelUIAdapterHelper.isBoundToExtendedData(bindingRoot)) {
                    return InsertInLayoutUtil.getAdapter() != null && InsertInLayoutUtil.getAdapter().getBoundExtendedData(bindingRoot).equals(InsertInLayoutUtil.getAdapter().resolveExtendedData((DesignElementHandle)InsertInLayoutUtil.getDataSet(insertObj)));
                }
            }
        }
        return false;
    }

    private static boolean hasGroup(TableHandle tableHandle, String groupName) {
        SlotHandle slotHandle = tableHandle.getGroups();
        for (Object o : slotHandle.getContents()) {
            GroupHandle group = (GroupHandle)o;
            if (!group.getName().equals(groupName)) continue;
            return true;
        }
        return true;
    }

    private static boolean isMasterPageHeaderOrFooter(Object obj) {
        if (!(obj instanceof SlotHandle)) {
            return false;
        }
        return ((SlotHandle)obj).getElementHandle() instanceof MasterPageHandle;
    }

    protected static boolean handleValidateParameter(EditPart target) {
        return InsertInLayoutUtil.handleValidateParameterDropContainer(target) && DNDUtil.handleValidateTargetCanContainType((Object)target.getModel(), (String)"Data");
    }

    public static boolean handleValidateInsert(Object insertObj) {
        if (insertObj instanceof Object[]) {
            Object[] array = (Object[])insertObj;
            if (array.length == 0) {
                return false;
            }
            int i = 0;
            while (i < array.length) {
                if (!InsertInLayoutUtil.handleValidateInsert(array[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (insertObj instanceof IStructuredSelection) {
            return InsertInLayoutUtil.handleValidateInsert(((IStructuredSelection)insertObj).toArray());
        }
        if (insertObj instanceof DataSetHandle) {
            return DataSetUIUtil.hasMetaData((DataSetHandle)insertObj);
        }
        return insertObj instanceof ResultSetColumnHandle || insertObj instanceof ScalarParameterHandle || insertObj instanceof DimensionHandle || insertObj instanceof MeasureHandle;
    }

    public static void insertToCell(DataSetHandle model, TableHandle tableHandle, SlotHandle slot, ResultSetColumnHandle[] columns, boolean isLabel) {
        List<ColumnHintHandle> list = null;
        int i = 0;
        while (i < slot.getCount()) {
            SlotHandle cells = ((RowHandle)slot.get(i)).getCells();
            int j = 0;
            while (j < cells.getCount() && j < columns.length) {
                if (list == null) {
                    list = DataUtil.getColumnHints(model);
                }
                CellHandle cell = (CellHandle)cells.get(j);
                try {
                    String displayKey;
                    if (isLabel) {
                        LabelHandle labelItemHandle = SessionHandleAdapter.getInstance().getReportDesignHandle().getElementFactory().newLabel(null);
                        String labelText = UIUtil.getHeadColumnDisplayName(list, columns[j]);
                        if (labelText != null) {
                            labelItemHandle.setText(labelText);
                        }
                        if ((displayKey = UIUtil.getColumnHeaderDisplayNameKey(list, columns[j])) == null) {
                            displayKey = UIUtil.getColumnDisplayNameKey(list, columns[j]);
                        }
                        if (displayKey != null) {
                            labelItemHandle.setTextKey(displayKey);
                        }
                        cell.addElement((DesignElementHandle)labelItemHandle, cells.getSlotID());
                    } else {
                        DataItemHandle dataHandle = SessionHandleAdapter.getInstance().getReportDesignHandle().getElementFactory().newDataItem(null);
                        dataHandle.setResultSetColumn(columns[j].getColumnName());
                        InsertInLayoutUtil.formatDataHandle(dataHandle, columns[j], list);
                        cell.addElement((DesignElementHandle)dataHandle, cells.getSlotID());
                        ComputedColumn bindingColumn = StructureFactory.newComputedColumn((DesignElementHandle)tableHandle, (String)columns[j].getColumnName());
                        bindingColumn.setDataType(columns[j].getDataType());
                        ExpressionUtility.setBindingColumnExpression(columns[j], bindingColumn);
                        bindingColumn.setDisplayName(UIUtil.getColumnDisplayName(list, columns[j]));
                        displayKey = UIUtil.getColumnDisplayNameKey(list, columns[j]);
                        if (displayKey != null) {
                            bindingColumn.setDisplayNameID(displayKey);
                        }
                        tableHandle.addColumnBinding(bindingColumn, false);
                        ActionHandle actionHandle = UIUtil.getColumnAction(list, columns[j]);
                        if (actionHandle != null) {
                            ArrayList<IStructure> source = new ArrayList<IStructure>();
                            source.add(actionHandle.getStructure());
                            ArrayList newAction = ModelUtil.cloneStructList(source);
                            dataHandle.setAction((Action)newAction.get(0));
                        }
                    }
                }
                catch (Exception e) {
                    ExceptionHandler.handle(e);
                }
                ++j;
            }
            ++i;
        }
    }

    private static void formatDataHandle(DataItemHandle dataHandle, ResultSetColumnHandle column, ColumnHintHandle hintHandle) {
        if (hintHandle == null) {
            return;
        }
        try {
            String helpText;
            String aliment;
            StyleHandle styleHandle = dataHandle.getPrivateStyle();
            if (hintHandle != null && hintHandle.isLocal("wordWrap")) {
                boolean wordWrap = UIUtil.isWordWrap(column);
                if (wordWrap) {
                    styleHandle.setWhiteSpace("normal");
                } else {
                    styleHandle.setWhiteSpace("nowrap");
                }
            }
            if ((aliment = hintHandle.getHorizontalAlign()) != null) {
                styleHandle.setTextAlign(aliment);
            }
            if ((helpText = hintHandle.getHelpText()) != null) {
                dataHandle.setHelpText(helpText);
            }
            if (hintHandle != null) {
                InsertInLayoutUtil.formatDataHandleDataType(column.getDataType(), hintHandle.getValueFormat(), styleHandle);
            }
        }
        catch (SemanticException semanticException) {
            // empty catch block
        }
    }

    private static void formatDataHandle(DataItemHandle dataHandle, ResultSetColumnHandle column, List<ColumnHintHandle> list) {
        ColumnHintHandle hintHandle = InsertInLayoutUtil.findColumnHintHandle(list, column);
        InsertInLayoutUtil.formatDataHandle(dataHandle, column, hintHandle);
    }

    private static void formatDataHandle(DataItemHandle dataHandle, ResultSetColumnHandle column) {
        ColumnHintHandle hintHandle = InsertInLayoutUtil.findColumnHintHandle(column);
        InsertInLayoutUtil.formatDataHandle(dataHandle, column, hintHandle);
    }

    private static void formatDataHandle(DataItemHandle dataHandle, MeasureHandle measure) {
        try {
            FormatValueHandle formatValue;
            StyleHandle styleHandle = dataHandle.getPrivateStyle();
            String aliment = measure.getAlignment();
            if (aliment != null) {
                styleHandle.setTextAlign(aliment);
            }
            if ((formatValue = measure.getFormat()) != null) {
                InsertInLayoutUtil.formatDataHandleDataType(measure.getDataType(), (FormatValue)formatValue.getStructure(), styleHandle);
            }
        }
        catch (SemanticException semanticException) {
            // empty catch block
        }
    }

    private static ColumnHintHandle findColumnHintHandle(List<ColumnHintHandle> columnHints, ResultSetColumnHandle column) {
        for (ColumnHintHandle columnHint : columnHints) {
            if (!column.getColumnName().equals(columnHint.getColumnName()) && !column.getColumnName().equals(columnHint.getAlias())) continue;
            return columnHint;
        }
        return null;
    }

    private static ColumnHintHandle findColumnHintHandle(ResultSetColumnHandle column) {
        DataSetHandle dataset = InsertInLayoutUtil.getDataSet(column);
        List<ColumnHintHandle> columnHints = DataUtil.getColumnHints(dataset);
        for (ColumnHintHandle columnHint : columnHints) {
            if (!column.getColumnName().equals(columnHint.getColumnName()) && !column.getColumnName().equals(columnHint.getAlias())) continue;
            return columnHint;
        }
        return null;
    }

    public static void formatDataHandleDataType(String type, FormatValue formartValue, StyleHandle styleHandle) {
        if (formartValue == null) {
            return;
        }
        try {
            if ("integer".equals(type) || "decimal".equals(type) || "float".equals(type)) {
                if (formartValue.getPattern() != null) {
                    styleHandle.setNumberFormat(formartValue.getPattern());
                }
                if (formartValue.getCategory() != null) {
                    styleHandle.setNumberFormatCategory(formartValue.getCategory());
                }
            } else if ("date-time".equals(type) || "date".equals(type)) {
                if (formartValue.getPattern() != null) {
                    styleHandle.setDateTimeFormat(formartValue.getPattern());
                }
                if (formartValue.getCategory() != null) {
                    styleHandle.setDateTimeFormatCategory(formartValue.getCategory());
                }
            } else if ("string".equals(type)) {
                if (formartValue.getPattern() != null) {
                    styleHandle.setStringFormat(formartValue.getPattern());
                }
                if (formartValue.getCategory() != null) {
                    styleHandle.setStringFormatCategory(formartValue.getCategory());
                }
            }
        }
        catch (SemanticException semanticException) {
            // empty catch block
        }
    }

    public static void setInitWidth(Object object) {
    }

    protected static boolean isHandleValid(DesignElementHandle handle) {
        if (handle instanceof DataSetHandle) {
            boolean needsDataSource;
            boolean bl = needsDataSource = InsertInLayoutUtil.getAdapter() == null ? true : InsertInLayoutUtil.getAdapter().needsDataSource((ReportElementHandle)((DataSetHandle)handle));
            if (!(handle instanceof JointDataSetHandle) && !(handle instanceof DerivedDataSetHandle) && needsDataSource && ((DataSetHandle)handle).getDataSource() == null || !DataSetUIUtil.hasMetaData((DataSetHandle)handle)) {
                return false;
            }
        }
        return handle.isValid() && handle.getSemanticErrors().isEmpty();
    }

    public static IStructuredSelection editPart2Model(ISelection selection) {
        if (selection == null || !(selection instanceof IStructuredSelection)) {
            return new StructuredSelection(Collections.EMPTY_LIST);
        }
        List list = ((IStructuredSelection)selection).toList();
        ArrayList<Object> resultList = new ArrayList<Object>();
        int i = 0;
        while (i < list.size()) {
            Object obj = list.get(i);
            if (obj instanceof ReportElementEditPart) {
                Object model = ((ReportElementEditPart)obj).getModel();
                if (model instanceof ListBandProxy) {
                    model = ((ListBandProxy)model).getSlotHandle();
                }
                resultList.add(model);
            }
            ++i;
        }
        return new StructuredSelection(resultList);
    }

    public static IStructuredSelection editPart2Model(List selection) {
        if (selection == null || selection.size() == 0) {
            return new StructuredSelection(Collections.EMPTY_LIST);
        }
        List list = selection;
        ArrayList<Object> resultList = new ArrayList<Object>();
        int i = 0;
        while (i < list.size()) {
            Object obj = list.get(i);
            if (obj instanceof ReportElementEditPart) {
                Object model = ((ReportElementEditPart)obj).getModel();
                if (model instanceof ListBandProxy) {
                    model = ((ListBandProxy)model).getSlotHandle();
                }
                resultList.add(model);
            }
            ++i;
        }
        return new StructuredSelection(resultList);
    }

    private static DataSetHandle getDataSet(Object column) {
        if (column instanceof ResultSetColumnHandle) {
            return InsertInLayoutUtil.getDataSet((ResultSetColumnHandle)column);
        }
        return null;
    }

    private static DataSetHandle getDataSet(ResultSetColumnHandle column) {
        DataSetHandle dataSet = InsertInLayoutUtil.getAdapter() != null && InsertInLayoutUtil.getAdapter().getDataSet(column) != null ? InsertInLayoutUtil.getAdapter().getDataSet(column) : (DataSetHandle)column.getElementHandle();
        return dataSet;
    }

    private static void setDataSet(ReportItemHandle target, DataSetHandle dataSet) throws SemanticException {
        if (InsertInLayoutUtil.getAdapter() != null && InsertInLayoutUtil.getAdapter().resolveExtendedData((DesignElementHandle)dataSet) != null) {
            InsertInLayoutUtil.getAdapter().setExtendedData(target, InsertInLayoutUtil.getAdapter().resolveExtendedData((DesignElementHandle)dataSet));
        } else {
            target.setDataSet(dataSet);
        }
    }

    private static IExtendedDataModelUIAdapter getAdapter() {
        return ExtendedDataModelUIAdapterHelper.getInstance().getAdapter();
    }

    static class GroupKeySetRule
    implements InsertInLayoutRule {
        private Object container;
        private Object dataSetColumn;

        public GroupKeySetRule(Object container, ResultSetColumnHandle dataSetColumn) {
            this.container = container;
            this.dataSetColumn = dataSetColumn;
        }

        public GroupKeySetRule(Object container, MeasureHandle dataSetColumn) {
            this.container = container;
            this.dataSetColumn = dataSetColumn;
        }

        @Override
        public boolean canInsert() {
            return InsertInLayoutUtil.getGroupContainer(this.container) != null && InsertInLayoutUtil.getGroupHandle(this.container).getKeyExpr() == null && (InsertInLayoutUtil.getGroupContainer(this.container).getDataSet() == InsertInLayoutUtil.getDataSet(this.dataSetColumn) || InsertInLayoutUtil.getGroupContainer(this.container).getDataSet() == null);
        }

        @Override
        public Object getInsertPosition() {
            return null;
        }

        @Override
        public void insert(Object object) throws SemanticException {
            Assert.isTrue((boolean)(object instanceof ResultSetColumnHandle));
            Assert.isTrue((object == this.dataSetColumn || object == null ? 1 : 0) != 0);
            ReportItemHandle groupContainer = InsertInLayoutUtil.getGroupContainer(this.container);
            DataSetHandle dataSetHandle = groupContainer.getDataSet();
            if (dataSetHandle == null) {
                ReportItemHandle elementHandle = groupContainer;
                while (elementHandle != null) {
                    if (elementHandle instanceof ListingHandle && (dataSetHandle = ((ListingHandle)elementHandle).getDataSet()) != null && dataSetHandle == InsertInLayoutUtil.getDataSet(this.dataSetColumn)) break;
                    elementHandle = elementHandle.getContainer();
                }
            }
            if (dataSetHandle == null || dataSetHandle != InsertInLayoutUtil.getDataSet(this.dataSetColumn)) {
                InsertInLayoutUtil.setDataSet(InsertInLayoutUtil.getGroupContainer(this.container), InsertInLayoutUtil.getDataSet(this.dataSetColumn));
            }
            String name = this.dataSetColumn instanceof ResultSetColumnHandle ? ((ResultSetColumnHandle)this.dataSetColumn).getColumnName() : ((MeasureHandle)this.dataSetColumn).getName();
            String expr = DEUtil.getColumnExpression((String)name);
            InsertInLayoutUtil.getGroupHandle(this.container).setKeyExpr(expr);
        }
    }

    static interface InsertInLayoutRule {
        public boolean canInsert();

        public Object getInsertPosition();

        public void insert(Object var1) throws SemanticException;
    }

    static class LabelAddRule
    implements InsertInLayoutRule {
        private Object container;
        private CellHandle newTarget;

        public LabelAddRule(Object container) {
            this.container = container;
        }

        @Override
        public boolean canInsert() {
            if (this.container instanceof SlotHandle) {
                this.container = ((SlotHandle)this.container).getElementHandle();
            }
            if (!(this.container instanceof CellHandle)) {
                return false;
            }
            CellHandle cell = (CellHandle)this.container;
            boolean canInsert = false;
            if (cell.getContainer().getContainer() instanceof TableGroupHandle) {
                canInsert = true;
            } else if (cell.getContainer().getContainerSlotHandle().getSlotID() == 2) {
                canInsert = true;
            }
            if (canInsert) {
                TableHandle table = null;
                table = cell.getContainer().getContainer() instanceof TableHandle ? (TableHandle)cell.getContainer().getContainer() : (TableHandle)cell.getContainer().getContainer().getContainer();
                SlotHandle header = table.getHeader();
                if (header != null && header.getCount() > 0) {
                    int columnNum = HandleAdapterFactory.getInstance().getCellHandleAdapter((Object)cell).getColumnNumber();
                    this.newTarget = (CellHandle)HandleAdapterFactory.getInstance().getTableHandleAdapter((Object)table).getCell(1, columnNum, false);
                    return this.newTarget != null && this.newTarget.getContent().getCount() == 0;
                }
            }
            return false;
        }

        @Override
        public Object getInsertPosition() {
            return this.newTarget;
        }

        @Override
        public void insert(Object object) throws SemanticException {
            Assert.isTrue((boolean)(object instanceof DesignElementHandle));
            this.newTarget.addElement((DesignElementHandle)object, 0);
        }
    }

    static class MultiItemsExpandRule
    implements InsertInLayoutRule {
        private Object[] items;
        private Object target;
        private int focusIndex = 0;

        public MultiItemsExpandRule(Object[] items, Object target) {
            this.items = items;
            this.target = target;
        }

        @Override
        public boolean canInsert() {
            return this.items != null && this.items.length > 1 && this.target != null && (this.target instanceof DesignElementHandle || this.target instanceof ListBandProxy);
        }

        @Override
        public Object getInsertPosition() {
            Object[] positions = new Object[this.items.length];
            if (this.target instanceof CellHandle) {
                CellHandle firstCell = (CellHandle)this.target;
                TableHandleAdapter tableAdapter = HandleAdapterFactory.getInstance().getTableHandleAdapter((Object)this.getTableHandle(firstCell));
                int currentColumn = HandleAdapterFactory.getInstance().getCellHandleAdapter((Object)firstCell).getColumnNumber();
                int currentRow = HandleAdapterFactory.getInstance().getCellHandleAdapter((Object)firstCell).getRowNumber();
                int columnDiff = currentColumn + this.items.length - tableAdapter.getColumnCount() - 1;
                if (columnDiff > 0) {
                    int insertColumn = tableAdapter.getColumnCount();
                    try {
                        tableAdapter.insertColumns(columnDiff, insertColumn);
                    }
                    catch (SemanticException e) {
                        ExceptionHandler.handle(e);
                        return null;
                    }
                }
                int i = 0;
                while (i < positions.length) {
                    positions[i] = tableAdapter.getCell(currentRow, currentColumn++);
                    ++i;
                }
                this.focusIndex = 0;
            } else {
                int i = 0;
                while (i < positions.length) {
                    positions[i] = this.target;
                    ++i;
                }
                this.focusIndex = this.items.length - 1;
            }
            return positions;
        }

        protected ReportItemHandle getTableHandle(CellHandle firstCell) {
            DesignElementHandle tableContainer = firstCell.getContainer().getContainer();
            if (tableContainer instanceof ReportItemHandle) {
                return (ReportItemHandle)tableContainer;
            }
            return (ReportItemHandle)tableContainer.getContainer();
        }

        public int getFocusIndex() {
            return this.focusIndex;
        }

        @Override
        public void insert(Object object) throws SemanticException {
        }
    }
}

