/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.visualization.runnabledependency;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.app4mc.amalthea.model.ActivityGraphItem;
import org.eclipse.app4mc.amalthea.model.Group;
import org.eclipse.app4mc.amalthea.model.INamed;
import org.eclipse.app4mc.amalthea.model.InterProcessStimulus;
import org.eclipse.app4mc.amalthea.model.InterProcessTrigger;
import org.eclipse.app4mc.amalthea.model.Label;
import org.eclipse.app4mc.amalthea.model.Process;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableCall;
import org.eclipse.app4mc.amalthea.model.SWModel;
import org.eclipse.app4mc.amalthea.model.SetEvent;
import org.eclipse.app4mc.amalthea.model.Stimulus;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.app4mc.amalthea.model.WaitEvent;
import org.eclipse.app4mc.amalthea.model.util.SoftwareUtil;
import org.eclipse.app4mc.amalthea.visualization.runnabledependency.RunnableDependencyConfig;
import org.eclipse.app4mc.visualization.util.svg.GraphvizDiagram;
import org.eclipse.emf.ecore.EObject;

public class RunnableDependencyGenerator {
    private static final int MAX_MODEL_SIZE = 200;

    private RunnableDependencyGenerator() {
        throw new IllegalStateException("Utility class");
    }

    public static void updateDiagram(GraphvizDiagram diagram, SWModel swModel, RunnableDependencyConfig config, boolean limitModelSize, boolean createHyperlinks) {
        diagram.resetDiagramData();
        if (limitModelSize && swModel.getRunnables().size() > 200) {
            diagram.append("digraph model {\"The model contains more than 200 Runnables and thus is too large to be visualized.\"}");
            return;
        }
        SetMultimap labelReads = MultimapBuilder.linkedHashKeys().linkedHashSetValues().build();
        SetMultimap labelWrites = MultimapBuilder.linkedHashKeys().linkedHashSetValues().build();
        diagram.append("digraph model {");
        diagram.append(System.lineSeparator());
        diagram.append("node [shape=\"Mrecord\", fontname=\"Helvetica\"];");
        diagram.append(System.lineSeparator());
        diagram.append("edge [fontname=\"Helvetica\"];");
        diagram.append(System.lineSeparator());
        if (config.isHorizontalLayout()) {
            diagram.append("rankdir=LR;");
            diagram.append(System.lineSeparator());
        }
        int i = 0;
        if (config.isShowCallDependencies()) {
            RunnableDependencyGenerator.buildCallGraph(swModel, diagram);
        }
        if (config.isShowTasks()) {
            RunnableDependencyGenerator.buildTaskGroups(swModel, diagram);
        }
        diagram.append("node [shape=\"Mrecord\", fontname=\"Helvetica\"];");
        diagram.append(System.lineSeparator());
        for (Runnable runnable : swModel.getRunnables()) {
            Set reads = SoftwareUtil.getReadLabelSet((Runnable)runnable, null);
            labelReads.putAll((Object)runnable, (Iterable)reads);
            Set writes = SoftwareUtil.getWriteLabelSet((Runnable)runnable, null);
            labelWrites.putAll((Object)runnable, (Iterable)writes);
            RunnableDependencyGenerator.buildNode(runnable, reads, writes, i++, diagram, config, createHyperlinks);
        }
        if (config.isShowLabelDependencies()) {
            Multimap readers = Multimaps.invertFrom((Multimap)labelReads, (Multimap)MultimapBuilder.linkedHashKeys().linkedHashSetValues().build());
            HashSet connections = new HashSet();
            labelWrites.forEach((writer, label) -> readers.get(label).forEach(reader -> {
                if (writer == reader || !config.isShowLabels() && !connections.add(Arrays.asList(writer, reader))) {
                    return;
                }
                diagram.appendId(writer);
                if (config.isShowLabels()) {
                    diagram.append(":W");
                    diagram.appendId(label);
                }
                diagram.append(config.isHorizontalLayout() ? ":e -> " : ":s -> ");
                diagram.appendId(reader);
                if (config.isShowLabels()) {
                    diagram.append(":R");
                    diagram.appendId(label);
                }
                diagram.append(config.isHorizontalLayout() ? ":w[color=\"" : ":n[color=\"");
                diagram.append(RunnableDependencyGenerator.getColor(swModel.getRunnables().indexOf(writer)));
                diagram.append("\"];");
                diagram.append(System.lineSeparator());
            }));
        }
        diagram.append("}");
    }

    /*
     * WARNING - void declaration
     */
    private static Runnable buildCallChain(List<ActivityGraphItem> lst, Runnable prevRunnable, Set<EObject> inputs, Multimap<Object, Runnable> sources, Multimap<Object, Runnable> targets) {
        Runnable lastRunnable = prevRunnable;
        for (ActivityGraphItem item : lst) {
            void group;
            ActivityGraphItem activityGraphItem = item;
            if (activityGraphItem instanceof RunnableCall) {
                void runnableCall;
                RunnableCall cfr_ignored_0 = (RunnableCall)activityGraphItem;
                RunnableCall cfr_ignored_1 = (RunnableCall)activityGraphItem;
                SetEvent r = runnableCall.getRunnable();
                for (EObject o : inputs) {
                    targets.put((Object)o, (Object)r);
                }
                inputs.clear();
                if (lastRunnable != null) {
                    sources.put((Object)lastRunnable, (Object)lastRunnable);
                    targets.put((Object)lastRunnable, (Object)r);
                }
                lastRunnable = r;
                continue;
            }
            ActivityGraphItem activityGraphItem2 = item;
            if (activityGraphItem2 instanceof SetEvent) {
                void setEvent;
                SetEvent cfr_ignored_2 = (SetEvent)activityGraphItem2;
                SetEvent cfr_ignored_3 = (SetEvent)activityGraphItem2;
                if (lastRunnable == null) continue;
                for (WaitEvent e : setEvent.getEventMask().getEvents()) {
                    sources.put((Object)e, (Object)lastRunnable);
                }
                continue;
            }
            ActivityGraphItem activityGraphItem3 = item;
            if (activityGraphItem3 instanceof WaitEvent) {
                void waitEvent;
                WaitEvent cfr_ignored_4 = (WaitEvent)activityGraphItem3;
                WaitEvent cfr_ignored_5 = (WaitEvent)activityGraphItem3;
                inputs.addAll((Collection<EObject>)waitEvent.getEventMask().getEvents());
                continue;
            }
            ActivityGraphItem activityGraphItem4 = item;
            if (activityGraphItem4 instanceof InterProcessTrigger) {
                void interProcessTrigger;
                InterProcessTrigger cfr_ignored_6 = (InterProcessTrigger)activityGraphItem4;
                InterProcessTrigger cfr_ignored_7 = (InterProcessTrigger)activityGraphItem4;
                if (lastRunnable == null) continue;
                sources.put((Object)interProcessTrigger.getStimulus(), (Object)lastRunnable);
                continue;
            }
            ActivityGraphItem activityGraphItem5 = item;
            if (!(activityGraphItem5 instanceof Group)) continue;
            Group cfr_ignored_8 = (Group)activityGraphItem5;
            Group cfr_ignored_9 = (Group)activityGraphItem5;
            lastRunnable = RunnableDependencyGenerator.buildCallChain((List<ActivityGraphItem>)group.getItems(), lastRunnable, inputs, sources, targets);
        }
        return lastRunnable;
    }

    /*
     * WARNING - void declaration
     */
    private static void buildCallGraph(SWModel model, GraphvizDiagram diagram) {
        SetMultimap sources = MultimapBuilder.linkedHashKeys().linkedHashSetValues().build();
        SetMultimap targets = MultimapBuilder.linkedHashKeys().linkedHashSetValues().build();
        LinkedHashSet stims = new LinkedHashSet();
        for (Task t : model.getTasks()) {
            stims.addAll(t.getStimuli());
            RunnableDependencyGenerator.buildCallChain((List<ActivityGraphItem>)t.getActivityGraph().getItems(), null, new LinkedHashSet<EObject>((Collection<EObject>)t.getStimuli()), (Multimap<Object, Runnable>)sources, (Multimap<Object, Runnable>)targets);
        }
        diagram.append("node[shape=\"ellipse\"];" + System.lineSeparator());
        for (Stimulus s : stims) {
            if (s instanceof InterProcessStimulus) continue;
            for (Runnable r : targets.get((Object)s)) {
                diagram.append("\"" + RunnableDependencyGenerator.getName((INamed)s) + "\" -> ");
                diagram.appendId((Object)r);
                diagram.append(System.lineSeparator());
            }
        }
        for (Map.Entry e : sources.entries()) {
            for (Runnable r : targets.get(e.getKey())) {
                diagram.appendId(e.getValue());
                diagram.append(" -> ");
                diagram.appendId((Object)r);
                if (e.getKey() instanceof Runnable) {
                    diagram.append("[style=\"dashed\"]");
                } else {
                    Object k = e.getKey();
                    if (k instanceof INamed) {
                        void namedObj;
                        INamed cfr_ignored_0 = (INamed)k;
                        INamed cfr_ignored_1 = (INamed)k;
                        diagram.append("[label=\"" + namedObj.eClass().getName() + " " + namedObj.getName() + "\"]");
                    }
                }
                diagram.append(System.lineSeparator());
            }
        }
    }

    private static void buildNode(Runnable runnable, Set<Label> reads, Set<Label> writes, int idx, GraphvizDiagram diagram, RunnableDependencyConfig config, boolean addLink) {
        diagram.appendId((Object)runnable);
        diagram.append("[shape=\"Mrecord\", color=\"");
        diagram.append(RunnableDependencyGenerator.getColor(idx));
        diagram.append("\",label=\"{");
        if (config.isShowLabels()) {
            RunnableDependencyGenerator.buildPortList(reads, "R", diagram);
            diagram.append("|");
            diagram.append(runnable.getName());
            diagram.append("|");
            RunnableDependencyGenerator.buildPortList(writes, "W", diagram);
        } else {
            diagram.append(runnable.getName());
        }
        diagram.append("}\"");
        if (addLink) {
            diagram.appendUrl((Object)runnable);
        }
        diagram.append("];");
        diagram.append(System.lineSeparator());
    }

    private static void buildPortList(Set<Label> labels, String dir, GraphvizDiagram diagram) {
        diagram.append("{");
        diagram.append(String.join((CharSequence)"|", (CharSequence[])labels.stream().sorted((a, b) -> RunnableDependencyGenerator.getName((INamed)a).compareTo(RunnableDependencyGenerator.getName((INamed)b))).map(label -> "<" + dir + diagram.getOrCreateId(label) + ">" + RunnableDependencyGenerator.getName((INamed)label)).toArray(String[]::new)));
        diagram.append("}");
    }

    private static void buildTaskGroups(SWModel sw, GraphvizDiagram diagram) {
        int cnt = 0;
        diagram.append("newrank=true");
        diagram.append(System.lineSeparator());
        for (Task t : sw.getTasks()) {
            diagram.append("subgraph cluster");
            diagram.append(Integer.toString(cnt++));
            diagram.append(" {");
            diagram.append(System.lineSeparator());
            diagram.append("fontname=\"Helvetica\"");
            diagram.append(System.lineSeparator());
            diagram.append("label=\"");
            diagram.append(t.getName());
            diagram.append("\"");
            diagram.append(System.lineSeparator());
            for (Runnable r : SoftwareUtil.getRunnableList((Process)t, null)) {
                diagram.appendId((Object)r);
                diagram.append(System.lineSeparator());
            }
            diagram.append("}");
            diagram.append(System.lineSeparator());
        }
    }

    private static String getColor(int n) {
        int colorBits = 0;
        int i = 0;
        while (i < 24) {
            if ((n & 1 << i) != 0) {
                colorBits |= 1 << 8 * (i % 3) + 7 - i / 3;
            }
            ++i;
        }
        return String.format("#%06x", colorBits);
    }

    private static String getName(INamed obj) {
        return obj.getName() != null ? obj.getName() : "<unnamed>";
    }
}

