/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters090.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.IPostProcessor;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.amalthea.converters090.utils.HWCacheBuilder;
import org.eclipse.app4mc.amalthea.converters090.utils.HWTransformationCache;
import org.eclipse.app4mc.util.sessionlog.SessionLogger;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"input_model_version=0.8.3", "output_model_version=0.9.0"})
public class UpdateCustomPropsPostProcessor
implements IPostProcessor {
    private static final String CORE = "Core";
    private static final String MEMORY = "Memory";
    private static final String VALUE = "value";
    private static final String AMLT_PREFIX = "amlt:/#";
    private static final String HW_STRUCTURE = "HwStructure";
    private static final Namespace XSI_NAMESPACE = AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi");
    @Reference
    SessionLogger logger;
    @Reference
    private HWCacheBuilder cache;

    public void process(Map<File, Document> filename2documentMap) {
        if (this.logger != null) {
            this.logger.info("Start UpdateCustomPropsPostProcessor from 0.8.3 to 0.9.0", new Object[0]);
        }
        List<String> hwTypes083 = this.initializeHwTypesList();
        Collection<Document> values = filename2documentMap.values();
        for (Document document : values) {
            Element rootElement = document.getRootElement();
            List customPropertyValueElementList = HelperUtil.getXpathResult((Element)rootElement, (String)".//customProperties//*[@xsi:type=\"am:ReferenceObject\"]", Element.class, (Namespace[])new Namespace[]{XSI_NAMESPACE});
            for (Element customPropertyValueElement : customPropertyValueElementList) {
                Map.Entry entry = HelperUtil.getSingleElementsNameandTypeFromAttributeOrChildeElement((String)VALUE, (Element)customPropertyValueElement);
                if (entry == null || !hwTypes083.contains(entry.getValue())) continue;
                customPropertyValueElement.removeAttribute(VALUE);
                customPropertyValueElement.removeChild(VALUE);
                String updatedTypeAfterMigration = this.getUpdatedType((String)entry.getKey(), (String)entry.getValue());
                if (values.size() > 1) {
                    Element valueElement = new Element(VALUE);
                    valueElement.setAttribute("type", "am:" + updatedTypeAfterMigration, XSI_NAMESPACE);
                    valueElement.setAttribute("href", AMLT_PREFIX + (String)entry.getKey() + "?type=" + updatedTypeAfterMigration);
                    customPropertyValueElement.addContent((Content)valueElement);
                    continue;
                }
                customPropertyValueElement.setAttribute(VALUE, String.valueOf((String)entry.getKey()) + "?type=" + updatedTypeAfterMigration);
            }
        }
    }

    private List<String> initializeHwTypesList() {
        ArrayList<String> ls = new ArrayList<String>();
        ls.add("HWModel");
        ls.add("ComplexNode");
        ls.add("HwSystem");
        ls.add("ECU");
        ls.add("Microcontroller");
        ls.add(CORE);
        ls.add(MEMORY);
        ls.add("Network");
        ls.add("Quartz");
        ls.add("HwComponent");
        ls.add("HardwareTypeDescription");
        ls.add("AbstractionType");
        ls.add("SystemType");
        ls.add("ECUType");
        ls.add("MicrocontrollerType");
        ls.add("CoreType");
        ls.add("MemoryType");
        ls.add("NetworkType");
        ls.add("HwPort");
        ls.add("Pin");
        ls.add("ComplexPort");
        ls.add("ComplexPin");
        ls.add("Prescaler");
        ls.add("CrossbarSwitch");
        ls.add("Bus");
        ls.add("Bridge");
        ls.add("LatencyAccessPath");
        ls.add("HwAccessPath");
        ls.add("AccessPathRef");
        ls.add("LatencyConstant");
        ls.add("LatencyDeviation");
        ls.add("HwAccessPathRef");
        ls.add("HwElementRef");
        return ls;
    }

    private String getUpdatedType(String name, String value) {
        if (value == null) {
            return null;
        }
        HWTransformationCache transformationCache = this.getHWTransformationCache();
        if ("MemoryType".equals(value)) {
            if (transformationCache.getNewCacheTypesDefinitionMap().containsKey(name)) {
                value = "CacheDefinition";
            } else if (transformationCache.getNewMemoriesMap().containsKey(name)) {
                value = "MemoryDefinition";
            }
        } else if (MEMORY.equals(value)) {
            if (transformationCache.getNewCachesMap().containsKey(name)) {
                value = "Cache";
            } else if (transformationCache.getNewMemoriesMap().containsKey(name)) {
                value = MEMORY;
            }
        } else if (CORE.equals(value)) {
            value = "ProcessingUnit";
        } else if ("Network".equals(value)) {
            value = "ConnectionHandler";
        } else if ("HwSystem".equals(value) || "ECU".equals(value) || "Microcontroller".equals(value)) {
            value = HW_STRUCTURE;
        } else if ("CoreType".equals(value)) {
            value = "ProcessingUnitDefinition";
        } else if ("NetworkType".equals(value)) {
            value = "ConnectionHandlerDefinition";
        } else if ("Quartz".equals(value)) {
            value = "FrequencyDomain";
        }
        return value;
    }

    private HWTransformationCache getHWTransformationCache() {
        Map<String, Object> map;
        Map<File, Map<String, Object>> cacheMap = this.cache.getCacheMap();
        if (cacheMap != null && !cacheMap.isEmpty() && (map = cacheMap.values().iterator().next()) != null) {
            Object object = map.get("globalCache");
            return (HWTransformationCache)object;
        }
        return new HWTransformationCache();
    }
}

