/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.ide.ui.wizard;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.UUID;
import org.eclipse.acceleo.AcceleoASTNode;
import org.eclipse.acceleo.AcceleoPackage;
import org.eclipse.acceleo.Block;
import org.eclipse.acceleo.Comment;
import org.eclipse.acceleo.CommentBody;
import org.eclipse.acceleo.Documentation;
import org.eclipse.acceleo.DocumentedElement;
import org.eclipse.acceleo.Expression;
import org.eclipse.acceleo.FileStatement;
import org.eclipse.acceleo.Metamodel;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.ModuleDocumentation;
import org.eclipse.acceleo.ModuleElement;
import org.eclipse.acceleo.ModuleElementDocumentation;
import org.eclipse.acceleo.OpenModeKind;
import org.eclipse.acceleo.Query;
import org.eclipse.acceleo.Template;
import org.eclipse.acceleo.TextStatement;
import org.eclipse.acceleo.Variable;
import org.eclipse.acceleo.VisibilityKind;
import org.eclipse.acceleo.aql.AcceleoUtil;
import org.eclipse.acceleo.aql.ide.ui.AcceleoUIPlugin;
import org.eclipse.acceleo.aql.ide.ui.wizard.ModuleConfiguration;
import org.eclipse.acceleo.aql.ide.ui.wizard.ModulePage;
import org.eclipse.acceleo.aql.parser.AcceleoAstSerializer;
import org.eclipse.acceleo.query.parser.AstResult;
import org.eclipse.acceleo.query.runtime.impl.QueryBuilderEngine;
import org.eclipse.acceleo.query.services.StringServices;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class NewModuleWizard
extends Wizard
implements INewWizard {
    private static final String OK_MESSAGE = "Acceleo 4 module %s created.";
    private static final String NEW_LINE = System.lineSeparator();
    private String container;
    private ModulePage modulePage;
    private IWorkbenchPage activePage;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        IStructuredSelection aSelection;
        IContainer firstContainer = null;
        if (selection != null && !selection.isEmpty() && (aSelection = selection).size() > 0) {
            Object element = aSelection.getFirstElement();
            if (element instanceof IAdaptable) {
                element = ((IAdaptable)element).getAdapter(IResource.class);
            }
            if (element instanceof IContainer) {
                firstContainer = (IContainer)element;
            } else if (element instanceof IResource) {
                firstContainer = ((IResource)element).getParent();
            }
        }
        this.container = firstContainer != null ? firstContainer.getFullPath().toString() : "";
        this.activePage = workbench.getActiveWorkbenchWindow().getActivePage();
    }

    public void addPages() {
        this.modulePage = new ModulePage(this.container);
        this.addPage((IWizardPage)this.modulePage);
    }

    public boolean performFinish() {
        FinishJob job = new FinishJob(this.modulePage.getModuleConfiguration());
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.schedule();
        try {
            job.join();
            IFile moduleFile = this.modulePage.getModuleConfiguration().getModuleFile();
            if (moduleFile != null && moduleFile.isAccessible()) {
                try {
                    IDE.openEditor((IWorkbenchPage)this.activePage, (IFile)moduleFile);
                }
                catch (PartInitException partInitException) {}
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    private class FinishJob
    extends Job {
        private ModuleConfiguration moduleConfiguration;

        public FinishJob(ModuleConfiguration moduleConfiguration) {
            super("Creating Acceleo 4 module: " + String.valueOf(moduleConfiguration.getModuleFile().getFullPath()));
            this.moduleConfiguration = moduleConfiguration;
        }

        protected IStatus run(IProgressMonitor monitor) {
            IFile moduleFile = this.moduleConfiguration.getModuleFile();
            Status res = new Status(0, "org.eclipse.acceleo.aql.ide.ui", String.format(NewModuleWizard.OK_MESSAGE, moduleFile.getFullPath()));
            Module module = AcceleoPackage.eINSTANCE.getAcceleoFactory().createModule();
            module.setName(this.moduleConfiguration.getModuleName());
            ModuleDocumentation moduleDocumentation = AcceleoPackage.eINSTANCE.getAcceleoFactory().createModuleDocumentation();
            module.setDocumentation((Documentation)moduleDocumentation);
            moduleDocumentation.setDocumentedElement((DocumentedElement)module);
            CommentBody moduleDocumentationBody = AcceleoPackage.eINSTANCE.getAcceleoFactory().createCommentBody();
            moduleDocumentationBody.setValue(NEW_LINE + " * The documentation of the module " + module.getName() + "." + NEW_LINE);
            String username = System.getProperty("user.name");
            if (username != null && !"".equals(username)) {
                moduleDocumentationBody.setValue(moduleDocumentationBody.getValue() + " * @author " + username + NEW_LINE);
            }
            moduleDocumentationBody.setValue(moduleDocumentationBody.getValue() + " * @version 1.0.0" + NEW_LINE);
            moduleDocumentationBody.setValue(moduleDocumentationBody.getValue() + " * @since 1.0.0" + NEW_LINE);
            moduleDocumentationBody.setValue(moduleDocumentationBody.getValue() + " *");
            moduleDocumentation.setBody(moduleDocumentationBody);
            module.setDocumentation((Documentation)moduleDocumentation);
            for (String nsURI : this.moduleConfiguration.getNsURIs()) {
                Metamodel metamodel = AcceleoPackage.eINSTANCE.getAcceleoFactory().createMetamodel();
                EPackage ePkg = EPackage.Registry.INSTANCE.getEPackage(nsURI);
                metamodel.setReferencedPackage(ePkg);
                module.getMetamodels().add((Object)metamodel);
            }
            if (this.moduleConfiguration.getModuleElementEClass() == AcceleoPackage.eINSTANCE.getTemplate()) {
                Template template = AcceleoPackage.eINSTANCE.getAcceleoFactory().createTemplate();
                template.setName(this.moduleConfiguration.getModuleElementName());
                template.setVisibility(VisibilityKind.PUBLIC);
                template.getParameters().add((Object)this.createVariable(this.moduleConfiguration.getModuleElementParameterType()));
                if (this.moduleConfiguration.isGenerateDocumentation()) {
                    template.setDocumentation(this.createModuleElementDocumentation((ModuleElement)template));
                    if (this.moduleConfiguration.isMainTemplate()) {
                        CommentBody body = template.getDocumentation().getBody();
                        body.setValue(body.getValue() + " @main" + NEW_LINE + " *");
                    }
                } else if (this.moduleConfiguration.isMainTemplate()) {
                    Comment mainComment = AcceleoPackage.eINSTANCE.getAcceleoFactory().createComment();
                    CommentBody mainCommentBody = AcceleoPackage.eINSTANCE.getAcceleoFactory().createCommentBody();
                    mainCommentBody.setValue("@main");
                    mainComment.setBody(mainCommentBody);
                    module.getModuleElements().add((Object)mainComment);
                }
                template.setBody(this.createTemplateBody(this.moduleConfiguration));
                module.getModuleElements().add((Object)template);
            } else if (this.moduleConfiguration.getModuleElementEClass() == AcceleoPackage.eINSTANCE.getQuery()) {
                Query query = AcceleoPackage.eINSTANCE.getAcceleoFactory().createQuery();
                query.setName(this.moduleConfiguration.getModuleElementName());
                query.setVisibility(VisibilityKind.PUBLIC);
                query.getParameters().add((Object)this.createVariable(this.moduleConfiguration.getModuleElementParameterType()));
                QueryBuilderEngine queryBuilder = new QueryBuilderEngine();
                AstResult astResultReturnType = queryBuilder.build(this.moduleConfiguration.getModuleElementParameterType());
                query.setType(astResultReturnType);
                query.setTypeAql(astResultReturnType.getAst());
                query.setBody(this.createExpression(((Variable)query.getParameters().get(0)).getName()));
                if (this.moduleConfiguration.isGenerateDocumentation()) {
                    query.setDocumentation(this.createModuleElementDocumentation((ModuleElement)query));
                }
                module.getModuleElements().add((Object)query);
            }
            AcceleoAstSerializer serializer = new AcceleoAstSerializer(NEW_LINE);
            try {
                module.setEncoding(moduleFile.getCharset());
                String moduleString = serializer.serialize((AcceleoASTNode)module);
                ByteArrayInputStream moduleInputStream = new ByteArrayInputStream(moduleString.getBytes(moduleFile.getCharset()));
                moduleFile.create((InputStream)moduleInputStream, true, monitor);
            }
            catch (CoreException e) {
                res = new Status(4, "org.eclipse.acceleo.aql.ide.ui", "Can't write " + String.valueOf(moduleFile.getFullPath()), (Throwable)e);
            }
            catch (UnsupportedEncodingException e) {
                res = new Status(4, "org.eclipse.acceleo.aql.ide.ui", "Can't write " + String.valueOf(moduleFile.getFullPath()), (Throwable)e);
            }
            return res;
        }

        private Block createTemplateBody(ModuleConfiguration configuration) {
            String initialContent;
            Block res = AcceleoPackage.eINSTANCE.getAcceleoFactory().createBlock();
            if (configuration.isIsInitialized()) {
                String fileContent;
                IFile initialContentFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(configuration.getInitializationPath()));
                try {
                    fileContent = AcceleoUtil.getContent((InputStream)initialContentFile.getContents(), (String)initialContentFile.getCharset());
                }
                catch (IOException e) {
                    fileContent = "";
                    AcceleoUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.aql.ide.ui", "unable to load intial file content.", (Throwable)e));
                    e.printStackTrace();
                }
                catch (CoreException e) {
                    fileContent = "";
                    AcceleoUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.aql.ide.ui", "unable to load intial file content.", (Throwable)e));
                }
                initialContent = fileContent;
            } else {
                initialContent = "";
            }
            res.setInlined(false);
            TextStatement text = AcceleoPackage.eINSTANCE.getAcceleoFactory().createTextStatement();
            if (configuration.isGenerateFile()) {
                text.setValue(NEW_LINE);
            } else {
                String newText = StringServices.NEW_LINE_PATTERN.matcher(initialContent).replaceAll(NEW_LINE + "  ") + NEW_LINE;
                text.setValue(newText);
            }
            if (configuration.isGenerateFile()) {
                FileStatement fileStatement = AcceleoPackage.eINSTANCE.getAcceleoFactory().createFileStatement();
                fileStatement.setUrl(this.createExpression("'file.txt'"));
                fileStatement.setMode(OpenModeKind.OVERWRITE);
                fileStatement.setCharset(this.createExpression("'UTF-8'"));
                Block fileBlock = AcceleoPackage.eINSTANCE.getAcceleoFactory().createBlock();
                fileBlock.setInlined(false);
                TextStatement fileText = AcceleoPackage.eINSTANCE.getAcceleoFactory().createTextStatement();
                fileText.setValue(this.getTextStatementValue(initialContent));
                fileBlock.getStatements().add((Object)fileText);
                fileStatement.setBody(fileBlock);
                res.getStatements().add((Object)fileStatement);
            }
            res.getStatements().add((Object)text);
            return res;
        }

        private String getTextStatementValue(String initialContent) {
            String emptyLineReplacement = UUID.randomUUID().toString() + UUID.randomUUID().toString() + UUID.randomUUID().toString();
            String res = StringServices.EMPTY_LINE_PATTERN.matcher(initialContent).replaceAll(emptyLineReplacement);
            res = StringServices.NEW_LINE_PATTERN.matcher(res).replaceAll(NEW_LINE + "    ");
            res = res.replace(emptyLineReplacement, NEW_LINE + NEW_LINE + "    ");
            res = res.replace("[", "['['/]");
            return res + NEW_LINE + "  ";
        }

        private Documentation createModuleElementDocumentation(ModuleElement moduleElement) {
            ModuleElementDocumentation res = AcceleoPackage.eINSTANCE.getAcceleoFactory().createModuleElementDocumentation();
            CommentBody documentationBody = AcceleoPackage.eINSTANCE.getAcceleoFactory().createCommentBody();
            res.setBody(documentationBody);
            if (moduleElement instanceof Template) {
                Template template = (Template)moduleElement;
                documentationBody.setValue(NEW_LINE + " * The documentation of the template " + template.getName() + "." + NEW_LINE + " *");
                documentationBody.setValue(documentationBody.getValue() + " @param " + ((Variable)template.getParameters().get(0)).getName() + NEW_LINE + " *");
                res.setDocumentedElement((DocumentedElement)template);
            } else if (moduleElement instanceof Query) {
                Query query = (Query)moduleElement;
                documentationBody.setValue(NEW_LINE + " * The documentation of the query " + query.getName() + "." + NEW_LINE + " *");
                documentationBody.setValue(documentationBody.getValue() + " @param " + ((Variable)query.getParameters().get(0)).getName() + NEW_LINE + " *");
                res.setDocumentedElement((DocumentedElement)query);
            }
            return res;
        }

        private Expression createExpression(String expression) {
            Expression res = AcceleoPackage.eINSTANCE.getAcceleoFactory().createExpression();
            QueryBuilderEngine queryBuilder = new QueryBuilderEngine();
            AstResult astResult = queryBuilder.build(expression);
            res.setAst(astResult);
            res.setAql(astResult.getAst());
            return res;
        }

        private Variable createVariable(String moduleElementParameterType) {
            Variable res = AcceleoPackage.eINSTANCE.getAcceleoFactory().createVariable();
            QueryBuilderEngine queryBuilder = new QueryBuilderEngine();
            AstResult astResult = queryBuilder.build(moduleElementParameterType);
            res.setName("parameter");
            res.setType(astResult);
            res.setTypeAql(astResult.getAst());
            return res;
        }
    }
}

