/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.performance.config;

import org.eclipse.nebula.widgets.nattable.config.AbstractLayerConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.group.action.RowGroupExpandCollapseAction;
import org.eclipse.nebula.widgets.nattable.group.action.ViewportSelectRowGroupAction;
import org.eclipse.nebula.widgets.nattable.group.painter.RowGroupHeaderTextPainter;
import org.eclipse.nebula.widgets.nattable.group.performance.RowGroupHeaderLayer;
import org.eclipse.nebula.widgets.nattable.group.performance.action.RowGroupHeaderReorderDragMode;
import org.eclipse.nebula.widgets.nattable.group.performance.action.RowHeaderReorderDragMode;
import org.eclipse.nebula.widgets.nattable.painter.cell.VerticalTextPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.BeveledBorderDecorator;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.style.VerticalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.ui.action.AggregateDragMode;
import org.eclipse.nebula.widgets.nattable.ui.action.CellDragMode;
import org.eclipse.nebula.widgets.nattable.ui.action.NoOpMouseAction;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.matcher.MouseEventMatcher;
import org.eclipse.swt.SWT;

public class DefaultRowGroupHeaderLayerConfiguration
extends AbstractLayerConfiguration<RowGroupHeaderLayer> {
    private final boolean enableRowGroupSelectionBinding;
    private final boolean enableExpandCollapseBinding;
    private RowGroupHeaderLayer rowGroupHeaderLayer;

    public DefaultRowGroupHeaderLayerConfiguration(boolean enableGroupSelection) {
        this(enableGroupSelection, true);
    }

    public DefaultRowGroupHeaderLayerConfiguration(boolean enableGroupSelection, boolean enableExpandCollapse) {
        this.enableRowGroupSelectionBinding = enableGroupSelection;
        this.enableExpandCollapseBinding = enableExpandCollapse;
    }

    @Override
    public void configureTypedLayer(RowGroupHeaderLayer layer) {
        this.rowGroupHeaderLayer = layer;
    }

    @Override
    public void configureRegistry(IConfigRegistry configRegistry) {
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, new BeveledBorderDecorator(new RowGroupHeaderTextPainter(new VerticalTextPainter())), DisplayMode.NORMAL, "ROW_GROUP_HEADER");
        if (this.rowGroupHeaderLayer.isShowAlwaysGroupNames()) {
            Style headerStyle = new Style();
            headerStyle.setAttributeValue(CellStyleAttributes.VERTICAL_ALIGNMENT, VerticalAlignmentEnum.TOP);
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, headerStyle, DisplayMode.NORMAL, "ROW_GROUP_HEADER");
        }
    }

    @Override
    public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
        uiBindingRegistry.registerMouseDragMode(MouseEventMatcher.rowGroupHeaderLeftClick(0), new AggregateDragMode(new CellDragMode(), new RowGroupHeaderReorderDragMode(this.rowGroupHeaderLayer)));
        uiBindingRegistry.registerMouseDragMode(MouseEventMatcher.rowHeaderLeftClick(0), new AggregateDragMode(new CellDragMode(), new RowHeaderReorderDragMode(this.rowGroupHeaderLayer)));
        uiBindingRegistry.registerMouseDownBinding(MouseEventMatcher.rowGroupHeaderLeftClick(0), new NoOpMouseAction());
        uiBindingRegistry.registerMouseDownBinding(MouseEventMatcher.rowGroupHeaderLeftClick(SWT.MOD1), new NoOpMouseAction());
        uiBindingRegistry.registerMouseDownBinding(MouseEventMatcher.rowGroupHeaderLeftClick(SWT.MOD2), new NoOpMouseAction());
        uiBindingRegistry.registerMouseDownBinding(MouseEventMatcher.rowGroupHeaderLeftClick(SWT.MOD1 | SWT.MOD2), new NoOpMouseAction());
        if (this.enableRowGroupSelectionBinding) {
            uiBindingRegistry.registerSingleClickBinding(MouseEventMatcher.rowGroupHeaderLeftClick(0), new ViewportSelectRowGroupAction(false, false));
            uiBindingRegistry.registerSingleClickBinding(MouseEventMatcher.rowGroupHeaderLeftClick(SWT.MOD1), new ViewportSelectRowGroupAction(false, true));
            uiBindingRegistry.registerSingleClickBinding(MouseEventMatcher.rowGroupHeaderLeftClick(SWT.MOD2), new ViewportSelectRowGroupAction(true, false));
            uiBindingRegistry.registerSingleClickBinding(MouseEventMatcher.rowGroupHeaderLeftClick(SWT.MOD1 | SWT.MOD2), new ViewportSelectRowGroupAction(true, true));
        }
        if (this.enableExpandCollapseBinding) {
            uiBindingRegistry.registerDoubleClickBinding(MouseEventMatcher.rowGroupHeaderLeftClick(0), new RowGroupExpandCollapseAction(this.enableRowGroupSelectionBinding));
        }
    }
}

