/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.ui.widget;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.fordiac.ide.ui.providers.RowHeaderDataProvider;
import org.eclipse.fordiac.ide.ui.widget.DataObjectTransfer;
import org.eclipse.fordiac.ide.ui.widget.I4diacNatTableUtil;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.copy.command.PasteDataCommand;
import org.eclipse.nebula.widgets.nattable.edit.command.EditUtils;
import org.eclipse.nebula.widgets.nattable.edit.command.UpdateDataCommand;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PasteDataFromClipboardCommandHandler
extends AbstractLayerCommandHandler<PasteDataCommand> {
    protected final SelectionLayer selectionLayer;
    protected final I4diacNatTableUtil section;
    private final RowHeaderDataProvider rowHeaderDataProvider;

    public PasteDataFromClipboardCommandHandler(SelectionLayer selectionLayer) {
        this(selectionLayer, null, null);
    }

    public PasteDataFromClipboardCommandHandler(SelectionLayer selectionLayer, I4diacNatTableUtil section, RowHeaderDataProvider rowHeaderDataProvider) {
        this.selectionLayer = selectionLayer;
        this.section = section;
        this.rowHeaderDataProvider = rowHeaderDataProvider;
    }

    protected boolean doCommand(PasteDataCommand command) {
        Clipboard clipboard = new Clipboard(Display.getDefault());
        Object clipboardCellsContents = clipboard.getContents((Transfer)TextTransfer.getInstance());
        Object clipboardElementsContents = clipboard.getContents((Transfer)DataObjectTransfer.getInstance());
        clipboard.dispose();
        if (clipboardElementsContents != null) {
            this.pasteClipboardElementsContents(clipboardElementsContents);
        } else if (clipboardCellsContents != null) {
            this.pasteClipboardCellsContents(command, clipboardCellsContents);
        }
        return true;
    }

    protected void pasteClipboardCellsContents(PasteDataCommand command, Object contents) {
        String[][] cellsContent = this.parseContent(contents);
        if (!EditUtils.allCellsEditable((SelectionLayer)this.selectionLayer, (IConfigRegistry)command.configRegistry)) {
            return;
        }
        List ranges = this.selectionLayer.getSelectionModel().getSelections().stream().distinct().toList();
        if (ranges.size() != 1) {
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"", (String)FordiacMessages.NatTable_TEXT_Paste);
            return;
        }
        int startingRow = ((Rectangle)ranges.get((int)0)).y;
        int startingColumn = ((Rectangle)ranges.get((int)0)).x;
        int r = 0;
        while (r < cellsContent.length) {
            int c = 0;
            while (c < cellsContent[0].length) {
                ILayerCell cell = this.selectionLayer.getCellByPosition(startingColumn + c, startingRow + r);
                if (cell != null) {
                    this.selectionLayer.doCommand((ILayerCommand)new UpdateDataCommand((ILayer)this.selectionLayer, cell.getColumnIndex(), cell.getRowIndex(), (Object)cellsContent[r][c]));
                    this.selectionLayer.selectRegion(startingColumn, startingRow, cell.getColumnIndex() - startingColumn + 1, cell.getRowIndex() - startingRow + 1);
                }
                ++c;
            }
            ++r;
        }
    }

    private void pasteClipboardElementsContents(Object contents) {
        Object[] contentsArray;
        block9: {
            block8: {
                if (!(contents instanceof Object[])) break block8;
                contentsArray = (Object[])contents;
                if (this.rowHeaderDataProvider != null && this.section != null && this.section.isEditable()) break block9;
            }
            return;
        }
        CompoundCommand cmpCommand = new CompoundCommand();
        if (this.selectionLayer == null) {
            int i = 0;
            Object[] objectArray = contentsArray;
            int n = contentsArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object entry = objectArray[n2];
                this.section.addEntry(entry, this.rowHeaderDataProvider.isInput(), i, cmpCommand);
                ++i;
                ++n2;
            }
            this.section.executeCompoundCommand(cmpCommand);
        } else {
            int[] rows = this.selectionLayer.getFullySelectedRowPositions();
            int[] selectedIndices = new int[contentsArray.length];
            int index = rows.length != 0 ? rows[rows.length - 1] + 1 : this.selectionLayer.getRowCount();
            int i = 0;
            Object[] objectArray = contentsArray;
            int n = contentsArray.length;
            int n3 = 0;
            while (n3 < n) {
                Object entry = objectArray[n3];
                selectedIndices[i] = index;
                ++i;
                this.section.addEntry(entry, this.rowHeaderDataProvider.isInput(), index, cmpCommand);
                ++index;
                ++n3;
            }
            this.section.executeCompoundCommand(cmpCommand);
            objectArray = selectedIndices;
            n = selectedIndices.length;
            n3 = 0;
            while (n3 < n) {
                Object ind = objectArray[n3];
                this.selectionLayer.selectRow(0, (int)ind, false, true);
                ++n3;
            }
            this.updateNewRow(selectedIndices);
        }
    }

    protected void updateNewRow(int[] rowIndices) {
    }

    protected String[][] parseContent(Object contents) {
        ArrayList lines = new ArrayList();
        ((String)contents).lines().forEach(s -> {
            String[] st = s.split("\t", -1);
            lines.add(st);
        });
        String[][] content = new String[lines.size()][];
        int i = 0;
        while (i < lines.size()) {
            content[i] = (String[])lines.get(i);
            ++i;
        }
        return content;
    }

    public Class<PasteDataCommand> getCommandClass() {
        return PasteDataCommand.class;
    }
}

