/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.util;

import com.google.common.collect.Iterables;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.libraryElement.BaseFBType;
import org.eclipse.fordiac.ide.model.libraryElement.GlobalConstants;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.structuredtextcore.resource.LibraryElementXtextResource;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.LazyStringInputStream;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public final class STCoreParseUtil {
    public static IParseResult parse(IResourceServiceProvider serviceProvider, XtextResourceSet resourceSet, String text, ParserRule entryPoint, LibraryElement type, Collection<? extends EObject> additionalContent, List<Issue> issues, URI uri) {
        return STCoreParseUtil.parse(serviceProvider, resourceSet, text, entryPoint, type, additionalContent, issues, uri, null);
    }

    public static IParseResult parse(IResourceServiceProvider serviceProvider, XtextResourceSet resourceSet, String text, ParserRule entryPoint, LibraryElement type, Collection<? extends EObject> additionalContent, List<Issue> issues, URI uri, boolean includeInternalLibraryElement) {
        return STCoreParseUtil.parse(serviceProvider, resourceSet, text, entryPoint, type, additionalContent, issues, uri, null, includeInternalLibraryElement);
    }

    public static IParseResult parse(IResourceServiceProvider serviceProvider, XtextResourceSet resourceSet, String text, ParserRule entryPoint, LibraryElement type, Collection<? extends EObject> additionalContent, List<Issue> issues, URI uri, Map<?, ?> loadOptions) {
        return STCoreParseUtil.parse(serviceProvider, resourceSet, text, entryPoint, type, additionalContent, issues, uri, loadOptions, type instanceof BaseFBType || type instanceof GlobalConstants);
    }

    public static IParseResult parse(IResourceServiceProvider serviceProvider, XtextResourceSet resourceSet, String text, ParserRule entryPoint, LibraryElement type, Collection<? extends EObject> additionalContent, List<Issue> issues, URI uri, Map<?, ?> loadOptions, boolean includeInternalLibraryElement) {
        try {
            Map _loadOptions;
            boolean _not;
            Pair _mappedTo = Pair.of((Object)"org.eclipse.xtext.builder.impl.PersistentDataAwareDirtyResource.PERSISTED_DESCRIPTIONS", (Object)Boolean.TRUE);
            resourceSet.getLoadOptions().putAll(Collections.unmodifiableMap(CollectionLiterals.newHashMap((Pair[])new Pair[]{_mappedTo})));
            XtextResource _get = (XtextResource)serviceProvider.get(XtextResource.class);
            LibraryElementXtextResource resource = (LibraryElementXtextResource)_get;
            URI _elvis = null;
            TypeEntry _typeEntry = null;
            if (type != null) {
                _typeEntry = type.getTypeEntry();
            }
            IFile _file = null;
            if (_typeEntry != null) {
                _file = _typeEntry.getFile();
            }
            IPath _fullPath = null;
            if (_file != null) {
                _fullPath = _file.getFullPath();
            }
            String _string = null;
            if (_fullPath != null) {
                _string = _fullPath.toString();
            }
            URI _createPlatformResourceURI = null;
            if (_string != null) {
                _createPlatformResourceURI = URI.createPlatformResourceURI((String)_string, (boolean)true);
            }
            _elvis = _createPlatformResourceURI != null ? _createPlatformResourceURI : uri;
            resource.setURI(_elvis);
            resourceSet.getResources().add((Object)resource);
            resource.setEntryPoint(entryPoint);
            resource.setLibraryElement(type);
            resource.setIncludeInternalLibraryElement(includeInternalLibraryElement);
            boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(additionalContent);
            boolean bl = _not = !_isNullOrEmpty;
            if (_not) {
                resource.getAdditionalContent().addAll(additionalContent);
            }
            LazyStringInputStream _lazyStringInputStream = new LazyStringInputStream(text);
            Map _elvis_1 = null;
            _elvis_1 = loadOptions != null ? loadOptions : (_loadOptions = resourceSet.getLoadOptions());
            resource.load((InputStream)_lazyStringInputStream, _elvis_1);
            EcoreUtil.resolveAll((Resource)resource);
            if (issues != null) {
                IResourceValidator validator = resource.getResourceServiceProvider().getResourceValidator();
                issues.addAll(validator.validate((Resource)resource, CheckMode.FAST_ONLY, CancelIndicator.NullImpl));
            }
            return resource.getParseResult();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static IParseResult postProcess(String name, List<String> errors, List<String> warnings, List<String> infos, List<Issue> issues, IParseResult parseResult) {
        Functions.Function1 _function_6;
        boolean _exists;
        if (errors != null) {
            Functions.Function1 _function = it -> {
                Severity _severity = it.getSeverity();
                return Objects.equals(_severity, Severity.ERROR);
            };
            Functions.Function1 _function_1 = it -> {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append(name);
                _builder.append(" at ");
                Integer _lineNumber = it.getLineNumber();
                _builder.append((Object)_lineNumber);
                _builder.append(": ");
                String _message = it.getMessage();
                _builder.append(_message);
                return _builder.toString();
            };
            Iterables.addAll(errors, (Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter(issues, (Functions.Function1)_function), (Functions.Function1)_function_1));
        }
        if (warnings != null) {
            Functions.Function1 _function_2 = it -> {
                Severity _severity = it.getSeverity();
                return Objects.equals(_severity, Severity.WARNING);
            };
            Functions.Function1 _function_3 = it -> {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append(name);
                _builder.append(" at ");
                Integer _lineNumber = it.getLineNumber();
                _builder.append((Object)_lineNumber);
                _builder.append(": ");
                String _message = it.getMessage();
                _builder.append(_message);
                return _builder.toString();
            };
            Iterables.addAll(warnings, (Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter(issues, (Functions.Function1)_function_2), (Functions.Function1)_function_3));
        }
        if (infos != null) {
            Functions.Function1 _function_4 = it -> {
                Severity _severity = it.getSeverity();
                return Objects.equals(_severity, Severity.INFO);
            };
            Functions.Function1 _function_5 = it -> {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append(name);
                _builder.append(" at ");
                Integer _lineNumber = it.getLineNumber();
                _builder.append((Object)_lineNumber);
                _builder.append(": ");
                String _message = it.getMessage();
                _builder.append(_message);
                return _builder.toString();
            };
            Iterables.addAll(infos, (Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter(issues, (Functions.Function1)_function_4), (Functions.Function1)_function_5));
        }
        if (_exists = IterableExtensions.exists(issues, (Functions.Function1)(_function_6 = it -> {
            Severity _severity = it.getSeverity();
            return Objects.equals(_severity, Severity.ERROR);
        }))) {
            return null;
        }
        return parseResult;
    }

    public static IParseResult postProcess(IParseResult parseResult, List<String> errors, List<String> warnings, List<String> infos, List<Issue> issues) {
        Functions.Function1 _function_6;
        boolean _exists;
        if (errors != null) {
            Functions.Function1 _function = it -> {
                Severity _severity = it.getSeverity();
                return Objects.equals(_severity, Severity.ERROR);
            };
            Functions.Function1 _function_1 = it -> it.getMessage();
            Iterables.addAll(errors, (Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter(issues, (Functions.Function1)_function), (Functions.Function1)_function_1));
        }
        if (warnings != null) {
            Functions.Function1 _function_2 = it -> {
                Severity _severity = it.getSeverity();
                return Objects.equals(_severity, Severity.WARNING);
            };
            Functions.Function1 _function_3 = it -> it.getMessage();
            Iterables.addAll(warnings, (Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter(issues, (Functions.Function1)_function_2), (Functions.Function1)_function_3));
        }
        if (infos != null) {
            Functions.Function1 _function_4 = it -> {
                Severity _severity = it.getSeverity();
                return Objects.equals(_severity, Severity.INFO);
            };
            Functions.Function1 _function_5 = it -> it.getMessage();
            Iterables.addAll(infos, (Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter(issues, (Functions.Function1)_function_4), (Functions.Function1)_function_5));
        }
        if (_exists = IterableExtensions.exists(issues, (Functions.Function1)(_function_6 = it -> {
            Severity _severity = it.getSeverity();
            return Objects.equals(_severity, Severity.ERROR);
        }))) {
            return null;
        }
        return parseResult;
    }

    private STCoreParseUtil() {
        throw new UnsupportedOperationException();
    }
}

