/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.search;

import java.util.regex.Pattern;
import org.eclipse.fordiac.ide.model.search.ModelQuerySpec;

public class ModelSearchPattern {
    private final Pattern searchPattern;
    private final Pattern preScannSTPattern;
    private final String preScannSTStringPattern;

    public ModelSearchPattern(ModelQuerySpec modelQuerySpec) {
        this.searchPattern = Pattern.compile(ModelSearchPattern.convertSearchStringToPattern(modelQuerySpec.searchString()));
        this.preScannSTStringPattern = ModelSearchPattern.generatePreScanSTStringPattern(modelQuerySpec.searchString());
        this.preScannSTPattern = ModelSearchPattern.containsRegex(this.preScannSTStringPattern) ? Pattern.compile(this.preScannSTStringPattern, 2) : null;
    }

    private static String convertSearchStringToPattern(String searchString) {
        String temp = searchString;
        if (searchString.contains("?")) {
            temp = searchString.replace("?", "[a-zA-Z0-9_]");
        }
        if (searchString.contains("*")) {
            temp = searchString.replace("*", ".*");
        }
        return temp;
    }

    public boolean matchSearchString(String toTest) {
        return this.searchPattern.matcher(toTest).matches();
    }

    public boolean preScanST(String toTest) {
        if (this.preScannSTPattern != null) {
            return this.preScannSTPattern.matcher(toTest).find();
        }
        return this.preScanSTIgnoreCase(toTest);
    }

    private static String generatePreScanSTStringPattern(String searchString) {
        String result = searchString;
        int lastPackageSepeartor = result.lastIndexOf("::");
        if (lastPackageSepeartor != -1) {
            result = result.substring(lastPackageSepeartor + 2);
        }
        return ModelSearchPattern.convertSearchStringToPattern(result);
    }

    private static boolean containsRegex(String pattern) {
        return pattern.matches(".*[.*+?^${}()|\\[\\]\\\\].*");
    }

    private boolean preScanSTIgnoreCase(String toTest) {
        int patternLength = this.preScannSTStringPattern.length();
        int i = 0;
        while (i <= toTest.length() - patternLength) {
            if (toTest.regionMatches(true, i, this.preScannSTStringPattern, 0, patternLength)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

