/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.value;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.fordiac.ide.model.eval.EvaluatorInitializerException;
import org.eclipse.fordiac.ide.model.eval.value.Value;
import org.eclipse.fordiac.ide.model.eval.value.ValueOperations;
import org.eclipse.fordiac.ide.model.eval.variable.ECStateVariable;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.eval.variable.VariableOperations;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.BaseFBType;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;

public final class FBValue
implements Value,
Iterable<Value> {
    private final FBType type;
    private final Map<String, Variable<?>> members = new HashMap();

    public FBValue(FBType type) {
        this(type, Collections.emptyList());
    }

    public FBValue(FBType type, Iterable<Variable<?>> variables) {
        this(type, type.getInterfaceList(), variables);
    }

    public FBValue(FB fb) {
        this(fb, Collections.emptyList());
    }

    public FBValue(FB fb, Iterable<Variable<?>> variables) {
        this(fb.getType(), fb.getInterface(), variables);
    }

    private FBValue(FBType type, InterfaceList interfaceList, Iterable<Variable<?>> variables) {
        this.type = type;
        if (variables != null) {
            variables.forEach(variable -> {
                Variable variable2 = this.members.put(variable.getName(), (Variable<?>)variable);
            });
        }
        interfaceList.getInputVars().forEach(this::initializeMember);
        interfaceList.getInOutVars().forEach(this::initializeMember);
        interfaceList.getOutputVars().forEach(this::initializeMember);
        interfaceList.getSockets().stream().map(AdapterDeclaration::getAdapterFB).forEach(this::initializeMember);
        interfaceList.getPlugs().stream().map(AdapterDeclaration::getAdapterFB).forEach(this::initializeMember);
        if (type instanceof BaseFBType) {
            BaseFBType baseFBType = (BaseFBType)type;
            baseFBType.getInternalConstVars().forEach(this::initializeMember);
            baseFBType.getInternalVars().forEach(this::initializeMember);
            baseFBType.getInternalFbs().forEach(this::initializeMember);
        }
        if (type instanceof BasicFBType) {
            BasicFBType basicFBType = (BasicFBType)type;
            this.members.computeIfAbsent("__STATE", unused -> new ECStateVariable(basicFBType));
        }
    }

    public FBValue(FBType type, Map<String, ?> values) {
        this(type);
        values.forEach((? super K name, ? super V value) -> {
            Variable<?> member = this.members.get(name);
            if (member != null) {
                member.setValue(ValueOperations.wrapValue(value, member.getType()));
            }
        });
    }

    protected void initializeMember(VarDeclaration variable) {
        this.members.computeIfAbsent(variable.getName(), unused -> {
            try {
                return VariableOperations.newVariable(variable);
            }
            catch (Exception e) {
                throw new EvaluatorInitializerException((INamedElement)variable, (Throwable)e);
            }
        });
    }

    protected void initializeMember(FB fb) {
        this.members.computeIfAbsent(fb.getName(), unused -> {
            try {
                return VariableOperations.newVariable(fb);
            }
            catch (Exception e) {
                throw new EvaluatorInitializerException((INamedElement)fb, (Throwable)e);
            }
        });
    }

    public Variable<?> get(String key) {
        return this.members.get(key);
    }

    public int hashCode() {
        return this.members.values().stream().map(Variable::getValue).mapToInt(Objects::hashCode).sum();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FBValue other = (FBValue)obj;
        return this.members.values().stream().allMatch(member -> Objects.equals(member.getValue(), other.get(member.getName()).getValue()));
    }

    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean pretty) {
        return this.members.values().stream().map(member -> member.getName() + (pretty ? " := " : ":=") + member.toString(pretty)).collect(Collectors.joining(pretty ? ", " : ",", "(", ")"));
    }

    @Override
    public Iterator<Value> iterator() {
        return this.members.values().stream().sorted(Comparator.comparing(Variable::getName)).map(Variable::getValue).iterator();
    }

    public FBType getType() {
        return this.type;
    }

    public Map<String, Variable<?>> getMembers() {
        return this.members;
    }
}

