/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.st;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.eval.Evaluator;
import org.eclipse.fordiac.ide.model.eval.EvaluatorException;
import org.eclipse.fordiac.ide.model.eval.EvaluatorPrepareException;
import org.eclipse.fordiac.ide.model.eval.st.STCallableEvaluator;
import org.eclipse.fordiac.ide.model.eval.st.StructuredTextEvaluator;
import org.eclipse.fordiac.ide.model.eval.value.Value;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.libraryElement.STAlgorithm;
import org.eclipse.fordiac.ide.structuredtextalgorithm.util.StructuredTextParseUtil;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarDeclarationBlock;

public class STAlgorithmEvaluator
extends STCallableEvaluator {
    private final STAlgorithm algorithm;
    private org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STAlgorithm parseResult;

    public STAlgorithmEvaluator(STAlgorithm algorithm, Variable<?> context, Iterable<Variable<?>> variables, Evaluator parent) {
        super(algorithm.getName(), context, variables, parent);
        this.algorithm = algorithm;
    }

    public void prepare() {
        if (this.parseResult == null) {
            ArrayList errors = new ArrayList();
            ArrayList warnings = new ArrayList();
            ArrayList infos = new ArrayList();
            this.parseResult = StructuredTextParseUtil.parse((STAlgorithm)this.algorithm, errors, warnings, infos);
            errors.forEach(arg_0 -> ((STAlgorithmEvaluator)this).error(arg_0));
            warnings.forEach(arg_0 -> ((STAlgorithmEvaluator)this).warn(arg_0));
            infos.forEach(arg_0 -> ((STAlgorithmEvaluator)this).info(arg_0));
            if (this.parseResult == null) {
                throw new EvaluatorPrepareException(errors.stream().collect(Collectors.joining(", ")), (Evaluator)this);
            }
        }
    }

    public void cleanup() {
        this.parseResult = null;
    }

    public Value evaluate() throws EvaluatorException, InterruptedException {
        this.prepare();
        this.evaluateStructuredTextAlgorithm(this.parseResult);
        this.trap(this.parseResult);
        return null;
    }

    protected void evaluateStructuredTextAlgorithm(org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STAlgorithm algorithm) throws EvaluatorException, InterruptedException {
        this.evaluateCallableVariables((List<? extends STVarDeclarationBlock>)algorithm.getBody().getVarTempDeclarations());
        try {
            this.evaluateStatementList((List<STStatement>)algorithm.getBody().getStatements());
        }
        catch (StructuredTextEvaluator.StructuredTextException structuredTextException) {
            // empty catch block
        }
    }

    public org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STAlgorithm getSourceElement() {
        return this.parseResult;
    }

    public Set<String> getDependencies() {
        this.prepare();
        if (this.parseResult != null) {
            return StructuredTextParseUtil.collectUsedTypes((EObject)this.parseResult);
        }
        return Collections.emptySet();
    }
}

