/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.delete;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.commands.Messages;
import org.eclipse.fordiac.ide.model.commands.QualNameAffectedCommand;
import org.eclipse.fordiac.ide.model.commands.change.UnmapCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteConnectionCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Group;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.ui.editors.EditorUtils;
import org.eclipse.fordiac.ide.ui.editors.I4diacModelEditor;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;

public class DeleteFBNetworkElementCommand
extends Command
implements QualNameAffectedCommand {
    private final FBNetwork fbParent;
    private final FBNetworkElement element;
    private final CompoundCommand cmds = new CompoundCommand();
    private final Group group;
    private int elementIndex;

    public DeleteFBNetworkElementCommand(FBNetworkElement element) {
        super(Messages.DeleteFBNetworkElementCommand_DeleteFBOrSubapplication);
        this.element = Objects.requireNonNull(element);
        this.group = element.getGroup();
        this.fbParent = element.getFbNetwork();
    }

    public FBNetworkElement getFBNetworkElement() {
        return this.element;
    }

    public boolean canExecute() {
        FB fb;
        FBNetworkElement fBNetworkElement;
        return this.fbParent != null && (!((fBNetworkElement = this.element) instanceof FB) || !(fb = (FB)fBNetworkElement).isResourceTypeFB());
    }

    public void execute() {
        if (this.element.isMapped()) {
            this.cmds.add((Command)new UnmapCommand(this.element));
        }
        this.collectDeleteCommands(this.element);
        if (this.cmds.canExecute()) {
            this.cmds.execute();
        }
        if (this.group != null) {
            this.element.setGroup(null);
        }
        this.elementIndex = this.fbParent.getNetworkElements().indexOf((Object)this.element);
        this.fbParent.getNetworkElements().remove((Object)this.element);
        FBNetworkElement fBNetworkElement = this.element;
        if (fBNetworkElement instanceof SubApp) {
            SubApp subapp = (SubApp)fBNetworkElement;
            DeleteFBNetworkElementCommand.closeSubApplicationEditor(subapp);
        }
    }

    public void undo() {
        this.fbParent.getNetworkElements().add(this.elementIndex, (Object)this.element);
        if (this.group != null) {
            this.element.setGroup(this.group);
        }
        if (this.cmds.canUndo()) {
            this.cmds.undo();
        }
    }

    public void redo() {
        if (this.cmds.canRedo()) {
            this.cmds.redo();
        }
        if (this.group != null) {
            this.element.setGroup(null);
        }
        this.elementIndex = this.fbParent.getNetworkElements().indexOf((Object)this.element);
        this.fbParent.getNetworkElements().remove((Object)this.element);
    }

    private void collectDeleteCommands(FBNetworkElement element) {
        for (IInterfaceElement intElement : element.getInterface().getAllInterfaceElements()) {
            EList connections = intElement.isIsInput() ? intElement.getInputConnections() : intElement.getOutputConnections();
            connections.forEach(con -> this.cmds.add((Command)new DeleteConnectionCommand((Connection)con, element)));
        }
    }

    private static void closeSubApplicationEditor(SubApp subapp) {
        EditorUtils.closeEditorsFiltered(editor -> {
            if (!(editor instanceof I4diacModelEditor)) return false;
            I4diacModelEditor modelEditor = (I4diacModelEditor)editor;
            if (subapp.getSubAppNetwork() != modelEditor.getModel()) return false;
            return true;
        });
    }

    public FBNetwork getFbParent() {
        return this.fbParent;
    }

    @Override
    public Set<EObject> getAffectedObjects() {
        if (this.fbParent != null) {
            return Set.of(this.fbParent);
        }
        return Set.of(this.element);
    }

    @Override
    public String getOldQualName(INamedElement element) {
        return element.getQualifiedName();
    }

    @Override
    public String getNewQualName(INamedElement element) {
        return null;
    }

    @Override
    public List<INamedElement> getChangedElements() {
        return List.of(this.element);
    }
}

