/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.create;

import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.model.CoordinateConverter;
import org.eclipse.fordiac.ide.model.commands.change.AddElementsToGroup;
import org.eclipse.fordiac.ide.model.commands.create.AbstractCreateFBNetworkElementCommand;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Group;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;

public class CreateGroupCommand
extends AbstractCreateFBNetworkElementCommand {
    private static final int GROUP_TOP_BORDER = 20;
    private static final int GROUP_BORDER = 2;
    private static final String INITIAL_GROUP_NAME = "Group01";
    private final AddElementsToGroup addElements;
    private final Rectangle posSizeRef;

    public CreateGroupCommand(FBNetwork fbNetwork, List<?> selection, Rectangle posSizeRef) {
        super(fbNetwork, (FBNetworkElement)LibraryElementFactory.eINSTANCE.createGroup(), posSizeRef.x, posSizeRef.y);
        this.addElements = new AddElementsToGroup(this.getElement(), selection, posSizeRef.getTopLeft());
        this.posSizeRef = this.checkPosSizeRef(posSizeRef);
    }

    @Override
    public boolean canExecute() {
        return super.canExecute() && this.allElementsInSameFBnetwork();
    }

    @Override
    public void execute() {
        this.updateCreatePosition(this.posSizeRef.getTopLeft());
        this.getElement().setWidth((double)this.posSizeRef.width);
        this.getElement().setHeight((double)this.posSizeRef.height);
        super.execute();
        this.addElements.execute();
    }

    @Override
    public void redo() {
        super.redo();
        this.addElements.redo();
    }

    @Override
    public void undo() {
        this.addElements.undo();
        super.undo();
    }

    @Override
    protected final InterfaceList createInterfaceList() {
        return null;
    }

    @Override
    protected String getInitialInstanceName() {
        return INITIAL_GROUP_NAME;
    }

    public Group getElement() {
        return (Group)super.getElement();
    }

    private final Rectangle checkPosSizeRef(Rectangle posSizeRef) {
        if (!this.addElements.getElementsToAdd().isEmpty()) {
            posSizeRef.x -= 2;
            posSizeRef.y -= 20;
            posSizeRef.width += 4;
            posSizeRef.height += 22;
            posSizeRef.width = Math.max(posSizeRef.width, CoordinateConverter.INSTANCE.iec61499ToScreen(this.getElement().getWidth()));
            posSizeRef.height = Math.max(posSizeRef.height, CoordinateConverter.INSTANCE.iec61499ToScreen(this.getElement().getHeight()));
        }
        return posSizeRef;
    }

    private boolean allElementsInSameFBnetwork() {
        List<FBNetworkElement> elementsToAdd = this.addElements.getElementsToAdd();
        if (!elementsToAdd.isEmpty()) {
            return elementsToAdd.stream().allMatch(el -> this.getFBNetwork().equals(el.getFbNetwork()));
        }
        return true;
    }
}

