/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.annotation;

import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationProvider;

public class GraphicalAnnotationProviderDescriptor {
    private static final String CLASS_ATTRIBUTE = "class";
    private final IConfigurationElement element;
    private Expression enablement;

    public GraphicalAnnotationProviderDescriptor(IConfigurationElement element) {
        this.element = element;
    }

    public boolean isEnabled(Object context) {
        try {
            return this.getEnablement().evaluate((IEvaluationContext)new EvaluationContext(null, context)) == EvaluationResult.TRUE;
        }
        catch (CoreException e) {
            this.log("Exception occurred evaluating enablement expression", e);
            return false;
        }
    }

    public GraphicalAnnotationProvider createProvider() {
        return (GraphicalAnnotationProvider)SafeRunner.run(() -> (GraphicalAnnotationProvider)this.element.createExecutableExtension(CLASS_ATTRIBUTE));
    }

    private Expression getEnablement() {
        if (this.enablement == null) {
            this.enablement = this.createEnablement();
        }
        return this.enablement;
    }

    private Expression createEnablement() {
        IConfigurationElement[] children = this.element.getChildren("enablement");
        if (children.length == 0) {
            return Expression.TRUE;
        }
        if (children.length > 1) {
            this.log("More than one enablement sub-element", null);
            return Expression.FALSE;
        }
        try {
            return ExpressionConverter.getDefault().perform(children[0]);
        }
        catch (CoreException e) {
            this.log("Invalid enablement expression", e);
            return Expression.FALSE;
        }
    }

    private void log(String message, Throwable t) {
        Platform.getLog(this.getClass()).error(String.format("%s in extension %s from plugin %s", message, this.element.getDeclaringExtension().getExtensionPointUniqueIdentifier(), this.element.getDeclaringExtension().getContributor().getName()), t);
    }
}

