/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.validation;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.fordiac.ide.gef.validation.CancelableDiagnostician;
import org.eclipse.fordiac.ide.model.data.AnyType;
import org.eclipse.fordiac.ide.model.datatype.helper.InternalAttributeDeclarations;
import org.eclipse.fordiac.ide.model.errormarker.FordiacMarkerHelper;
import org.eclipse.fordiac.ide.model.eval.variable.VariableOperations;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.AttributeDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.ECTransition;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;

public class VariableDiagnostician
extends CancelableDiagnostician {
    public VariableDiagnostician(IProgressMonitor progressMonitor) {
        super(progressMonitor);
    }

    @Override
    protected boolean doValidate(EValidator eValidator, EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        EObject eObject2;
        boolean result = super.doValidate(eValidator, eClass, eObject, diagnostics, context);
        EObject eObject3 = eObject;
        Objects.requireNonNull(eObject3);
        EObject eObject4 = eObject2 = eObject3;
        int n = 0;
        block5: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{VarDeclaration.class, Attribute.class, ECTransition.class}, (Object)eObject4, n)) {
                case 0: {
                    VarDeclaration varDeclaration = (VarDeclaration)eObject2;
                    if (!(varDeclaration.getType() instanceof AnyType)) {
                        eObject4 = eObject2;
                        n = 1;
                        continue block5;
                    }
                    result &= VariableDiagnostician.validate(varDeclaration, VariableOperations::validateType, diagnostics, (EObject)varDeclaration.getArraySize());
                    result &= VariableDiagnostician.validate(varDeclaration, VariableOperations::validateValue, diagnostics, (EObject)varDeclaration.getValue());
                    break block5;
                }
                case 1: {
                    Attribute attribute = (Attribute)eObject2;
                    if (!(attribute.getType() instanceof AnyType) || InternalAttributeDeclarations.isInternalAttribute((AttributeDeclaration)attribute.getAttributeDeclaration())) {
                        eObject4 = eObject2;
                        n = 2;
                        continue block5;
                    }
                    result &= VariableDiagnostician.validate(attribute, VariableOperations::validateValue, diagnostics, (EObject)attribute, (EStructuralFeature)LibraryElementPackage.Literals.ATTRIBUTE__VALUE);
                    break block5;
                }
                case 2: {
                    ECTransition transition = (ECTransition)eObject2;
                    result &= VariableDiagnostician.validate(transition, VariableOperations::validateConditionExpression, diagnostics, (EObject)transition, (EStructuralFeature)LibraryElementPackage.Literals.EC_TRANSITION__CONDITION_EXPRESSION);
                    break block5;
                }
            }
            break;
        }
        return result;
    }

    protected static <T> boolean validate(T element, VariableValidator<? super T> validator, DiagnosticChain diagnostics, EObject context) {
        return VariableDiagnostician.validate(element, validator, diagnostics, context, null);
    }

    protected static <T> boolean validate(T element, VariableValidator<? super T> validator, DiagnosticChain diagnostics, EObject context, EStructuralFeature feature) {
        ArrayList<String> errors = new ArrayList<String>();
        ArrayList<String> warnings = new ArrayList<String>();
        ArrayList<String> infos = new ArrayList<String>();
        boolean result = validator.validate(element, errors, warnings, infos);
        if (diagnostics != null) {
            VariableDiagnostician.createDiagnostics(4, errors, context, feature, diagnostics);
            VariableDiagnostician.createDiagnostics(2, warnings, context, feature, diagnostics);
            VariableDiagnostician.createDiagnostics(1, infos, context, feature, diagnostics);
        }
        return result;
    }

    protected static void createDiagnostics(int severity, List<String> messages, EObject object, EStructuralFeature feature, DiagnosticChain diagnostics) {
        messages.stream().map(message -> VariableDiagnostician.createDiagnostic(severity, message, object, feature)).forEachOrdered(arg_0 -> ((DiagnosticChain)diagnostics).add(arg_0));
    }

    protected static Diagnostic createDiagnostic(int severity, String message, EObject object, EStructuralFeature feature) {
        return new BasicDiagnostic(severity, "org.eclipse.fordiac.ide.model.libraryElement", 0, message, FordiacMarkerHelper.getDiagnosticData((EObject)object, (EStructuralFeature)feature, (String[])new String[0]));
    }

    @FunctionalInterface
    public static interface VariableValidator<T> {
        public boolean validate(T var1, List<String> var2, List<String> var3, List<String> var4);
    }
}

