/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug.ui.actions;

import java.lang.runtime.SwitchBootstraps;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.fordiac.ide.debug.EvaluatorDebugVariable;
import org.eclipse.fordiac.ide.debug.ui.Messages;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class EvaluatorDebugFindDialog
extends FilteredItemsSelectionDialog {
    private final IStackFrame stackFrame;

    public EvaluatorDebugFindDialog(Shell shell, IStackFrame stackFrame) {
        super(shell);
        this.stackFrame = stackFrame;
        this.setTitle(Messages.EvaluatorDebugFindDialog_Title);
        this.setSelectionHistory(this.getSelectionHistory());
        this.setListLabelProvider((ILabelProvider)new EvaluatorDebugFindDialogListLabelProvider());
        this.setDetailsLabelProvider((ILabelProvider)new EvaluatorDebugFindDialogDetailsLabelProvider());
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new FilteredItemsSelectionDialog.ItemsFilter(this){

            public boolean matchItem(Object item) {
                return this.matches(EvaluatorDebugFindDialog.this.getElementSimpleName(item)) || this.matches(EvaluatorDebugFindDialog.this.getElementName(item));
            }

            public boolean isConsistentItem(Object item) {
                return true;
            }
        };
    }

    protected Comparator getItemsComparator() {
        return Comparator.comparing(this::getElementName).thenComparing(this::getElementExpression);
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        this.fillContentProvider(this.stackFrame.getVariables(), contentProvider, itemsFilter, progressMonitor);
    }

    protected void fillContentProvider(IVariable[] variables, FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)variables.length);
        IVariable[] iVariableArray = variables;
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            IVariable variable = iVariableArray[n2];
            contentProvider.add((Object)variable, itemsFilter);
            this.fillContentProvider(variable.getValue().getVariables(), contentProvider, itemsFilter, (IProgressMonitor)subMonitor.split(1));
            ++n2;
        }
    }

    protected Optional<IVariable> findVariable(Object element, String expression) {
        try {
            Optional<Object> optional;
            Object object;
            Object object2 = object = element;
            int n = 0;
            block7: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IStackFrame.class, IVariable.class, IVariable.class}, (Object)object2, n)) {
                    case 0: {
                        IStackFrame frame = (IStackFrame)object;
                        optional = Stream.of(frame.getVariables()).map(child -> this.findVariable(child, expression)).flatMap(Optional::stream).findAny();
                        break block7;
                    }
                    case 1: {
                        IVariable variable = (IVariable)object;
                        if (!this.getElementExpression(variable).equals(expression)) {
                            object2 = object;
                            n = 2;
                            continue block7;
                        }
                        optional = Optional.of(variable);
                        break block7;
                    }
                    case 2: {
                        IVariable variable = (IVariable)object;
                        if (!expression.startsWith(this.getElementExpression(variable))) {
                            object2 = object;
                            n = 3;
                            continue block7;
                        }
                        optional = Stream.of(variable.getValue().getVariables()).map(child -> this.findVariable(child, expression)).flatMap(Optional::stream).findAny();
                        break block7;
                    }
                    default: {
                        optional = Optional.empty();
                    }
                }
                break;
            }
            return optional;
        }
        catch (DebugException e) {
            return Optional.empty();
        }
    }

    public String getElementName(Object item) {
        if (item instanceof IVariable) {
            IVariable variable = (IVariable)item;
            try {
                return variable.getName();
            }
            catch (DebugException e) {
                return e.getLocalizedMessage();
            }
        }
        return Objects.toString(item);
    }

    public String getElementSimpleName(Object item) {
        String name = this.getElementName(item);
        int index = name.lastIndexOf(46);
        if (index >= 0) {
            return name.substring(index + 1);
        }
        return name;
    }

    public String getElementExpression(Object item) {
        if (item instanceof EvaluatorDebugVariable) {
            EvaluatorDebugVariable variable = (EvaluatorDebugVariable)item;
            return variable.getExpression();
        }
        return this.getElementName(item);
    }

    public String getElementDetail(Object item) {
        if (item instanceof EvaluatorDebugVariable) {
            EvaluatorDebugVariable variable = (EvaluatorDebugVariable)item;
            return variable.getValue().getValueString();
        }
        return this.getElementName(item);
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = PlatformUI.getDialogSettingsProvider((Bundle)FrameworkUtil.getBundle(EvaluatorDebugFindDialog.class)).getDialogSettings();
        return DialogSettings.getOrCreateSection((IDialogSettings)settings, (String)((Object)((Object)this)).getClass().getSimpleName());
    }

    class EvaluatorDebugFindDialogDetailsLabelProvider
    extends LabelProvider {
        EvaluatorDebugFindDialogDetailsLabelProvider() {
        }

        public String getText(Object element) {
            return EvaluatorDebugFindDialog.this.getElementDetail(element);
        }
    }

    class EvaluatorDebugFindDialogListLabelProvider
    extends LabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        EvaluatorDebugFindDialogListLabelProvider() {
        }

        public String getText(Object element) {
            return EvaluatorDebugFindDialog.this.getElementName(element);
        }

        public StyledString getStyledText(Object element) {
            return new StyledString(EvaluatorDebugFindDialog.this.getElementName(element)).append(" - " + EvaluatorDebugFindDialog.this.getElementExpression(element), StyledString.QUALIFIER_STYLER);
        }

        public Image getImage(Object element) {
            if (element instanceof IVariable) {
                return DebugUITools.getImage((String)"IMG_OBJS_VARIABLE");
            }
            return null;
        }
    }

    class EvaluatorDebugFindDialogSelectionHistory
    extends FilteredItemsSelectionDialog.SelectionHistory {
        EvaluatorDebugFindDialogSelectionHistory() {
        }

        protected Object restoreItemFromMemento(IMemento memento) {
            String expression = memento.getTextData();
            if (expression != null) {
                return EvaluatorDebugFindDialog.this.findVariable(EvaluatorDebugFindDialog.this.stackFrame, expression);
            }
            return null;
        }

        protected void storeItemToMemento(Object item, IMemento memento) {
            memento.putTextData(EvaluatorDebugFindDialog.this.getElementExpression(item));
        }
    }
}

