/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug.replaydebugging.ui;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class CollapsableComposite {
    private static final String COLLAPSED_TEXT = "+";
    private static final String EXPANDED_TEXT = "-";
    private final Group group;
    private final Button toggleButton;
    private Composite content;

    public CollapsableComposite(Composite parent, String name, CollapseListener listener) {
        this.group = new Group(parent, 0);
        this.group.setText(name);
        this.group.setLayout((Layout)new GridLayout(1, false));
        this.group.setLayoutData((Object)new GridData(4, 128, true, false));
        this.toggleButton = new Button((Composite)this.group, 2);
        this.toggleButton.setText(EXPANDED_TEXT);
        this.toggleButton.addListener(13, e -> {
            boolean collapsed = this.toggleButton.getSelection();
            Control[] controlArray = this.content.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                child.setVisible(!collapsed);
                ((GridData)child.getLayoutData()).exclude = collapsed;
                ++n2;
            }
            this.content.setVisible(!collapsed);
            ((GridData)this.content.getLayoutData()).exclude = collapsed;
            this.toggleButton.setText(collapsed ? COLLAPSED_TEXT : EXPANDED_TEXT);
            this.content.layout(true, true);
            this.group.layout(true, true);
            listener.onCollapse(collapsed);
        });
        this.content = new Composite((Composite)this.group, 0);
        this.content.setLayout((Layout)new GridLayout(1, false));
        this.content.setLayoutData((Object)new GridData(4, 128, true, false));
    }

    public boolean isEmpty() {
        return this.content.getChildren().length == 0;
    }

    public void dispose() {
        this.group.dispose();
    }

    public Composite getContentsParent() {
        return this.content;
    }

    @FunctionalInterface
    public static interface CollapseListener {
        public void onCollapse(boolean var1);
    }
}

