/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.handlers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.fordiac.ide.model.commands.change.TransferCommentsOfConnectedPinsCommand;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class TransferCommentsOfConnectedPinsHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection sel = HandlerUtil.getCurrentStructuredSelection((ExecutionEvent)event);
        Object element = ((EditPart)sel.getFirstElement()).getModel();
        HashMap<IInterfaceElement, List<IInterfaceElement>> commentsToCopy = new HashMap<IInterfaceElement, List<IInterfaceElement>>();
        if (element instanceof BlockFBNetworkElement) {
            BlockFBNetworkElement fbnElement = (BlockFBNetworkElement)element;
            commentsToCopy.putAll(TransferCommentsOfConnectedPinsHandler.findConnectedPins(fbnElement));
        } else if (element instanceof IInterfaceElement) {
            IInterfaceElement interfaceElement = (IInterfaceElement)element;
            if (interfaceElement.isIsInput()) {
                commentsToCopy.put(interfaceElement, interfaceElement.getInputConnections().stream().map(Connection::getSource).toList());
            } else {
                commentsToCopy.put(interfaceElement, interfaceElement.getOutputConnections().stream().map(Connection::getDestination).toList());
            }
        }
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        CommandStack commandStack = (CommandStack)editor.getAdapter(CommandStack.class);
        commandStack.execute((Command)new TransferCommentsOfConnectedPinsCommand(commentsToCopy));
        return null;
    }

    private static Map<IInterfaceElement, List<IInterfaceElement>> findConnectedPins(BlockFBNetworkElement src) {
        HashMap<IInterfaceElement, List<IInterfaceElement>> commentsToCopy = new HashMap<IInterfaceElement, List<IInterfaceElement>>();
        for (IInterfaceElement outVar : src.getInterface().getOutputVars()) {
            if (outVar.getOutputConnections().isEmpty()) continue;
            commentsToCopy.put(outVar, outVar.getOutputConnections().stream().map(Connection::getDestination).toList());
        }
        for (IInterfaceElement event : src.getInterface().getEventOutputs()) {
            if (event.getOutputConnections().isEmpty()) continue;
            commentsToCopy.put(event, event.getOutputConnections().stream().map(Connection::getDestination).toList());
        }
        return commentsToCopy;
    }
}

