/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.actions;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.fordiac.ide.application.commands.ResizeGroupOrSubappCommand;
import org.eclipse.fordiac.ide.application.editors.FBNetworkContextMenuProvider;
import org.eclipse.fordiac.ide.application.editparts.AbstractContainerContentEditPart;
import org.eclipse.fordiac.ide.application.editparts.GroupContentEditPart;
import org.eclipse.fordiac.ide.application.editparts.UnfoldedSubappContentEditPart;
import org.eclipse.fordiac.ide.application.utilities.GetEditPartFromGraficalViewerHelper;
import org.eclipse.fordiac.ide.model.commands.create.AbstractCreateFBNetworkElementCommand;
import org.eclipse.fordiac.ide.model.commands.create.CreateFBElementInGroupCommand;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.ui.actions.WorkbenchPartAction;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;

public class FBNetworkElementInsertAction
extends WorkbenchPartAction {
    private final TypeEntry typeEntry;
    private final FBNetwork fbNetwork;

    public FBNetworkElementInsertAction(IWorkbenchPart part, TypeEntry entry, FBNetwork fbNetwork) {
        super(part);
        this.typeEntry = entry;
        this.fbNetwork = fbNetwork;
        this.setId(this.typeEntry.getFile().getFullPath().toString());
        this.setText(this.typeEntry.getTypeName());
    }

    protected boolean calculateEnabled() {
        return this.typeEntry != null && this.fbNetwork != null;
    }

    public void run() {
        this.execute(this.createFBNetworkElementCreateCommand());
    }

    private Command createFBNetworkElementCreateCommand() {
        EditPart editPart;
        Point pt = FBNetworkElementInsertAction.getPositionInViewer((IEditorPart)this.getWorkbenchPart());
        AbstractContainerContentEditPart containerEP = GetEditPartFromGraficalViewerHelper.findAbstractContainerContentEditPartAtPosition((IEditorPart)this.getWorkbenchPart(), pt, this.fbNetwork);
        if (containerEP instanceof GroupContentEditPart) {
            GroupContentEditPart groupContentEP = (GroupContentEditPart)containerEP;
            pt = FBNetworkElementInsertAction.applySnapToGrid(pt, (GraphicalEditPart)groupContentEP);
            Point topLeft = containerEP.getFigure().getClientArea().getTopLeft();
            pt.translate(-topLeft.x, -topLeft.y);
            return new ResizeGroupOrSubappCommand((GraphicalEditPart)containerEP, (Command)new CreateFBElementInGroupCommand(this.typeEntry, groupContentEP.getModel().getGroup(), pt.x, pt.y));
        }
        if (containerEP instanceof UnfoldedSubappContentEditPart) {
            UnfoldedSubappContentEditPart subappContentEP = (UnfoldedSubappContentEditPart)containerEP;
            pt = FBNetworkElementInsertAction.applySnapToGrid(pt, (GraphicalEditPart)subappContentEP);
            Point topLeft = containerEP.getFigure().getClientArea().getTopLeft();
            pt.translate(-topLeft.x, -topLeft.y);
            return new ResizeGroupOrSubappCommand((GraphicalEditPart)containerEP, (Command)AbstractCreateFBNetworkElementCommand.createCreateCommand((TypeEntry)this.typeEntry, (FBNetwork)subappContentEP.getModel(), (int)(pt.x - containerEP.getFigure().getBounds().x), (int)(pt.y - containerEP.getFigure().getBounds().y)));
        }
        GraphicalViewer graphicalViewer = (GraphicalViewer)this.getWorkbenchPart().getAdapter(GraphicalViewer.class);
        if (graphicalViewer != null && (editPart = graphicalViewer.getEditPartForModel((Object)this.fbNetwork)) instanceof GraphicalEditPart) {
            GraphicalEditPart graphicalEditPart = (GraphicalEditPart)editPart;
            pt = FBNetworkElementInsertAction.applySnapToGrid(pt, graphicalEditPart);
        }
        return AbstractCreateFBNetworkElementCommand.createCreateCommand((TypeEntry)this.typeEntry, (FBNetwork)this.fbNetwork, (int)pt.x, (int)pt.y);
    }

    private static Point getPositionInViewer(IEditorPart editor) {
        GraphicalViewer viewer = (GraphicalViewer)editor.getAdapter(GraphicalViewer.class);
        return ((FBNetworkContextMenuProvider)viewer.getContextMenu()).getTranslatedAndZoomedPoint();
    }

    private static Point applySnapToGrid(Point refPoint, GraphicalEditPart gep) {
        SnapToHelper helper = (SnapToHelper)gep.getAdapter(SnapToHelper.class);
        if (helper != null) {
            gep.getFigure().translateToAbsolute((Translatable)refPoint);
            PrecisionPoint preciseLocation = new PrecisionPoint(refPoint);
            PrecisionPoint result = new PrecisionPoint(refPoint);
            helper.snapPoint(null, 192, preciseLocation, result);
            gep.getFigure().translateToRelative((Translatable)result);
            return result;
        }
        return refPoint;
    }
}

