/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.properties;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.application.commands.ResizeGroupOrSubappCommand;
import org.eclipse.fordiac.ide.application.utilities.GetEditPartFromGraficalViewerHelper;
import org.eclipse.fordiac.ide.gef.properties.AbstractDoubleColumnSection;
import org.eclipse.fordiac.ide.gef.properties.AbstractSection;
import org.eclipse.fordiac.ide.gef.widgets.ConnectionDisplayWidget;
import org.eclipse.fordiac.ide.gef.widgets.InternalConnectionsViewer;
import org.eclipse.fordiac.ide.gef.widgets.PinInfoBasicWidget;
import org.eclipse.fordiac.ide.model.commands.change.ChangeNameCommand;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableObject;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.ui.nat.EventTypeSelectionTreeContentProvider;
import org.eclipse.fordiac.ide.model.ui.widgets.EventTypeSelectionContentProvider;
import org.eclipse.fordiac.ide.model.ui.widgets.ITypeSelectionContentProvider;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class PinEventInfoSection
extends AbstractDoubleColumnSection {
    private PinInfoBasicWidget pinInfo;
    private ConnectionDisplayWidget inConnections;
    private InternalConnectionsViewer outConnections;
    private static final int NUM_OF_CONN_DISPLAYS = 2;

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.getRightComposite().setLayout((Layout)new GridLayout(2, true));
        Composite middleComposite = this.createSmallComposite(this.getRightComposite());
        Composite rightComposite = this.createSmallComposite(this.getRightComposite());
        this.pinInfo = this.pinInfoCreation(this.getLeftComposite());
        this.inConnections = new ConnectionDisplayWidget(this.getWidgetFactory(), middleComposite, (AbstractSection)this);
        this.outConnections = new InternalConnectionsViewer(this.getWidgetFactory(), rightComposite, (AbstractSection)this);
    }

    protected PinInfoBasicWidget pinInfoCreation(Composite parent) {
        return new PinInfoBasicWidget(parent, this.getWidgetFactory()){

            protected void onNameChange(Text name) {
                ChangeNameCommand changeNameCommand = ChangeNameCommand.forName((INamedElement)this.getType(), (String)name.getText());
                if (this.isExpandedSubappPin()) {
                    this.executeCommand(new ResizeGroupOrSubappCommand((GraphicalEditPart)GetEditPartFromGraficalViewerHelper.findAbstractContainerContentEditFromInterfaceElement(this.getType()), (Command)changeNameCommand));
                } else {
                    this.executeCommand((Command)changeNameCommand);
                }
            }

            private boolean isExpandedSubappPin() {
                SubApp subapp;
                BlockFBNetworkElement blockFBNetworkElement;
                IInterfaceElement ie = this.getType();
                return ie != null && (blockFBNetworkElement = ie.getBlockFBNetworkElement()) instanceof SubApp && (subapp = (SubApp)blockFBNetworkElement).isUnfolded();
            }
        };
    }

    protected IInterfaceElement getType() {
        return (IInterfaceElement)this.type;
    }

    protected EObject getInputType(Object input) {
        IInterfaceElement ie;
        Object refType = input;
        if (input instanceof EditPart) {
            EditPart ep = (EditPart)input;
            refType = ep.getModel();
        }
        return refType instanceof IInterfaceElement ? (ie = (IInterfaceElement)refType) : null;
    }

    protected void performRefresh() {
        if (this.pinInfo != null && this.inConnections != null && this.outConnections != null) {
            this.pinInfo.refresh();
            this.inConnections.refreshConnectionsViewer(this.getType());
            this.outConnections.refreshConnectionsViewer(this.getType());
            BlockFBNetworkElement fb = this.getType().getBlockFBNetworkElement();
            if (fb != null) {
                this.inConnections.setEditable(true);
                this.outConnections.setEditable(true);
            }
        }
    }

    protected void setInputCode() {
        this.pinInfo.disableAllFields();
        this.inConnections.setEditable(false);
        this.outConnections.setEditable(false);
    }

    protected void setInputInit() {
        if (this.pinInfo != null) {
            this.pinInfo.initialize(this.getType(), arg_0 -> ((PinEventInfoSection)this).executeCommand(arg_0));
            this.pinInfo.getTypeSelectionWidget().initialize((ConfigurableObject)this.getType(), this.getTypeSelectionContentProvider(), this.getTypeSelectionTreeContentProvider());
        }
    }

    private Composite createSmallComposite(Composite parent) {
        Composite composite = this.getWidgetFactory().createComposite(parent);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        return composite;
    }

    protected ITypeSelectionContentProvider getTypeSelectionContentProvider() {
        return EventTypeSelectionContentProvider.INSTANCE;
    }

    protected ITreeContentProvider getTypeSelectionTreeContentProvider() {
        return EventTypeSelectionTreeContentProvider.INSTANCE;
    }
}

