/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.editors;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.fordiac.ide.fbtypeeditor.editors.FBTypeContentOutline;
import org.eclipse.fordiac.ide.fbtypeeditor.editors.FBTypeNavigationLocation;
import org.eclipse.fordiac.ide.fbtypeeditor.editors.IFBTValidation;
import org.eclipse.fordiac.ide.model.commands.change.AbstractChangeInterfaceElementCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeNameCommand;
import org.eclipse.fordiac.ide.model.commands.create.CreateInterfaceElementCommand;
import org.eclipse.fordiac.ide.model.commands.create.WithCreateCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteInterfaceCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteWithCommand;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.search.dialog.AbstractTypeEntryDataHandler;
import org.eclipse.fordiac.ide.model.search.dialog.FBTypeEntryDataHandler;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.typeeditor.AbstractTypeEditor;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.fordiac.ide.ui.contentoutline.MultiPageEditorContentOutlinePage;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStackEvent;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.INavigationLocationProvider;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class FBTypeEditor
extends AbstractTypeEditor
implements INavigationLocationProvider {
    private IContentOutlinePage contentOutline = null;
    private int interfaceChanges = 0;

    public void doSave(IProgressMonitor monitor) {
        if (this.getTypeEntry() != null) {
            this.performPresaveHooks();
            super.doSave(monitor);
        }
    }

    protected boolean dependencyAffectingTypeChange() {
        return this.interfaceChanges != 0;
    }

    protected AbstractTypeEntryDataHandler<? extends TypeEntry> createTypeEntryDataHandler() {
        return new FBTypeEntryDataHandler(this.getTypeEntry());
    }

    private void performPresaveHooks() {
        IConfigurationElement[] config;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = config = registry.getConfigurationElementsFor("org.eclipse.fordiac.ide.fbtypeeditor.fBTEditorValidation");
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                Object o = e.createExecutableExtension("class");
                if (o instanceof IFBTValidation) {
                    IFBTValidation fbtValidation = (IFBTValidation)o;
                    fbtValidation.invokeValidation((INamedElement)this.getType());
                }
            }
            catch (CoreException ex) {
                FordiacLogHelper.logError((String)ex.getMessage(), (Throwable)ex);
            }
            ++n2;
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IContentOutlinePage.class) {
            return adapter.cast(this.getOutlinePage());
        }
        if (adapter == FBType.class) {
            return adapter.cast(this.getType());
        }
        if (adapter == IGotoMarker.class) {
            return adapter.cast((Object)this);
        }
        return (T)super.getAdapter(adapter);
    }

    protected IContentOutlinePage getOutlinePage() {
        if (this.contentOutline == null) {
            this.contentOutline = new MultiPageEditorContentOutlinePage((MultiPageEditorPart)this, (IContentOutlinePage)new FBTypeContentOutline(this.getType()));
        }
        return this.contentOutline;
    }

    public void stackChanged(CommandStackEvent event) {
        super.stackChanged(event);
        if (this.isInterfaceChangeCommand(event.getCommand())) {
            switch (event.getDetail()) {
                case 8: 
                case 16: {
                    ++this.interfaceChanges;
                    break;
                }
                case 32: {
                    --this.interfaceChanges;
                    break;
                }
            }
        } else if (event.getDetail() == 512) {
            this.interfaceChanges = 0;
        }
    }

    public String getContributorId() {
        return "property.contributor.fb";
    }

    public INavigationLocation createEmptyNavigationLocation() {
        return null;
    }

    public INavigationLocation createNavigationLocation() {
        return this.getType() != null ? new FBTypeNavigationLocation(this) : null;
    }

    private boolean isInterfaceChangeCommand(Command cmd) {
        block7: {
            block10: {
                FBType fbType;
                block9: {
                    block8: {
                        block6: {
                            if (cmd instanceof CompoundCommand) {
                                CompoundCommand compoundCmd = (CompoundCommand)cmd;
                                for (Command childCmd : compoundCmd.getCommands()) {
                                    if (!this.isInterfaceChangeCommand(childCmd)) continue;
                                    return true;
                                }
                                return false;
                            }
                            fbType = this.getType();
                            if (!(cmd instanceof CreateInterfaceElementCommand)) break block6;
                            CreateInterfaceElementCommand createIFCmd = (CreateInterfaceElementCommand)cmd;
                            if (fbType.getInterfaceList().equals(createIFCmd.getTargetInterfaceList())) break block7;
                        }
                        if (!(cmd instanceof DeleteInterfaceCommand)) break block8;
                        DeleteInterfaceCommand delIFCmd = (DeleteInterfaceCommand)cmd;
                        if (fbType.getInterfaceList().equals(delIFCmd.getParent())) break block7;
                    }
                    if (!(cmd instanceof AbstractChangeInterfaceElementCommand)) break block9;
                    AbstractChangeInterfaceElementCommand changeIFCmd = (AbstractChangeInterfaceElementCommand)cmd;
                    if (fbType.getInterfaceList().equals(changeIFCmd.getInterfaceElement().eContainer())) break block7;
                }
                if (!(cmd instanceof ChangeNameCommand)) break block10;
                ChangeNameCommand chgNameCmd = (ChangeNameCommand)cmd;
                if (fbType.getInterfaceList().equals(chgNameCmd.getElement().eContainer())) break block7;
            }
            if (!(cmd instanceof WithCreateCommand) && !(cmd instanceof DeleteWithCommand)) {
                return false;
            }
        }
        return true;
    }

    protected FBType getType() {
        return (FBType)super.getType();
    }
}

