/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.attributetypeeditor.properties;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.attributetypeeditor.editors.AttributeTypeEditor;
import org.eclipse.fordiac.ide.gef.properties.AbstractSection;
import org.eclipse.fordiac.ide.model.AttributeInheritMode;
import org.eclipse.fordiac.ide.model.AttributeTarget;
import org.eclipse.fordiac.ide.model.commands.change.ChangeInheritAttributeCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeTargetAttributeCommand;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.datatype.helper.InternalAttributeDeclarations;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.AttributeDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class AttributeTargetSection
extends AbstractSection {
    private static final String TARGET_CATEGORY = "category";
    private final List<Button> buttons = new ArrayList<Button>();
    private StructuredType lock;
    private Button inheritButton;
    private Button copyButton;
    private final SelectionListener buttonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            Button btn = (Button)event.getSource();
            AttributeTargetSection.this.lock.getMemberVariables().stream().filter(member -> AttributeTarget.checkTargetName((String)member.getName(), (String)btn.getText(), (String)((String)btn.getParent().getData(AttributeTargetSection.TARGET_CATEGORY)))).findFirst().ifPresent(correctMember -> {
                Value val = correctMember.getValue();
                val.setValue(Boolean.toString(btn.getSelection()).toUpperCase());
                AttributeTargetSection.this.executeCommand((Command)new ChangeTargetAttributeCommand(AttributeTargetSection.this.getType(), AttributeTargetSection.this.lock));
                AttributeTargetSection.this.refresh();
            });
        }
    };

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        Composite composite = this.getWidgetFactory().createComposite(parent);
        composite.setLayout((Layout)new GridLayout(7, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        HashMap groups = new HashMap();
        StructuredType targetType = (StructuredType)InternalAttributeDeclarations.TARGET.getType();
        targetType.getMemberVariables().stream().map(member -> AttributeTarget.fromName((String)member.getName())).filter(Objects::nonNull).forEach(target -> {
            Group container = groups.computeIfAbsent(target.getCategory(), cat -> {
                Group group = this.getWidgetFactory().createGroup(composite, cat);
                group.setLayout((Layout)new GridLayout(1, false));
                group.setLayoutData((Object)new GridData(4, 4, true, false));
                group.setData(TARGET_CATEGORY, cat);
                return group;
            });
            this.createButton((Composite)container, (AttributeTarget)target);
        });
        this.createInheritButtons(composite);
    }

    private void createButton(Composite parent, AttributeTarget target) {
        Button button = this.getWidgetFactory().createButton(parent, target.getDisplayName(), 32);
        button.setToolTipText(target.getToolTip());
        button.addSelectionListener(this.buttonListener);
        this.buttons.add(button);
    }

    public void createInheritButtons(Composite parent) {
        Group group = this.getWidgetFactory().createGroup(parent, Messages.AttributeInherit_SectionTitle);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        this.inheritButton = this.getWidgetFactory().createButton((Composite)group, Messages.AttributeInherit_InheritAttribute, 32);
        this.inheritButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AttributeTargetSection.this.executeCommand((Command)new ChangeInheritAttributeCommand(AttributeTargetSection.this.getType(), AttributeTargetSection.this.getInheritModeFromButtons()));
            }
        });
        this.copyButton = this.getWidgetFactory().createButton((Composite)group, Messages.AttributeInherit_CopyAttribute, 32);
        this.copyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AttributeTargetSection.this.executeCommand((Command)new ChangeInheritAttributeCommand(AttributeTargetSection.this.getType(), AttributeTargetSection.this.getInheritModeFromButtons()));
            }
        });
        this.updateInheritButtons();
    }

    public void performRefresh() {
        this.updateButtons(this.getType());
        this.updateInheritButtons();
    }

    private void updateButtons(AttributeDeclaration attributeDeclaration) {
        StructuredType targetStruct = AttributeTargetSection.getTarget(attributeDeclaration);
        targetStruct.getMemberVariables().forEach(member -> {
            for (Button button : this.buttons) {
                if (!AttributeTarget.checkTargetName((String)member.getName(), (String)button.getText(), (String)((String)button.getParent().getData(TARGET_CATEGORY)))) continue;
                button.setSelection(Boolean.parseBoolean(member.getValue().getValue()));
            }
        });
    }

    private void updateInheritButtons() {
        if (this.getType() == null) {
            return;
        }
        Attribute inheritAttribute = this.getType().getAttribute(InternalAttributeDeclarations.INHERIT.getName());
        AttributeInheritMode mode = inheritAttribute != null ? AttributeInheritMode.valueOf((String)inheritAttribute.getValue()) : AttributeInheritMode.IGNORE;
        this.inheritButton.setSelection(mode == AttributeInheritMode.COPY_INHERIT || mode == AttributeInheritMode.INHERIT);
        this.copyButton.setSelection(mode == AttributeInheritMode.COPY_INHERIT || mode == AttributeInheritMode.COPY);
    }

    private static StructuredType getTarget(AttributeDeclaration attributeDeclaration) {
        StructuredType targetStruct = attributeDeclaration.getTarget();
        if (targetStruct == null || targetStruct.getMemberVariables().stream().anyMatch(member -> member.getName().equals(IInterfaceElement.class.getSimpleName()) || member.getName().equals(SubApp.class.getSimpleName()))) {
            return (StructuredType)EcoreUtil.copy((EObject)InternalAttributeDeclarations.TARGET.getType());
        }
        return targetStruct;
    }

    private AttributeInheritMode getInheritModeFromButtons() {
        if (this.inheritButton.getSelection() && this.copyButton.getSelection()) {
            return AttributeInheritMode.COPY_INHERIT;
        }
        if (this.copyButton.getSelection()) {
            return AttributeInheritMode.COPY;
        }
        if (this.inheritButton.getSelection()) {
            return AttributeInheritMode.INHERIT;
        }
        return AttributeInheritMode.IGNORE;
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        if (part instanceof AttributeTypeEditor) {
            AttributeTypeEditor editor = (AttributeTypeEditor)part;
            this.setType(editor.getAdapter(LibraryElement.class));
            this.lock = AttributeTargetSection.getTarget(this.getType());
        }
    }

    protected AttributeDeclaration getType() {
        AttributeDeclaration decl;
        Object object = this.type;
        return object instanceof AttributeDeclaration ? (decl = (AttributeDeclaration)object) : null;
    }

    protected Object getInputType(Object input) {
        if (input instanceof AttributeDeclaration) {
            AttributeDeclaration attDecl = (AttributeDeclaration)input;
            this.updateButtons(attDecl);
            this.lock = AttributeTargetSection.getTarget(attDecl);
            return attDecl;
        }
        return null;
    }

    protected void setInputCode() {
    }

    protected void setInputInit() {
    }
}

