/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.hierarchymanager.model.hierarchy.provider;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.fordiac.ide.hierarchymanager.model.hierarchy.provider.LeafItemProvider;
import org.eclipse.fordiac.ide.hierarchymanager.model.hierarchy.provider.LevelItemProvider;
import org.eclipse.fordiac.ide.hierarchymanager.model.hierarchy.provider.NodeItemProvider;
import org.eclipse.fordiac.ide.hierarchymanager.model.hierarchy.provider.RootLevelItemProvider;
import org.eclipse.fordiac.ide.hierarchymanager.model.hierarchy.util.HierarchyAdapterFactory;

public class HierarchyItemProviderAdapterFactory
extends HierarchyAdapterFactory
implements ComposeableAdapterFactory,
IChangeNotifier,
IDisposable {
    public static final String copyright = "*******************************************************************************\n Copyright (c) 2023 Primetals Technologies Austria GmbH\n \n This program and the accompanying materials are made available under the\n terms of the Eclipse Public License 2.0 which is available at\n http://www.eclipse.org/legal/epl-2.0.\n\n SPDX-License-Identifier: EPL-2.0\n\n Contributors:\n   Michael Oberlehner , Bianca Wiesmayr- initial API and implementation and/or initial documentation\n*******************************************************************************";
    protected ComposedAdapterFactory parentAdapterFactory;
    protected IChangeNotifier changeNotifier = new ChangeNotifier();
    protected Collection<Object> supportedTypes = new ArrayList<Object>();
    protected LeafItemProvider leafItemProvider;
    protected LevelItemProvider levelItemProvider;
    protected NodeItemProvider nodeItemProvider;
    protected RootLevelItemProvider rootLevelItemProvider;

    public HierarchyItemProviderAdapterFactory() {
        this.supportedTypes.add(IEditingDomainItemProvider.class);
        this.supportedTypes.add(IStructuredItemContentProvider.class);
        this.supportedTypes.add(ITreeItemContentProvider.class);
        this.supportedTypes.add(IItemLabelProvider.class);
        this.supportedTypes.add(IItemPropertySource.class);
    }

    public Adapter createLeafAdapter() {
        if (this.leafItemProvider == null) {
            this.leafItemProvider = new LeafItemProvider((AdapterFactory)this);
        }
        return this.leafItemProvider;
    }

    public Adapter createLevelAdapter() {
        if (this.levelItemProvider == null) {
            this.levelItemProvider = new LevelItemProvider((AdapterFactory)this);
        }
        return this.levelItemProvider;
    }

    public Adapter createNodeAdapter() {
        if (this.nodeItemProvider == null) {
            this.nodeItemProvider = new NodeItemProvider((AdapterFactory)this);
        }
        return this.nodeItemProvider;
    }

    public Adapter createRootLevelAdapter() {
        if (this.rootLevelItemProvider == null) {
            this.rootLevelItemProvider = new RootLevelItemProvider((AdapterFactory)this);
        }
        return this.rootLevelItemProvider;
    }

    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    public boolean isFactoryForType(Object type) {
        return this.supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    public Adapter adapt(Notifier notifier, Object type) {
        return super.adapt(notifier, (Object)this);
    }

    public Object adapt(Object object, Object type) {
        if (this.isFactoryForType(type)) {
            Object adapter = super.adapt(object, type);
            if (!(type instanceof Class) || ((Class)type).isInstance(adapter)) {
                return adapter;
            }
        }
        return null;
    }

    public void addListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    public void removeListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    public void fireNotifyChanged(Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);
        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    public void dispose() {
        if (this.leafItemProvider != null) {
            this.leafItemProvider.dispose();
        }
        if (this.levelItemProvider != null) {
            this.levelItemProvider.dispose();
        }
        if (this.nodeItemProvider != null) {
            this.nodeItemProvider.dispose();
        }
        if (this.rootLevelItemProvider != null) {
            this.rootLevelItemProvider.dispose();
        }
    }
}

