/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.typemanagement.wizards.NewFBTypeWizardPage;
import org.eclipse.fordiac.ide.typemanagement.wizards.NewTypeWizard;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class RestrictedNewTypeWizard
extends NewTypeWizard {
    private RestrictedNewTypeWizard() {
    }

    @Override
    protected NewFBTypeWizardPage createNewFBTypeWizardPage() {
        return new NewFBTypeWizardPage((IStructuredSelection)new StructuredSelection());
    }

    public static TypeEntry showRestrictedNewTypeWizard(Shell shell, String fullName, String fileEnding, String projectName) {
        RestrictedNewTypeWizard wizard = new RestrictedNewTypeWizard();
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        dialog.create();
        NewFBTypeWizardPage page = (NewFBTypeWizardPage)dialog.getCurrentPage();
        page.setTemplateFileFilter(pathname -> pathname.getName().toUpperCase().endsWith(fileEnding.toUpperCase()));
        page.setFileName(PackageNameHelper.extractPlainTypeName((String)fullName));
        page.setPackageName(PackageNameHelper.extractPackageName((String)fullName));
        TableViewer tv = page.getTemplateViewer();
        Object selection = tv.getElementAt(0);
        if (selection != null) {
            tv.setSelection((ISelection)new StructuredSelection(selection), true);
            if (tv.getElementAt(1) == null) {
                tv.getTable().setEnabled(false);
            }
        }
        if (projectName != null) {
            RestrictedNewTypeWizard.restrictProjectSelection(page.getControl(), projectName);
        }
        if (dialog.open() == 0) {
            TypeEntry newEntry = wizard.getTypeEntry();
            newEntry.refresh();
            return newEntry;
        }
        return null;
    }

    private static void restrictProjectSelection(Control control, String projectName) {
        Composite root = (Composite)control;
        List<Control> elements = RestrictedNewTypeWizard.getFlattenedList(root);
        elements.stream().filter(Tree.class::isInstance).map(Tree.class::cast).flatMap(a -> Arrays.stream(a.getItems())).filter(i -> !i.getText().equals(projectName)).forEach(TreeItem::dispose);
        control.redraw();
    }

    private static List<Control> getFlattenedList(Composite root) {
        ArrayList<Control> flattenedSet = new ArrayList<Control>();
        if (root.getChildren().length == 0) {
            flattenedSet.add((Control)root);
            return flattenedSet;
        }
        Control[] controlArray = root.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (c instanceof Composite) {
                Composite com = (Composite)c;
                flattenedSet.addAll(RestrictedNewTypeWizard.getFlattenedList(com));
            } else {
                flattenedSet.add(c);
            }
            ++n2;
        }
        return flattenedSet;
    }
}

