/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.hierarchymanager.ui.decorator;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.hierarchymanager.model.hierarchy.Leaf;
import org.eclipse.fordiac.ide.hierarchymanager.model.hierarchy.Level;
import org.eclipse.fordiac.ide.hierarchymanager.model.hierarchy.RootLevel;
import org.eclipse.fordiac.ide.hierarchymanager.ui.util.HierarchyManagerUtil;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;

public class NodeCommentDecorator
implements ILightweightLabelDecorator {
    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void decorate(Object element, IDecoration decoration) {
        Leaf leaf;
        EObject eObject;
        String comment = null;
        if (element instanceof Level) {
            Level level = (Level)element;
            comment = level.getComment();
        } else if (element instanceof Leaf && (eObject = EcoreUtil.getRootContainer((EObject)(leaf = (Leaf)element))) instanceof RootLevel) {
            RootLevel root = (RootLevel)eObject;
            Resource resource = root.eResource();
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(resource.getURI().segment(1));
            EObject obj = HierarchyManagerUtil.getElementReferencedbyLeaf(leaf, project);
            if (obj instanceof SubApp) {
                SubApp subapp = (SubApp)obj;
                comment = subapp.getComment();
            } else {
                comment = "SubApp not found";
            }
        }
        if (comment != null && !comment.isBlank()) {
            decoration.addSuffix(" [" + NodeCommentDecorator.checkComment(comment) + "]");
        }
    }

    private static String checkComment(String comment) {
        int i = comment.indexOf(System.getProperty("line.separator"));
        if (i != -1) {
            return comment.substring(0, i) + "...";
        }
        return comment;
    }
}

