/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.forte_ng.function;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.export.forte_ng.ForteFBTemplate;
import org.eclipse.fordiac.ide.export.forte_ng.util.ForteNgExportUtil;
import org.eclipse.fordiac.ide.export.language.ILanguageSupport;
import org.eclipse.fordiac.ide.export.language.ILanguageSupportFactory;
import org.eclipse.fordiac.ide.model.libraryElement.FunctionFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ICallable;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;

public abstract class FunctionFBTemplate
extends ForteFBTemplate<FunctionFBType> {
    private final ILanguageSupport bodyLanguageSupport;

    protected FunctionFBTemplate(FunctionFBType type, String name, Path prefix, String baseClass, Map<?, ?> options) {
        super(type, name, prefix, baseClass, options);
        this.bodyLanguageSupport = type.getBody() != null ? ILanguageSupportFactory.createLanguageSupport((String)"forte_ng", (EObject)type.getBody(), options) : null;
    }

    protected CharSequence generateFunctionSignature() {
        StringBuilder builder = new StringBuilder();
        if (((FunctionFBType)this.getType()).getReturnType() != null) {
            builder.append(ForteNgExportUtil.generateTypeName((LibraryElement)((FunctionFBType)this.getType()).getReturnType()));
        } else {
            builder.append("void");
        }
        builder.append(" func_");
        builder.append(((FunctionFBType)this.getType()).getName());
        builder.append('(');
        builder.append(this.generateParameters((ICallable)this.getType()));
        builder.append(')');
        return builder;
    }

    public ILanguageSupport getBodyLanguageSupport() {
        return this.bodyLanguageSupport;
    }

    @Override
    public List<String> getErrors() {
        if (this.bodyLanguageSupport != null) {
            return Stream.concat(super.getErrors().stream(), this.bodyLanguageSupport.getErrors().stream()).toList();
        }
        return super.getErrors();
    }

    @Override
    public List<String> getWarnings() {
        if (this.bodyLanguageSupport != null) {
            return Stream.concat(super.getWarnings().stream(), this.bodyLanguageSupport.getWarnings().stream()).toList();
        }
        return super.getWarnings();
    }

    @Override
    public List<String> getInfos() {
        if (this.bodyLanguageSupport != null) {
            return Stream.concat(super.getInfos().stream(), this.bodyLanguageSupport.getInfos().stream()).toList();
        }
        return super.getInfos();
    }

    @Override
    public Set<INamedElement> getDependencies(Map<?, ?> options) {
        if (this.bodyLanguageSupport != null) {
            return Stream.concat(super.getDependencies(options).stream(), this.bodyLanguageSupport.getDependencies(options).stream()).collect(Collectors.toSet());
        }
        return super.getDependencies(options);
    }
}

