/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.bulkeditor.editors;

import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.application.utilities.SubAppHierarchyDialog;
import org.eclipse.fordiac.ide.bulkeditor.Messages;
import org.eclipse.fordiac.ide.bulkeditor.editors.AddAttributeTreeSelectionDialog;
import org.eclipse.fordiac.ide.bulkeditor.editors.BulkEditorInput;
import org.eclipse.fordiac.ide.bulkeditor.editors.BulkEditorNatTable;
import org.eclipse.fordiac.ide.bulkeditor.editors.BulkEditorSettings;
import org.eclipse.fordiac.ide.bulkeditor.editors.BulkEditorTypeEntryAdapter;
import org.eclipse.fordiac.ide.bulkeditor.editors.CreateAttributeBulkEditorCommand;
import org.eclipse.fordiac.ide.bulkeditor.editors.DeleteAttributeBulkEditorCommand;
import org.eclipse.fordiac.ide.bulkeditor.editors.FilterComposite;
import org.eclipse.fordiac.ide.bulkeditor.editors.SearchHelper;
import org.eclipse.fordiac.ide.model.commands.ScopedCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.errormarker.FordiacMarkerHelper;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.AttributeDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableObject;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.search.ISearchContext;
import org.eclipse.fordiac.ide.model.search.types.IEC61499ElementSearch;
import org.eclipse.fordiac.ide.model.search.types.IEC61499SearchFilter;
import org.eclipse.fordiac.ide.model.typelibrary.AttributeTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.model.ui.widgets.AttributeSelectionContentProvider;
import org.eclipse.fordiac.ide.model.ui.widgets.ITypeSelectionContentProvider;
import org.eclipse.fordiac.ide.model.ui.widgets.TypeSelectionProposalProvider;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.fordiac.ide.ui.editors.EditorUtils;
import org.eclipse.fordiac.ide.ui.widget.AddDeleteWidget;
import org.eclipse.fordiac.ide.ui.widget.CommandExecutor;
import org.eclipse.fordiac.ide.ui.widget.NatTableWidgetFactory;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackEvent;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.RedoAction;
import org.eclipse.gef.ui.actions.UndoAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.widgets.ButtonFactory;
import org.eclipse.jface.widgets.TextFactory;
import org.eclipse.jface.widgets.WidgetFactory;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Twistie;
import org.eclipse.ui.part.EditorPart;

public class BulkEditor
extends EditorPart
implements CommandExecutor,
CommandStackEventListener {
    private static final String CONTEXT_ID = "org.eclipse.fordiac.ide.bulkeditor";
    private static final List<String> DEFAULT_LIST = List.of(Messages.Name, Messages.Type, Messages.Comment, Messages.InitialValue);
    private static final List<String> LIST_WITHOUT_VALUE = List.of(Messages.Name, Messages.Type, Messages.Comment);
    private IProject project;
    private final CommandStack commandStack = new CommandStack();
    private ActionRegistry actionRegistry;
    private SearchHelper helper;
    private final Map<TypeEntry, LibraryElement> copiedElementsMap = new HashMap<TypeEntry, LibraryElement>();
    private final Set<TypeEntry> dirtyEntries = new HashSet<TypeEntry>();
    private BulkEditorSettings settings;
    private List<URI> selectedSubApps = Collections.emptyList();
    private BulkEditorTypeEntryAdapter adapter;
    private final IPartListener2 focusListener = new IPartListener2(){

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
            if (partRef.getPart(false) == BulkEditor.this) {
                BulkEditor.this.checkTypeEntriesForDirty();
            }
        }
    };
    private Combo modeSelectionDropDown;
    private Button advancedButton;
    private boolean changedSearchParameter = false;
    private Group searchWhereGroup;
    private FilterComposite searchFilter;
    private Text searchText;
    private Button searchInClearButton;
    private FilterComposite fbSubappTypesFilter;
    private FilterComposite fbTypedSubappInstanceFilter;
    private FilterComposite untypedSubappFilter;
    private FilterComposite dataTypesFilter;
    private FilterComposite attributeTypesFilter;
    private Button ignoreLinkedLibrariesButton;
    private Button workspaceScopeButton;
    private Button projectScopeButton;
    private Button subappHierarchyScopeButton;
    private Button subappHierarchyScopeSearchButton;
    private Label subappHierarchyScopeLabel;
    BulkEditorNatTable natTable;
    private Composite addDeleteComposite;
    private Label searchInformation;
    private Label dirtyInformation;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.adapter = new BulkEditorTypeEntryAdapter(this, site.getWorkbenchWindow().getPartService());
        this.registerActions(site);
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.commandStack.addCommandStackEventListener((CommandStackEventListener)this);
        if (input instanceof BulkEditorInput) {
            BulkEditorInput bulkEditorInput = (BulkEditorInput)input;
            this.settings = bulkEditorInput.getSettings();
            this.project = bulkEditorInput.getProject();
            this.selectedSubApps = bulkEditorInput.getInitialSelectedSubApps();
            this.setPartName(this.getPartName() + ": " + this.project.getName());
        }
    }

    private void registerActions(IEditorSite site) {
        ActionRegistry registry = new ActionRegistry();
        UndoAction undoAction = new UndoAction((IEditorPart)this);
        undoAction.setActionDefinitionId(ActionFactory.UNDO.getCommandId());
        registry.registerAction((IAction)undoAction);
        RedoAction redoAction = new RedoAction((IEditorPart)this);
        redoAction.setActionDefinitionId(ActionFactory.REDO.getCommandId());
        registry.registerAction((IAction)redoAction);
        IActionBars bars = site.getActionBars();
        bars.setGlobalActionHandler(ActionFactory.UNDO.getId(), registry.getAction((Object)ActionFactory.UNDO.getId()));
        bars.setGlobalActionHandler(ActionFactory.REDO.getId(), registry.getAction((Object)ActionFactory.REDO.getId()));
        bars.updateActionBars();
        IContextService contextService = (IContextService)site.getService(IContextService.class);
        contextService.activateContext(CONTEXT_ID);
    }

    public void createPartControl(Composite parent) {
        ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 512);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setBackground(parent.getBackground());
        scrolledComposite.setBackgroundMode(1);
        Composite pageComposite = new Composite((Composite)scrolledComposite, 0);
        scrolledComposite.setContent((Control)pageComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(20, 20).generateLayout(pageComposite);
        Composite pageHeaderComposite = new Composite(pageComposite, 0);
        pageHeaderComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        pageHeaderComposite.setLayout((Layout)new GridLayout(2, false));
        Composite pageBodyComposite = new Composite(pageComposite, 0);
        pageBodyComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        pageBodyComposite.setLayout((Layout)new GridLayout(1, false));
        WidgetFactory.label((int)0).text(Messages.SearchFor).create((Widget)pageHeaderComposite);
        Twistie expandBodyCompositeTwistie = new Twistie(pageHeaderComposite, 0);
        expandBodyCompositeTwistie.setExpanded(true);
        expandBodyCompositeTwistie.addListener(4, event -> {
            boolean isVisible = expandBodyCompositeTwistie.isExpanded();
            BulkEditor.updateVisibility(isVisible, pageBodyComposite);
        });
        this.createModeSelectionComposite(pageBodyComposite);
        this.createSearchWhereGroup(pageBodyComposite);
        this.createSearchInGroup(pageBodyComposite);
        this.createScopeGroup(pageBodyComposite);
        this.createSearchButton(pageBodyComposite);
        this.natTable = new BulkEditorNatTable(pageComposite, this, this.settings.modeSelection);
        scrolledComposite.setMinSize(pageComposite.computeSize(-1, -1));
        pageComposite.layout();
        this.getSite().getPage().addPartListener(this.focusListener);
    }

    private void createModeSelectionComposite(Composite parent) {
        Composite modeSelectionComposite = new Composite(parent, 0);
        modeSelectionComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        modeSelectionComposite.setLayout((Layout)new GridLayout(2, false));
        this.modeSelectionDropDown = new Combo(modeSelectionComposite, 12);
        this.modeSelectionDropDown.setItems(new String[]{Messages.Variable, Messages.Attribute});
        this.modeSelectionDropDown.select(this.settings.modeSelection);
        this.modeSelectionDropDown.addListener(13, event -> {
            if (this.modeSelectionDropDown.getSelectionIndex() == this.settings.modeSelection) {
                return;
            }
            int choice = this.openUnsavedChangesDialog();
            if (choice == 1) {
                return;
            }
            this.advancedButton.setVisible(this.modeSelectionDropDown.getSelectionIndex() == 1);
            this.advancedButton.setSelection(this.settings.advancedMode);
            this.changeSearchWhereGroupFilter(this.modeSelectionDropDown.getSelectionIndex() != 1 || this.settings.advancedMode);
            this.changeNatTable(this.modeSelectionDropDown.getSelectionIndex(), null);
            this.settings.modeSelection = this.modeSelectionDropDown.getSelectionIndex();
            parent.getParent().layout();
            this.changedSearchParameter = false;
            this.searchInformation.setText("");
            this.commandStack.flush();
        });
        this.advancedButton = (Button)WidgetFactory.button((int)2).text(Messages.Advanced).onSelect(event -> {
            this.changeSearchWhereGroupFilter(this.advancedButton.getSelection());
            this.settings.advancedMode = this.advancedButton.getSelection();
            this.changeNatTable(this.modeSelectionDropDown.getSelectionIndex(), null);
            parent.getParent().layout();
        }).create((Widget)modeSelectionComposite);
        this.advancedButton.setVisible(this.modeSelectionDropDown.getSelectionIndex() == 1);
        this.advancedButton.setSelection(this.settings.advancedMode);
    }

    private void createSearchWhereGroup(Composite parent) {
        this.searchWhereGroup = BulkEditor.createCollapsibleGroup(parent, Messages.SearchWhere, button -> button.addListener(13, event -> {
            if (this.searchFilter != null && !this.searchFilter.isDisposed()) {
                this.searchFilter.clear();
            }
            if (this.searchText != null && !this.searchText.isDisposed()) {
                this.searchText.setText("");
            }
        }));
        this.changeSearchWhereGroupFilter(this.settings.modeSelection != 1 || this.settings.advancedMode);
    }

    private void changeSearchWhereGroupFilter(boolean advancedMode) {
        Control[] controlArray = this.searchWhereGroup.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        if (advancedMode) {
            this.searchFilter = new FilterComposite((Composite)this.searchWhereGroup, 0, DEFAULT_LIST, this.settings, BulkEditorSettings.whereSearchList);
            this.searchFilter.addFilterChangedListener(() -> {
                boolean bl = this.changedSearchParameter = true;
            });
        } else {
            Composite simpleTextComposite = new Composite((Composite)this.searchWhereGroup, 0);
            GridLayoutFactory.fillDefaults().numColumns(2).margins(0, 0).generateLayout(simpleTextComposite);
            simpleTextComposite.setLayoutData((Object)new GridData(4, 4, true, false));
            WidgetFactory.label((int)0).text(Messages.Name).create((Widget)simpleTextComposite);
            this.searchText = (Text)((TextFactory)WidgetFactory.text((int)2048).layoutData((Object)new GridData(4, 4, true, false))).create((Widget)simpleTextComposite);
            TypeSelectionProposalProvider proposalProvider = new TypeSelectionProposalProvider(() -> TypeLibraryManager.INSTANCE.getTypeLibrary(this.project), (ITypeSelectionContentProvider)AttributeSelectionContentProvider.INSTANCE);
            ContentProposalAdapter proposalAdapter = new ContentProposalAdapter((Control)this.searchText, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)proposalProvider, KeyStroke.getInstance((int)262144, (int)32), NatTableWidgetFactory.getActivationChars());
            proposalAdapter.setProposalAcceptanceStyle(2);
        }
        this.searchWhereGroup.layout();
    }

    private void createSearchInGroup(Composite parent) {
        Group searchGroup = BulkEditor.createCollapsibleGroup(parent, Messages.SearchIn, button -> {
            Button button2 = this.searchInClearButton = button;
        });
        this.searchInClearButton.addListener(13, event -> {
            this.fbSubappTypesFilter.clear();
            this.fbTypedSubappInstanceFilter.clear();
            this.untypedSubappFilter.clear();
            this.dataTypesFilter.clear();
            this.attributeTypesFilter.clear();
            this.ignoreLinkedLibrariesButton.setSelection(true);
            this.settings.ignoreLinkedLibraries = true;
        });
        this.fbSubappTypesFilter = this.createSearchFilterInGroup((Composite)searchGroup, Messages.FBandSubappTypes, BulkEditorSettings.inFBTypesSearchList, this.settings.fbSubappTypes, b -> {
            boolean bl = this.settings.fbSubappTypes = b.booleanValue();
        });
        this.fbTypedSubappInstanceFilter = this.createSearchFilterInGroup((Composite)searchGroup, Messages.FBandSubappInstances, BulkEditorSettings.inFBInstanceSearchList, this.settings.fbTypedSubappInstance, b -> {
            boolean bl = this.settings.fbTypedSubappInstance = b.booleanValue();
        });
        this.untypedSubappFilter = this.createSearchFilterInGroup((Composite)searchGroup, Messages.UntypedSubapps, BulkEditorSettings.inUntypedSubAppSearchList, this.settings.untypedSubapp, b -> {
            boolean bl = this.settings.untypedSubapp = b.booleanValue();
        });
        this.dataTypesFilter = this.createSearchFilterInGroup((Composite)searchGroup, Messages.DataTypes, BulkEditorSettings.inDataTypesSearchList, this.settings.dataTypes, b -> {
            boolean bl = this.settings.dataTypes = b.booleanValue();
        });
        this.attributeTypesFilter = this.createSearchFilterInGroup((Composite)searchGroup, Messages.AttributeTypes, BulkEditorSettings.inAttributeTypesSearchList, this.settings.attributeTypes, b -> {
            boolean bl = this.settings.attributeTypes = b.booleanValue();
        });
        this.ignoreLinkedLibrariesButton = (Button)WidgetFactory.button((int)32).text(Messages.IgnoreLinkedLibraries).onSelect(event -> {
            boolean bl = this.settings.ignoreLinkedLibraries = this.ignoreLinkedLibrariesButton.getSelection();
        }).create((Widget)searchGroup);
        this.ignoreLinkedLibrariesButton.setSelection(this.settings.ignoreLinkedLibraries);
        GridData buttonLayoutData = new GridData(4, 0x1000000, true, false);
        buttonLayoutData.verticalIndent = 10;
        this.ignoreLinkedLibrariesButton.setLayoutData((Object)buttonLayoutData);
    }

    private void createSearchButton(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(4).margins(0, 0).generateLayout(composite);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        WidgetFactory.button((int)8).text(Messages.Search).onSelect(event -> {
            int choice = this.openUnsavedChangesDialog();
            if (choice == 1) {
                return;
            }
            if (!this.performSearch()) {
                return;
            }
            this.checkTypeEntriesForDirty();
            if (this.modeSelectionDropDown.getSelectionIndex() == 1 && this.addDeleteComposite.getChildren().length == 0) {
                this.createAddDeleteButtons();
            }
        }).create((Widget)composite);
        this.addDeleteComposite = new Composite(composite, 0);
        this.addDeleteComposite.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.addDeleteComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(0, 0).create());
        this.dirtyInformation = (Label)WidgetFactory.label((int)0).create((Widget)composite);
        this.dirtyInformation.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.searchInformation = (Label)WidgetFactory.label((int)0).create((Widget)composite);
        this.searchInformation.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    private void createAddDeleteButtons() {
        AttributeTypeEntry attributeTypeEntry = this.advancedButton.getSelection() ? null : TypeLibraryManager.INSTANCE.getTypeLibrary(this.project).getAttributeTypeEntry(this.searchText.getText());
        AddDeleteWidget addDeleteWidget = new AddDeleteWidget();
        addDeleteWidget.createControls(this.addDeleteComposite, new FormToolkit(Display.getDefault()), true);
        addDeleteWidget.bindToTableViewer(this.natTable.getCurrentTable(), (CommandExecutor)this, refElement -> {
            AddAttributeTreeSelectionDialog addAttributeDialog = new AddAttributeTreeSelectionDialog(this.getSite().getShell(), this.copiedElementsMap.entrySet().stream().filter(entry -> SearchHelper.linkedElementsFilter.test((TypeEntry)entry.getKey())).map(Map.Entry::getValue).toList(), this.helper.createChildrenSearchProvider(), attributeTypeEntry != null ? attributeTypeEntry.getFullTypeName() : null, this.project, new HashSet<Object>());
            if (addAttributeDialog.open() == 0) {
                DataType dataType = TypeLibraryManager.INSTANCE.getTypeLibrary(this.project).getDataTypeLibrary().getType(addAttributeDialog.getAttributeType());
                CompoundCommand addAttributesCompoundCommand = new CompoundCommand();
                Arrays.stream(addAttributeDialog.getResult()).filter(ConfigurableObject.class::isInstance).map(ConfigurableObject.class::cast).map(configureableObject -> new CreateAttributeBulkEditorCommand(this.natTable, (ConfigurableObject)configureableObject, addAttributeDialog.getAttributeName(), addAttributeDialog.getAttributeComment(), dataType, attributeTypeEntry != null ? attributeTypeEntry.getType() : null, addAttributeDialog.getAttributeValue())).forEach(arg_0 -> ((CompoundCommand)addAttributesCompoundCommand).add(arg_0));
                return addAttributesCompoundCommand;
            }
            return null;
        }, refElement -> {
            Attribute attribute;
            EObject eObject;
            if (refElement instanceof Attribute && (eObject = (attribute = (Attribute)refElement).eContainer()) instanceof ConfigurableObject) {
                ConfigurableObject configurableObject = (ConfigurableObject)eObject;
                return new DeleteAttributeBulkEditorCommand(this.natTable, configurableObject, attribute);
            }
            return null;
        });
        this.addDeleteComposite.getParent().layout();
    }

    private static Group createCollapsibleGroup(Composite parent, String groupLabel, Consumer<Button> clearButtonProvider) {
        Button clearButton;
        Composite groupComposite = new Composite(parent, 0);
        groupComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout groupCompositeLayout = new GridLayout(1, false);
        groupCompositeLayout.verticalSpacing = 0;
        groupCompositeLayout.marginWidth = 0;
        groupComposite.setLayout((Layout)groupCompositeLayout);
        Composite header = new Composite(groupComposite, 0);
        header.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        header.setLayout((Layout)new GridLayout(clearButtonProvider != null ? 3 : 2, false));
        Group searchGroup = new Group(groupComposite, 0);
        searchGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        searchGroup.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(1).create());
        Label titleLabel = new Label(header, 0);
        titleLabel.setText(groupLabel);
        Twistie expandCompositeTwistie = new Twistie(header, 0);
        if (clearButtonProvider != null) {
            clearButton = (Button)((ButtonFactory)WidgetFactory.button((int)8).image(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ETOOL_CLEAR")).tooltip(Messages.ClearFilter)).create((Widget)header);
            clearButtonProvider.accept(clearButton);
        } else {
            clearButton = null;
        }
        expandCompositeTwistie.setExpanded(true);
        expandCompositeTwistie.addListener(4, event -> {
            boolean isVisible = expandCompositeTwistie.isExpanded();
            if (clearButton != null) {
                clearButton.setVisible(isVisible);
            }
            BulkEditor.updateVisibility(isVisible, (Composite)searchGroup);
        });
        return searchGroup;
    }

    private FilterComposite createSearchFilterInGroup(Composite parent, String name, List<String> subSettingsReferencesNames, boolean initalSelection, Consumer<Boolean> buttonListener) {
        Composite searchInCategoryComposite = new Composite(parent, 0);
        searchInCategoryComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        searchInCategoryComposite.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(1).create());
        Composite searchInCategorySubComposite = new Composite(searchInCategoryComposite, 0);
        searchInCategorySubComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        searchInCategorySubComposite.setLayout((Layout)GridLayoutFactory.swtDefaults().margins(0, 0).numColumns(3).create());
        Button categorySelectionButton = (Button)WidgetFactory.button((int)32).text(name).create((Widget)searchInCategorySubComposite);
        categorySelectionButton.addListener(13, event -> buttonListener.accept(categorySelectionButton.getSelection()));
        categorySelectionButton.setSelection(initalSelection);
        FilterComposite filterComposite = new FilterComposite(searchInCategoryComposite, 0, LIST_WITHOUT_VALUE, this.settings, subSettingsReferencesNames);
        Twistie expandFilterCompositeTwistie = new Twistie(searchInCategorySubComposite, 0);
        expandFilterCompositeTwistie.addListener(4, event -> BulkEditor.updateVisibility(expandFilterCompositeTwistie.isExpanded(), filterComposite));
        BulkEditor.updateVisibility(false, filterComposite);
        this.searchInClearButton.addListener(13, event -> {
            categorySelectionButton.setSelection(true);
            categorySelectionButton.notifyListeners(13, null);
            expandFilterCompositeTwistie.setExpanded(false);
            expandFilterCompositeTwistie.notifyListeners(4, null);
        });
        Label stateLabel = new Label(searchInCategorySubComposite, 16384);
        stateLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        filterComposite.addTextChangedListener(arg_0 -> ((Label)stateLabel).setText(arg_0));
        return filterComposite;
    }

    private void changeNatTable(int modeSelection, AttributeDeclaration simpleAttribute) {
        Arrays.stream(this.addDeleteComposite.getChildren()).forEach(Widget::dispose);
        this.addDeleteComposite.getParent().layout();
        if (simpleAttribute != null) {
            this.natTable.createDynamicNatTable(simpleAttribute);
        } else {
            this.natTable.changeNatTable(modeSelection);
        }
    }

    private static void updateVisibility(boolean visible, Composite composite) {
        composite.setVisible(visible);
        ((GridData)composite.getLayoutData()).exclude = !visible;
        Composite current = composite.getParent();
        while (current != null && !(current.getParent() instanceof ScrolledComposite)) {
            current = current.getParent();
        }
        if (current != null) {
            ScrolledComposite scrolledParentComposite = (ScrolledComposite)current.getParent();
            scrolledParentComposite.setMinSize(current.computeSize(-1, -1));
            current.layout();
        }
        composite.getParent().layout();
    }

    private void createScopeGroup(Composite parent) {
        Group scopeGroup = BulkEditor.createCollapsibleGroup(parent, Messages.Scope, null);
        Composite groupContent = new Composite((Composite)scopeGroup, 0);
        groupContent.setLayoutData((Object)new GridData(4, 4, true, false));
        groupContent.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(5).create());
        this.projectScopeButton = (Button)WidgetFactory.button((int)16).text(MessageFormat.format(Messages.Project, this.project.getName())).create((Widget)groupContent);
        this.projectScopeButton.setSelection(this.settings.scope == BulkEditorSettings.ScopeOption.PROJECT);
        this.projectScopeButton.addListener(13, event -> {
            if (this.projectScopeButton.getSelection()) {
                this.settings.scope = BulkEditorSettings.ScopeOption.PROJECT;
            }
        });
        this.workspaceScopeButton = (Button)WidgetFactory.button((int)16).text(Messages.Workspace).create((Widget)groupContent);
        this.workspaceScopeButton.setSelection(this.settings.scope == BulkEditorSettings.ScopeOption.WORKSPACE);
        this.workspaceScopeButton.addListener(13, event -> {
            if (this.workspaceScopeButton.getSelection()) {
                this.settings.scope = BulkEditorSettings.ScopeOption.WORKSPACE;
            }
        });
        this.subappHierarchyScopeButton = (Button)WidgetFactory.button((int)16).text(Messages.SubappHierarchy).create((Widget)groupContent);
        this.subappHierarchyScopeButton.setSelection(this.settings.scope == BulkEditorSettings.ScopeOption.SUBAPP_HIERARCHY);
        this.subappHierarchyScopeButton.addListener(13, event -> {
            if (this.subappHierarchyScopeButton.getSelection()) {
                this.settings.scope = BulkEditorSettings.ScopeOption.SUBAPP_HIERARCHY;
            }
            this.subappHierarchyScopeSearchButton.setVisible(this.subappHierarchyScopeButton.getSelection());
            this.subappHierarchyScopeLabel.setVisible(this.subappHierarchyScopeButton.getSelection());
        });
        this.subappHierarchyScopeSearchButton = (Button)WidgetFactory.button((int)0).text(Messages.SelectSubappHierarchy).create((Widget)groupContent);
        this.subappHierarchyScopeSearchButton.addListener(13, event -> {
            if (this.subappHierarchyScopeButton.getSelection()) {
                this.openScopeDialog();
            }
        });
        this.subappHierarchyScopeSearchButton.setVisible(this.subappHierarchyScopeButton.getSelection());
        this.selectedSubApps = this.settings.subappHierarchies;
        this.subappHierarchyScopeLabel = (Label)WidgetFactory.label((int)0).create((Widget)groupContent);
        this.createSubappHierarchyText();
        this.subappHierarchyScopeLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.subappHierarchyScopeLabel.setVisible(this.subappHierarchyScopeButton.getSelection());
        this.createSubappHierarchyText();
    }

    private void openScopeDialog() {
        List<EObject> elements = this.selectedSubApps.stream().map(uri -> {
            TypeEntry typeEntry = Objects.requireNonNull(TypeLibraryManager.INSTANCE.getTypeEntryForURI(uri));
            return typeEntry.getType().eResource().getEObject(uri.fragment());
        }).toList();
        SubAppHierarchyDialog dialog = new SubAppHierarchyDialog(this.project, elements);
        Object[] result = dialog.open();
        if (result != null) {
            this.selectedSubApps = SubAppHierarchyDialog.mapResultToURIs((Object[])result);
            this.settings.subappHierarchies = this.selectedSubApps;
        }
        this.createSubappHierarchyText();
    }

    private void createSubappHierarchyText() {
        if (this.selectedSubApps.isEmpty()) {
            this.subappHierarchyScopeLabel.setForeground(new Color(255, 0, 0));
            this.subappHierarchyScopeLabel.setText(Messages.NoHierarchySelected);
            return;
        }
        Stream<String> elements = this.selectedSubApps.stream().map(uri -> {
            TypeEntry typeEntry = Objects.requireNonNull(TypeLibraryManager.INSTANCE.getTypeEntryForURI(uri));
            return typeEntry.getType().eResource().getEObject(uri.fragment());
        }).map(eObject -> {
            INamedElement rootElement;
            EObject eObject2 = EcoreUtil.getRootContainer((EObject)eObject);
            if (eObject2 instanceof INamedElement && (rootElement = (INamedElement)eObject2) != eObject) {
                return rootElement.getName() + "." + FordiacMarkerHelper.getLocation((EObject)eObject);
            }
            return FordiacMarkerHelper.getLocation((EObject)eObject);
        });
        this.subappHierarchyScopeLabel.setForeground(new Color(0, 0, 0));
        this.subappHierarchyScopeLabel.setText(elements.collect(Collectors.joining("; ")));
    }

    private int openUnsavedChangesDialog() {
        if (this.commandStack.isDirty()) {
            MessageDialog dialog = new MessageDialog(this.getSite().getShell(), "", null, Messages.Unsaved_Changes, 3, new String[]{Messages.Continue, Messages.Cancel}, 0);
            return dialog.open();
        }
        return 0;
    }

    private IEditorPart[] getDirtyEditors() {
        return EditorUtils.findEditor(part -> {
            if (!part.isDirty()) {
                return false;
            }
            LibraryElement libE = (LibraryElement)part.getAdapter(LibraryElement.class);
            if (libE == null) {
                return false;
            }
            return this.copiedElementsMap.containsKey(libE.getTypeEntry());
        });
    }

    private void checkTypeEntriesForDirty() {
        IEditorPart[] editors = this.getDirtyEditors();
        if (editors.length <= 0) {
            this.dirtyInformation.setText("");
            return;
        }
        StringBuilder sb = new StringBuilder();
        IEditorPart[] iEditorPartArray = editors;
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorPart editor = iEditorPartArray[n2];
            sb.append("\n");
            sb.append(((LibraryElement)editor.getAdapter(LibraryElement.class)).getTypeEntry().getFile().getFullPath().toOSString());
            ++n2;
        }
        sb.append("\n");
        MessageDialog dialog = new MessageDialog(this.getSite().getShell(), "", null, MessageFormat.format(editors.length > 1 ? Messages.Dirty_Editors : Messages.Dirty_Editor, sb.toString()), 3, new String[]{Messages.Dirty_Editor_IgnoreChange, editors.length > 1 ? Messages.Dirty_Editors_SaveAndSearch : Messages.Dirty_Editor_SaveAndSearch}, 0);
        int choise = dialog.open();
        if (choise == 1) {
            IEditorPart[] iEditorPartArray2 = editors;
            int n3 = editors.length;
            int n4 = 0;
            while (n4 < n3) {
                IEditorPart editor = iEditorPartArray2[n4];
                editor.doSave((IProgressMonitor)new NullProgressMonitor());
                ++n4;
            }
            this.dirtyInformation.setText("");
            this.performSearch();
        } else {
            this.dirtyInformation.setText(Messages.Other_Dirty_Editor);
        }
        this.dirtyInformation.getParent().layout();
    }

    /*
     * Unable to fully structure code
     */
    private boolean performSearch() {
        this.helper = new SearchHelper(new SearchHelper.FilterRecordClass(this.settings.fbSubappTypes, this.fbSubappTypesFilter.getFilter(BulkEditor.LIST_WITHOUT_VALUE.get(0)), this.fbSubappTypesFilter.getFilter(BulkEditor.LIST_WITHOUT_VALUE.get(1)), this.fbSubappTypesFilter.getFilter(BulkEditor.LIST_WITHOUT_VALUE.get(2))), new SearchHelper.FilterRecordClass(this.settings.fbTypedSubappInstance, this.fbTypedSubappInstanceFilter.getFilter(BulkEditor.LIST_WITHOUT_VALUE.get(0)), this.fbTypedSubappInstanceFilter.getFilter(BulkEditor.LIST_WITHOUT_VALUE.get(1)), this.fbTypedSubappInstanceFilter.getFilter(BulkEditor.LIST_WITHOUT_VALUE.get(2))), new SearchHelper.FilterRecordClass(this.settings.untypedSubapp, this.untypedSubappFilter.getFilter(BulkEditor.LIST_WITHOUT_VALUE.get(0)), this.untypedSubappFilter.getFilter(BulkEditor.LIST_WITHOUT_VALUE.get(1)), this.untypedSubappFilter.getFilter(BulkEditor.LIST_WITHOUT_VALUE.get(2))), new SearchHelper.FilterRecordClass(this.settings.dataTypes, this.dataTypesFilter.getFilter(BulkEditor.LIST_WITHOUT_VALUE.get(0)), this.dataTypesFilter.getFilter(BulkEditor.LIST_WITHOUT_VALUE.get(1)), this.dataTypesFilter.getFilter(BulkEditor.LIST_WITHOUT_VALUE.get(2))), new SearchHelper.FilterRecordClass(this.settings.attributeTypes, this.attributeTypesFilter.getFilter(BulkEditor.LIST_WITHOUT_VALUE.get(0)), this.attributeTypesFilter.getFilter(BulkEditor.LIST_WITHOUT_VALUE.get(1)), this.attributeTypesFilter.getFilter(BulkEditor.LIST_WITHOUT_VALUE.get(2))), this.ignoreLinkedLibrariesButton.getSelection());
        contexts = this.subappHierarchyScopeButton.getSelection() != false ? SearchHelper.createSearchContextList(this.project, this.selectedSubApps) : this.helper.createSearchContextList(this.workspaceScopeButton.getSelection(), this.projectScopeButton.getSelection(), this.project);
        if (this.modeSelectionDropDown.getSelectionIndex() != 1) ** GOTO lbl8
        if (this.advancedButton.getSelection()) {
lbl8:
            // 2 sources

            modelSearchFilter = SearchHelper.createSearchFilter(this.modeSelectionDropDown.getSelectionIndex(), BulkEditor.DEFAULT_LIST.stream().map((Function<String, FilterComposite.Filter>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getFilter(java.lang.String ), (Ljava/lang/String;)Lorg/eclipse/fordiac/ide/bulkeditor/editors/FilterComposite$Filter;)((FilterComposite)this.searchFilter)).toList());
        } else {
            attributeTypeEntry = TypeLibraryManager.INSTANCE.getTypeLibrary(this.project).getAttributeTypeEntry(this.searchText.getText());
            if (attributeTypeEntry == null) {
                return false;
            }
            this.changeNatTable(1, attributeTypeEntry.getType());
            modelSearchFilter = SearchHelper.createAttributeDeclarationSearchFilter(attributeTypeEntry.getType());
        }
        result = contexts.stream().flatMap((Function<ISearchContext, Stream>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$39(org.eclipse.fordiac.ide.model.search.types.IEC61499SearchFilter org.eclipse.fordiac.ide.model.search.ISearchContext ), (Lorg/eclipse/fordiac/ide/model/search/ISearchContext;)Ljava/util/stream/Stream;)((BulkEditor)this, (IEC61499SearchFilter)modelSearchFilter)).toList();
        this.copiedElementsMap.keySet().forEach((Consumer<TypeEntry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$40(org.eclipse.fordiac.ide.model.typelibrary.TypeEntry ), (Lorg/eclipse/fordiac/ide/model/typelibrary/TypeEntry;)V)((BulkEditor)this));
        this.copiedElementsMap.clear();
        contexts.stream().flatMap((Function<ISearchContext, Stream>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$41(org.eclipse.fordiac.ide.model.search.ISearchContext ), (Lorg/eclipse/fordiac/ide/model/search/ISearchContext;)Ljava/util/stream/Stream;)()).forEach((Consumer<EObject>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$43(org.eclipse.emf.ecore.EObject ), (Lorg/eclipse/emf/ecore/EObject;)V)((BulkEditor)this));
        mappedList = this.createMappedList(result);
        this.natTable.updateList(mappedList);
        this.changedSearchParameter = false;
        this.searchInformation.setText("");
        this.commandStack.flush();
        this.dirtyEntries.clear();
        return true;
    }

    private List<EObject> createMappedList(List<? extends EObject> list) {
        ArrayList<EObject> copyList = new ArrayList<EObject>();
        for (EObject eObject : list) {
            EObject eObject2 = EcoreUtil.getRootContainer((EObject)eObject);
            if (!(eObject2 instanceof LibraryElement)) continue;
            LibraryElement rootLibE = (LibraryElement)eObject2;
            TypeEntry entry = rootLibE.getTypeEntry();
            EObject copyLibE = EcoreUtil.getEObject((EObject)((EObject)this.copiedElementsMap.get(entry)), (String)EcoreUtil.getRelativeURIFragmentPath((EObject)rootLibE, (EObject)eObject));
            copyList.add(copyLibE);
        }
        return copyList;
    }

    public boolean isDirty() {
        return this.commandStack.isDirty();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void setFocus() {
    }

    public void reloadType() {
        this.performSearch();
    }

    public boolean hasDirtyType(TypeEntry entry) {
        return this.dirtyEntries.contains(entry);
    }

    public void doSave(IProgressMonitor monitor) {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation((ISchedulingRule)this.project.getParent()){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                List<TypeEntry> affect = Arrays.stream(BulkEditor.this.commandStack.getCommands()).flatMap(cmd -> {
                    if (cmd instanceof CompoundCommand) {
                        CompoundCommand compound = (CompoundCommand)cmd;
                        return compound.getCommands().stream();
                    }
                    return Stream.of(cmd);
                }).filter(ScopedCommand.class::isInstance).flatMap(cmd -> ((ScopedCommand)cmd).getAffectedObjects().stream()).map(eobj -> {
                    EObject eObject = EcoreUtil.getRootContainer((EObject)eobj);
                    if (eObject instanceof LibraryElement) {
                        LibraryElement rootLibE = (LibraryElement)eObject;
                        return rootLibE.getTypeEntry();
                    }
                    return null;
                }).filter(Objects::nonNull).distinct().toList();
                affect.forEach(entry -> {
                    try {
                        if (BulkEditor.this.copiedElementsMap.containsKey(entry)) {
                            entry.eAdapters().remove((Object)BulkEditor.this.adapter);
                            entry.save(BulkEditor.this.copiedElementsMap.get(entry));
                            entry.eAdapters().add((Object)BulkEditor.this.adapter);
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                });
            }
        };
        try {
            operation.run(monitor);
        }
        catch (InvocationTargetException e) {
            FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
            Thread.currentThread().interrupt();
        }
        this.commandStack.markSaveLocation();
        this.dirtyEntries.clear();
    }

    public void doSaveAs() {
    }

    public void dispose() {
        super.dispose();
        this.getSite().getPage().removePartListener(this.focusListener);
        this.copiedElementsMap.keySet().forEach(typeEntry -> {
            boolean bl = typeEntry.eAdapters().remove((Object)this.adapter);
        });
        this.adapter.dispose();
    }

    public void executeCommand(Command cmd) {
        this.commandStack.execute(cmd);
        if (cmd instanceof ScopedCommand) {
            ScopedCommand scopedCmd = (ScopedCommand)cmd;
            Set eobjects = scopedCmd.getAffectedObjects();
            eobjects.forEach(eobj -> {
                EObject eObject = EcoreUtil.getRootContainer((EObject)eobj);
                if (eObject instanceof LibraryElement) {
                    LibraryElement libe = (LibraryElement)eObject;
                    this.dirtyEntries.add(libe.getTypeEntry());
                }
            });
        }
        if (!this.changedSearchParameter) {
            this.searchInformation.setText(Messages.Search_Changes);
        }
    }

    public void stackChanged(CommandStackEvent event) {
        if ((event.getDetail() & 0x20) != 0 || (event.getDetail() & 0x10) != 0) {
            this.natTable.getCurrentTable().refresh();
        }
        if (event.isPostChangeEvent()) {
            this.firePropertyChange(257);
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == CommandStack.class) {
            return adapter.cast(this.commandStack);
        }
        if (adapter == ActionRegistry.class) {
            return adapter.cast(this.actionRegistry);
        }
        return (T)super.getAdapter(adapter);
    }

    private /* synthetic */ Stream lambda$39(IEC61499SearchFilter iEC61499SearchFilter, ISearchContext context) {
        return new IEC61499ElementSearch(context, iEC61499SearchFilter, this.helper.createChildrenSearchProvider()).performSearch().stream();
    }

    private /* synthetic */ void lambda$40(TypeEntry typeEntry) {
        boolean bl = typeEntry.eAdapters().remove((Object)this.adapter);
    }

    private static /* synthetic */ Stream lambda$41(ISearchContext context) {
        return context.getTypes().map(arg_0 -> ((ISearchContext)context).mapTypes(arg_0));
    }

    private /* synthetic */ void lambda$43(EObject eobj) {
        EObject eObject = EcoreUtil.getRootContainer((EObject)eobj);
        if (eObject instanceof LibraryElement) {
            LibraryElement rootLibE = (LibraryElement)eObject;
            TypeEntry entry = rootLibE.getTypeEntry();
            this.copiedElementsMap.computeIfAbsent(entry, e -> {
                entry.eAdapters().add((Object)this.adapter);
                return e.copyType();
            });
        }
    }
}

