/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands;

import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.InputPrimitive;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Service;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceTransaction;
import org.eclipse.gef.commands.Command;

public class CreateInputPrimitiveCommand
extends Command {
    private final String type;
    private final ServiceTransaction element;
    private InputPrimitive newPrimitive;

    public CreateInputPrimitiveCommand(String type, ServiceTransaction element) {
        this.type = type;
        this.element = element;
    }

    public boolean canExecute() {
        return this.type != null && this.element != null && this.element.getInputPrimitive() != null;
    }

    public void execute() {
        Service service = this.element.getServiceSequence().getService();
        this.createInputPrimitive(service);
        this.element.setInputPrimitive(this.newPrimitive);
    }

    private void createInputPrimitive(Service service) {
        this.newPrimitive = LibraryElementFactory.eINSTANCE.createInputPrimitive();
        EList eventInputs = service.getFBType().getInterfaceList().getEventInputs();
        if (eventInputs.isEmpty()) {
            this.newPrimitive.setEvent("INIT");
        } else {
            this.newPrimitive.setEvent(((Event)eventInputs.get(0)).getName());
        }
        if (this.type.equals("LeftInputPrimitive")) {
            this.newPrimitive.setInterface(service.getLeftInterface());
        } else {
            this.newPrimitive.setInterface(service.getRightInterface());
        }
    }

    public void undo() {
        this.element.setInputPrimitive(null);
    }

    public void redo() {
        this.element.setInputPrimitive(this.newPrimitive);
    }
}

