/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.st;

import com.google.inject.Inject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.fordiac.ide.fbtypeeditor.editors.FBTypeXtextEditor;
import org.eclipse.fordiac.ide.model.edit.TypeEntryAdapter;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.structuredtextcore.resource.LibraryElementXtextResource;
import org.eclipse.fordiac.ide.structuredtextcore.ui.cleanup.STCoreSaveActionsEditor;
import org.eclipse.fordiac.ide.structuredtextcore.ui.document.LibraryElementXtextDocument;
import org.eclipse.fordiac.ide.structuredtextcore.ui.document.LibraryElementXtextDocumentUpdater;
import org.eclipse.fordiac.ide.structuredtextcore.ui.editor.STCoreEditorPreferences;
import org.eclipse.fordiac.ide.structuredtextcore.ui.editor.STCoreNestedEditor;
import org.eclipse.fordiac.ide.structuredtextcore.util.STCoreMapper;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.util.ITextRegion;

public class StructuredTextFBTypeEditor
extends FBTypeXtextEditor
implements STCoreSaveActionsEditor,
STCoreNestedEditor {
    @Inject
    private STCoreMapper algorithmMapper;
    @Inject
    private ILocationInFileProvider locationProvider;
    @Inject
    private LibraryElementXtextDocumentUpdater fbTypeUpdater;
    @Inject
    private STCoreEditorPreferences editorPreferences;
    private boolean saveActionsDisabled;

    protected void installFBTypeUpdater() {
        IXtextDocument iXtextDocument = this.getDocument();
        if (iXtextDocument instanceof LibraryElementXtextDocument) {
            LibraryElementXtextDocument libraryElementXtextDocument = (LibraryElementXtextDocument)iXtextDocument;
            this.fbTypeUpdater.install(libraryElementXtextDocument);
        }
    }

    protected void removeFBTypeUpdater() {
        this.fbTypeUpdater.uninstall();
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        this.setPartName(FordiacMessages.Algorithm);
        this.setTitleImage(FordiacImage.ICON_ALGORITHM.getImage());
    }

    public void reloadType() {
        this.removeFBTypeUpdater();
        IXtextDocument iXtextDocument = this.getDocument();
        if (iXtextDocument instanceof LibraryElementXtextDocument) {
            LibraryElementXtextDocument libraryElementXtextDocument = (LibraryElementXtextDocument)iXtextDocument;
            libraryElementXtextDocument.internalModify(state -> {
                ((LibraryElementXtextResource)state).setLibraryElement((LibraryElement)this.getType());
                return null;
            });
        }
        super.reloadType();
        this.installFBTypeUpdater();
    }

    protected boolean selectAndReveal(Object element, boolean revealEditor) {
        ITextRegion location = (ITextRegion)this.getDocument().priorityReadOnly(resource -> {
            EObject object2;
            if (resource != null && (object2 = this.algorithmMapper.fromModel((Resource)resource, element)) != null) {
                return this.locationProvider.getSignificantTextRegion(object2);
            }
            return null;
        });
        if (location != null) {
            this.selectAndReveal(location.getOffset(), location.getLength());
            if (revealEditor) {
                this.revealEditor();
            }
        }
        return location != null;
    }

    protected boolean shouldEnablePerformanceMode() {
        return this.getDocument().getNumberOfLines() > this.editorPreferences.getPerformanceModeThreshold();
    }

    public String getEditorId() {
        return this.getLanguageName();
    }

    public void doRevertToSaved() {
        this.setSaveActionsDisabled(true);
        try {
            super.doRevertToSaved();
        }
        finally {
            this.setSaveActionsDisabled(false);
        }
    }

    public boolean isSaveActionsDisabled() {
        return this.saveActionsDisabled;
    }

    public void setSaveActionsDisabled(boolean saveActionsDisabled) {
        this.saveActionsDisabled = saveActionsDisabled;
    }

    public void setBlockUpdates(boolean block) {
        TypeEntryAdapter typeEntryAdapter = this.getTypeEntryAdapter();
        if (typeEntryAdapter != null) {
            typeEntryAdapter.setBlockUpdates(block);
        }
    }

    public void doSaveOuterEditor(IProgressMonitor monitor) {
        IEditorSite iEditorSite = this.getEditorSite();
        if (iEditorSite instanceof MultiPageEditorSite) {
            MultiPageEditorSite multiPageEditorSite = (MultiPageEditorSite)iEditorSite;
            multiPageEditorSite.getMultiPageEditor().doSave(monitor);
        }
    }
}

