
$: << File.expand_path("../../oj/ext", __FILE__)
$: << File.expand_path("../../oj/lib", __FILE__)

require 'rubygems'
require 'sqlite3'
require 'terminal-table'
require 'oj'
require 'rails/all'
require 'benchmark'
begin
  require 'benchmark/memory'
rescue LoadError => e
end

OJ_1 = { mode: :object, use_as_json: false, float_precision: 16, bigdecimal_as_decimal: false, nan: :null }
OJ_2 = { mode: :compat, use_as_json: false, float_precision: 16, bigdecimal_as_decimal: false, nan: :null, time_format: :xmlschema, second_precision: 3 }
OJ_3 = { mode: :compat, use_as_json: true,  float_precision: 16, bigdecimal_as_decimal: false, nan: :null, time_format: :xmlschema, second_precision: 3 }

# test data
class Colors
  include Enumerable
  def each
    yield 'red'
    yield 'green'
    yield 'blue'
  end
end

Struct.new('Customer', :name, :address)

fork { exit 99 }
Process.wait

ActiveRecord::Base.logger = Logger.new(STDERR)
ActiveRecord::Base.logger.level = 1

ActiveRecord::Base.establish_connection(
  adapter: 'sqlite3',
  database:':memory:'
)

ActiveRecord::Migration.verbose = false
ActiveRecord::Schema.define do
  create_table :users do |table|
    table.column :name, :string
  end
end

class User < ActiveRecord::Base
  validates :name, presence: true
end

user = User.new
user.valid?

TEST_DATA = {
  Regexp: /test/,
  FalseClass: false,
  NilClass: nil,
  Object: Object.new,
  TrueClass: true,
  String: 'abc',
  StringChinese: '二胡',
  Numeric: 1,
  Symbol: :sym,
  Time: Time.new,
  Array: [],
  Hash: {},
  HashNotEmpty: {a: 1},
  Date: Date.new,
  DateTime: DateTime.new,
  Enumerable: Colors.new,
  BigDecimal: '1'.to_d/3,
  BigDecimalInfinity: '0.5'.to_d/0,
  Struct: Struct::Customer.new('Dave', '123 Main'),
  Float: 1.0/3,
  FloatInfinity: 0.5/0,
  Range: (1..10),
  'Process::Status': $?,
  'ActiveSupport::TimeWithZone': Time.utc(2005,2,1,15,15,10).in_time_zone('Hawaii'),
  'ActiveModel::Errors': user.errors,
  'ActiveSupport::Duration': 1.month.ago,
  'ActiveSupport::Multibyte::Chars': 'über'.mb_chars,
  'ActiveRecord::Relation': User.where(name: 'aaa'),

  # 'ActionDispatch::Journey::GTG::TransitionTable': TODO,
}

# helper
def compare(expected, result) 
  if result.is_a? Exception
    '💀'
  else
    if expected != result
      puts "*** expected: #{expected}"
      puts "***   actual: #{result}"
    end
    expected == result ? '👌' : '❌'
  end
end

# def compare(expected, result) 
#   if result.is_a? Exception
#     'Error'
#   else
#     expected == result ? 'Ok' : 'Fail'
#   end
# end

# actual tests
test_result = TEST_DATA.map do |key, val|
  to_json_result = val.to_json
  
  json_generate_result = begin 
    JSON.generate(val)
  rescue JSON::GeneratorError => e
    e
  end

  Oj.default_options = OJ_1
  oj_dump_result_1 = begin
    if key == :DateTime
      Exception.new('Unknown error')
    else
      Oj.dump(val)
    end
  rescue NoMemoryError => e
    e
  end

  Oj.default_options = OJ_2
  oj_dump_result_2 = begin
    Oj.dump(val)
  rescue NoMemoryError => e
    e
  end

  Oj.default_options = OJ_3
  oj_dump_result_3 = begin
    Oj.dump(val)
  rescue NoMemoryError => e
    e
  end

  [key, {
     to_json_result: to_json_result,
     #json_generate: compare(to_json_result, json_generate_result),
     #oj_dump_1: compare(to_json_result, oj_dump_result_1),
     oj_dump_2: compare(to_json_result, oj_dump_result_2),
     #oj_dump_3: compare(to_json_result, oj_dump_result_3),
   }]
end.to_h

# format output
rows = test_result.map do |key, val|
  [key, val[:json_generate], val[:oj_dump_1], val[:oj_dump_2], val[:oj_dump_3]]
end

puts "\nComparing Rails to_json with other JSON implementations\n"
puts Terminal::Table.new headings: ['class', 'JSON.generate', 'Oj.dump (object)', 'Oj.dump (compat)', 'Oj.dump (compat, as_json)'], rows: rows

Oj.default_options = OJ_3

obj = TEST_DATA

puts "\n"

=begin
if Benchmark.respond_to?(:memory)
  Benchmark.memory do |x|
    x.report('to_json:'){ 10_000.times { obj.to_json } }
    x.report('Oj:') { 10_000.times { Oj.dump(obj) } }
    x.compare!
  end
  puts "---------------------------------------------\n\n"
end

Benchmark.benchmark(Benchmark::CAPTION, 14, Benchmark::FORMAT) do |x|
  x.report('to_json:'){ 10_000.times { obj.to_json } }
  x.report('Oj:') { 10_000.times { Oj.dump(obj) } }
end
=end
puts "\n"

