// 16-bit control fields
#define VPID 0x00000000
#define POSTED_INTERRUPT_NOTIFICATION_VECTOR 0x00000002
#define EPTP_INDEX 0x00000004

// 16-bit guest-state fields
#define GUEST_ES_SEL 0x00000800
#define GUEST_CS_SEL 0x00000802
#define GUEST_SS_SEL 0x00000804
#define GUEST_DS_SEL 0x00000806
#define GUEST_FS_SEL 0x00000808
#define GUEST_GS_SEL 0x0000080a
#define GUEST_LDTR_SEL 0x0000080c
#define GUEST_TR_SEL 0x0000080e
#define GUEST_INTERRUPT_STATUS 0x0000080e

// 16-bit host-state fields
#define HOST_ES_SEL 0x00000c00
#define HOST_CS_SEL 0x00000c02
#define HOST_SS_SEL 0x00000c04
#define HOST_DS_SEL 0x00000c06
#define HOST_FS_SEL 0x00000c08
#define HOST_GS_SEL 0x00000c0a
#define HOST_TR_SEL 0x00000c0c

// 64-bit control fields
#define IO_BITMAP_A_FULL 0x00002000
#define IO_BITMAP_A_HIGH 0x00002001
#define IO_BITMAP_B_FULL 0x00002002
#define IO_BITMAP_B_HIGH 0x00002003
#define MSR_BITMAP_FULL 0x00002004
#define MSR_BITMAP_HIGH 0x00002005
#define EXIT_MSR_STORE_ADDR_FULL 0x00002006
#define EXIT_MSR_STORE_ADDR_HIGH 0x00002007
#define EXIT_MSR_LOAD_ADDR_FULL 0x00002008
#define EXIT_MSR_LOAD_ADDR_HIGH 0x00002009
#define ENTRY_MSR_LOAD_ADDR_FULL 0x0000200a
#define ENTRY_MSR_LOAD_ADDR_HIGH 0x0000200b
#define EXECUTIVE_VMCS_PTR_FULL 0x0000200c
#define EXECUTIVE_VMCS_PTR_HIGH 0x0000200d
#define TSC_OFFSET_FULL 0x00002010
#define TSC_OFFSET_HIGH 0x00002011
#define VIRTUAL_APIC_PAGE_ADDR_FULL 0x00002012
#define VIRTUAL_APIC_PAGE_ADDR_HIGH 0x00002013
#define APIC_ACCESS_ADDR_FULL 0x00002014
#define APIC_ACCESS_ADDR_HIGH 0x00002015
#define POSTED_INTERRUPT_DESCRIPTION_ADDR_FULL 0x00002016
#define POSTED_INTERRUPT_DESCRIPTION_ADDR_HIGH 0x00002017
#define VM_FUNCTION_CTRL_FULL 0x00002018
#define VM_FUNCTION_CTRL_HIGH 0x00002019
#define EPT_POINTER_FULL 0x0000201A
#define EPT_POINTER_HIGH 0x0000201B
#define EOI_EXIT_BITMAP_0_FULL 0x0000201C
#define EOI_EXIT_BITMAP_0_HIGH 0x0000201D
#define EOI_EXIT_BITMAP_1_FULL 0x0000201E
#define EOI_EXIT_BITMAP_1_HIGH 0x0000201F
#define EOI_EXIT_BITMAP_2_FULL 0x00002020
#define EOI_EXIT_BITMAP_2_HIGH 0x00002021
#define EOI_EXIT_BITMAP_3_FULL 0x00002022
#define EOI_EXIT_BITMAP_3_HIGH 0x00002023
#define EPTP_LIST_ADDRESS_FULL 0x00002024
#define EPTP_LIST_ADDRESS_HIGH 0x00002025
#define VMREAD_BITMAP_ADDRESS_FULL 0x00002026
#define VMREAD_BITMAP_ADDRESS_HIGH 0x00002027
#define VMWRITE_BITMAP_ADDRESS_FULL 0x00002028
#define VMWRITE_BITMAP_ADDRESS_HIGH 0x00002029
#define VE_INFO_ADDRESS_FULL 0x0000202A
#define VE_INFO_ADDRESS_HIGH 0x0000202B

// 64-bit read-only fields
#define GUEST_PHYSICAL_ADDR_FULL 0x00002400
#define GUEST_PHYSICAL_ADDR_HIGH 0x00002401

// 64-bit guest-state fields
#define VMCS_LINK_PTR_FULL 0x00002800
#define VMCS_LINK_PTR_HIGH 0x00002801
#define GUEST_IA32_DEBUGCTL_FULL 0x00002802
#define GUEST_IA32_DEBUGCTL_HIGH 0x00002803
#define GUEST_IA32_PAT_FULL 0x00002804
#define GUEST_IA32_PAT_HIGH 0x00002805
#define GUEST_IA32_EFER_FULL 0x00002806
#define GUEST_IA32_EFER_HIGH 0x00002807
#define GUEST_IA32_PERF_CTL_FULL 0x00002808
#define GUEST_IA32_PERF_CTL_HIGH 0x00002809
#define GUEST_PDPTE0_FULL 0x0000280A
#define GUEST_PDPTE0_HIGH 0x0000280B
#define GUEST_PDPTE1_FULL 0x0000280C
#define GUEST_PDPTE1_HIGH 0x0000280D
#define GUEST_PDPTE2_FULL 0x0000280E
#define GUEST_PDPTE2_HIGH 0x0000280F
#define GUEST_PDPTE3_FULL 0x00002810
#define GUEST_PDPTE3_HIGH 0x00002811

// 64-bit host-state fields
#define HOST_IA32_PAT_FULL 0x00002C00
#define HOST_IA32_PAT_HIGH 0x00002C01
#define HOST_IA32_EFER_FULL 0x00002C02
#define HOST_IA32_EFER_HIGH 0x00002C03
#define HOST_IA32_PERF_CTL_FULL 0x00002C04
#define HOST_IA32_PERF_CTL_HIGH 0x00002C05

// 32-bit control fields
#define PIN_VM_EXEC_CONTROLS 0x00004000
#define PROC_VM_EXEC_CONTROLS 0x00004002
#define EXCEPTION_BITMAP 0x00004004
#define PAGEFAULT_ERRCODE_MASK 0x00004006
#define PAGEFAULT_ERRCODE_MATCH 0x00004008
#define CR3_TARGET_COUNT 0x0000400a
#define EXIT_CONTROLS 0x0000400c
#define EXIT_MSR_STORE_COUNT 0x0000400e
#define EXIT_MSR_LOAD_COUNT 0x00004010
#define ENTRY_CONTROLS 0x00004012
#define ENTRY_MSR_LOAD_COUNT 0x00004014
#define ENTRY_INT_INFO_FIELD 0x00004016
#define ENTRY_EXCEPTION_EC 0x00004018
#define ENTRY_INSTR_LENGTH 0x0000401a
#define TPR_THRESHOLD 0x0000401c
#define PROC_VM_EXEC_CONTROLS2 0x0000401E
#define PLE_GAP 0x00004020
#define PLE_WINDOW 0x00004022

// 32-bit read-only fields
#define INSTR_ERROR 0x00004400
#define EXIT_REASON 0x00004402
#define EXIT_INTERRUPT_INFO 0x00004404
#define EXIT_INTERRUPT_ERRCODE 0x00004406
#define IDT_VECTORING_INFO_FIELD 0x00004408
#define IDT_VECTORING_ERRCODE 0x0000440a
#define EXIT_INSTR_LEN 0x0000440c
#define INSTR_INFO 0x0000440e

// 32-bit guest-state fields
#define GUEST_ES_LIMIT 0x00004800
#define GUEST_CS_LIMIT 0x00004802
#define GUEST_SS_LIMIT 0x00004804
#define GUEST_DS_LIMIT 0x00004806
#define GUEST_FS_LIMIT 0x00004808
#define GUEST_GS_LIMIT 0x0000480a
#define GUEST_LDTR_LIMIT 0x0000480c
#define GUEST_TR_LIMIT 0x0000480e
#define GUEST_GDTR_LIMIT 0x00004810
#define GUEST_IDTR_LIMIT 0x00004812
#define GUEST_ES_ATTR 0x00004814
#define GUEST_CS_ATTR 0x00004816
#define GUEST_SS_ATTR 0x00004818
#define GUEST_DS_ATTR 0x0000481a
#define GUEST_FS_ATTR 0x0000481c
#define GUEST_GS_ATTR 0x0000481e
#define GUEST_LDTR_ATTR 0x00004820
#define GUEST_TR_ATTR 0x00004822
#define GUEST_INTERRUPTIBILITY_INFO 0x00004824
#define GUEST_ACTIVITY_STATE 0x00004826
#define GUEST_SMBASE 0x00004828
#define GUEST_IA32_SYSENTER_CS 0x0000482A
// Where's 0x0000482C?
#define GUEST_PREEMTION_TIMER 0x0000482E

// 32-bit host-state fields
#define HOST_IA32_SYSENTER_CS 0x00004c00

// Natural-width control fields
#define CR0_MASK 0x00006000
#define CR4_MASK 0x00006002
#define CR0_READ_SHADOW 0x00006004
#define CR4_READ_SHADOW 0x00006006
#define CR3_TARGET_0 0x00006008
#define CR3_TARGET_1 0x0000600a
#define CR3_TARGET_2 0x0000600c
#define CR3_TARGET_3 0x0000600e

// Natural-width read-only fields
#define EXIT_QUALIFICATION 0x00006400
#define IO_RCX 0x00006402
#define IO_RSI 0x00006404
#define IO_RDI 0x00006406
#define IO_RIP 0x00006408
#define GUEST_LINEAR_ADDR 0x0000640a

// Natural-width guest-state fields
#define GUEST_CR0 0x00006800
#define GUEST_CR3 0x00006802
#define GUEST_CR4 0x00006804
#define GUEST_ES_BASE 0x00006806
#define GUEST_CS_BASE 0x00006808
#define GUEST_SS_BASE 0x0000680a
#define GUEST_DS_BASE 0x0000680c
#define GUEST_FS_BASE 0x0000680e
#define GUEST_GS_BASE 0x00006810
#define GUEST_LDTR_BASE 0x00006812
#define GUEST_TR_BASE 0x00006814
#define GUEST_GDTR_BASE 0x00006816
#define GUEST_IDTR_BASE 0x00006818
#define GUEST_DR7 0x0000681a
#define GUEST_RSP 0x0000681c
#define GUEST_RIP 0x0000681e
#define GUEST_RFLAGS 0x00006820
#define GUEST_PENDING_DEBUG_EXCEPT 0x00006822
#define GUEST_IA32_SYSENTER_ESP 0x00006824
#define GUEST_IA32_SYSENTER_EIP 0x00006826

// Natural-width host-state fields
#define HOST_CR0 0x00006c00
#define HOST_CR3 0x00006c02
#define HOST_CR4 0x00006c04
#define HOST_FS_BASE 0x00006c06
#define HOST_GS_BASE 0x00006c08
#define HOST_TR_BASE 0x00006c0a
#define HOST_GDTR_BASE 0x00006c0c
#define HOST_IDTR_BASE 0x00006c0e
#define HOST_IA32_SYSENTER_ESP 0x00006c10
#define HOST_IA32_SYSENTER_EIP 0x00006c12
#define HOST_RSP 0x00006c14
#define HOST_RIP 0x00006c16


typedef struct field_info {
 const char *field_name;
 unsigned int encoding;
} FIELD_INFO;


FIELD_INFO field_table[] = {
 {"VPID", VPID},
 {"POSTED_INTERRUPT_NOTIFICATION_VECTOR", POSTED_INTERRUPT_NOTIFICATION_VECTOR},
 {"EPTP_INDEX", EPTP_INDEX},
 {"GUEST_ES_SEL", GUEST_ES_SEL},
 {"GUEST_CS_SEL", GUEST_CS_SEL},
 {"GUEST_SS_SEL", GUEST_SS_SEL},
 {"GUEST_DS_SEL", GUEST_DS_SEL},
 {"GUEST_FS_SEL", GUEST_FS_SEL},
 {"GUEST_GS_SEL", GUEST_GS_SEL},
 {"GUEST_LDTR_SEL", GUEST_LDTR_SEL},
 {"GUEST_TR_SEL", GUEST_TR_SEL},
 {"GUEST_INTERRUPT_STATUS", GUEST_INTERRUPT_STATUS},
 {"HOST_ES_SEL", HOST_ES_SEL},
 {"HOST_CS_SEL", HOST_CS_SEL},
 {"HOST_SS_SEL", HOST_SS_SEL},
 {"HOST_DS_SEL", HOST_DS_SEL},
 {"HOST_FS_SEL", HOST_FS_SEL},
 {"HOST_GS_SEL", HOST_GS_SEL},
 {"HOST_TR_SEL", HOST_TR_SEL},
 {"IO_BITMAP_A_FULL", IO_BITMAP_A_FULL},
 {"IO_BITMAP_A_HIGH", IO_BITMAP_A_HIGH},
 {"IO_BITMAP_B_FULL", IO_BITMAP_B_FULL},
 {"IO_BITMAP_B_HIGH", IO_BITMAP_B_HIGH},
 {"MSR_BITMAP_FULL", MSR_BITMAP_FULL},
 {"MSR_BITMAP_HIGH", MSR_BITMAP_HIGH},
 {"EXIT_MSR_STORE_ADDR_FULL", EXIT_MSR_STORE_ADDR_FULL},
 {"EXIT_MSR_STORE_ADDR_HIGH", EXIT_MSR_STORE_ADDR_HIGH},
 {"EXIT_MSR_LOAD_ADDR_FULL", EXIT_MSR_LOAD_ADDR_FULL},
 {"EXIT_MSR_LOAD_ADDR_HIGH", EXIT_MSR_LOAD_ADDR_HIGH},
 {"ENTRY_MSR_LOAD_ADDR_FULL", ENTRY_MSR_LOAD_ADDR_FULL},
 {"ENTRY_MSR_LOAD_ADDR_HIGH", ENTRY_MSR_LOAD_ADDR_HIGH},
 {"EXECUTIVE_VMCS_PTR_FULL", EXECUTIVE_VMCS_PTR_FULL},
 {"EXECUTIVE_VMCS_PTR_HIGH", EXECUTIVE_VMCS_PTR_HIGH},
 {"TSC_OFFSET_FULL", TSC_OFFSET_FULL},
 {"TSC_OFFSET_HIGH", TSC_OFFSET_HIGH},
 {"VIRTUAL_APIC_PAGE_ADDR_FULL", VIRTUAL_APIC_PAGE_ADDR_FULL},
 {"VIRTUAL_APIC_PAGE_ADDR_HIGH", VIRTUAL_APIC_PAGE_ADDR_HIGH},
 {"APIC_ACCESS_ADDR_FULL", APIC_ACCESS_ADDR_FULL},
 {"APIC_ACCESS_ADDR_HIGH", APIC_ACCESS_ADDR_HIGH},
 {"POSTED_INTERRUPT_DESCRIPTION_ADDR_FULL", POSTED_INTERRUPT_DESCRIPTION_ADDR_FULL},
 {"POSTED_INTERRUPT_DESCRIPTION_ADDR_HIGH", POSTED_INTERRUPT_DESCRIPTION_ADDR_HIGH},
 {"VM_FUNCTION_CTRL_FULL", VM_FUNCTION_CTRL_FULL},
 {"VM_FUNCTION_CTRL_HIGH", VM_FUNCTION_CTRL_HIGH},
 {"EPT_POINTER_FULL", EPT_POINTER_FULL},
 {"EPT_POINTER_HIGH", EPT_POINTER_HIGH},
 {"EOI_EXIT_BITMAP_0_FULL", EOI_EXIT_BITMAP_0_FULL},
 {"EOI_EXIT_BITMAP_0_HIGH", EOI_EXIT_BITMAP_0_HIGH},
 {"EOI_EXIT_BITMAP_1_FULL", EOI_EXIT_BITMAP_1_FULL},
 {"EOI_EXIT_BITMAP_1_HIGH", EOI_EXIT_BITMAP_1_HIGH},
 {"EOI_EXIT_BITMAP_2_FULL", EOI_EXIT_BITMAP_2_FULL},
 {"EOI_EXIT_BITMAP_2_HIGH", EOI_EXIT_BITMAP_2_HIGH},
 {"EOI_EXIT_BITMAP_3_FULL", EOI_EXIT_BITMAP_3_FULL},
 {"EOI_EXIT_BITMAP_3_HIGH", EOI_EXIT_BITMAP_3_HIGH},
 {"EPTP_LIST_ADDRESS_FULL", EPTP_LIST_ADDRESS_FULL},
 {"EPTP_LIST_ADDRESS_HIGH", EPTP_LIST_ADDRESS_HIGH},
 {"VMREAD_BITMAP_ADDRESS_FULL", VMREAD_BITMAP_ADDRESS_FULL},
 {"VMREAD_BITMAP_ADDRESS_HIGH", VMREAD_BITMAP_ADDRESS_HIGH},
 {"VMWRITE_BITMAP_ADDRESS_FULL", VMWRITE_BITMAP_ADDRESS_FULL},
 {"VMWRITE_BITMAP_ADDRESS_HIGH", VMWRITE_BITMAP_ADDRESS_HIGH},
 {"VE_INFO_ADDRESS_FULL", VE_INFO_ADDRESS_FULL},
 {"VE_INFO_ADDRESS_HIGH", VE_INFO_ADDRESS_HIGH},
 {"GUEST_PHYSICAL_ADDR_FULL", GUEST_PHYSICAL_ADDR_FULL},
 {"GUEST_PHYSICAL_ADDR_HIGH", GUEST_PHYSICAL_ADDR_HIGH},
 {"VMCS_LINK_PTR_FULL", VMCS_LINK_PTR_FULL},
 {"VMCS_LINK_PTR_HIGH", VMCS_LINK_PTR_HIGH},
 {"GUEST_IA32_DEBUGCTL_FULL", GUEST_IA32_DEBUGCTL_FULL},
 {"GUEST_IA32_DEBUGCTL_HIGH", GUEST_IA32_DEBUGCTL_HIGH},
 {"GUEST_IA32_PAT_FULL", GUEST_IA32_PAT_FULL},
 {"GUEST_IA32_PAT_HIGH", GUEST_IA32_PAT_HIGH},
 {"GUEST_IA32_EFER_FULL", GUEST_IA32_EFER_FULL},
 {"GUEST_IA32_EFER_HIGH", GUEST_IA32_EFER_HIGH},
 {"GUEST_IA32_PERF_CTL_FULL", GUEST_IA32_PERF_CTL_FULL},
 {"GUEST_IA32_PERF_CTL_HIGH", GUEST_IA32_PERF_CTL_HIGH},
 {"GUEST_PDPTE0_FULL", GUEST_PDPTE0_FULL},
 {"GUEST_PDPTE0_HIGH", GUEST_PDPTE0_HIGH},
 {"GUEST_PDPTE1_FULL", GUEST_PDPTE1_FULL},
 {"GUEST_PDPTE1_HIGH", GUEST_PDPTE1_HIGH},
 {"GUEST_PDPTE2_FULL", GUEST_PDPTE2_FULL},
 {"GUEST_PDPTE2_HIGH", GUEST_PDPTE2_HIGH},
 {"GUEST_PDPTE3_FULL", GUEST_PDPTE3_FULL},
 {"GUEST_PDPTE3_HIGH", GUEST_PDPTE3_HIGH},
 {"HOST_IA32_PAT_FULL", HOST_IA32_PAT_FULL},
 {"HOST_IA32_PAT_HIGH", HOST_IA32_PAT_HIGH},
 {"HOST_IA32_EFER_FULL", HOST_IA32_EFER_FULL},
 {"HOST_IA32_EFER_HIGH", HOST_IA32_EFER_HIGH},
 {"HOST_IA32_PERF_CTL_FULL", HOST_IA32_PERF_CTL_FULL},
 {"HOST_IA32_PERF_CTL_HIGH", HOST_IA32_PERF_CTL_HIGH},
 {"PIN_VM_EXEC_CONTROLS", PIN_VM_EXEC_CONTROLS},
 {"PROC_VM_EXEC_CONTROLS", PROC_VM_EXEC_CONTROLS},
 {"EXCEPTION_BITMAP", EXCEPTION_BITMAP},
 {"PAGEFAULT_ERRCODE_MASK", PAGEFAULT_ERRCODE_MASK},
 {"PAGEFAULT_ERRCODE_MATCH", PAGEFAULT_ERRCODE_MATCH},
 {"CR3_TARGET_COUNT", CR3_TARGET_COUNT},
 {"EXIT_CONTROLS", EXIT_CONTROLS},
 {"EXIT_MSR_STORE_COUNT", EXIT_MSR_STORE_COUNT},
 {"EXIT_MSR_LOAD_COUNT", EXIT_MSR_LOAD_COUNT},
 {"ENTRY_CONTROLS", ENTRY_CONTROLS},
 {"ENTRY_MSR_LOAD_COUNT", ENTRY_MSR_LOAD_COUNT},
 {"ENTRY_INT_INFO_FIELD", ENTRY_INT_INFO_FIELD},
 {"ENTRY_EXCEPTION_EC", ENTRY_EXCEPTION_EC},
 {"ENTRY_INSTR_LENGTH", ENTRY_INSTR_LENGTH},
 {"TPR_THRESHOLD", TPR_THRESHOLD},
 {"PROC_VM_EXEC_CONTROLS2", PROC_VM_EXEC_CONTROLS2},
 {"PLE_GAP", PLE_GAP},
 {"PLE_WINDOW", PLE_WINDOW},
 {"INSTR_ERROR", INSTR_ERROR},
 {"EXIT_REASON", EXIT_REASON},
 {"EXIT_INTERRUPT_INFO", EXIT_INTERRUPT_INFO},
 {"EXIT_INTERRUPT_ERRCODE", EXIT_INTERRUPT_ERRCODE},
 {"IDT_VECTORING_INFO_FIELD", IDT_VECTORING_INFO_FIELD},
 {"IDT_VECTORING_ERRCODE", IDT_VECTORING_ERRCODE},
 {"EXIT_INSTR_LEN", EXIT_INSTR_LEN},
 {"INSTR_INFO", INSTR_INFO},
 {"GUEST_ES_LIMIT", GUEST_ES_LIMIT},
 {"GUEST_CS_LIMIT", GUEST_CS_LIMIT},
 {"GUEST_SS_LIMIT", GUEST_SS_LIMIT},
 {"GUEST_DS_LIMIT", GUEST_DS_LIMIT},
 {"GUEST_FS_LIMIT", GUEST_FS_LIMIT},
 {"GUEST_GS_LIMIT", GUEST_GS_LIMIT},
 {"GUEST_LDTR_LIMIT", GUEST_LDTR_LIMIT},
 {"GUEST_TR_LIMIT", GUEST_TR_LIMIT},
 {"GUEST_GDTR_LIMIT", GUEST_GDTR_LIMIT},
 {"GUEST_IDTR_LIMIT", GUEST_IDTR_LIMIT},
 {"GUEST_ES_ATTR", GUEST_ES_ATTR},
 {"GUEST_CS_ATTR", GUEST_CS_ATTR},
 {"GUEST_SS_ATTR", GUEST_SS_ATTR},
 {"GUEST_DS_ATTR", GUEST_DS_ATTR},
 {"GUEST_FS_ATTR", GUEST_FS_ATTR},
 {"GUEST_GS_ATTR", GUEST_GS_ATTR},
 {"GUEST_LDTR_ATTR", GUEST_LDTR_ATTR},
 {"GUEST_TR_ATTR", GUEST_TR_ATTR},
 {"GUEST_INTERRUPTIBILITY_INFO", GUEST_INTERRUPTIBILITY_INFO},
 {"GUEST_ACTIVITY_STATE", GUEST_ACTIVITY_STATE},
 {"GUEST_SMBASE", GUEST_SMBASE},
 {"GUEST_IA32_SYSENTER_CS", GUEST_IA32_SYSENTER_CS},
 {"GUEST_PREEMTION_TIMER", GUEST_PREEMTION_TIMER},
 {"HOST_IA32_SYSENTER_CS", HOST_IA32_SYSENTER_CS},
 {"CR0_MASK", CR0_MASK},
 {"CR4_MASK", CR4_MASK},
 {"CR0_READ_SHADOW", CR0_READ_SHADOW},
 {"CR4_READ_SHADOW", CR4_READ_SHADOW},
 {"CR3_TARGET_0", CR3_TARGET_0},
 {"CR3_TARGET_1", CR3_TARGET_1},
 {"CR3_TARGET_2", CR3_TARGET_2},
 {"CR3_TARGET_3", CR3_TARGET_3},
 {"EXIT_QUALIFICATION", EXIT_QUALIFICATION},
 {"IO_RCX", IO_RCX},
 {"IO_RSI", IO_RSI},
 {"IO_RDI", IO_RDI},
 {"IO_RIP", IO_RIP},
 {"GUEST_LINEAR_ADDR", GUEST_LINEAR_ADDR},
 {"GUEST_CR0", GUEST_CR0},
 {"GUEST_CR3", GUEST_CR3},
 {"GUEST_CR4", GUEST_CR4},
 {"GUEST_ES_BASE", GUEST_ES_BASE},
 {"GUEST_CS_BASE", GUEST_CS_BASE},
 {"GUEST_SS_BASE", GUEST_SS_BASE},
 {"GUEST_DS_BASE", GUEST_DS_BASE},
 {"GUEST_FS_BASE", GUEST_FS_BASE},
 {"GUEST_GS_BASE", GUEST_GS_BASE},
 {"GUEST_LDTR_BASE", GUEST_LDTR_BASE},
 {"GUEST_TR_BASE", GUEST_TR_BASE},
 {"GUEST_GDTR_BASE", GUEST_GDTR_BASE},
 {"GUEST_IDTR_BASE", GUEST_IDTR_BASE},
 {"GUEST_DR7", GUEST_DR7},
 {"GUEST_RSP", GUEST_RSP},
 {"GUEST_RIP", GUEST_RIP},
 {"GUEST_RFLAGS", GUEST_RFLAGS},
 {"GUEST_PENDING_DEBUG_EXCEPT", GUEST_PENDING_DEBUG_EXCEPT},
 {"GUEST_IA32_SYSENTER_ESP", GUEST_IA32_SYSENTER_ESP},
 {"GUEST_IA32_SYSENTER_EIP", GUEST_IA32_SYSENTER_EIP},
 {"HOST_CR0", HOST_CR0},
 {"HOST_CR3", HOST_CR3},
 {"HOST_CR4", HOST_CR4},
 {"HOST_FS_BASE", HOST_FS_BASE},
 {"HOST_GS_BASE", HOST_GS_BASE},
 {"HOST_TR_BASE", HOST_TR_BASE},
 {"HOST_GDTR_BASE", HOST_GDTR_BASE},
 {"HOST_IDTR_BASE", HOST_IDTR_BASE},
 {"HOST_IA32_SYSENTER_ESP", HOST_IA32_SYSENTER_ESP},
 {"HOST_IA32_SYSENTER_EIP", HOST_IA32_SYSENTER_EIP},
 {"HOST_RSP", HOST_RSP},
 {"HOST_RIP", HOST_RIP},
 {NULL, 0}
};
