% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec-sql-quote-identifier.R
\docType{data}
\name{spec_sql_quote_identifier}
\alias{spec_sql_quote_identifier}
\title{spec_sql_quote_identifier}
\value{
\code{dbQuoteIdentifier()} returns an object that can be coerced to \link{character},
of the same length as the input.
For an empty character vector this function returns a length-0 object.
An error is raised if the input contains \code{NA},
but not for an empty string.

When passing the returned object again to \code{dbQuoteIdentifier()}
as \code{x}
argument, it is returned unchanged.
Passing objects of class \link{SQL} should also return them unchanged.
(For backends it may be most convenient to return \link{SQL} objects
to achieve this behavior, but this is not required.)
}
\description{
spec_sql_quote_identifier
}
\section{Specification}{

Calling \code{\link[=dbGetQuery]{dbGetQuery()}} for a query of the format \code{SELECT 1 AS ...}
returns a data frame with the identifier, unquoted, as column name.
Quoted identifiers can be used as table and column names in SQL queries,
in particular in queries like \code{SELECT 1 AS ...}
and \code{SELECT * FROM (SELECT 1) ...}.
The method must use a quoting mechanism that is unambiguously different
from the quoting mechanism used for strings, so that a query like
\code{SELECT ... FROM (SELECT 1 AS ...)}
throws an error if the column names do not match.

The method can quote column names that
contain special characters such as a space,
a dot,
a comma,
or quotes used to mark strings
or identifiers,
if the database supports this.
In any case, checking the validity of the identifier
should be performed only when executing a query,
and not by \code{dbQuoteIdentifier()}.
}

