/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 3.0.12
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;


/**
  * Wrapper class for global methods and constants defined by libSBML.
  * <p>
  * <em style='color: #555'>
  * This class of objects is defined by libSBML only and has no direct
  * equivalent in terms of SBML components.  This class is not prescribed by
  * the SBML specifications, although it is used to implement features
  * defined in SBML.
  * </em>
  * <p>
  * In the C++ and C versions of libSBML, there exists a small number of
  * methods that are global in scope; in addition, libSBML uses a number
  * of enum's to define such things as error codes in a way that can be
  * used by both C++ and C.  This poses a problem in languages such as
  * Java, where there is no concept of global method or global constant.
  * SWIG wraps these global identifiers in the class whose documentation
  * you see before you.
  */
public class libsbml implements libsbmlConstants {

	
  /**
   * Downcast a package extension object to its specific package class.
   *
   * This method is used in the implementation of libSBML extensions to
   * support SBML Level&nbsp;3 packages.  It allows an object to be
   * downcast to the actual {@link SBMLExtension} object it is.
   *
   * @param cPtr the the pointer to the object
   * @param owner if <code>true</code>, it indicates the caller will "own"
   * the memory associated with the object and will be responsible for
   * freeing it.
   *
   * @return the {@link SBMLExtension} for the package
   *
   * @internal
   */
  public static SBMLExtension DowncastExtension(long cPtr, boolean owner)
  {		
    if (cPtr == 0) return null;
		
    SBMLExtension ext = new SBMLExtension(cPtr, false);
    String pkgName = ext.getName();


  if (pkgName.equals("l3v2extended"))
  {
    return new L3v2extendedmathExtension(cPtr, owner);
  }


    return new SBMLExtension(cPtr,owner);
  }     
        
  /**
   * SBMLExtension derived classes must override this method
   * @internal
   */
  public static SBasePlugin DowncastSBasePlugin(long cPtr, boolean owner)
  {
    if (cPtr == 0) return null;

    SBasePlugin sbp = new SBasePlugin(cPtr,false);
    String pkgName = sbp.getPackageName();

    SBMLExtension sbmlext = SBMLExtensionRegistry.getInstance().getExtension(pkgName);
    if (sbmlext != null)
    {
      return sbmlext.DowncastSBasePlugin(cPtr,owner);
    }
    return new SBasePlugin(cPtr,owner);
  }

  /**
   * @internal
   */
  public static SBMLConverter DowncastSBMLConverter(long cPtr, boolean owner)
  {
    if (cPtr == 0) return null;
                
    SBMLConverter con = new SBMLConverter(cPtr, false);
    String conName = con.getName();
    
    if (conName.equals("SBML Units Converter"))
      return new SBMLUnitsConverter(cPtr,owner);
    else if (conName.equals("SBML Strip Package Converter"))
      return new SBMLStripPackageConverter(cPtr,owner);
    else if (conName.equals("SBML Rule Converter"))
      return new SBMLRuleConverter(cPtr,owner);
    else if (conName.equals("SBML Reaction Converter"))
      return new SBMLReactionConverter(cPtr,owner);
    else if (conName.equals("SBML Local Parameter Converter"))
      return new SBMLLocalParameterConverter(cPtr,owner);
    else if (conName.equals("SBML Level Version Converter"))
      return new SBMLLevelVersionConverter(cPtr,owner);
    else if (conName.equals("SBML Initial Assignment Converter"))
      return new SBMLInitialAssignmentConverter(cPtr,owner);
    else if (conName.equals("SBML Infer Units Converter"))
      return new SBMLInferUnitsConverter(cPtr,owner);
    else if (conName.equals("SBML Id Converter"))
      return new SBMLIdConverter(cPtr,owner);
    else if (conName.equals("SBML Function Definition Converter"))
      return new SBMLFunctionDefinitionConverter(cPtr,owner);

		
    return new SBMLConverter(cPtr,owner);
  }
  
  /**
   * @internal
   */
  public static SBMLNamespaces DowncastSBMLNamespaces(long cPtr, boolean owner)
  {
    if (cPtr == 0) return null;
                
    SBMLNamespaces sbn = new SBMLNamespaces(cPtr, false);
    if (sbn != null)
    {
      XMLNamespaces ns = sbn.getNamespaces();


  if (ns.hasURI(L3v2extendedmathExtension.getXmlnsL3V1V1()))
  {
    return new L3v2extendedmathPkgNamespaces(cPtr, owner);
  }

                              
    }
    return new SBMLNamespaces(cPtr, owner);
  }     
  
  /**
   * Internal method.
   *
   * @internal
   */
  public static SBase DowncastSBase(long cPtr, boolean owner)
  {
    if (cPtr == 0) return null;

    SBase sb = new SBase(cPtr,false);
    String pkgName = sb.getPackageName();
    if (pkgName.equals("core"))
    {
      switch( sb.getTypeCode() )
      {
        case libsbmlConstants.SBML_COMPARTMENT:
          return new Compartment(cPtr, owner);
  
        case libsbmlConstants.SBML_COMPARTMENT_TYPE:
          return new CompartmentType(cPtr, owner);
  
        case libsbmlConstants.SBML_CONSTRAINT:
          return new Constraint(cPtr, owner);
  
        case libsbmlConstants.SBML_DOCUMENT:
          return new SBMLDocument(cPtr, owner);
  
        case libsbmlConstants.SBML_DELAY:
          return new Delay(cPtr, owner);
  
        case libsbmlConstants.SBML_EVENT:
          return new Event(cPtr, owner);

        case libsbmlConstants.SBML_EVENT_ASSIGNMENT:
          return new EventAssignment(cPtr, owner);

        case libsbmlConstants.SBML_FUNCTION_DEFINITION:
          return new FunctionDefinition(cPtr, owner);
  
        case libsbmlConstants.SBML_INITIAL_ASSIGNMENT:
          return new InitialAssignment(cPtr, owner);

        case libsbmlConstants.SBML_KINETIC_LAW:
          return new KineticLaw(cPtr, owner);

        case libsbmlConstants.SBML_LIST_OF:
          String name = sb.getElementName();
          if(name.equals("listOf")){
            return new ListOf(cPtr, owner);
          }
          else if(name.equals("listOfCompartments")){
            return new ListOfCompartments(cPtr, owner);
          }
          else if(name.equals("listOfCompartmentTypes")){
            return new ListOfCompartmentTypes(cPtr, owner);
          }
          else if(name.equals("listOfConstraints")){
            return new ListOfConstraints(cPtr, owner);
          }
          else if(name.equals("listOfEvents")){
            return new ListOfEvents(cPtr, owner);
          }
          else if(name.equals("listOfEventAssignments")){
            return new ListOfEventAssignments(cPtr, owner);
          }
          else if(name.equals("listOfFunctionDefinitions")){
            return new ListOfFunctionDefinitions(cPtr, owner);
          }
          else if(name.equals("listOfInitialAssignments")){
            return new ListOfInitialAssignments(cPtr, owner);
          }
          else if(name.equals("listOfParameters")){
            return new ListOfParameters(cPtr, owner);
          }
          else if(name.equals("listOfLocalParameters")){
            return new ListOfLocalParameters(cPtr, owner);
          }
          else if(name.equals("listOfReactions")){
            return new ListOfReactions(cPtr, owner);
          }
          else if(name.equals("listOfRules")){
            return new ListOfRules(cPtr, owner);
          }
          else if(name.equals("listOfSpecies")){
            return new ListOfSpecies(cPtr, owner);
          }
          else if(name.equals("listOfUnknowns")){
            return new ListOfSpeciesReferences(cPtr, owner);
          }
          else if(name.equals("listOfReactants")){
            return new ListOfSpeciesReferences(cPtr, owner);
          }
          else if(name.equals("listOfProducts")){
            return new ListOfSpeciesReferences(cPtr, owner);
          }
          else if(name.equals("listOfModifiers")){
            return new ListOfSpeciesReferences(cPtr, owner);
          }
          else if(name.equals("listOfSpeciesTypes")){
            return new ListOfSpeciesTypes(cPtr, owner);
          }
          else if(name.equals("listOfUnits")){
            return new ListOfUnits(cPtr, owner);
          }
          else if(name.equals("listOfUnitDefinitions")){
            return new ListOfUnitDefinitions(cPtr, owner);
          }
          return new ListOf(cPtr, owner);

        case libsbmlConstants.SBML_MODEL:
          return new Model(cPtr, owner);

        case libsbmlConstants.SBML_PARAMETER:
          return new Parameter(cPtr, owner);

      case libsbmlConstants.SBML_PRIORITY:
        return new Priority(cPtr, owner);

      case libsbmlConstants.SBML_LOCAL_PARAMETER:
        return new LocalParameter(cPtr, owner);

        case libsbmlConstants.SBML_REACTION:
          return new Reaction(cPtr, owner);

        case libsbmlConstants.SBML_SPECIES:
          return new Species(cPtr, owner);

        case libsbmlConstants.SBML_SPECIES_REFERENCE:
          return new SpeciesReference(cPtr, owner);

        case libsbmlConstants.SBML_MODIFIER_SPECIES_REFERENCE:
          return new ModifierSpeciesReference(cPtr, owner);

        case libsbmlConstants.SBML_SPECIES_TYPE:
          return new SpeciesType(cPtr, owner);

        case libsbmlConstants.SBML_TRIGGER:
          return new Trigger(cPtr, owner);

        case libsbmlConstants.SBML_UNIT_DEFINITION:
          return new UnitDefinition(cPtr, owner);

        case libsbmlConstants.SBML_UNIT:
          return new Unit(cPtr, owner);

        case libsbmlConstants.SBML_ALGEBRAIC_RULE:
          return new AlgebraicRule(cPtr, owner);

        case libsbmlConstants.SBML_ASSIGNMENT_RULE:
          return new AssignmentRule(cPtr, owner);

        case libsbmlConstants.SBML_RATE_RULE:
          return new RateRule(cPtr, owner);

        case libsbmlConstants.SBML_STOICHIOMETRY_MATH:
          return new StoichiometryMath(cPtr, owner);

        default:
          return new SBase(cPtr, owner);
      }
    }
    else
    {
      SBMLExtension sbmlext = SBMLExtensionRegistry.getInstance().getExtension(pkgName);
      if (sbmlext != null)
      {
        return sbmlext.DowncastSBase(cPtr,owner);
      }
    }
    return new SBase(cPtr, owner);
  }
  



	public static ASTBasePlugin DowncastASTBasePlugin(long cPtr, boolean owner)
  {
    if (cPtr == 0) return null;
    
		ASTBasePlugin ext = new ASTBasePlugin(cPtr, false);
		String pkgName = ext.getPackageName();


  if (pkgName.equals("l3v2extendedmath"))
  {
    return new L3v2extendedmathASTPlugin(cPtr, owner);
  }

				
		return new ASTBasePlugin(cPtr,owner);
	}


   static String getAbsolutePath(String filename)
   {
     java.io.File file = new java.io.File(filename);
     return file.getAbsolutePath();
   }


  /**
    * Stream handle for low-level C++ standard output stream.
    * <p>
    * A few libSBML methods accept an argument for indicating where to send
    * text string output.  An example is the {@link
    * SBMLDocument#printErrors} method.  However, the methods use C++ style
    * streams and not Java stream objects.  The OStream object class in the
    * libSBML Java interface provides a wrapper for the underlying C++
    * streams.  The present object (cout) is a static final variable that
    * can be used directly from your code.  An example use might be
    * something like this:
    * <p>
    * <div class="fragment"><pre class="fragment">
    * SBMLDocument document = libsbml.readSBML("somefile.xml");
    * if (document.getNumErrors() > 0)
    * {
    *     document.printErrors(libsbml.cout);
    *     println("Please correct the above problems first.");
    *     System.exit(1);
    * }</div>
    *
    * @see #cerr
    * @see #clog
    */
  public final static OStream cout;


  /**
    * Stream handle for low-level C++ standard error stream.
    * <p>
    * A few libSBML methods accept an argument for indicating where to send
    * text string output.  An example is the {@link
    * SBMLDocument#printErrors} method.  However, the methods use C++ style
    * streams and not Java stream objects.  The OStream object class in the
    * libSBML Java interface provides a wrapper for the underlying C++
    * streams.  The present object (cerr) is a static final variable that
    * can be used directly from your code.  An example use might be
    * something like this:
    * <p>
    * <div class="fragment"><pre class="fragment">
    * SBMLDocument document = libsbml.readSBML("somefile.xml");
    * if (document.getNumErrors() > 0)
    * {
    *     document.printErrors(libsbml.cerr);
    *     println("Please correct the above problems first.");
    *     System.exit(1);
    * }</div>
    * <p>
    * By default, most operating systems have have their standard error and
    * logging output streams directed to the console/terminal, and this is
    * where text messages will be shown.  This can usually be redirected
    * elsewhere, although how to do this depends on the specific environment
    * where the program is running.
    *
    * @see #cout
    * @see #clog
    */
  public final static OStream cerr;


  /**
    * Stream handle for low-level C++ standard logging stream.
    * <p>
    * A few libSBML methods accept an argument for indicating where to send
    * text string output.  An example is the {@link
    * SBMLDocument#printErrors} method.  However, the methods use C++ style
    * streams and not Java stream objects.  The OStream object class in the
    * libSBML Java interface provides a wrapper for the underlying C++
    * streams.  The present object (clog) is a static final variable that
    * can be used directly from your code.  An example use might be
    * something like this:
    * <p>
    * <div class="fragment"><pre class="fragment">
    * SBMLDocument document = libsbml.readSBML("somefile.xml");
    * if (document.getNumErrors() > 0)
    * {
    *     document.printErrors(libsbml.clog);
    *     println("Please correct the above problems first.");
    *     System.exit(1);
    * }</div>
    * <p>
    * By default, most operating systems have have their standard error and
    * logging output streams directed to the console/terminal, and this is
    * where text messages will be shown.  This can usually be redirected
    * elsewhere, although how to do this depends on the specific environment
    * where the program is running.
    *
    * @see #cout
    * @see #cerr
    */
  public final static OStream clog;

  static {
    cout = new OStream(OStream.COUT); 
    cerr = new OStream(OStream.CERR); 
    clog = new OStream(OStream.CLOG); 
  }

  /**
   * This private constructor does nothing and never invoked.
   * The purpose of this constuctor is to hide a default constructor of this 
   * class in javadoc documentation.
   */
  private libsbml() {}


  
/**
 * Returns the version number of this copy of libSBML as an integer.
 <p>
 * @return the libSBML version as an integer; version 1.2.3 becomes 10203.
 */ public
 static int getLibSBMLVersion() {
    return libsbmlJNI.getLibSBMLVersion();
  }

  
/**
 * Returns the version number of this copy of libSBML as a string.
 <p>
 * @return the libSBML version as a string; version 1.2.3 becomes
 * '1.2.3'.
 <p>
 * @see #getLibSBMLVersionString()
 */ public
 static String getLibSBMLDottedVersion() {
    return libsbmlJNI.getLibSBMLDottedVersion();
  }

  
/**
 * Returns the version number of this copy of libSBML as a string without
 * periods.
 <p>
 * @return the libSBML version as a string: version 1.2.3 becomes '10203'.
 <p>
 * @see #getLibSBMLDottedVersion()
 */ public
 static String getLibSBMLVersionString() {
    return libsbmlJNI.getLibSBMLVersionString();
  }

  
/**
 * Returns an indication whether libSBML has been compiled with
 * against a specific library. 
 <p>
 * @param option the library to test against, this can be one of
 *        'expat', 'libxml', 'xerces-c', 'bzip2', 'zip'
 <p>
 * @return 0 in case the libSBML has not been compiled against 
 *         that library and non-zero otherwise (for libraries 
 *         that define an integer version number that number will 
 *         be returned).
 <p>
 * @see #getLibSBMLDependencyVersionOf(String option)
 */ public
 static int isLibSBMLCompiledWith(String option) {
    return libsbmlJNI.isLibSBMLCompiledWith(option);
  }

  
/**
 * Returns the version string for the dependency library used. 
 <p>
 * @param option the library for which the version
 *        should be retrieved, this can be one of
 *        'expat', 'libxml', 'xerces-c', 'bzip2', 'zip'
 <p>
 * @return null in case libSBML has not been compiled against 
 *         that library and a version string otherwise.
 <p>
 * @see #isLibSBMLCompiledWith(String option)
 */ public
 static String getLibSBMLDependencyVersionOf(String option) {
    return libsbmlJNI.getLibSBMLDependencyVersionOf(option);
  }

  
/**
 * This method takes an SBML operation return value and returns a string representing
 * the code.
 <p>
 * @param returnValue the operation return value to convert to a string.
 <p>
 * @return a human readable name for the given
 * operation return value .
 <p>
 * @note The caller does not own the returned string and is therefore not
 * allowed to modify it.
 */ public
 static String OperationReturnValue_toString(int returnValue) {
    return libsbmlJNI.OperationReturnValue_toString(returnValue);
  }

  
/**
 * <p>
 * Reads an SBML document from the given file.
 <p>
 * If the file named <code>filename</code> does not exist or its content is not valid
 * SBML, one or more errors will be logged with the {@link SBMLDocument} object
 * returned by this method.  Callers can use the methods on {@link SBMLDocument} such
 * as
 * ,
 * {@link SBMLDocument#getNumErrors()}
 * and
 <p>
 * {@link SBMLDocument#getError(long)}
 <p>
 * to get the errors.  The object returned by
 <p>
 * {@link SBMLDocument#getError(long)}
 <p>
 * is an {@link SBMLError} object, and it has methods to get the error code,
 * category, and severity level of the problem, as well as a textual
 * description of the problem.  The possible severity levels range from
 * informational messages to fatal errors; see the documentation for
 * {@link SBMLError}
 * for more information.
 <p>
 * If the file <code>filename</code> could not be read, the file-reading error will
 * appear first.  The error code  can provide a clue about what
 * happened.  For example, a file might be unreadable (either because it does
 * not actually exist or because the user does not have the necessary access
 * privileges to read it) or some sort of file operation error may have been
 * reported by the underlying operating system.  Callers can check for these
 * situations using a program fragment such as the following:
 <p>
<pre class='fragment'>
{@link SBMLReader} reader = new {@link SBMLReader}();
{@link SBMLDocument} doc  = reader.readSBMLFromFile(filename);

if (doc.getNumErrors() &gt; 0)
{
    if (doc.getError(0).getErrorId() == libsbmlConstants.XMLFileUnreadable)
    {
        // Handle case of unreadable file here.
    }
    else if (doc.getError(0).getErrorId() == libsbmlConstants.XMLFileOperationError)
    {
        // Handle case of other file operation error here.
    }
    else
    {
        // Handle other error cases.
    }
}
</pre>
<p>
 * <p>
 * If the given filename ends with the suffix <code>'.gz'</code> (for example,
 * <code>'myfile.xml.gz'</code>), the file is assumed to be compressed in <em>gzip</em>
 * format and will be automatically decompressed upon reading.
 * Similarly, if the given filename ends with <code>'.zip'</code> or <code>'.bz2'</code>, the
 * file is assumed to be compressed in <em>zip</em> or <em>bzip2</em> format
 * (respectively).  Files whose names lack these suffixes will be read
 * uncompressed.  Note that if the file is in <em>zip</em> format but the
 * archive contains more than one file, only the first file in the
 * archive will be read and the rest ignored.
 <p>
 * <p>
 * To read a gzip/zip file, libSBML needs to be configured and linked with the
 * <a target='_blank' href='http://www.zlib.net/'>zlib</a> library at compile
 * time.  It also needs to be linked with the <a target='_blank'
 * href=''>bzip2</a> library to read files in <em>bzip2</em> format.  (Both of
 * these are the default configurations for libSBML.)  Errors about unreadable
 * files will be logged if a compressed filename is given and libSBML was
 * <em>not</em> linked with the corresponding required library.
 */ public
 static SBMLDocument readSBML(String filename) {
    long cPtr = libsbmlJNI.readSBML(libsbml.getAbsolutePath(filename));
    return (cPtr == 0) ? null : new SBMLDocument(cPtr, true);
  }

  
/**
 * <p>
 * Reads an SBML document from the given file.
 <p>
 * If the file named <code>filename</code> does not exist or its content is not valid
 * SBML, one or more errors will be logged with the {@link SBMLDocument} object
 * returned by this method.  Callers can use the methods on {@link SBMLDocument} such
 * as
 * ,
 * {@link SBMLDocument#getNumErrors()}
 * and
 <p>
 * {@link SBMLDocument#getError(long)}
 <p>
 * to get the errors.  The object returned by
 <p>
 * {@link SBMLDocument#getError(long)}
 <p>
 * is an {@link SBMLError} object, and it has methods to get the error code,
 * category, and severity level of the problem, as well as a textual
 * description of the problem.  The possible severity levels range from
 * informational messages to fatal errors; see the documentation for
 * {@link SBMLError}
 * for more information.
 <p>
 * If the file <code>filename</code> could not be read, the file-reading error will
 * appear first.  The error code  can provide a clue about what
 * happened.  For example, a file might be unreadable (either because it does
 * not actually exist or because the user does not have the necessary access
 * privileges to read it) or some sort of file operation error may have been
 * reported by the underlying operating system.  Callers can check for these
 * situations using a program fragment such as the following:
 <p>
<pre class='fragment'>
{@link SBMLReader} reader = new {@link SBMLReader}();
{@link SBMLDocument} doc  = reader.readSBMLFromFile(filename);

if (doc.getNumErrors() &gt; 0)
{
    if (doc.getError(0).getErrorId() == libsbmlConstants.XMLFileUnreadable)
    {
        // Handle case of unreadable file here.
    }
    else if (doc.getError(0).getErrorId() == libsbmlConstants.XMLFileOperationError)
    {
        // Handle case of other file operation error here.
    }
    else
    {
        // Handle other error cases.
    }
}
</pre>
<p>
 * <p>
 * If the given filename ends with the suffix <code>'.gz'</code> (for example,
 * <code>'myfile.xml.gz'</code>), the file is assumed to be compressed in <em>gzip</em>
 * format and will be automatically decompressed upon reading.
 * Similarly, if the given filename ends with <code>'.zip'</code> or <code>'.bz2'</code>, the
 * file is assumed to be compressed in <em>zip</em> or <em>bzip2</em> format
 * (respectively).  Files whose names lack these suffixes will be read
 * uncompressed.  Note that if the file is in <em>zip</em> format but the
 * archive contains more than one file, only the first file in the
 * archive will be read and the rest ignored.
 <p>
 * <p>
 * To read a gzip/zip file, libSBML needs to be configured and linked with the
 * <a target='_blank' href='http://www.zlib.net/'>zlib</a> library at compile
 * time.  It also needs to be linked with the <a target='_blank'
 * href=''>bzip2</a> library to read files in <em>bzip2</em> format.  (Both of
 * these are the default configurations for libSBML.)  Errors about unreadable
 * files will be logged if a compressed filename is given and libSBML was
 * <em>not</em> linked with the corresponding required library.
 <p>
 * @param filename the name or full pathname of the file to be read.
 <p>
 * @return a pointer to the {@link SBMLDocument} structure created from the SBML
 * content in <code>filename</code>.
 */ public
 static SBMLDocument readSBMLFromFile(String filename) {
    long cPtr = libsbmlJNI.readSBMLFromFile(libsbml.getAbsolutePath(filename));
    return (cPtr == 0) ? null : new SBMLDocument(cPtr, true);
  }

  
/**
 * <p>
 * Reads an SBML document from a text string.
 <p>
 * This method is flexible with respect to the presence of an XML
 * declaration at the beginning of the string.  In particular, if the
 * string in <code>xml</code> does not begin with the XML declaration
 * <pre class='fragment'>
&lt;?xml version='1.0' encoding='UTF-8'?&gt;
</pre>
 * then this method will automatically prepend the declaration
 * to <code>xml</code>.
 <p>
 * This method will log a fatal error if the content given in the parameter
 * <code>xml</code> is not in SBML format.  See the method documentation for
 * {@link SBMLReader#readSBML()}
 <p>
 * for an example of code for testing the returned error code.
 <p>
 * @param xml a string containing a full SBML model.
 <p>
 * @return a pointer to the {@link SBMLDocument} structure created from the SBML
 * content in <code>xml</code>.
 <p>
 * <p>
 * @note When using this method to read an {@link SBMLDocument} that uses the SBML
 * Level&nbsp;3 Hierarchical Model Composition package (comp) the document
 * location cannot be set automatically. Thus, if the model contains
 * references to ExternalModelDefinition objects, it will be necessary to
 * manually set the document URI location
 * ({@link SBMLDocument#setLocationURI()}
 <p>
 * ) in order to facilitate resolving these models.
 */ public
 static SBMLDocument readSBMLFromString(String xml) {
    long cPtr = libsbmlJNI.readSBMLFromString(xml);
    return (cPtr == 0) ? null : new SBMLDocument(cPtr, true);
  }

  
/**
 * Writes the given SBML document <code>d</code> to the file named by <code>filename</code>.
 * This convenience function is functionally equivalent to:
 <p>
 *   SBMLWriter_writeSBML(SBMLWriter_create(), d, filename);
 <p>
 * If the given filename ends with the suffix <code>&quot;.gz&quot;</code>
(for example, <code>&quot;myfile.xml.gz&quot;</code>), libSBML assumes the
caller wants the file to be written compressed in <em>gzip</em> format.
Similarly, if the given filename ends with <code>&quot;.zip&quot;</code> or
<code>&quot;.bz2&quot;</code>, libSBML assumes the caller wants the file to
be compressed in <em>zip</em> or <em>bzip2</em> format (respectively).
Files whose names lack these suffixes will be written uncompressed.
<em>Special considerations for the zip format</em>: If the given filename
ends with <code>&quot;.zip&quot;</code>, the file placed in the zip archive
will have the suffix <code>&quot;.xml&quot;</code> or
<code>&quot;.sbml&quot;</code>.  For example, the file in the zip archive
will be named <code>&quot;test.xml&quot;</code> if the given filename is
<code>&quot;test.xml.zip&quot;</code> or <code>&quot;test.zip&quot;</code>.
Similarly, the filename in the archive will be
<code>&quot;test.sbml&quot;</code> if the given filename is
<code>&quot;test.sbml.zip&quot;</code>.

 <p>
 * @param d the {@link SBMLDocument} object to be written out in XML format.
 <p>
 * @param filename a string giving the path to a file where the XML
 * content is to be written.
 <p>
 * @return <code>1</code> (true) on success and <code>0</code> (false) if <code>filename</code> could not be
 * written.  Some possible reasons for failure include (a) being unable to
 * open the file, and (b) using a filename that indicates a compressed SBML
 * file (i.e., a filename ending in <code>&quot;.zip&quot;</code> or
 * similar) when the compression functionality has not been enabled in
 * the underlying copy of libSBML.
 <p>
 * @see SBMLWriter#hasZlib() 
 * @see SBMLWriter#hasBzip2() 
 */ public
 static int writeSBML(SBMLDocument d, String filename) {
    return libsbmlJNI.writeSBML(SBMLDocument.getCPtr(d), d, libsbml.getAbsolutePath(filename));
  }

  
/**
 * Writes the given SBML document <code>d</code> to an in-memory string and returns a
 * pointer to it.  The string is owned by the caller and should be freed
 * (with free()) when no longer needed.  This convenience function is
 * functionally equivalent to:
 <p>
 *   SBMLWriter_writeSBMLToString(SBMLWriter_create(), d);
 <p>
 * but does not require the caller to create an {@link SBMLWriter} object first.
 <p>
 * @param d an {@link SBMLDocument} object to be written out in XML format.
 <p>
 * @return the string on success and <code>null</code> if one of the underlying parser
 * components fail.
 */ public
 static String writeSBMLToString(SBMLDocument d) {
    return libsbmlJNI.writeSBMLToString(SBMLDocument.getCPtr(d), d);
  }

  
/**
 * Writes the given SBML document <code>d</code> to the file <code>filename</code>.
 * This convenience function is functionally equivalent to:
 <p>
 *   SBMLWriter_writeSBMLToFile(SBMLWriter_create(), d, filename);
 <p>
 * but that does not require the caller to create an {@link SBMLWriter} object first.
 <p>
 * If the given filename ends with the suffix <code>&quot;.gz&quot;</code>
(for example, <code>&quot;myfile.xml.gz&quot;</code>), libSBML assumes the
caller wants the file to be written compressed in <em>gzip</em> format.
Similarly, if the given filename ends with <code>&quot;.zip&quot;</code> or
<code>&quot;.bz2&quot;</code>, libSBML assumes the caller wants the file to
be compressed in <em>zip</em> or <em>bzip2</em> format (respectively).
Files whose names lack these suffixes will be written uncompressed.
<em>Special considerations for the zip format</em>: If the given filename
ends with <code>&quot;.zip&quot;</code>, the file placed in the zip archive
will have the suffix <code>&quot;.xml&quot;</code> or
<code>&quot;.sbml&quot;</code>.  For example, the file in the zip archive
will be named <code>&quot;test.xml&quot;</code> if the given filename is
<code>&quot;test.xml.zip&quot;</code> or <code>&quot;test.zip&quot;</code>.
Similarly, the filename in the archive will be
<code>&quot;test.sbml&quot;</code> if the given filename is
<code>&quot;test.sbml.zip&quot;</code>.

 <p>
 * @param d an {@link SBMLDocument} object to be written out in XML format.
 <p>
 * @param filename a string giving the path to a file where the XML
 * content is to be written.
 <p>
 * @return <code>1</code> (true) on success and <code>0</code> (false) if <code>filename</code> could not be
 * written.  Some possible reasons for failure include (a) being unable to
 * open the file, and (b) using a filename that indicates a compressed SBML
 * file (i.e., a filename ending in <code>&quot;.zip&quot;</code> or
 * similar) when the compression functionality has not been enabled in
 * the underlying copy of libSBML.
 <p>
 * @see SBMLWriter#hasZlib()
 * @see SBMLWriter#hasBzip2()
 */ public
 static int writeSBMLToFile(SBMLDocument d, String filename) {
    return libsbmlJNI.writeSBMLToFile(SBMLDocument.getCPtr(d), d, libsbml.getAbsolutePath(filename));
  }

  
/**
 * This method takes an SBML type code and returns a string representing
 * the code.
 <p>
 * LibSBML attaches an identifying code to every
 * kind of SBML object.  These are known as <em>SBML type codes</em>.  In
 * other languages, the set of type codes is stored in an enumeration; in
 * the Java language interface for libSBML, the type codes are defined as
 * static integer constants in the interface class {@link
 * libsbmlConstants}.  The names of the type codes all begin with the
 * characters <code>SBML_.</code> 
 <p>
 * @return a human readable name for the given
 * SBML type code.
 <p>
 * @note The caller does not own the returned string and is therefore not
 * allowed to modify it.
 */ public
 static String SBMLTypeCode_toString(int tc, String pkgName) {
    return libsbmlJNI.SBMLTypeCode_toString(tc, pkgName);
  }

  
/**
 * Tests for logical equality between two given <code>UNIT_KIND_</code>
 * code values.
 <p>
 * This function behaves exactly like C's <code>==</code> operator, except
 * for the following two cases:
 * <ul>
  * <li>{@link libsbmlConstants#UNIT_KIND_LITER UNIT_KIND_LITER} <code>==</code> {@link libsbmlConstants#UNIT_KIND_LITRE UNIT_KIND_LITRE}
 * <li>{@link libsbmlConstants#UNIT_KIND_METER UNIT_KIND_METER} <code>==</code> {@link libsbmlConstants#UNIT_KIND_METRE UNIT_KIND_METRE}
 * </ul>
 <p>
 * In the two cases above, C equality comparison would yield <code>0</code> (false)
 * (because each of the above is a distinct enumeration value), but
 * this function returns <code>true.</code>
 <p>
 * @param uk1 a <code>UNIT_KIND_</code> value.
 * @param uk2 a second <code>UNIT_KIND_</code> value to compare to <code>uk1</code>.
 <p>
 * @return <code>1</code> (true) if <code>uk1</code> is logically equivalent to 
 * <code>uk2</code>, <code>0</code> (false) otherwise.
 <p>
 * @note For more information about the libSBML unit codes, please refer to
 * the class documentation for {@link Unit}.
 */ public
 static int UnitKind_equals(int uk1, int uk2) {
    return libsbmlJNI.UnitKind_equals(uk1, uk2);
  }

  
/**
 * Converts a text string naming a kind of unit to its corresponding
 * libSBML <code>UNIT_KIND_</code> constant/enumeration value.
 <p>
 * @param name a string, the name of a predefined base unit in SBML.
 <p>
 * @return a value the set of <code>UNIT_KIND_</code> codes
 * defined in class {@link libsbmlConstants}, corresponding to the string
 * <code>name</code> (determined in a case-insensitive manner).
 <p>
 * @note For more information about the libSBML unit codes, please refer to
 * the class documentation for {@link Unit}.
 */ public
 static int UnitKind_forName(String name) {
    return libsbmlJNI.UnitKind_forName(name);
  }

  
/**
 * Converts a unit code to a text string equivalent.
 <p>
 * @param uk a value from the set of <code>UNIT_KIND_</code> codes
 * defined in the class {@link libsbmlConstants}
 <p>
 * @return the name corresponding to the given unit code.
 <p>
 * @note For more information about the libSBML unit codes, please refer to
 * the class documentation for {@link Unit}.
 <p>
 * @warning The string returned is a static data value.  The caller does not
 * own the returned string and is therefore not allowed to modify it.
 */ public
 static String UnitKind_toString(int uk) {
    return libsbmlJNI.UnitKind_toString(uk);
  }

  
/**
 * Predicate for testing whether a given string corresponds to a
 * predefined libSBML unit code.
 <p>
 * @param str a text string naming a base unit defined by SBML.
 * @param level the Level of SBML.
 * @param version the Version within the Level of SBML.
 <p>
 * @return 1 (true) if string is the name of a valid
 * <code>UNIT_KIND_</code> value, <code>0</code> (false) otherwise.
 <p>
 * @note For more information about the libSBML unit codes, please refer to
 * the class documentation for {@link Unit}.
 */ public
 static int UnitKind_isValidUnitKindString(String str, long level, long version) {
    return libsbmlJNI.UnitKind_isValidUnitKindString(str, level, version);
  }

  
/**
 * This method takes a model qualifier type code and returns a string
 * representing the code.
 <p>
 * This method takes a model qualifier type as argument
 * and returns a string name corresponding to that code.  For example,
 * passing it the qualifier {@link libsbmlConstants#BQM_IS_DESCRIBED_BY BQM_IS_DESCRIBED_BY} will return
 * the string <code>'isDescribedBy'</code>.
 <p>
 * @param type the  value to
 * translate. The value should be a libSBML constant whose
 * name begins with <code>BQM_</code>, such as (for example)
 * {@link libsbmlConstants#BQM_IS BQM_IS}.
 <p>
 * @return a human readable qualifier name for the given qualifier type.
 <p>
 * @note The caller does not own the returned string and is therefore not
 * allowed to modify it.
 */ public
 static String ModelQualifierType_toString(int type) {
    return libsbmlJNI.ModelQualifierType_toString(type);
  }

  
/**
 * This method takes a biol qualifier type code and returns a string
 * representing the code.
 <p>
 * This method takes a biol qualifier type as argument
 * and returns a string name corresponding to that code.  For example,
 * passing it the qualifier {@link libsbmlConstants#BQB_HAS_VERSION BQB_HAS_VERSION} will return
 * the string <code>'hasVersion'</code>.
 <p>
 * @param type the  value to
 * translate. The value should be a constant whose name
 * begins with <code>BQB_</code>, such as (for example)
 * {@link libsbmlConstants#BQB_IS BQB_IS}.
 <p>
 * @return a human readable qualifier name for the given type.
 <p>
 * @note The caller does not own the returned string and is therefore not
 * allowed to modify it.
 */ public
 static String BiolQualifierType_toString(int type) {
    return libsbmlJNI.BiolQualifierType_toString(type);
  }

  
/**
 * This method takes a string and returns a model qualifier
 * representing the string.
 <p>
 * This method takes a string as argument and returns a model qualifier type
 * corresponding to that string.  For example, passing it the string
 * <code>'isDescribedBy'</code> will return the qualifier
 * {@link libsbmlConstants#BQM_IS_DESCRIBED_BY BQM_IS_DESCRIBED_BY}.
 <p>
 * @param s the string to translate to a libSBML constant value representing a model qualifier.
 <p>
 * @return a libSBML qualifier enumeration value for the given human readable
 * qualifier name.
 */ public
 static int ModelQualifierType_fromString(String s) {
    return libsbmlJNI.ModelQualifierType_fromString(s);
  }

  
/**
 * This method takes a string and returns a biol qualifier
 * representing the string.
 <p>
 * This method takes a string as argument and returns a biol qualifier type
 * corresponding to that string.  For example, passing it the string
 * <code>'hasVersion'</code> will return the qualifier
 * {@link libsbmlConstants#BQB_HAS_VERSION BQB_HAS_VERSION}.
 <p>
 * @param s the string to translate to a libSBML constant value representing a biological qualifier.
 <p>
 * @return a libSBML qualifier enumeration value for the given human readable
 * qualifier name.
 */ public
 static int BiolQualifierType_fromString(String s) {
    return libsbmlJNI.BiolQualifierType_fromString(s);
  }

  
/**
 * Reads the MathML from the given XML string, constructs a corresponding
 * abstract syntax tree, and returns a pointer to the root of the tree.
 <p>
 * @param xml a string containing a full MathML expression
 <p>
 * @return the root of an AST corresponding to the given mathematical
 * expression, otherwise <code>null</code> is returned if the given string is <code>null</code>
 * or invalid.
 */ public
 static ASTNode readMathMLFromString(String xml) {
    long cPtr = libsbmlJNI.readMathMLFromString(xml);
    return (cPtr == 0) ? null : new ASTNode(cPtr, true);
  }

  
/**
 * Reads the MathML from the given XML string, constructs a corresponding
 * abstract syntax tree, and returns a pointer to the root of the tree.
 <p>
 * @param xml a string containing a full MathML expression
 * @param xmlns an {@link XMLNamespaces}
 * object containing namespaces that are considered active during the
 * read. (For example, an SBML Level&nbsp;3 package namespace.)
 <p>
 * @return the root of an AST corresponding to the given mathematical
 * expression, otherwise <code>null</code> is returned if the given string is <code>null</code>
 * or invalid.
 */ public
 static ASTNode readMathMLFromStringWithNamespaces(String xml, XMLNamespaces xmlns) {
    long cPtr = libsbmlJNI.readMathMLFromStringWithNamespaces(xml, XMLNamespaces.getCPtr(xmlns), xmlns);
    return (cPtr == 0) ? null : new ASTNode(cPtr, false);
  }

  
/**
 * Writes the given {@link ASTNode} (and its children) to a string as MathML, and
 * returns the string.
 <p>
 * @param node the root of an AST to write out to the stream.
 <p>
 * @return a string containing the written-out MathML representation
 * of the given AST.
 <p>
 * @note The string is owned by the caller and should be freed (with
 * free()) when no longer needed.  <code>null</code> is returned if the given
 * argument is <code>null.</code>
 */ public
 static String writeMathMLToString(ASTNode node) {
    return libsbmlJNI.writeMathMLToString(ASTNode.getCPtr(node), node);
  }

  
/**
* Writes the given AST node (and its children) to a string as MathML, and
* returns the string.
*
* @param node the root of an AST to write out to the stream.
* @param sbmlns the SBML namespace to be used
*
* @return a string containing the written-out MathML representation
* of the given AST.
*
* @note The string is owned by the caller and should be freed (with
* free()) when no longer needed.  <code>null</code> is returned if the given
* argument is <code>null.</code>
*
* 
*/ public
 static String writeMathMLWithNamespaceToString(ASTNode node, SBMLNamespaces sbmlns) {
    return libsbmlJNI.writeMathMLWithNamespaceToString(ASTNode.getCPtr(node), node, SBMLNamespaces.getCPtr(sbmlns), sbmlns);
  }

  
/**
 * Parses the given SBML formula and returns a representation of it as an
 * Abstract Syntax Tree (AST).
 <p>
 * <p>
 * The text-string form of mathematical formulas produced by
 * <a href='libsbml.html#formulaToString(org.sbml.libsbml.ASTNode)'><code>libsbml.formulaToString(ASTNode)</code></a> and read by
 * <a href='libsbml.html#parseFormula(java.lang.String)'><code>libsbml.parseFormula(String)</code></a> use a simple C-inspired infix
 * notation taken from SBML Level&nbsp;1.  A formula in this text-string form
 * therefore can be handed to a program that understands SBML Level&nbsp;1
 * mathematical expressions, or used as part of a formula translation system.
 * The syntax is described in detail in the documentation for {@link ASTNode}.  The
 * following are illustrative examples of formulas expressed using this syntax:
 * <pre class='fragment'>
0.10 * k4^2
</pre>
<pre class='fragment'>
(vm * s1)/(km + s1)
</pre>
 <p>
 * Note that this facility is provided as a convenience by libSBML&mdash;the
 * MathML standard does not actually define a 'string-form' equivalent to
 * MathML expression trees, so the choice of formula syntax is somewhat
 * arbitrary.  The approach taken by libSBML is to use the syntax defined by
 * SBML Level&nbsp;1 (which in fact used a text-string representation of
 * formulas and not MathML).  This formula syntax is based mostly on C
 * programming syntax, and may contain operators, function calls, symbols,
 * and white space characters.  The following table provides the precedence
 * rules for the different entities that may appear in formula strings.
 <p>
 * <table border="0" class="centered text-table width80 normal-font alt-row-colors" style="padding-bottom: 0.5em">
 <tr style="background: lightgray; font-size: 14px;">
     <th align="left">Token</th>
     <th align="left">Operation</th>
     <th align="left">Class</th>
     <th>Precedence</th>
     <th align="left">Associates</th>
 </tr>
<tr><td><em>name</em></td><td>symbol reference</td><td>operand</td><td align="center">6</td><td>n/a</td></tr>
<tr><td><code>(</code><em>expression</em><code>)</code></td><td>expression grouping</td><td>operand</td><td align="center">6</td><td>n/a</td></tr>
<tr><td><code>f(</code><em>...</em><code>)</code></td><td>function call</td><td>prefix</td><td align="center">6</td><td>left</td></tr>
<tr><td><code>-</code></td><td>negation</td><td>unary</td><td align="center">5</td><td>right</td></tr>
<tr><td><code>^</code></td><td>power</td><td>binary</td><td align="center">4</td><td>left</td></tr>
<tr><td><code>*</code></td><td>multiplication</td><td>binary</td><td align="center">3</td><td>left</td></tr>
<tr><td><code>/</code></td><td>divison</td><td>binary</td><td align="center">3</td><td>left</td></tr>
<tr><td><code>+</code></td><td>addition</td><td>binary</td><td align="center">2</td><td>left</td></tr>
<tr><td><code>-</code></td><td>subtraction</td><td>binary</td><td align="center">2</td><td>left</td></tr>
<tr><td><code>,</code></td><td>argument delimiter</td><td>binary</td><td align="center">1</td><td>left</td></tr>
<caption class="top-caption">A table of the expression operators and their precedence in the
text-string format for mathematical expressions used by SBML_parseFormula().
</caption>
</table>


 <p>
 * In the table above, <em>operand</em> implies the construct is an operand, 
 * <em>prefix</em> implies the operation is applied to the following arguments, 
 * <em>unary</em> implies there is one argument, and <em>binary</em> implies there are
 * two arguments.  The values in the <b>Precedence</b> column show how the
 * order of different types of operation are determined.  For example, the
 * expression <code>a * b + c</code> is evaluated as <code>(a * b) +
 * c</code> because the @c * operator has higher precedence.  The
 * <b>Associates</b> column shows how the order of similar precedence
 * operations is determined; for example, <code>a - b + c</code> is
 * evaluated as <code>(a - b) + c</code> because the <code>+</code> and <code>-</code>
 * operators are left-associative.
 <p>
 * The function call syntax consists of a function name, followed by optional
 * white space, followed by an opening parenthesis token, followed by a
 * sequence of zero or more arguments separated by commas (with each comma
 * optionally preceded and/or followed by zero or more white space
 * characters, followed by a closing parenthesis token.  The function name
 * must be chosen from one of the pre-defined functions in SBML or a
 * user-defined function in the model.  The following table lists the names
 * of certain common mathematical functions; this table corresponds to
 * Table&nbsp;6 in the <a target='_blank' href='http://sbml.org/Documents/Specifications#SBML_Level_1_Version_2'>SBML Level&nbsp;1 Version&nbsp;2 specification</a>:
 <p>
 * <table border="0" class="centered text-table width80 normal-font alt-row-colors">
 <tr>
     <th align="left" width="60">Name</th>
     <th align="left" width="35">Args</th>
     <th align="left">Formula or meaning</th>
     <th align="left" width="90">Argument Constraints</th>
     <th align="left" width="90">Result constraints</th>
 </tr>
<tr><td><code>abs</code></td><td><em>x</em></td><td>absolute value of <em>x</em></td><td></td><td></td></tr>
<tr><td><code>acos</code></td><td><em>x</em></td><td>arc cosine of <em>x</em> in radians</td><td>-1.0 &le; <em>x</em> &le; 1.0</td><td>0 &le; <em>acos(x)</em> &le; &pi;</td></tr>
<tr><td><code>asin</code></td><td><em>x</em></td><td>arc sine of <em>x</em> in radians</td><td>-1.0 &le; <em>x</em> &le; 1.0</td><td>0 &le; <em>asin(x)</em> &le; &pi;</td></tr>
<tr><td><code>atan</code></td><td><em>x</em></td><td>arc tangent of <em>x</em> in radians</td><td></td><td>0 &le; <em>atan(x)</em> &le; &pi;</td></tr>
<tr><td><code>ceil</code></td><td><em>x</em></td><td>smallest number not less than <em>x</em> whose value is an exact integer</td><td></td><td></td></tr>
<tr><td><code>cos</code></td><td><em>x</em></td><td>cosine of <em>x</em></td><td></td><td></td></tr>
<tr><td><code>exp</code></td><td><em>x</em></td><td><em>e</em><sup><em> x</em></sup>, where <em>e</em> is the base of the natural logarithm</td><td></td><td></td></tr>
<tr><td><code>floor</code></td><td><em>x</em></td><td>largest number not greater than <em>x</em> whose value is an exact integer</td><td></td><td></td></tr>
<tr><td><code>log</code></td><td><em>x</em></td><td>natural logarithm of <em>x</em></td><td><em>x</em> &gt; 0</td><td></td></tr>
<tr><td><code>log10</code></td><td><em>x</em></td><td>base 10 logarithm of <em>x</em></td><td><em>x</em> &gt; 0</td><td></td></tr>
<tr><td><code>pow</code></td><td><em>x, y</em></td><td><em>x</em><sup><em> y</em></sup></td><td></td><td></td></tr>
<tr><td><code>sqr</code></td><td><em>x</em></td><td><em>x</em><sup><em>2</em></sup></td><td></td><td></td></tr>
<tr><td><code>sqrt</code></td><td><em>x</em></td><td>&radic;<em>x</em></td><td><em>x</em> &gt; 0</td><td><em>sqrt(x)</em> &ge; 0</td></tr>
<tr><td><code>sin</code></td><td><em>x</em></td><td>sine of <em>x</em></td><td></td><td></td></tr>
<tr><td><code>tan</code></td><td><em>x</em></td><td>tangent of <em>x</em></td><td>x &ne; n*&pi;/2, for odd integer <em>n</em></td><td></td></tr>
<caption class="bottom-caption">The names of mathematical functions defined in the SBML
Level&nbsp;1 Version&nbsp;2 text-string formula syntax.</caption>
</table>


 <p>
 * @warning <span class='warning'>There are differences between the symbols
 * used to represent the common mathematical functions and the corresponding
 * MathML token names.  This is a potential source of incompatibilities.
 * Note in particular that in this text-string syntax, <code>log(x)</code>
 * represents the natural logarithm, whereas in MathML, the natural logarithm
 * is <code>&lt;ln/&gt;</code>.  Application writers are urged to be careful
 * when translating between text forms and MathML forms, especially if they
 * provide a direct text-string input facility to users of their software
 * systems.</span> 
 <p>
 * @copydetails doc_warning_L1_math_string_syntax
 <p>
 * @param formula the text-string formula expression to be parsed
 <p>
 * @return the root node of the AST corresponding to the <code>formula</code>, or 
 * <code>null</code> if an error occurred in parsing the formula
 <p>
 * @see <code><a href='libsbml.html#formulaToString(org.sbml.libsbml.ASTNode tree)'>libsbml.formulaToString(ASTNode tree)</a></code>
 * @see <code><a href='libsbml.html#parseL3FormulaWithSettings(java.lang.String, org.sbml.libsbml.L3ParserSettings)'>libsbml.parseL3FormulaWithSettings(String formula, L3ParserSettings settings)</a></code>
 * @see <code><a href='libsbml.html#parseL3Formula(java.lang.String)'>libsbml.parseL3Formula(String formula)</a></code>
 * @see <code><a href='libsbml.html#parseL3FormulaWithModel(java.lang.String, org.sbml.libsbml.Model)'>parseL3FormulaWithModel(String formula, Model model)</a></code>
 * @see <code><a href='libsbml.html#getLastParseL3Error()'>getLastParseL3Error()</a></code>
 * @see <code><a href='libsbml.html#getDefaultL3ParserSettings()'>getDefaultL3ParserSettings()</a></code>
 */ public
 static ASTNode parseFormula(String formula) {
    long cPtr = libsbmlJNI.parseFormula(formula);
    return (cPtr == 0) ? null : new ASTNode(cPtr, true);
  }

  
/**
 * Converts an AST to a string representation of a formula using a syntax
 * derived from SBML Level&nbsp;1, but extended to include elements from
 * SBML Level&nbsp;2 and SBML Level&nbsp;3.
 <p>
 * <p>
 * The text-string form of mathematical formulas read by the function
 * <a href='libsbml.html#parseL3Formula(java.lang.String)'><code>libsbml.parseL3Formula(String)</code></a> and written by the function
 * <a href='libsbml.html#formulaToL3String(org.sbml.libsbml.ASTNode)'><code>libsbml.formulaToL3String(ASTNode)</code></a> uses an expanded version of
 * the syntax read and written by <a href='libsbml.html#parseFormula(java.lang.String)'><code>libsbml.parseFormula(String)</code></a>
 * and <a href='libsbml.html#formulaToString(org.sbml.libsbml.ASTNode)'><code>libsbml.formulaToString(ASTNode)</code></a>, respectively.  The
 * latter two libSBML functions were originally developed to support
 * conversion between SBML Levels&nbsp;1 and&nbsp;2, and were focused on the
 * syntax of mathematical formulas used in SBML Level&nbsp;1.  With time, and
 * the use of MathML in SBML Levels&nbsp;2 and&nbsp;3, it became clear that
 * supporting Level&nbsp;2 and&nbsp;3's expanded mathematical syntax would be
 * useful for software developers.  To maintain backwards compatibility for
 * libSBML users, the original <a href='libsbml.html#formulaToString(org.sbml.libsbml.ASTNode)'><code>libsbml.formulaToString(ASTNode)</code></a>
 * and <a href='libsbml.html#parseFormula(java.lang.String)'><code>libsbml.parseFormula(String)</code></a> have been left untouched,
 * and instead, the new functionality is provided in the form of
 * <a href='libsbml.html#parseL3Formula(java.lang.String)'><code>libsbml.parseL3Formula(String)</code></a> and
 * <a href='libsbml.html#formulaToL3String(org.sbml.libsbml.ASTNode)'><code>libsbml.formulaToL3String(ASTNode)</code></a>.
 <p>
 * The following lists the main differences in the formula syntax supported by
 * the Level 3 ('L3') versions of the formula parsers and formatters,
 * compared to what is supported by the Level&nbsp;1-oriented
 * <a href='libsbml.html#parseFormula(java.lang.String)'><code>libsbml.parseFormula(String)</code></a> and
 * <a href='libsbml.html#formulaToString(org.sbml.libsbml.ASTNode)'><code>libsbml.formulaToString(ASTNode)</code></a>:
 <p>
 * <ul>
 * <li> Units may be asociated with bare numbers, using the following syntax:
 * <div style='margin: 10px auto 10px 25px; display: block'>
 * <span class='code' style='background-color: #d0d0ee'>number</span>
 * <span class='code' style='background-color: #edd'>unit</span>
 * </div>
 * The <span class='code' style='background-color: #d0d0ee'>number</span>
 * may be in any form (an integer, real, or rational
 * number), and the
 * <span class='code' style='background-color: #edd'>unit</span>
 * must conform to the syntax of an SBML identifier (technically, the
 * type defined as <code>SId</code> in the SBML specifications).  The whitespace between
 * <span class='code' style='background-color: #d0d0ee'>number</span>
 * and <span class='code' style='background-color: #edd'>unit</span>
 * is optional.
 <p>
 * <li> The Boolean function symbols <code>&&</code> (<em>and</em>), <code>||</code> (<em>or</em>), <code>!</code> (<em>not</em>),
 * and <code>!=</code> (<em>not</em> <em>equals</em>) may be used.
 <p>
 * <li> The <em>modulo</em> operation is allowed as the symbol <code>@%</code> and will
 * produce a <code>&lt;piecewise&gt;</code> function in the corresponding
 * MathML output by default, or can produce the MathML function <code>rem</code>, 
 * depending on the {@link L3ParserSettings} object (see 
 * L3ParserSettings_setParseModuloL3v2() ).
 <p>
 * <li> All inverse trigonometric functions may be defined in the infix either
 * using <code>arc</code> as a prefix or simply <code>a</code>; in other words, both <code>arccsc</code>
 * and <code>acsc</code> are interpreted as the operator <em>arccosecant</em> as defined in
 * MathML&nbsp;2.0.  (Many functions in the simpler SBML Level&nbsp;1
 * oriented parser implemented by <a href='libsbml.html#parseFormula(java.lang.String)'><code>libsbml.parseFormula(String)</code></a>
 * are defined this way as well, but not all.)
 <p>
 * <li> The following expression is parsed as a rational number instead of
 * as a numerical division:
 * <pre style='display: block; margin-left: 25px'>
 * (<span class='code' style='background-color: #d0d0ee'>integer</span>/<span class='code' style='background-color: #d0d0ee'>integer</span>)</pre>
 * <strong>Spaces are not allowed</strong> in this construct; in other words,
 * &quot;<code>(3 / 4)</code>&quot; (with whitespace between the numbers and
 * the operator) will be parsed into the MathML <code>&lt;divide&gt;</code>
 * construct rather than a rational number.  You can, however, assign units to a
 * rational number as a whole; here is an example: &quot;<code>(3/4) ml</code>&quot;.
 * (In the case of division rather than a rational number, units are not interpreted
 * in this way.)
 <p>
 * <li> Various parser and formatter behaviors may be altered through the use
 * of a {@link L3ParserSettings} object in conjunction with the functions
 * <a href='libsbml.html#parseL3FormulaWithSettings(java.lang.String, org.sbml.libsbml.L3ParserSettings)'><code>libsbml.parseL3FormulaWithSettings(String, L3ParserSettings)</code></a> and
 * <a href='libsbml.html#formulaToL3StringWithSettings(org.sbml.libsbml.ASTNode, org.sbml.libsbml.L3ParserSettings)'><code>libsbml.formulaToL3StringWithSettings(ASTNode, L3ParserSettings)</code></a>
 * The settings available include the following:
 * <ul style='list-style-type: circle'>
 *
 * </ul> <p>
 * <li style='margin-bottom: 0.5em'> The function <code>log</code> with a single
 * argument (&quot;<code>log(x)</code>&quot;) can be parsed as
 * <code>log10(x)</code>, <code>ln(x)</code>, or treated as an error, as
 * desired.
 <p>
 * <li style='margin-bottom: 0.5em'> Unary minus signs can be collapsed or
 * preserved; that is, sequential pairs of unary minuses (e.g., &quot;<code>-
 * -3</code>&quot;) can be removed from the input entirely and single unary
 * minuses can be incorporated into the number node, or all minuses can be
 * preserved in the AST node structure.
 <p>
 * <li style='margin-bottom: 0.5em'> Parsing of units embedded in the input
 * string can be turned on and off.
 <p>
 * <li style='margin-bottom: 0.5em'> The string <code>avogadro</code> can be parsed as
 * a MathML <em>csymbol</em> or as an identifier.
 <p>
 * <li style='margin-bottom: 0.5em'> The string @% can be parsed either as a 
 * piecewise function or as the 'rem' function:  <code>a @% b</code> will either
 * become
 <p>
 * <code>piecewise(a - b*ceil(a/b), xor((a < 0), (b < 0)), a - b*floor(a/b))</code>
 <p>
 * or 
 <p>
 * <code>rem(a, b)</code>.
 <p>
 * The latter is simpler, but the <code>rem</code> MathML is only allowed
 * as of SBML Level&nbsp;3 Version&nbsp;2.</li>
 <p>
 * <li style='margin-bottom: 0.5em'> A {@link Model} object may optionally be
 * provided to the parser using the variant function call
 * <a href='libsbml.html#parseL3FormulaWithModel(java.lang.String, org.sbml.libsbml.Model)'><code>libsbml.parseL3FormulaWithModel(String, Model)</code></a> or
 * stored in a {@link L3ParserSettings} object passed to the variant function
 * <a href='libsbml.html#parseL3FormulaWithSettings(java.lang.String, org.sbml.libsbml.L3ParserSettings)'><code>libsbml.parseL3FormulaWithSettings(String, L3ParserSettings)</code></a>.  When a {@link Model} object is provided, identifiers
 * (values of type <code>SId</code> ) from that model are used in preference to
 * pre-defined MathML definitions for both symbols and functions.
 * More precisely:
 * <ul style='list-style-type: square'>
 <p>
 * <li style='margin-bottom: 0.5em'> <em>In the case of symbols</em>: the
 * {@link Model} entities whose identifiers will shadow identical symbols in the
 * mathematical formula are: {@link Species}, {@link Compartment}, {@link Parameter}, {@link Reaction}, and
 * {@link SpeciesReference}.  For instance, if the parser is given a {@link Model} containing
 * a {@link Species} with the identifier &quot;<code>pi</code>&quot;, and the formula
 * to be parsed is &quot;<code>3*pi</code>&quot;, the MathML produced will
 * contain the construct <code>&lt;ci&gt; pi &lt;/ci&gt;</code> instead of
 * the construct <code>&lt;pi/&gt;</code>.
 <p>
 * <li style='margin-bottom: 0.5em'> <em>In the case of user-defined
 * functions</em>: when a {@link Model} object is provided, <code>SId</code> values of
 * user-defined functions present in the model will be used preferentially
 * over pre-defined MathML functions.  For example, if the passed-in {@link Model}
 * contains a {@link FunctionDefinition} object with the identifier
 * &quot;<code>sin</code>&quot;, that function will be used instead of the
 * predefined MathML function <code>&lt;sin/&gt;</code>.
 * </ul>
 <p>
 * <li style='margin-bottom: 0.5em'> An {@link SBMLNamespaces} object may optionally
 * be provided to identify SBML Level&nbsp;3 packages that extend the
 * syntax understood by the formula parser.  When the namespaces are provided,
 * the parser will interpret possible additional syntax defined by the libSBML
 * plug-ins implementing the SBML Level&nbsp;3 packages; for example, it may
 * understand vector/array extensions introduced by the SBML Level&nbsp;3 
 * <em>Arrays</em> package.
 * </ul>
 <p>
 * These configuration settings cannot be changed directly using the basic
 * parser and formatter functions, but <em>can</em> be changed on a per-call basis
 * by using the alternative functions <a href='libsbml.html#parseL3FormulaWithSettings(java.lang.String, org.sbml.libsbml.L3ParserSettings)'><code>libsbml.parseL3FormulaWithSettings(String, L3ParserSettings)</code></a> and
 * <a href='libsbml.html#formulaToL3StringWithSettings(org.sbml.libsbml.ASTNode, org.sbml.libsbml.L3ParserSettings)'><code>libsbml.formulaToL3StringWithSettings(ASTNode, L3ParserSettings)</code></a>.
 <p>
 * Neither SBML nor the MathML standard define a 'string-form' equivalent to
 * MathML expressions.  The approach taken by libSBML is to start with the
 * formula syntax defined by SBML Level&nbsp;1 (which in fact used a custom
 * text-string representation of formulas, and not MathML), and expand it to
 * include the functionality described above.  This formula syntax is based
 * mostly on C programming syntax, and may contain operators, function calls,
 * symbols, and white space characters.  The following table provides the
 * precedence rules for the different entities that may appear in formula
 * strings.
 <p>
 * <table border="0" width="95%"
       class="centered text-table normal-font alt-row-colors"
       style="padding-bottom: 0.5em">
 <tr style="background: lightgray; font-size: 14px;">
     <th align="left">Token</th>
     <th align="left">Operation</th>
     <th align="left">Class</th>
     <th>Preced.</th>
     <th align="left">Assoc.</th>
 </tr>
<tr><td><em>name</em></td><td>symbol reference</td><td>operand</td><td align="center">8</td><td>n/a</td></tr>
<tr><td><code>(</code><em>expression</em><code>)</code></td><td>expression grouping</td><td>operand</td><td align="center">8</td><td>n/a</td></tr>
<tr><td><code>f(</code><em>...</em><code>)</code></td><td>function call</td><td>prefix</td><td align="center">8</td><td>left</td></tr>
<tr><td><code>^</code></td><td>power</td><td>binary</td><td align="center">7</td><td>left</td></tr>
<tr><td><code>-, !</code></td><td>negation, Boolean 'not'</td><td>unary</td><td align="center">6</td><td>right</td></tr>
<tr><td><code>*, /, %</code></td><td>multip., div., modulo</td><td>binary</td><td align="center">5</td><td>left</td></tr>
<tr><td><code>+, -</code></td><td>addition and subtraction</td><td>binary</td><td align="center">4</td><td>left</td></tr>
<tr><td><code>==, &lt;, &gt;, &lt;=, &gt;=, !=</code></td><td>Boolean comparisons</td><td>binary</td><td align="center">3</td><td>left</td></tr>
<tr><td><code>&&, ||</code></td><td>Boolean 'and' and 'or'</td><td>binary</td><td align="center">2</td><td>left</td></tr>
<tr><td><code>,</code></td><td>argument delimiter</td><td>binary</td><td align="center">1</td><td>left</td></tr>

<caption class="top-caption">Expression operators and their precedence in the
"Level&nbsp;3" text-string format for mathematical expressions.
</caption>
</table>


 <p>
 * In the table above, <em>operand</em> implies the construct is an operand, 
 * <em>prefix</em> implies the operation is applied to the following arguments, 
 * <em>unary</em> implies there is one argument, and <em>binary</em> implies there are
 * two arguments.  The values in the <b>Precedence</b> column show how the
 * order of different types of operation are determined.  For example, the
 * expression <code>a + b * c</code> is evaluated as <code>a + (b * c)</code>
 * because the @c * operator has higher precedence.  The
 * <b>Associates</b> column shows how the order of similar precedence
 * operations is determined; for example, <code>a && b || c</code> is
 * evaluated as <code>(a && b) || c</code> because the <code>&&</code> and <code>||</code>
 * operators are left-associative and have the same precedence.
 <p>
 * The function call syntax consists of a function name, followed by optional
 * white space, followed by an opening parenthesis token, followed by a
 * sequence of zero or more arguments separated by commas (with each comma
 * optionally preceded and/or followed by zero or more white space
 * characters), followed by a closing parenthesis token.  The function name
 * must be chosen from one of the pre-defined functions in SBML or a
 * user-defined function in the model.  The following table lists the names
 * of certain common mathematical functions; this table corresponds to
 * Table&nbsp;6 in the <a target='_blank'
 * href='http://sbml.org/Documents/Specifications#SBML_Level_1_Version_2'>SBML
 * Level&nbsp;1 Version&nbsp;2 specification</a> with additions based on the
 * functions added in SBML Level 2 and Level 3:
 <p>
 * <table border="0" width="95%" 
       class="centered text-table normal-font alt-row-colors">
 <tr>
     <th align="left" width="60">Name</th>
     <th align="left" width="75">Argument(s)</th>
     <th align="left">Formula or meaning</th>
     <th align="left" width="90">Argument Constraints</th>
     <th align="left" width="90">Result constraints</th>
 </tr>
<tr><td><code>abs</code></td>   
    <td><em>x</em></td> 
    <td>Absolute value of <em>x</em>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>acos</code>, <code>arccos</code></td>
    <td><em>x</em></td>
    <td>Arccosine of <em>x</em> in radians.</td>
    <td>&ndash;1.0 &le; <em>x</em> &le; 1.0</td>
    <td>0 &le; <em>acos(x)</em> &le; &pi;</td>
</tr>
<tr><td><code>acosh</code>, <code>arccosh</code></td>
    <td><em>x</em></td>
    <td>Hyperbolic arccosine of <em>x</em> in radians.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>acot</code>, <code>arccot</code></td>
    <td><em>x</em></td>
    <td>Arccotangent of <em>x</em> in radians.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>acoth</code>, <code>arccoth</code></td>
    <td><em>x</em></td>
    <td>Hyperbolic arccotangent of <em>x</em> in radians.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>acsc</code>, <code>arccsc</code></td>
    <td><em>x</em></td>
    <td>Arccosecant of <em>x</em> in radians.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>acsch</code>, <code>arccsch</code></td>
    <td><em>x</em></td>
    <td>Hyperbolic arccosecant of <em>x</em> in radians.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>asec</code>, <code>arcsec</code></td>
    <td><em>x</em></td>
    <td>Arcsecant of <em>x</em> in radians.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>asech</code>, <code>arcsech</code></td>
    <td><em>x</em></td>
    <td>Hyperbolic arcsecant of <em>x</em> in radians.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>asin</code>, <code>arcsin</code></td>
    <td><em>x</em></td><td>Arcsine of <em>x</em> in radians.</td>
    <td>&ndash;1.0 &le; <em>x</em> &le; 1.0</td>
    <td>0 &le; <em>asin(x)</em> &le; &pi;</td>
</tr>
<tr><td><code>atan</code>, <code>arctan</code></td>
    <td><em>x</em></td>
    <td>Arctangent of <em>x</em> in radians.</td>
    <td></td>
    <td>0 &le; <em>atan(x)</em> &le; &pi;</td>
</tr>
<tr><td><code>atanh</code>, <code>arctanh</code></td>
    <td><em>x</em></td>
    <td>Hyperbolic arctangent of <em>x</em> in radians.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>ceil</code>, <code>ceiling</code></td>
    <td><em>x</em></td>
    <td>Smallest number not less than <em>x</em> whose value is an exact integer.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>cos</code></td>
    <td><em>x</em></td>
    <td>Cosine of <em>x</em></td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>cosh</code></td>
    <td><em>x</em></td>
    <td>Hyperbolic cosine of <em>x</em>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>cot</code></td>
    <td><em>x</em></td>
    <td>Cotangent of <em>x</em>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>coth</code></td>
    <td><em>x</em></td>
    <td>Hyperbolic cotangent of <em>x</em>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>csc</code></td>
    <td><em>x</em></td>
    <td>Cosecant of <em>x</em>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>csch</code></td>
    <td><em>x</em></td>
    <td>Hyperbolic cosecant of <em>x</em>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>delay</code></td>
    <td><em>x, y</em></td>
    <td>The value of <em>x</em> at <em>y</em> time units in the past.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>factorial</code></td>
    <td><em>n</em></td>
    <td>The factorial of <em>n</em>. Factorials are defined by <em>n! = n*(n&ndash;1)* ... * 1</em>.</td>
    <td><em>n</em> must be an integer.</td>
    <td></td>
</tr>
<tr><td><code>exp</code></td>
    <td><em>x</em></td>
    <td><em>e</em><sup><em> x</em></sup>, where <em>e</em> is the base of the natural logarithm.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>floor</code></td>
    <td><em>x</em></td>
    <td>The largest number not greater than <em>x</em> whose value is an exact integer.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>ln</code></td>
    <td><em>x</em></td>
    <td>Natural logarithm of <em>x</em>.</td>
    <td><em>x</em> &gt; 0</td>
    <td></td>
</tr>
<tr><td><code>log</code></td>
    <td><em>x</em></td>
    <td>By default, the base 10 logarithm of <em>x</em>, but can be set to be the natural logarithm of <em>x</em>, or to be an illegal construct.</td>
    <td><em>x</em> &gt; 0</td>
    <td></td>
</tr>
<tr><td><code>log</code></td>
    <td><em>x, y</em></td>
    <td>The base <em>x</em> logarithm of <em>y</em>.</td>
    <td><em>y</em> &gt; 0</td>
    <td></td>
</tr>
<tr><td><code>log10</code></td>
    <td><em>x</em></td>
    <td>Base 10 logarithm of <em>x</em>.</td>
    <td><em>x</em> &gt; 0</td>
    <td></td>
</tr>
<tr><td><code>piecewise</code></td>
    <td><em>x1, y1, [x2, y2,] [...] [z]</em></td>
    <td>A piecewise function: if (<em>y1</em>), <em>x1</em>.  Otherwise, if (<em>y2</em>), <em>x2</em>, etc.  Otherwise, z. </td>
    <td><em>y1, y2, y3 [etc]</em> must be Boolean</td>
    <td></td>
</tr>
<tr><td><code>pow</code>, <code>power</code> </td>
    <td><em>x, y</em></td>
    <td><em>x</em><sup><em> y</em></sup>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>root</code></td>
    <td><em>b, x</em></td>
    <td>The root base <em>b</em> of <em>x</em>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>sec</code></td>
    <td><em>x</em></td>
    <td>Secant of <em>x</em>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>sech</code></td>
    <td><em>x</em></td>
    <td>Hyperbolic secant of <em>x</em>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>sqr</code></td>
    <td><em>x</em></td>
    <td><em>x</em><sup><em>2</em></sup>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>sqrt</code></td>
    <td><em>x</em></td>
    <td>&radic;<em>x</em>.</td>
    <td><em>x</em> &gt; 0</td>
    <td><em>sqrt(x)</em> &ge; 0</td>
</tr>
<tr><td><code>sin</code></td>
    <td><em>x</em></td>
    <td>Sine of <em>x</em>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>sinh</code></td>
    <td><em>x</em></td>
    <td>Hyperbolic sine of <em>x</em>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>tan</code></td>
    <td><em>x</em></td>
    <td>Tangent of <em>x</em>.</td>
    <td>x &ne; n*&pi;/2, for odd integer <em>n</em></td>
    <td></td>
</tr>
<tr><td><code>tanh</code></td>
    <td><em>x</em></td>
    <td>Hyperbolic tangent of <em>x</em>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>and</code></td>
    <td><em>x, y, z...</em></td>
    <td>Boolean <em>and(x, y, z...)</em>: returns <code>true</code> if all of its arguments are true.  Note that <code>and</code> is an n-ary function, taking 0 or more arguments, and that <code>and()</code> returns <code>true</code>.</td>
    <td>All arguments must be Boolean</td>
    <td></td>
</tr>
<tr><td><code>not</code></td>
    <td><em>x</em></td>
    <td>Boolean <em>not(x)</em></td>
    <td><em>x</em> must be Boolean</td>
    <td></td>
</tr>
<tr><td><code>or</code></td>
    <td><em>x, y, z...</em></td>
    <td>Boolean <em>or(x, y, z...)</em>: returns <code>true</code> if at least one of its arguments is true.  Note that <code>or</code> is an n-ary function, taking 0 or more arguments, and that <code>or()</code> returns <code>false</code>.</td>
    <td>All arguments must be Boolean</td>
    <td></td>
</tr>
<tr><td><code>xor</code></td>
    <td><em>x, y, z...</em></td>
    <td>Boolean <em>xor(x, y, z...)</em>: returns <code>true</code> if an odd number of its arguments is true.  Note that <code>xor</code> is an n-ary function, taking 0 or more arguments, and that <code>xor()</code> returns <code>false</code>.</td>
    <td>All arguments must be Boolean</td>
    <td></td>
</tr>
<tr><td><code>eq</code></td>
    <td><em>x, y, z...</em></td>
    <td>Boolean <em>eq(x, y, z...)</em>: returns <code>true</code> if all arguments are equal.  Note that <code>eq</code> is an n-ary function, but must take 2 or more arguments.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>geq</code></td>
    <td><em>x, y, z...</em></td>
    <td>Boolean <em>geq(x, y, z...)</em>: returns <code>true</code> if each argument is greater than or equal to the argument following it.  Note that <code>geq</code> is an n-ary function, but must take 2 or more arguments.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>gt</code></td>
    <td><em>x, y, z...</em></td>
    <td>Boolean <em>gt(x, y, z...)</em>: returns <code>true</code> if each argument is greater than the argument following it.  Note that <code>gt</code> is an n-ary function, but must take 2 or more arguments.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>leq</code></td>
    <td><em>x, y, z...</em></td>
    <td>Boolean <em>leq(x, y, z...)</em>: returns <code>true</code> if each argument is less than or equal to the argument following it.  Note that <code>leq</code> is an n-ary function, but must take 2 or more arguments.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>lt</code></td>
    <td><em>x, y, z...</em></td>
    <td>Boolean <em>lt(x, y, z...)</em>: returns <code>true</code> if each argument is less than the argument following it.  Note that <code>lt</code> is an n-ary function, but must take 2 or more arguments.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>neq</code></td>
    <td><em>x, y</em></td>
    <td>Boolean <em>x</em> != <em>y</em>: returns <code>true</code> unless x and y are equal.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>plus</code></td>
    <td><em>x, y, z...</em></td>
    <td><em>x</em> + <em>y</em> + <em>z</em> + <em>...</em>: The sum of the arguments of the function.  Note that <code>plus</code> is an n-ary function taking 0 or more arguments, and that <code>plus()</code> returns <code>0</code>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>times</code></td>
    <td><em>x, y, z...</em></td>
    <td><em>x</em> * <em>y</em> * <em>z</em> * <em>...</em>: The product of the arguments of the function.  Note that <code>times</code> is an n-ary function taking 0 or more arguments, and that <code>times()</code> returns <code>1</code>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>minus</code></td>
    <td><em>x, y</em></td>
    <td><em>x</em> &ndash; <em>y</em>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>divide</code></td>
    <td><em>x, y</em></td>
    <td><em>x</em> / <em>y</em>.</td>
    <td></td>
    <td></td>
</tr>

<caption class="top-caption">Mathematical functions defined
in the "Level&nbsp;3" text-string formula syntax.</caption>

</table>


 <p>
 * Parsing of the various MathML functions and constants are all
 * case-insensitive by default: function names such as <code>cos</code>,
 * <code>Cos</code> and <code>COS</code> are all parsed as the MathML cosine
 * operator, <code>&lt;cos&gt;</code>.  However, <em>when a {@link Model} object is
 * used</em> in conjunction with either
 * <a href='libsbml.html#parseL3FormulaWithModel(java.lang.String, org.sbml.libsbml.Model)'><code>libsbml.parseL3FormulaWithModel(String, Model)</code></a> or
 * <a href='libsbml.html#parseL3FormulaWithSettings(java.lang.String, org.sbml.libsbml.L3ParserSettings)'><code>libsbml.parseL3FormulaWithSettings(String, L3ParserSettings)</code></a>, any identifiers found in that model will be
 * parsed in a case-<em>sensitive</em> way.  For example, if a model contains
 * a {@link Species} having the identifier <code>Pi</code>, the parser will parse
 * &quot;<code>Pi</code>&quot; in the input as &quot;<code>&lt;ci&gt; Pi
 * &lt;/ci&gt;</code>&quot; but will continue to parse the symbols
 * &quot;<code>pi</code>&quot; and &quot;<code>PI</code>&quot; as
 * &quot;<code>&lt;pi&gt;</code>&quot;.
 <p>
 * As mentioned above, the manner in which the 'L3' versions of the formula
 * parser and formatter interpret the function &quot;<code>log</code>&quot;
 * can be changed.  To do so, callers should use the function
 * <a href='libsbml.html#parseL3FormulaWithSettings(java.lang.String, org.sbml.libsbml.L3ParserSettings)'><code>libsbml.parseL3FormulaWithSettings(String, L3ParserSettings)</code></a> and pass it an appropriate {@link L3ParserSettings}
 * object.  By default, unlike the SBML Level&nbsp;1 parser implemented by
 * <a href='libsbml.html#parseFormula(java.lang.String)'><code>libsbml.parseFormula(String)</code></a>, the string
 * &quot;<code>log</code>&quot; is interpreted as the base&nbsp;10 logarithm,
 * and <em>not</em> as the natural logarithm.  However, you can change the
 * interpretation to be base-10 log, natural log, or as an error; since the
 * name 'log' by itself is ambiguous, you require that the parser uses
 * <code>log10</code> or <code>ln</code> instead, which are more clear.  Please refer to
 * <a href='libsbml.html#parseL3FormulaWithSettings(java.lang.String, org.sbml.libsbml.L3ParserSettings)'><code>libsbml.parseL3FormulaWithSettings(String, L3ParserSettings)</code></a>.
 <p>
 * In addition, the following symbols will be translated to their MathML
 * equivalents, if no symbol with the same <code>SId</code> identifier string exists
 * in the {@link Model} object provided:
 <p>
 * <table border="0" width="95%"
       class="centered text-table normal-font alt-row-colors">
 <tr>
     <th align="left" width="60">Name</th>
     <th align="left" width="250">Meaning</th>
     <th align="left">MathML</th>
 </tr>
<tr><td><code>true</code></td>   
    <td>Boolean value <code>true</code></td>
    <td><code>&lt;true/&gt;</code></td>
</tr>
<tr><td><code>false</code></td>   
    <td>Boolean value <code>false</code></td>
    <td><code>&lt;false/&gt;</code></td>
</tr>
<tr><td><code>pi</code></td>   
    <td>Mathematical constant pi</td>
    <td><code>&lt;pi/&gt;</code></td>
</tr>
<tr><td><code>avogadro</code></td>   
    <td>Value of Avogadro's constant stipulated by SBML</td>
    <td><code style="letter-spacing: -1px">&lt;csymbol encoding="text" definitionURL="http://www.sbml.org/sbml/symbols/avogadro"&gt; avogadro &lt;/csymbol/&gt;</code></td>
</tr>
<tr><td><code>time</code></td>   
    <td>Simulation time as defined in SBML</td>
    <td><code style="letter-spacing: -1px">&lt;csymbol encoding="text" definitionURL="http://www.sbml.org/sbml/symbols/time"&gt; time &lt;/csymbol/&gt;</code></td>
</tr>
<tr><td><code>inf</code>, <code>infinity</code></td>   
    <td>Mathematical constant "infinity"</td>
    <td><code>&lt;infinity/&gt;</code></td>
</tr>
<tr><td><code>nan</code>, <code>notanumber</code></td>   
    <td>Mathematical concept "not a number"</td>
    <td><code>&lt;notanumber/&gt;</code></td>
</tr>

<caption class="top-caption">Mathematical symbols defined
in the "Level&nbsp;3" text-string formula syntax.
</caption>
</table>

 <p>
 * Again, as mentioned above, whether the string
 * &quot;<code>avogadro</code>&quot; is parsed as an AST node of type
 * {@link libsbmlConstants#AST_NAME_AVOGADRO AST_NAME_AVOGADRO} or
 * {@link libsbmlConstants#AST_NAME AST_NAME} is configurable; use the version of
 * the parser function called <a href='libsbml.html#parseL3FormulaWithSettings(java.lang.String, org.sbml.libsbml.L3ParserSettings)'><code>libsbml.parseL3FormulaWithSettings(String, L3ParserSettings)</code></a>.  This Avogadro-related
 * functionality is provided because SBML Level&nbsp;2 models may not use
 * {@link libsbmlConstants#AST_NAME_AVOGADRO AST_NAME_AVOGADRO} AST nodes.
 <p>
 * @param tree the AST to be converted.
 <p>
 * @return the formula from the given AST as an SBML Level 3 text-string
 * mathematical formula.  The caller owns the returned string and is
 * responsible for freeing it when it is no longer needed.
 <p>
 * @see <code><a href='libsbml.html#formulaToString(org.sbml.libsbml.ASTNode tree)'>libsbml.formulaToString(ASTNode tree)</a></code>
 * @see <code><a href='libsbml.html#parseL3FormulaWithSettings(java.lang.String, org.sbml.libsbml.L3ParserSettings)'>libsbml.parseL3FormulaWithSettings(String formula, L3ParserSettings settings)</a></code>
 * @see <code><a href='libsbml.html#parseL3Formula(java.lang.String)'>libsbml.parseL3Formula(String formula)</a></code>
 * @see <code><a href='libsbml.html#parseL3FormulaWithModel(java.lang.String, org.sbml.libsbml.Model)'>parseL3FormulaWithModel(String formula, Model model)</a></code>
 * @see <code><a href='libsbml.html#getLastParseL3Error()'>getLastParseL3Error()</a></code>
 * @see <code><a href='libsbml.html#getDefaultL3ParserSettings()'>getDefaultL3ParserSettings()</a></code>
 */ public
 static String formulaToL3String(ASTNode tree) {
    return libsbmlJNI.formulaToL3String(ASTNode.getCPtr(tree), tree);
  }

  
/**
 * Converts an AST to a string representation of a formula using a syntax
 * basically derived from SBML Level&nbsp;1, with behavior modifiable with
 * custom settings.
 <p>
 * This function behaves identically to SBML_formulaToL3String(), but 
 * its behavior can be modified by two settings in the @param settings
 * object, namely:
 <p>
 * <ul>
 * <li> ParseUnits:  If this is set to 'true' (the default), the function will 
 *     write out the units of any numerical ASTNodes that have them, producing
 *     (for example) '3 mL', '(3/4) m', or '5.5e-10 M'.  If this is set to
 *     'false', this function will only write out the number itself ('3',
 *     '(3/4)', and '5.5e-10', in the previous examples).
 <p>
 * <li> CollapseMinus: If this is set to 'false' (the default), the function
 *     will write out explicitly any doubly-nested unary minus ASTNodes,
 *     producing (for example) '--x' or even '&mdash;--3.1'.  If this is set
 *     to 'true', the function will collapse the nodes before producing the
 *     infix, producing 'x' and '-3.1' in the previous examples.
 *
 * </ul> <p>
 * All other settings will not affect the behavior of this function:  the
 * 'parseLog' setting is ignored, and 'log10(x)', 'ln(x)', and 'log(x, y)' 
 * are always produced.  Nothing in the {@link Model} object is used, and whether
 * Avogadro is a csymbol or not is immaterial to the produced infix.
 <p>
 * @param tree the AST to be converted.
 * @param settings the {@link L3ParserSettings} object used to modify behavior.
 <p>
 * @return the formula from the given AST as an SBML Level 3 text-string
 * mathematical formula.  The caller owns the returned string and is
 * responsible for freeing it when it is no longer needed.
 <p>
 * @see #SBML_parseFormula()
 * @see #SBML_parseL3Formula()
 * @see #SBML_formulaToL3String()
 */ public
 static String formulaToL3StringWithSettings(ASTNode tree, L3ParserSettings settings) {
    return libsbmlJNI.formulaToL3StringWithSettings(ASTNode.getCPtr(tree), tree, L3ParserSettings.getCPtr(settings), settings);
  }

  
/**
 * Converts an AST to a string representation of a formula using a syntax
 * basically derived from SBML Level&nbsp;1.
 <p>
 * <p>
 * The text-string form of mathematical formulas produced by
 * <a href='libsbml.html#formulaToString(org.sbml.libsbml.ASTNode)'><code>libsbml.formulaToString(ASTNode)</code></a> and read by
 * <a href='libsbml.html#parseFormula(java.lang.String)'><code>libsbml.parseFormula(String)</code></a> use a simple C-inspired infix
 * notation taken from SBML Level&nbsp;1.  A formula in this text-string form
 * therefore can be handed to a program that understands SBML Level&nbsp;1
 * mathematical expressions, or used as part of a formula translation system.
 * The syntax is described in detail in the documentation for {@link ASTNode}.  The
 * following are illustrative examples of formulas expressed using this syntax:
 * <pre class='fragment'>
0.10 * k4^2
</pre>
<pre class='fragment'>
(vm * s1)/(km + s1)
</pre>
 <p>
 * Note that this facility is provided as a convenience by libSBML&mdash;the
 * MathML standard does not actually define a 'string-form' equivalent to
 * MathML expression trees, so the choice of formula syntax is somewhat
 * arbitrary.  The approach taken by libSBML is to use the syntax defined by
 * SBML Level&nbsp;1 (which in fact used a text-string representation of
 * formulas and not MathML).  This formula syntax is based mostly on C
 * programming syntax, and may contain operators, function calls, symbols,
 * and white space characters.  The following table provides the precedence
 * rules for the different entities that may appear in formula strings.
 <p>
 * <table border="0" class="centered text-table width80 normal-font alt-row-colors" style="padding-bottom: 0.5em">
 <tr style="background: lightgray; font-size: 14px;">
     <th align="left">Token</th>
     <th align="left">Operation</th>
     <th align="left">Class</th>
     <th>Precedence</th>
     <th align="left">Associates</th>
 </tr>
<tr><td><em>name</em></td><td>symbol reference</td><td>operand</td><td align="center">6</td><td>n/a</td></tr>
<tr><td><code>(</code><em>expression</em><code>)</code></td><td>expression grouping</td><td>operand</td><td align="center">6</td><td>n/a</td></tr>
<tr><td><code>f(</code><em>...</em><code>)</code></td><td>function call</td><td>prefix</td><td align="center">6</td><td>left</td></tr>
<tr><td><code>-</code></td><td>negation</td><td>unary</td><td align="center">5</td><td>right</td></tr>
<tr><td><code>^</code></td><td>power</td><td>binary</td><td align="center">4</td><td>left</td></tr>
<tr><td><code>*</code></td><td>multiplication</td><td>binary</td><td align="center">3</td><td>left</td></tr>
<tr><td><code>/</code></td><td>divison</td><td>binary</td><td align="center">3</td><td>left</td></tr>
<tr><td><code>+</code></td><td>addition</td><td>binary</td><td align="center">2</td><td>left</td></tr>
<tr><td><code>-</code></td><td>subtraction</td><td>binary</td><td align="center">2</td><td>left</td></tr>
<tr><td><code>,</code></td><td>argument delimiter</td><td>binary</td><td align="center">1</td><td>left</td></tr>
<caption class="top-caption">A table of the expression operators and their precedence in the
text-string format for mathematical expressions used by SBML_parseFormula().
</caption>
</table>


 <p>
 * In the table above, <em>operand</em> implies the construct is an operand, 
 * <em>prefix</em> implies the operation is applied to the following arguments, 
 * <em>unary</em> implies there is one argument, and <em>binary</em> implies there are
 * two arguments.  The values in the <b>Precedence</b> column show how the
 * order of different types of operation are determined.  For example, the
 * expression <code>a * b + c</code> is evaluated as <code>(a * b) +
 * c</code> because the @c * operator has higher precedence.  The
 * <b>Associates</b> column shows how the order of similar precedence
 * operations is determined; for example, <code>a - b + c</code> is
 * evaluated as <code>(a - b) + c</code> because the <code>+</code> and <code>-</code>
 * operators are left-associative.
 <p>
 * The function call syntax consists of a function name, followed by optional
 * white space, followed by an opening parenthesis token, followed by a
 * sequence of zero or more arguments separated by commas (with each comma
 * optionally preceded and/or followed by zero or more white space
 * characters, followed by a closing parenthesis token.  The function name
 * must be chosen from one of the pre-defined functions in SBML or a
 * user-defined function in the model.  The following table lists the names
 * of certain common mathematical functions; this table corresponds to
 * Table&nbsp;6 in the <a target='_blank' href='http://sbml.org/Documents/Specifications#SBML_Level_1_Version_2'>SBML Level&nbsp;1 Version&nbsp;2 specification</a>:
 <p>
 * <table border="0" class="centered text-table width80 normal-font alt-row-colors">
 <tr>
     <th align="left" width="60">Name</th>
     <th align="left" width="35">Args</th>
     <th align="left">Formula or meaning</th>
     <th align="left" width="90">Argument Constraints</th>
     <th align="left" width="90">Result constraints</th>
 </tr>
<tr><td><code>abs</code></td><td><em>x</em></td><td>absolute value of <em>x</em></td><td></td><td></td></tr>
<tr><td><code>acos</code></td><td><em>x</em></td><td>arc cosine of <em>x</em> in radians</td><td>-1.0 &le; <em>x</em> &le; 1.0</td><td>0 &le; <em>acos(x)</em> &le; &pi;</td></tr>
<tr><td><code>asin</code></td><td><em>x</em></td><td>arc sine of <em>x</em> in radians</td><td>-1.0 &le; <em>x</em> &le; 1.0</td><td>0 &le; <em>asin(x)</em> &le; &pi;</td></tr>
<tr><td><code>atan</code></td><td><em>x</em></td><td>arc tangent of <em>x</em> in radians</td><td></td><td>0 &le; <em>atan(x)</em> &le; &pi;</td></tr>
<tr><td><code>ceil</code></td><td><em>x</em></td><td>smallest number not less than <em>x</em> whose value is an exact integer</td><td></td><td></td></tr>
<tr><td><code>cos</code></td><td><em>x</em></td><td>cosine of <em>x</em></td><td></td><td></td></tr>
<tr><td><code>exp</code></td><td><em>x</em></td><td><em>e</em><sup><em> x</em></sup>, where <em>e</em> is the base of the natural logarithm</td><td></td><td></td></tr>
<tr><td><code>floor</code></td><td><em>x</em></td><td>largest number not greater than <em>x</em> whose value is an exact integer</td><td></td><td></td></tr>
<tr><td><code>log</code></td><td><em>x</em></td><td>natural logarithm of <em>x</em></td><td><em>x</em> &gt; 0</td><td></td></tr>
<tr><td><code>log10</code></td><td><em>x</em></td><td>base 10 logarithm of <em>x</em></td><td><em>x</em> &gt; 0</td><td></td></tr>
<tr><td><code>pow</code></td><td><em>x, y</em></td><td><em>x</em><sup><em> y</em></sup></td><td></td><td></td></tr>
<tr><td><code>sqr</code></td><td><em>x</em></td><td><em>x</em><sup><em>2</em></sup></td><td></td><td></td></tr>
<tr><td><code>sqrt</code></td><td><em>x</em></td><td>&radic;<em>x</em></td><td><em>x</em> &gt; 0</td><td><em>sqrt(x)</em> &ge; 0</td></tr>
<tr><td><code>sin</code></td><td><em>x</em></td><td>sine of <em>x</em></td><td></td><td></td></tr>
<tr><td><code>tan</code></td><td><em>x</em></td><td>tangent of <em>x</em></td><td>x &ne; n*&pi;/2, for odd integer <em>n</em></td><td></td></tr>
<caption class="bottom-caption">The names of mathematical functions defined in the SBML
Level&nbsp;1 Version&nbsp;2 text-string formula syntax.</caption>
</table>


 <p>
 * @warning <span class='warning'>There are differences between the symbols
 * used to represent the common mathematical functions and the corresponding
 * MathML token names.  This is a potential source of incompatibilities.
 * Note in particular that in this text-string syntax, <code>log(x)</code>
 * represents the natural logarithm, whereas in MathML, the natural logarithm
 * is <code>&lt;ln/&gt;</code>.  Application writers are urged to be careful
 * when translating between text forms and MathML forms, especially if they
 * provide a direct text-string input facility to users of their software
 * systems.</span> 
 <p>
 * @copydetails doc_warning_L1_math_string_syntax 
 <p>
 * @param tree the AST to be converted.
 <p>
 * @return the formula from the given AST as an SBML Level 1 text-string
 * mathematical formula.  The caller owns the returned string and is
 * responsible for freeing it when it is no longer needed.
 <p>
 * @see <code><a href='libsbml.html#formulaToString(org.sbml.libsbml.ASTNode tree)'>libsbml.formulaToString(ASTNode tree)</a></code>
 * @see <code><a href='libsbml.html#parseL3FormulaWithSettings(java.lang.String, org.sbml.libsbml.L3ParserSettings)'>libsbml.parseL3FormulaWithSettings(String formula, L3ParserSettings settings)</a></code>
 * @see <code><a href='libsbml.html#parseL3Formula(java.lang.String)'>libsbml.parseL3Formula(String formula)</a></code>
 * @see <code><a href='libsbml.html#parseL3FormulaWithModel(java.lang.String, org.sbml.libsbml.Model)'>parseL3FormulaWithModel(String formula, Model model)</a></code>
 * @see <code><a href='libsbml.html#getLastParseL3Error()'>getLastParseL3Error()</a></code>
 * @see <code><a href='libsbml.html#getDefaultL3ParserSettings()'>getDefaultL3ParserSettings()</a></code>
 */ public
 static String formulaToString(ASTNode tree) {
    return libsbmlJNI.formulaToString(ASTNode.getCPtr(tree), tree);
  }

  
/**
 * Parses a text string as a mathematical formula and returns an AST
 * representation of it.
 <p>
 * <p>
 * The text-string form of mathematical formulas read by the function
 * <a href='libsbml.html#parseL3Formula(java.lang.String)'><code>libsbml.parseL3Formula(String)</code></a> and written by the function
 * <a href='libsbml.html#formulaToL3String(org.sbml.libsbml.ASTNode)'><code>libsbml.formulaToL3String(ASTNode)</code></a> uses an expanded version of
 * the syntax read and written by <a href='libsbml.html#parseFormula(java.lang.String)'><code>libsbml.parseFormula(String)</code></a>
 * and <a href='libsbml.html#formulaToString(org.sbml.libsbml.ASTNode)'><code>libsbml.formulaToString(ASTNode)</code></a>, respectively.  The
 * latter two libSBML functions were originally developed to support
 * conversion between SBML Levels&nbsp;1 and&nbsp;2, and were focused on the
 * syntax of mathematical formulas used in SBML Level&nbsp;1.  With time, and
 * the use of MathML in SBML Levels&nbsp;2 and&nbsp;3, it became clear that
 * supporting Level&nbsp;2 and&nbsp;3's expanded mathematical syntax would be
 * useful for software developers.  To maintain backwards compatibility for
 * libSBML users, the original <a href='libsbml.html#formulaToString(org.sbml.libsbml.ASTNode)'><code>libsbml.formulaToString(ASTNode)</code></a>
 * and <a href='libsbml.html#parseFormula(java.lang.String)'><code>libsbml.parseFormula(String)</code></a> have been left untouched,
 * and instead, the new functionality is provided in the form of
 * <a href='libsbml.html#parseL3Formula(java.lang.String)'><code>libsbml.parseL3Formula(String)</code></a> and
 * <a href='libsbml.html#formulaToL3String(org.sbml.libsbml.ASTNode)'><code>libsbml.formulaToL3String(ASTNode)</code></a>.
 <p>
 * The following lists the main differences in the formula syntax supported by
 * the Level 3 ('L3') versions of the formula parsers and formatters,
 * compared to what is supported by the Level&nbsp;1-oriented
 * <a href='libsbml.html#parseFormula(java.lang.String)'><code>libsbml.parseFormula(String)</code></a> and
 * <a href='libsbml.html#formulaToString(org.sbml.libsbml.ASTNode)'><code>libsbml.formulaToString(ASTNode)</code></a>:
 <p>
 * <ul>
 * <li> Units may be asociated with bare numbers, using the following syntax:
 * <div style='margin: 10px auto 10px 25px; display: block'>
 * <span class='code' style='background-color: #d0d0ee'>number</span>
 * <span class='code' style='background-color: #edd'>unit</span>
 * </div>
 * The <span class='code' style='background-color: #d0d0ee'>number</span>
 * may be in any form (an integer, real, or rational
 * number), and the
 * <span class='code' style='background-color: #edd'>unit</span>
 * must conform to the syntax of an SBML identifier (technically, the
 * type defined as <code>SId</code> in the SBML specifications).  The whitespace between
 * <span class='code' style='background-color: #d0d0ee'>number</span>
 * and <span class='code' style='background-color: #edd'>unit</span>
 * is optional.
 <p>
 * <li> The Boolean function symbols <code>&&</code> (<em>and</em>), <code>||</code> (<em>or</em>), <code>!</code> (<em>not</em>),
 * and <code>!=</code> (<em>not</em> <em>equals</em>) may be used.
 <p>
 * <li> The <em>modulo</em> operation is allowed as the symbol <code>@%</code> and will
 * produce a <code>&lt;piecewise&gt;</code> function in the corresponding
 * MathML output by default, or can produce the MathML function <code>rem</code>, 
 * depending on the {@link L3ParserSettings} object (see 
 * L3ParserSettings_setParseModuloL3v2() ).
 <p>
 * <li> All inverse trigonometric functions may be defined in the infix either
 * using <code>arc</code> as a prefix or simply <code>a</code>; in other words, both <code>arccsc</code>
 * and <code>acsc</code> are interpreted as the operator <em>arccosecant</em> as defined in
 * MathML&nbsp;2.0.  (Many functions in the simpler SBML Level&nbsp;1
 * oriented parser implemented by <a href='libsbml.html#parseFormula(java.lang.String)'><code>libsbml.parseFormula(String)</code></a>
 * are defined this way as well, but not all.)
 <p>
 * <li> The following expression is parsed as a rational number instead of
 * as a numerical division:
 * <pre style='display: block; margin-left: 25px'>
 * (<span class='code' style='background-color: #d0d0ee'>integer</span>/<span class='code' style='background-color: #d0d0ee'>integer</span>)</pre>
 * <strong>Spaces are not allowed</strong> in this construct; in other words,
 * &quot;<code>(3 / 4)</code>&quot; (with whitespace between the numbers and
 * the operator) will be parsed into the MathML <code>&lt;divide&gt;</code>
 * construct rather than a rational number.  You can, however, assign units to a
 * rational number as a whole; here is an example: &quot;<code>(3/4) ml</code>&quot;.
 * (In the case of division rather than a rational number, units are not interpreted
 * in this way.)
 <p>
 * <li> Various parser and formatter behaviors may be altered through the use
 * of a {@link L3ParserSettings} object in conjunction with the functions
 * <a href='libsbml.html#parseL3FormulaWithSettings(java.lang.String, org.sbml.libsbml.L3ParserSettings)'><code>libsbml.parseL3FormulaWithSettings(String, L3ParserSettings)</code></a> and
 * <a href='libsbml.html#formulaToL3StringWithSettings(org.sbml.libsbml.ASTNode, org.sbml.libsbml.L3ParserSettings)'><code>libsbml.formulaToL3StringWithSettings(ASTNode, L3ParserSettings)</code></a>
 * The settings available include the following:
 * <ul style='list-style-type: circle'>
 *
 * </ul> <p>
 * <li style='margin-bottom: 0.5em'> The function <code>log</code> with a single
 * argument (&quot;<code>log(x)</code>&quot;) can be parsed as
 * <code>log10(x)</code>, <code>ln(x)</code>, or treated as an error, as
 * desired.
 <p>
 * <li style='margin-bottom: 0.5em'> Unary minus signs can be collapsed or
 * preserved; that is, sequential pairs of unary minuses (e.g., &quot;<code>-
 * -3</code>&quot;) can be removed from the input entirely and single unary
 * minuses can be incorporated into the number node, or all minuses can be
 * preserved in the AST node structure.
 <p>
 * <li style='margin-bottom: 0.5em'> Parsing of units embedded in the input
 * string can be turned on and off.
 <p>
 * <li style='margin-bottom: 0.5em'> The string <code>avogadro</code> can be parsed as
 * a MathML <em>csymbol</em> or as an identifier.
 <p>
 * <li style='margin-bottom: 0.5em'> The string @% can be parsed either as a 
 * piecewise function or as the 'rem' function:  <code>a @% b</code> will either
 * become
 <p>
 * <code>piecewise(a - b*ceil(a/b), xor((a < 0), (b < 0)), a - b*floor(a/b))</code>
 <p>
 * or 
 <p>
 * <code>rem(a, b)</code>.
 <p>
 * The latter is simpler, but the <code>rem</code> MathML is only allowed
 * as of SBML Level&nbsp;3 Version&nbsp;2.</li>
 <p>
 * <li style='margin-bottom: 0.5em'> A {@link Model} object may optionally be
 * provided to the parser using the variant function call
 * <a href='libsbml.html#parseL3FormulaWithModel(java.lang.String, org.sbml.libsbml.Model)'><code>libsbml.parseL3FormulaWithModel(String, Model)</code></a> or
 * stored in a {@link L3ParserSettings} object passed to the variant function
 * <a href='libsbml.html#parseL3FormulaWithSettings(java.lang.String, org.sbml.libsbml.L3ParserSettings)'><code>libsbml.parseL3FormulaWithSettings(String, L3ParserSettings)</code></a>.  When a {@link Model} object is provided, identifiers
 * (values of type <code>SId</code> ) from that model are used in preference to
 * pre-defined MathML definitions for both symbols and functions.
 * More precisely:
 * <ul style='list-style-type: square'>
 <p>
 * <li style='margin-bottom: 0.5em'> <em>In the case of symbols</em>: the
 * {@link Model} entities whose identifiers will shadow identical symbols in the
 * mathematical formula are: {@link Species}, {@link Compartment}, {@link Parameter}, {@link Reaction}, and
 * {@link SpeciesReference}.  For instance, if the parser is given a {@link Model} containing
 * a {@link Species} with the identifier &quot;<code>pi</code>&quot;, and the formula
 * to be parsed is &quot;<code>3*pi</code>&quot;, the MathML produced will
 * contain the construct <code>&lt;ci&gt; pi &lt;/ci&gt;</code> instead of
 * the construct <code>&lt;pi/&gt;</code>.
 <p>
 * <li style='margin-bottom: 0.5em'> <em>In the case of user-defined
 * functions</em>: when a {@link Model} object is provided, <code>SId</code> values of
 * user-defined functions present in the model will be used preferentially
 * over pre-defined MathML functions.  For example, if the passed-in {@link Model}
 * contains a {@link FunctionDefinition} object with the identifier
 * &quot;<code>sin</code>&quot;, that function will be used instead of the
 * predefined MathML function <code>&lt;sin/&gt;</code>.
 * </ul>
 <p>
 * <li style='margin-bottom: 0.5em'> An {@link SBMLNamespaces} object may optionally
 * be provided to identify SBML Level&nbsp;3 packages that extend the
 * syntax understood by the formula parser.  When the namespaces are provided,
 * the parser will interpret possible additional syntax defined by the libSBML
 * plug-ins implementing the SBML Level&nbsp;3 packages; for example, it may
 * understand vector/array extensions introduced by the SBML Level&nbsp;3 
 * <em>Arrays</em> package.
 * </ul>
 <p>
 * These configuration settings cannot be changed directly using the basic
 * parser and formatter functions, but <em>can</em> be changed on a per-call basis
 * by using the alternative functions <a href='libsbml.html#parseL3FormulaWithSettings(java.lang.String, org.sbml.libsbml.L3ParserSettings)'><code>libsbml.parseL3FormulaWithSettings(String, L3ParserSettings)</code></a> and
 * <a href='libsbml.html#formulaToL3StringWithSettings(org.sbml.libsbml.ASTNode, org.sbml.libsbml.L3ParserSettings)'><code>libsbml.formulaToL3StringWithSettings(ASTNode, L3ParserSettings)</code></a>.
 <p>
 * Neither SBML nor the MathML standard define a 'string-form' equivalent to
 * MathML expressions.  The approach taken by libSBML is to start with the
 * formula syntax defined by SBML Level&nbsp;1 (which in fact used a custom
 * text-string representation of formulas, and not MathML), and expand it to
 * include the functionality described above.  This formula syntax is based
 * mostly on C programming syntax, and may contain operators, function calls,
 * symbols, and white space characters.  The following table provides the
 * precedence rules for the different entities that may appear in formula
 * strings.
 <p>
 * <table border="0" width="95%"
       class="centered text-table normal-font alt-row-colors"
       style="padding-bottom: 0.5em">
 <tr style="background: lightgray; font-size: 14px;">
     <th align="left">Token</th>
     <th align="left">Operation</th>
     <th align="left">Class</th>
     <th>Preced.</th>
     <th align="left">Assoc.</th>
 </tr>
<tr><td><em>name</em></td><td>symbol reference</td><td>operand</td><td align="center">8</td><td>n/a</td></tr>
<tr><td><code>(</code><em>expression</em><code>)</code></td><td>expression grouping</td><td>operand</td><td align="center">8</td><td>n/a</td></tr>
<tr><td><code>f(</code><em>...</em><code>)</code></td><td>function call</td><td>prefix</td><td align="center">8</td><td>left</td></tr>
<tr><td><code>^</code></td><td>power</td><td>binary</td><td align="center">7</td><td>left</td></tr>
<tr><td><code>-, !</code></td><td>negation, Boolean 'not'</td><td>unary</td><td align="center">6</td><td>right</td></tr>
<tr><td><code>*, /, %</code></td><td>multip., div., modulo</td><td>binary</td><td align="center">5</td><td>left</td></tr>
<tr><td><code>+, -</code></td><td>addition and subtraction</td><td>binary</td><td align="center">4</td><td>left</td></tr>
<tr><td><code>==, &lt;, &gt;, &lt;=, &gt;=, !=</code></td><td>Boolean comparisons</td><td>binary</td><td align="center">3</td><td>left</td></tr>
<tr><td><code>&&, ||</code></td><td>Boolean 'and' and 'or'</td><td>binary</td><td align="center">2</td><td>left</td></tr>
<tr><td><code>,</code></td><td>argument delimiter</td><td>binary</td><td align="center">1</td><td>left</td></tr>

<caption class="top-caption">Expression operators and their precedence in the
"Level&nbsp;3" text-string format for mathematical expressions.
</caption>
</table>


 <p>
 * In the table above, <em>operand</em> implies the construct is an operand, 
 * <em>prefix</em> implies the operation is applied to the following arguments, 
 * <em>unary</em> implies there is one argument, and <em>binary</em> implies there are
 * two arguments.  The values in the <b>Precedence</b> column show how the
 * order of different types of operation are determined.  For example, the
 * expression <code>a + b * c</code> is evaluated as <code>a + (b * c)</code>
 * because the @c * operator has higher precedence.  The
 * <b>Associates</b> column shows how the order of similar precedence
 * operations is determined; for example, <code>a && b || c</code> is
 * evaluated as <code>(a && b) || c</code> because the <code>&&</code> and <code>||</code>
 * operators are left-associative and have the same precedence.
 <p>
 * The function call syntax consists of a function name, followed by optional
 * white space, followed by an opening parenthesis token, followed by a
 * sequence of zero or more arguments separated by commas (with each comma
 * optionally preceded and/or followed by zero or more white space
 * characters), followed by a closing parenthesis token.  The function name
 * must be chosen from one of the pre-defined functions in SBML or a
 * user-defined function in the model.  The following table lists the names
 * of certain common mathematical functions; this table corresponds to
 * Table&nbsp;6 in the <a target='_blank'
 * href='http://sbml.org/Documents/Specifications#SBML_Level_1_Version_2'>SBML
 * Level&nbsp;1 Version&nbsp;2 specification</a> with additions based on the
 * functions added in SBML Level 2 and Level 3:
 <p>
 * <table border="0" width="95%" 
       class="centered text-table normal-font alt-row-colors">
 <tr>
     <th align="left" width="60">Name</th>
     <th align="left" width="75">Argument(s)</th>
     <th align="left">Formula or meaning</th>
     <th align="left" width="90">Argument Constraints</th>
     <th align="left" width="90">Result constraints</th>
 </tr>
<tr><td><code>abs</code></td>   
    <td><em>x</em></td> 
    <td>Absolute value of <em>x</em>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>acos</code>, <code>arccos</code></td>
    <td><em>x</em></td>
    <td>Arccosine of <em>x</em> in radians.</td>
    <td>&ndash;1.0 &le; <em>x</em> &le; 1.0</td>
    <td>0 &le; <em>acos(x)</em> &le; &pi;</td>
</tr>
<tr><td><code>acosh</code>, <code>arccosh</code></td>
    <td><em>x</em></td>
    <td>Hyperbolic arccosine of <em>x</em> in radians.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>acot</code>, <code>arccot</code></td>
    <td><em>x</em></td>
    <td>Arccotangent of <em>x</em> in radians.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>acoth</code>, <code>arccoth</code></td>
    <td><em>x</em></td>
    <td>Hyperbolic arccotangent of <em>x</em> in radians.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>acsc</code>, <code>arccsc</code></td>
    <td><em>x</em></td>
    <td>Arccosecant of <em>x</em> in radians.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>acsch</code>, <code>arccsch</code></td>
    <td><em>x</em></td>
    <td>Hyperbolic arccosecant of <em>x</em> in radians.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>asec</code>, <code>arcsec</code></td>
    <td><em>x</em></td>
    <td>Arcsecant of <em>x</em> in radians.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>asech</code>, <code>arcsech</code></td>
    <td><em>x</em></td>
    <td>Hyperbolic arcsecant of <em>x</em> in radians.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>asin</code>, <code>arcsin</code></td>
    <td><em>x</em></td><td>Arcsine of <em>x</em> in radians.</td>
    <td>&ndash;1.0 &le; <em>x</em> &le; 1.0</td>
    <td>0 &le; <em>asin(x)</em> &le; &pi;</td>
</tr>
<tr><td><code>atan</code>, <code>arctan</code></td>
    <td><em>x</em></td>
    <td>Arctangent of <em>x</em> in radians.</td>
    <td></td>
    <td>0 &le; <em>atan(x)</em> &le; &pi;</td>
</tr>
<tr><td><code>atanh</code>, <code>arctanh</code></td>
    <td><em>x</em></td>
    <td>Hyperbolic arctangent of <em>x</em> in radians.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>ceil</code>, <code>ceiling</code></td>
    <td><em>x</em></td>
    <td>Smallest number not less than <em>x</em> whose value is an exact integer.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>cos</code></td>
    <td><em>x</em></td>
    <td>Cosine of <em>x</em></td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>cosh</code></td>
    <td><em>x</em></td>
    <td>Hyperbolic cosine of <em>x</em>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>cot</code></td>
    <td><em>x</em></td>
    <td>Cotangent of <em>x</em>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>coth</code></td>
    <td><em>x</em></td>
    <td>Hyperbolic cotangent of <em>x</em>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>csc</code></td>
    <td><em>x</em></td>
    <td>Cosecant of <em>x</em>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>csch</code></td>
    <td><em>x</em></td>
    <td>Hyperbolic cosecant of <em>x</em>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>delay</code></td>
    <td><em>x, y</em></td>
    <td>The value of <em>x</em> at <em>y</em> time units in the past.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>factorial</code></td>
    <td><em>n</em></td>
    <td>The factorial of <em>n</em>. Factorials are defined by <em>n! = n*(n&ndash;1)* ... * 1</em>.</td>
    <td><em>n</em> must be an integer.</td>
    <td></td>
</tr>
<tr><td><code>exp</code></td>
    <td><em>x</em></td>
    <td><em>e</em><sup><em> x</em></sup>, where <em>e</em> is the base of the natural logarithm.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>floor</code></td>
    <td><em>x</em></td>
    <td>The largest number not greater than <em>x</em> whose value is an exact integer.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>ln</code></td>
    <td><em>x</em></td>
    <td>Natural logarithm of <em>x</em>.</td>
    <td><em>x</em> &gt; 0</td>
    <td></td>
</tr>
<tr><td><code>log</code></td>
    <td><em>x</em></td>
    <td>By default, the base 10 logarithm of <em>x</em>, but can be set to be the natural logarithm of <em>x</em>, or to be an illegal construct.</td>
    <td><em>x</em> &gt; 0</td>
    <td></td>
</tr>
<tr><td><code>log</code></td>
    <td><em>x, y</em></td>
    <td>The base <em>x</em> logarithm of <em>y</em>.</td>
    <td><em>y</em> &gt; 0</td>
    <td></td>
</tr>
<tr><td><code>log10</code></td>
    <td><em>x</em></td>
    <td>Base 10 logarithm of <em>x</em>.</td>
    <td><em>x</em> &gt; 0</td>
    <td></td>
</tr>
<tr><td><code>piecewise</code></td>
    <td><em>x1, y1, [x2, y2,] [...] [z]</em></td>
    <td>A piecewise function: if (<em>y1</em>), <em>x1</em>.  Otherwise, if (<em>y2</em>), <em>x2</em>, etc.  Otherwise, z. </td>
    <td><em>y1, y2, y3 [etc]</em> must be Boolean</td>
    <td></td>
</tr>
<tr><td><code>pow</code>, <code>power</code> </td>
    <td><em>x, y</em></td>
    <td><em>x</em><sup><em> y</em></sup>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>root</code></td>
    <td><em>b, x</em></td>
    <td>The root base <em>b</em> of <em>x</em>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>sec</code></td>
    <td><em>x</em></td>
    <td>Secant of <em>x</em>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>sech</code></td>
    <td><em>x</em></td>
    <td>Hyperbolic secant of <em>x</em>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>sqr</code></td>
    <td><em>x</em></td>
    <td><em>x</em><sup><em>2</em></sup>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>sqrt</code></td>
    <td><em>x</em></td>
    <td>&radic;<em>x</em>.</td>
    <td><em>x</em> &gt; 0</td>
    <td><em>sqrt(x)</em> &ge; 0</td>
</tr>
<tr><td><code>sin</code></td>
    <td><em>x</em></td>
    <td>Sine of <em>x</em>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>sinh</code></td>
    <td><em>x</em></td>
    <td>Hyperbolic sine of <em>x</em>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>tan</code></td>
    <td><em>x</em></td>
    <td>Tangent of <em>x</em>.</td>
    <td>x &ne; n*&pi;/2, for odd integer <em>n</em></td>
    <td></td>
</tr>
<tr><td><code>tanh</code></td>
    <td><em>x</em></td>
    <td>Hyperbolic tangent of <em>x</em>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>and</code></td>
    <td><em>x, y, z...</em></td>
    <td>Boolean <em>and(x, y, z...)</em>: returns <code>true</code> if all of its arguments are true.  Note that <code>and</code> is an n-ary function, taking 0 or more arguments, and that <code>and()</code> returns <code>true</code>.</td>
    <td>All arguments must be Boolean</td>
    <td></td>
</tr>
<tr><td><code>not</code></td>
    <td><em>x</em></td>
    <td>Boolean <em>not(x)</em></td>
    <td><em>x</em> must be Boolean</td>
    <td></td>
</tr>
<tr><td><code>or</code></td>
    <td><em>x, y, z...</em></td>
    <td>Boolean <em>or(x, y, z...)</em>: returns <code>true</code> if at least one of its arguments is true.  Note that <code>or</code> is an n-ary function, taking 0 or more arguments, and that <code>or()</code> returns <code>false</code>.</td>
    <td>All arguments must be Boolean</td>
    <td></td>
</tr>
<tr><td><code>xor</code></td>
    <td><em>x, y, z...</em></td>
    <td>Boolean <em>xor(x, y, z...)</em>: returns <code>true</code> if an odd number of its arguments is true.  Note that <code>xor</code> is an n-ary function, taking 0 or more arguments, and that <code>xor()</code> returns <code>false</code>.</td>
    <td>All arguments must be Boolean</td>
    <td></td>
</tr>
<tr><td><code>eq</code></td>
    <td><em>x, y, z...</em></td>
    <td>Boolean <em>eq(x, y, z...)</em>: returns <code>true</code> if all arguments are equal.  Note that <code>eq</code> is an n-ary function, but must take 2 or more arguments.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>geq</code></td>
    <td><em>x, y, z...</em></td>
    <td>Boolean <em>geq(x, y, z...)</em>: returns <code>true</code> if each argument is greater than or equal to the argument following it.  Note that <code>geq</code> is an n-ary function, but must take 2 or more arguments.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>gt</code></td>
    <td><em>x, y, z...</em></td>
    <td>Boolean <em>gt(x, y, z...)</em>: returns <code>true</code> if each argument is greater than the argument following it.  Note that <code>gt</code> is an n-ary function, but must take 2 or more arguments.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>leq</code></td>
    <td><em>x, y, z...</em></td>
    <td>Boolean <em>leq(x, y, z...)</em>: returns <code>true</code> if each argument is less than or equal to the argument following it.  Note that <code>leq</code> is an n-ary function, but must take 2 or more arguments.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>lt</code></td>
    <td><em>x, y, z...</em></td>
    <td>Boolean <em>lt(x, y, z...)</em>: returns <code>true</code> if each argument is less than the argument following it.  Note that <code>lt</code> is an n-ary function, but must take 2 or more arguments.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>neq</code></td>
    <td><em>x, y</em></td>
    <td>Boolean <em>x</em> != <em>y</em>: returns <code>true</code> unless x and y are equal.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>plus</code></td>
    <td><em>x, y, z...</em></td>
    <td><em>x</em> + <em>y</em> + <em>z</em> + <em>...</em>: The sum of the arguments of the function.  Note that <code>plus</code> is an n-ary function taking 0 or more arguments, and that <code>plus()</code> returns <code>0</code>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>times</code></td>
    <td><em>x, y, z...</em></td>
    <td><em>x</em> * <em>y</em> * <em>z</em> * <em>...</em>: The product of the arguments of the function.  Note that <code>times</code> is an n-ary function taking 0 or more arguments, and that <code>times()</code> returns <code>1</code>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>minus</code></td>
    <td><em>x, y</em></td>
    <td><em>x</em> &ndash; <em>y</em>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>divide</code></td>
    <td><em>x, y</em></td>
    <td><em>x</em> / <em>y</em>.</td>
    <td></td>
    <td></td>
</tr>

<caption class="top-caption">Mathematical functions defined
in the "Level&nbsp;3" text-string formula syntax.</caption>

</table>


 <p>
 * Parsing of the various MathML functions and constants are all
 * case-insensitive by default: function names such as <code>cos</code>,
 * <code>Cos</code> and <code>COS</code> are all parsed as the MathML cosine
 * operator, <code>&lt;cos&gt;</code>.  However, <em>when a {@link Model} object is
 * used</em> in conjunction with either
 * <a href='libsbml.html#parseL3FormulaWithModel(java.lang.String, org.sbml.libsbml.Model)'><code>libsbml.parseL3FormulaWithModel(String, Model)</code></a> or
 * <a href='libsbml.html#parseL3FormulaWithSettings(java.lang.String, org.sbml.libsbml.L3ParserSettings)'><code>libsbml.parseL3FormulaWithSettings(String, L3ParserSettings)</code></a>, any identifiers found in that model will be
 * parsed in a case-<em>sensitive</em> way.  For example, if a model contains
 * a {@link Species} having the identifier <code>Pi</code>, the parser will parse
 * &quot;<code>Pi</code>&quot; in the input as &quot;<code>&lt;ci&gt; Pi
 * &lt;/ci&gt;</code>&quot; but will continue to parse the symbols
 * &quot;<code>pi</code>&quot; and &quot;<code>PI</code>&quot; as
 * &quot;<code>&lt;pi&gt;</code>&quot;.
 <p>
 * As mentioned above, the manner in which the 'L3' versions of the formula
 * parser and formatter interpret the function &quot;<code>log</code>&quot;
 * can be changed.  To do so, callers should use the function
 * <a href='libsbml.html#parseL3FormulaWithSettings(java.lang.String, org.sbml.libsbml.L3ParserSettings)'><code>libsbml.parseL3FormulaWithSettings(String, L3ParserSettings)</code></a> and pass it an appropriate {@link L3ParserSettings}
 * object.  By default, unlike the SBML Level&nbsp;1 parser implemented by
 * <a href='libsbml.html#parseFormula(java.lang.String)'><code>libsbml.parseFormula(String)</code></a>, the string
 * &quot;<code>log</code>&quot; is interpreted as the base&nbsp;10 logarithm,
 * and <em>not</em> as the natural logarithm.  However, you can change the
 * interpretation to be base-10 log, natural log, or as an error; since the
 * name 'log' by itself is ambiguous, you require that the parser uses
 * <code>log10</code> or <code>ln</code> instead, which are more clear.  Please refer to
 * <a href='libsbml.html#parseL3FormulaWithSettings(java.lang.String, org.sbml.libsbml.L3ParserSettings)'><code>libsbml.parseL3FormulaWithSettings(String, L3ParserSettings)</code></a>.
 <p>
 * In addition, the following symbols will be translated to their MathML
 * equivalents, if no symbol with the same <code>SId</code> identifier string exists
 * in the {@link Model} object provided:
 <p>
 * <table border="0" width="95%"
       class="centered text-table normal-font alt-row-colors">
 <tr>
     <th align="left" width="60">Name</th>
     <th align="left" width="250">Meaning</th>
     <th align="left">MathML</th>
 </tr>
<tr><td><code>true</code></td>   
    <td>Boolean value <code>true</code></td>
    <td><code>&lt;true/&gt;</code></td>
</tr>
<tr><td><code>false</code></td>   
    <td>Boolean value <code>false</code></td>
    <td><code>&lt;false/&gt;</code></td>
</tr>
<tr><td><code>pi</code></td>   
    <td>Mathematical constant pi</td>
    <td><code>&lt;pi/&gt;</code></td>
</tr>
<tr><td><code>avogadro</code></td>   
    <td>Value of Avogadro's constant stipulated by SBML</td>
    <td><code style="letter-spacing: -1px">&lt;csymbol encoding="text" definitionURL="http://www.sbml.org/sbml/symbols/avogadro"&gt; avogadro &lt;/csymbol/&gt;</code></td>
</tr>
<tr><td><code>time</code></td>   
    <td>Simulation time as defined in SBML</td>
    <td><code style="letter-spacing: -1px">&lt;csymbol encoding="text" definitionURL="http://www.sbml.org/sbml/symbols/time"&gt; time &lt;/csymbol/&gt;</code></td>
</tr>
<tr><td><code>inf</code>, <code>infinity</code></td>   
    <td>Mathematical constant "infinity"</td>
    <td><code>&lt;infinity/&gt;</code></td>
</tr>
<tr><td><code>nan</code>, <code>notanumber</code></td>   
    <td>Mathematical concept "not a number"</td>
    <td><code>&lt;notanumber/&gt;</code></td>
</tr>

<caption class="top-caption">Mathematical symbols defined
in the "Level&nbsp;3" text-string formula syntax.
</caption>
</table>

 <p>
 * Again, as mentioned above, whether the string
 * &quot;<code>avogadro</code>&quot; is parsed as an AST node of type
 * {@link libsbmlConstants#AST_NAME_AVOGADRO AST_NAME_AVOGADRO} or
 * {@link libsbmlConstants#AST_NAME AST_NAME} is configurable; use the version of
 * the parser function called <a href='libsbml.html#parseL3FormulaWithSettings(java.lang.String, org.sbml.libsbml.L3ParserSettings)'><code>libsbml.parseL3FormulaWithSettings(String, L3ParserSettings)</code></a>.  This Avogadro-related
 * functionality is provided because SBML Level&nbsp;2 models may not use
 * {@link libsbmlConstants#AST_NAME_AVOGADRO AST_NAME_AVOGADRO} AST nodes.
 <p>
 * @param formula the text-string formula expression to be parsed.
 <p>
 * @return the root node of an AST representing the mathematical formula, or
 * <code>null</code> if an error occurred while parsing the formula.  When <code>null</code> is
 * returned, an error is recorded internally; information about the error can
 * be retrieved using <a href='libsbml.html#getLastParseL3Error()'><code>libsbml.getLastParseL3Error()</code></a>.
 <p>
 * 
 * <p>
 * @note We urge developers to keep in mind that the text-string formula
 * syntax is specific to libSBML.  <em>Neither MathML nor SBML define a
 * text-string format for mathematical formulas.</em> LibSBML's particular
 * syntax should not be considered to be a canonical or standard
 * general-purpose mathematical expression syntax.  LibSBML provides methods
 * for parsing and transforming text-string math formulas back and forth from
 * AST structures for the convenience of calling applications, but it is
 * important to keep the system's limitations in mind.
 <p>
   * @see <a href='libsbml.html#parseL3FormulaWithSettings(java.lang.String, org.sbml.libsbml.L3ParserSettings)'><code>libsbml.parseL3FormulaWithSettings(String, L3ParserSettings)</code></a>
 * @see <a href='libsbml.html#parseL3FormulaWithModel(java.lang.String, org.sbml.libsbml.Model)'><code>libsbml.parseL3FormulaWithModel(String, Model)</code></a>
 * @see <a href='libsbml.html#parseFormula(java.lang.String)'><code>libsbml.parseFormula(String)</code></a>
 * @see <a href='libsbml.html#formulaToL3StringWithSettings(org.sbml.libsbml.ASTNode, org.sbml.libsbml.L3ParserSettings)'><code>libsbml.formulaToL3StringWithSettings(ASTNode, L3ParserSettings)</code></a>
 * @see <a href='libsbml.html#formulaToL3String(org.sbml.libsbml.ASTNode)'><code>libsbml.formulaToL3String(ASTNode)</code></a>
 * @see <a href='libsbml.html#formulaToString(org.sbml.libsbml.ASTNode)'><code>libsbml.formulaToString(ASTNode)</code></a>
 * @see L3ParserSettings
 * @see <a href='libsbml.html#getDefaultL3ParserSettings()'><code>libsbml.getDefaultL3ParserSettings()</code></a>
 * @see <a href='libsbml.html#getLastParseL3Error()'><code>libsbml.getLastParseL3Error()</code></a>
 */ public
 static ASTNode parseL3Formula(String formula) {
    long cPtr = libsbmlJNI.parseL3Formula(formula);
    return (cPtr == 0) ? null : new ASTNode(cPtr, true);
  }

  
/**
 * Parses a text string as a mathematical formula using a {@link Model} to resolve
 * symbols, and returns an AST representation of the result.
 <p>
 * This is identical to <a href='libsbml.html#parseL3Formula(java.lang.String)'><code>libsbml.parseL3Formula(String)</code></a>, except
 * that this function uses the given model in the argument <code>model</code> to check
 * against identifiers that appear in the <code>formula</code>.  For more information
 * about the parser, please see the definition of {@link L3ParserSettings} and
 * the function <a href='libsbml.html#parseL3Formula(java.lang.String)'><code>libsbml.parseL3Formula(String)</code></a>.
 <p>
 * @param formula the mathematical formula expression to be parsed.
 <p>
 * @param model the {@link Model} object to use for checking identifiers.
 <p>
 * @return the root node of an AST representing the mathematical formula,
 * or <code>null</code> if an error occurred while parsing the formula.  When <code>null</code>
 * is returned, an error is recorded internally; information about the
 * error can be retrieved using <a href='libsbml.html#getLastParseL3Error()'><code>libsbml.getLastParseL3Error()</code></a>.
 <p>
 * @see <a href='libsbml.html#parseL3Formula(java.lang.String)'><code>libsbml.parseL3Formula(String)</code></a>
 * @see <a href='libsbml.html#parseL3FormulaWithSettings(java.lang.String, org.sbml.libsbml.L3ParserSettings)'><code>libsbml.parseL3FormulaWithSettings(String, L3ParserSettings)</code></a>
 * @see <a href='libsbml.html#parseL3FormulaWithModel(java.lang.String, org.sbml.libsbml.Model)'><code>libsbml.parseL3FormulaWithModel(String, Model)</code></a>
 * @see <a href='libsbml.html#parseFormula(java.lang.String)'><code>libsbml.parseFormula(String)</code></a>
 * @see <a href='libsbml.html#getLastParseL3Error()'><code>libsbml.getLastParseL3Error()</code></a>
 * @see L3ParserSettings
 */ public
 static ASTNode parseL3FormulaWithModel(String formula, Model model) {
    long cPtr = libsbmlJNI.parseL3FormulaWithModel(formula, Model.getCPtr(model), model);
    return (cPtr == 0) ? null : new ASTNode(cPtr, true);
  }

  
/**
 * Parses a text string as a mathematical formula using specific parser
 * settings and returns an AST representation of the result.
 <p>
 * This is identical to <a href='libsbml.html#parseL3Formula(java.lang.String)'><code>libsbml.parseL3Formula(String)</code></a>, except
 * that this function uses the parser settings given in the argument 
 * <code>settings</code>.  The settings override the default parsing behavior.  The
 * following parsing behaviors can be configured:
 <p>
 * <p>
 * <ul>
 * <li> A {@link Model} object may optionally be provided to use identifiers (values
 * of type <code>SId</code>) from the model in preference to pre-defined MathML symbols
 * More precisely, the {@link Model} entities whose identifiers will shadow identical
 * symbols in the mathematical formula are: {@link Species}, {@link Compartment}, {@link Parameter},
 * {@link Reaction}, and {@link SpeciesReference}.  For instance, if the parser is given a
 * {@link Model} containing a {@link Species} with the identifier
 * &quot;<code>pi</code>&quot;, and the formula to be parsed is
 * &quot;<code>3*pi</code>&quot;, the MathML produced by the parser will
 * contain the construct <code>&lt;ci&gt; pi &lt;/ci&gt;</code> instead of
 * the construct <code>&lt;pi/&gt;</code>.  Another example, if the passed-in
 * {@link Model} contains a {@link FunctionDefinition} with the identifier
 * &quot;<code>sin</code>&quot;, that function will be used instead of the
 * predefined MathML function <code>&lt;sin/&gt;</code>.
 * <li> The function <code>log</code> with a single argument
 * (&quot;<code>log(x)</code>&quot;) can be parsed as <code>log10(x)</code>,
 * <code>ln(x)</code>, or treated as an error, as desired.
 * <li> Unary minus signs can be either collapsed or preserved; that is, the
 * parser can either (1) remove sequential pairs of unary minuses (e.g.,
 * &quot;<code>- -3</code>&quot;) from the input and incorporate single unary
 * minuses into the number node, or (2) preserve all minuses in the AST node
 * structure, turning them into {@link ASTNode} objects of type
 * {@link libsbmlConstants#AST_MINUS AST_MINUS}.
 * <li> The character sequence &quot;<code>number id</code>&quot; can be
 * interpreted as a numerical value <code>number</code> followed by units of measurement
 * indicated by <code>id</code>, or it can be treated as a syntax error.  (In
 * Level&nbsp;3, MathML <code>&lt;cn&gt;</code> elements can have an
 * attribute named <code>units</code> placed in the SBML namespace, which can be used
 * to indicate the units to be associated with the number.  The text-string
 * infix formula parser allows units to be placed after raw numbers; they are
 * interpreted as unit identifiers for units defined by the SBML
 * specification or in the containing {@link Model} object.)
 * <li> The symbol <code>avogadro</code> can be parsed either as a MathML <em>csymbol</em> or
 * as a identifier.  More specifically, &quot;<code>avogadro</code>&quot; can
 * be treated as an {@link ASTNode} of type
 * {@link libsbmlConstants#AST_NAME_AVOGADRO AST_NAME_AVOGADRO} or of type
 * {@link libsbmlConstants#AST_NAME AST_NAME}.
 * <li> Strings that match built-in functions and constants can either be parsed
 * as a match regardless of capitalization, or may be required to be
 * all-lower-case to be considered a match.
 * <li> LibSBML plug-ins implementing support for SBML Level&nbsp;3 packages
 * may introduce extensions to the syntax understood by the parser.  The
 * precise nature of the extensions will be documented by the individual
 * package plug-ins.  An example of a possible extension is a notation for
 * vectors and arrays, introduced by the SBML Level&nbsp;3 <em>Arrays</em>
 * package.
 *
 * </ul>
 <p>
 * For more details about the parser, please see the definition of
 * {@link L3ParserSettings} and <a href='libsbml.html#parseL3FormulaWithSettings(java.lang.String, org.sbml.libsbml.L3ParserSettings)'><code>libsbml.parseL3FormulaWithSettings(String, L3ParserSettings)</code></a>.
 <p>
 * @param formula the mathematical formula expression to be parsed.
 <p>
 * @param settings the settings to be used for this parser invocation.
 <p>
 * @return the root node of an AST representing the mathematical formula,
 * or <code>null</code> if an error occurred while parsing the formula.  When <code>null</code>
 * is returned, an error is recorded internally; information about the
 * error can be retrieved using <a href='libsbml.html#getLastParseL3Error()'><code>libsbml.getLastParseL3Error()</code></a>.
 <p>
 * @see <a href='libsbml.html#parseL3Formula(java.lang.String)'><code>libsbml.parseL3Formula(String)</code></a>
 * @see <a href='libsbml.html#parseL3FormulaWithSettings(java.lang.String, org.sbml.libsbml.L3ParserSettings)'><code>libsbml.parseL3FormulaWithSettings(String, L3ParserSettings)</code></a>
 * @see <a href='libsbml.html#parseL3FormulaWithModel(java.lang.String, org.sbml.libsbml.Model)'><code>libsbml.parseL3FormulaWithModel(String, Model)</code></a>
 * @see <a href='libsbml.html#parseFormula(java.lang.String)'><code>libsbml.parseFormula(String)</code></a>
 * @see <a href='libsbml.html#getLastParseL3Error()'><code>libsbml.getLastParseL3Error()</code></a>
 * @see L3ParserSettings
 */ public
 static ASTNode parseL3FormulaWithSettings(String formula, L3ParserSettings settings) {
    long cPtr = libsbmlJNI.parseL3FormulaWithSettings(formula, L3ParserSettings.getCPtr(settings), settings);
    return (cPtr == 0) ? null : new ASTNode(cPtr, true);
  }

  
/**
 * Returns a copy of the default Level&nbsp;3 ('L3') formula parser settings.
 <p>
 * The data structure storing the settings allows callers to change the
 * following parsing behaviors:
 <p>
 * <p>
 * The text-string form of mathematical formulas read by the function
 * <a href='libsbml.html#parseL3Formula(java.lang.String)'><code>libsbml.parseL3Formula(String)</code></a> and written by the function
 * <a href='libsbml.html#formulaToL3String(org.sbml.libsbml.ASTNode)'><code>libsbml.formulaToL3String(ASTNode)</code></a> uses an expanded version of
 * the syntax read and written by <a href='libsbml.html#parseFormula(java.lang.String)'><code>libsbml.parseFormula(String)</code></a>
 * and <a href='libsbml.html#formulaToString(org.sbml.libsbml.ASTNode)'><code>libsbml.formulaToString(ASTNode)</code></a>, respectively.  The
 * latter two libSBML functions were originally developed to support
 * conversion between SBML Levels&nbsp;1 and&nbsp;2, and were focused on the
 * syntax of mathematical formulas used in SBML Level&nbsp;1.  With time, and
 * the use of MathML in SBML Levels&nbsp;2 and&nbsp;3, it became clear that
 * supporting Level&nbsp;2 and&nbsp;3's expanded mathematical syntax would be
 * useful for software developers.  To maintain backwards compatibility for
 * libSBML users, the original <a href='libsbml.html#formulaToString(org.sbml.libsbml.ASTNode)'><code>libsbml.formulaToString(ASTNode)</code></a>
 * and <a href='libsbml.html#parseFormula(java.lang.String)'><code>libsbml.parseFormula(String)</code></a> have been left untouched,
 * and instead, the new functionality is provided in the form of
 * <a href='libsbml.html#parseL3Formula(java.lang.String)'><code>libsbml.parseL3Formula(String)</code></a> and
 * <a href='libsbml.html#formulaToL3String(org.sbml.libsbml.ASTNode)'><code>libsbml.formulaToL3String(ASTNode)</code></a>.
 <p>
 * The following lists the main differences in the formula syntax supported by
 * the Level 3 ('L3') versions of the formula parsers and formatters,
 * compared to what is supported by the Level&nbsp;1-oriented
 * <a href='libsbml.html#parseFormula(java.lang.String)'><code>libsbml.parseFormula(String)</code></a> and
 * <a href='libsbml.html#formulaToString(org.sbml.libsbml.ASTNode)'><code>libsbml.formulaToString(ASTNode)</code></a>:
 <p>
 * <ul>
 * <li> Units may be asociated with bare numbers, using the following syntax:
 * <div style='margin: 10px auto 10px 25px; display: block'>
 * <span class='code' style='background-color: #d0d0ee'>number</span>
 * <span class='code' style='background-color: #edd'>unit</span>
 * </div>
 * The <span class='code' style='background-color: #d0d0ee'>number</span>
 * may be in any form (an integer, real, or rational
 * number), and the
 * <span class='code' style='background-color: #edd'>unit</span>
 * must conform to the syntax of an SBML identifier (technically, the
 * type defined as <code>SId</code> in the SBML specifications).  The whitespace between
 * <span class='code' style='background-color: #d0d0ee'>number</span>
 * and <span class='code' style='background-color: #edd'>unit</span>
 * is optional.
 <p>
 * <li> The Boolean function symbols <code>&&</code> (<em>and</em>), <code>||</code> (<em>or</em>), <code>!</code> (<em>not</em>),
 * and <code>!=</code> (<em>not</em> <em>equals</em>) may be used.
 <p>
 * <li> The <em>modulo</em> operation is allowed as the symbol <code>@%</code> and will
 * produce a <code>&lt;piecewise&gt;</code> function in the corresponding
 * MathML output by default, or can produce the MathML function <code>rem</code>, 
 * depending on the {@link L3ParserSettings} object (see 
 * L3ParserSettings_setParseModuloL3v2() ).
 <p>
 * <li> All inverse trigonometric functions may be defined in the infix either
 * using <code>arc</code> as a prefix or simply <code>a</code>; in other words, both <code>arccsc</code>
 * and <code>acsc</code> are interpreted as the operator <em>arccosecant</em> as defined in
 * MathML&nbsp;2.0.  (Many functions in the simpler SBML Level&nbsp;1
 * oriented parser implemented by <a href='libsbml.html#parseFormula(java.lang.String)'><code>libsbml.parseFormula(String)</code></a>
 * are defined this way as well, but not all.)
 <p>
 * <li> The following expression is parsed as a rational number instead of
 * as a numerical division:
 * <pre style='display: block; margin-left: 25px'>
 * (<span class='code' style='background-color: #d0d0ee'>integer</span>/<span class='code' style='background-color: #d0d0ee'>integer</span>)</pre>
 * <strong>Spaces are not allowed</strong> in this construct; in other words,
 * &quot;<code>(3 / 4)</code>&quot; (with whitespace between the numbers and
 * the operator) will be parsed into the MathML <code>&lt;divide&gt;</code>
 * construct rather than a rational number.  You can, however, assign units to a
 * rational number as a whole; here is an example: &quot;<code>(3/4) ml</code>&quot;.
 * (In the case of division rather than a rational number, units are not interpreted
 * in this way.)
 <p>
 * <li> Various parser and formatter behaviors may be altered through the use
 * of a {@link L3ParserSettings} object in conjunction with the functions
 * <a href='libsbml.html#parseL3FormulaWithSettings(java.lang.String, org.sbml.libsbml.L3ParserSettings)'><code>libsbml.parseL3FormulaWithSettings(String, L3ParserSettings)</code></a> and
 * <a href='libsbml.html#formulaToL3StringWithSettings(org.sbml.libsbml.ASTNode, org.sbml.libsbml.L3ParserSettings)'><code>libsbml.formulaToL3StringWithSettings(ASTNode, L3ParserSettings)</code></a>
 * The settings available include the following:
 * <ul style='list-style-type: circle'>
 *
 * </ul> <p>
 * <li style='margin-bottom: 0.5em'> The function <code>log</code> with a single
 * argument (&quot;<code>log(x)</code>&quot;) can be parsed as
 * <code>log10(x)</code>, <code>ln(x)</code>, or treated as an error, as
 * desired.
 <p>
 * <li style='margin-bottom: 0.5em'> Unary minus signs can be collapsed or
 * preserved; that is, sequential pairs of unary minuses (e.g., &quot;<code>-
 * -3</code>&quot;) can be removed from the input entirely and single unary
 * minuses can be incorporated into the number node, or all minuses can be
 * preserved in the AST node structure.
 <p>
 * <li style='margin-bottom: 0.5em'> Parsing of units embedded in the input
 * string can be turned on and off.
 <p>
 * <li style='margin-bottom: 0.5em'> The string <code>avogadro</code> can be parsed as
 * a MathML <em>csymbol</em> or as an identifier.
 <p>
 * <li style='margin-bottom: 0.5em'> The string @% can be parsed either as a 
 * piecewise function or as the 'rem' function:  <code>a @% b</code> will either
 * become
 <p>
 * <code>piecewise(a - b*ceil(a/b), xor((a < 0), (b < 0)), a - b*floor(a/b))</code>
 <p>
 * or 
 <p>
 * <code>rem(a, b)</code>.
 <p>
 * The latter is simpler, but the <code>rem</code> MathML is only allowed
 * as of SBML Level&nbsp;3 Version&nbsp;2.</li>
 <p>
 * <li style='margin-bottom: 0.5em'> A {@link Model} object may optionally be
 * provided to the parser using the variant function call
 * <a href='libsbml.html#parseL3FormulaWithModel(java.lang.String, org.sbml.libsbml.Model)'><code>libsbml.parseL3FormulaWithModel(String, Model)</code></a> or
 * stored in a {@link L3ParserSettings} object passed to the variant function
 * <a href='libsbml.html#parseL3FormulaWithSettings(java.lang.String, org.sbml.libsbml.L3ParserSettings)'><code>libsbml.parseL3FormulaWithSettings(String, L3ParserSettings)</code></a>.  When a {@link Model} object is provided, identifiers
 * (values of type <code>SId</code> ) from that model are used in preference to
 * pre-defined MathML definitions for both symbols and functions.
 * More precisely:
 * <ul style='list-style-type: square'>
 <p>
 * <li style='margin-bottom: 0.5em'> <em>In the case of symbols</em>: the
 * {@link Model} entities whose identifiers will shadow identical symbols in the
 * mathematical formula are: {@link Species}, {@link Compartment}, {@link Parameter}, {@link Reaction}, and
 * {@link SpeciesReference}.  For instance, if the parser is given a {@link Model} containing
 * a {@link Species} with the identifier &quot;<code>pi</code>&quot;, and the formula
 * to be parsed is &quot;<code>3*pi</code>&quot;, the MathML produced will
 * contain the construct <code>&lt;ci&gt; pi &lt;/ci&gt;</code> instead of
 * the construct <code>&lt;pi/&gt;</code>.
 <p>
 * <li style='margin-bottom: 0.5em'> <em>In the case of user-defined
 * functions</em>: when a {@link Model} object is provided, <code>SId</code> values of
 * user-defined functions present in the model will be used preferentially
 * over pre-defined MathML functions.  For example, if the passed-in {@link Model}
 * contains a {@link FunctionDefinition} object with the identifier
 * &quot;<code>sin</code>&quot;, that function will be used instead of the
 * predefined MathML function <code>&lt;sin/&gt;</code>.
 * </ul>
 <p>
 * <li style='margin-bottom: 0.5em'> An {@link SBMLNamespaces} object may optionally
 * be provided to identify SBML Level&nbsp;3 packages that extend the
 * syntax understood by the formula parser.  When the namespaces are provided,
 * the parser will interpret possible additional syntax defined by the libSBML
 * plug-ins implementing the SBML Level&nbsp;3 packages; for example, it may
 * understand vector/array extensions introduced by the SBML Level&nbsp;3 
 * <em>Arrays</em> package.
 * </ul>
 <p>
 * These configuration settings cannot be changed directly using the basic
 * parser and formatter functions, but <em>can</em> be changed on a per-call basis
 * by using the alternative functions <a href='libsbml.html#parseL3FormulaWithSettings(java.lang.String, org.sbml.libsbml.L3ParserSettings)'><code>libsbml.parseL3FormulaWithSettings(String, L3ParserSettings)</code></a> and
 * <a href='libsbml.html#formulaToL3StringWithSettings(org.sbml.libsbml.ASTNode, org.sbml.libsbml.L3ParserSettings)'><code>libsbml.formulaToL3StringWithSettings(ASTNode, L3ParserSettings)</code></a>.
 <p>
 * Neither SBML nor the MathML standard define a 'string-form' equivalent to
 * MathML expressions.  The approach taken by libSBML is to start with the
 * formula syntax defined by SBML Level&nbsp;1 (which in fact used a custom
 * text-string representation of formulas, and not MathML), and expand it to
 * include the functionality described above.  This formula syntax is based
 * mostly on C programming syntax, and may contain operators, function calls,
 * symbols, and white space characters.  The following table provides the
 * precedence rules for the different entities that may appear in formula
 * strings.
 <p>
 * <table border="0" width="95%"
       class="centered text-table normal-font alt-row-colors"
       style="padding-bottom: 0.5em">
 <tr style="background: lightgray; font-size: 14px;">
     <th align="left">Token</th>
     <th align="left">Operation</th>
     <th align="left">Class</th>
     <th>Preced.</th>
     <th align="left">Assoc.</th>
 </tr>
<tr><td><em>name</em></td><td>symbol reference</td><td>operand</td><td align="center">8</td><td>n/a</td></tr>
<tr><td><code>(</code><em>expression</em><code>)</code></td><td>expression grouping</td><td>operand</td><td align="center">8</td><td>n/a</td></tr>
<tr><td><code>f(</code><em>...</em><code>)</code></td><td>function call</td><td>prefix</td><td align="center">8</td><td>left</td></tr>
<tr><td><code>^</code></td><td>power</td><td>binary</td><td align="center">7</td><td>left</td></tr>
<tr><td><code>-, !</code></td><td>negation, Boolean 'not'</td><td>unary</td><td align="center">6</td><td>right</td></tr>
<tr><td><code>*, /, %</code></td><td>multip., div., modulo</td><td>binary</td><td align="center">5</td><td>left</td></tr>
<tr><td><code>+, -</code></td><td>addition and subtraction</td><td>binary</td><td align="center">4</td><td>left</td></tr>
<tr><td><code>==, &lt;, &gt;, &lt;=, &gt;=, !=</code></td><td>Boolean comparisons</td><td>binary</td><td align="center">3</td><td>left</td></tr>
<tr><td><code>&&, ||</code></td><td>Boolean 'and' and 'or'</td><td>binary</td><td align="center">2</td><td>left</td></tr>
<tr><td><code>,</code></td><td>argument delimiter</td><td>binary</td><td align="center">1</td><td>left</td></tr>

<caption class="top-caption">Expression operators and their precedence in the
"Level&nbsp;3" text-string format for mathematical expressions.
</caption>
</table>


 <p>
 * In the table above, <em>operand</em> implies the construct is an operand, 
 * <em>prefix</em> implies the operation is applied to the following arguments, 
 * <em>unary</em> implies there is one argument, and <em>binary</em> implies there are
 * two arguments.  The values in the <b>Precedence</b> column show how the
 * order of different types of operation are determined.  For example, the
 * expression <code>a + b * c</code> is evaluated as <code>a + (b * c)</code>
 * because the @c * operator has higher precedence.  The
 * <b>Associates</b> column shows how the order of similar precedence
 * operations is determined; for example, <code>a && b || c</code> is
 * evaluated as <code>(a && b) || c</code> because the <code>&&</code> and <code>||</code>
 * operators are left-associative and have the same precedence.
 <p>
 * The function call syntax consists of a function name, followed by optional
 * white space, followed by an opening parenthesis token, followed by a
 * sequence of zero or more arguments separated by commas (with each comma
 * optionally preceded and/or followed by zero or more white space
 * characters), followed by a closing parenthesis token.  The function name
 * must be chosen from one of the pre-defined functions in SBML or a
 * user-defined function in the model.  The following table lists the names
 * of certain common mathematical functions; this table corresponds to
 * Table&nbsp;6 in the <a target='_blank'
 * href='http://sbml.org/Documents/Specifications#SBML_Level_1_Version_2'>SBML
 * Level&nbsp;1 Version&nbsp;2 specification</a> with additions based on the
 * functions added in SBML Level 2 and Level 3:
 <p>
 * <table border="0" width="95%" 
       class="centered text-table normal-font alt-row-colors">
 <tr>
     <th align="left" width="60">Name</th>
     <th align="left" width="75">Argument(s)</th>
     <th align="left">Formula or meaning</th>
     <th align="left" width="90">Argument Constraints</th>
     <th align="left" width="90">Result constraints</th>
 </tr>
<tr><td><code>abs</code></td>   
    <td><em>x</em></td> 
    <td>Absolute value of <em>x</em>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>acos</code>, <code>arccos</code></td>
    <td><em>x</em></td>
    <td>Arccosine of <em>x</em> in radians.</td>
    <td>&ndash;1.0 &le; <em>x</em> &le; 1.0</td>
    <td>0 &le; <em>acos(x)</em> &le; &pi;</td>
</tr>
<tr><td><code>acosh</code>, <code>arccosh</code></td>
    <td><em>x</em></td>
    <td>Hyperbolic arccosine of <em>x</em> in radians.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>acot</code>, <code>arccot</code></td>
    <td><em>x</em></td>
    <td>Arccotangent of <em>x</em> in radians.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>acoth</code>, <code>arccoth</code></td>
    <td><em>x</em></td>
    <td>Hyperbolic arccotangent of <em>x</em> in radians.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>acsc</code>, <code>arccsc</code></td>
    <td><em>x</em></td>
    <td>Arccosecant of <em>x</em> in radians.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>acsch</code>, <code>arccsch</code></td>
    <td><em>x</em></td>
    <td>Hyperbolic arccosecant of <em>x</em> in radians.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>asec</code>, <code>arcsec</code></td>
    <td><em>x</em></td>
    <td>Arcsecant of <em>x</em> in radians.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>asech</code>, <code>arcsech</code></td>
    <td><em>x</em></td>
    <td>Hyperbolic arcsecant of <em>x</em> in radians.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>asin</code>, <code>arcsin</code></td>
    <td><em>x</em></td><td>Arcsine of <em>x</em> in radians.</td>
    <td>&ndash;1.0 &le; <em>x</em> &le; 1.0</td>
    <td>0 &le; <em>asin(x)</em> &le; &pi;</td>
</tr>
<tr><td><code>atan</code>, <code>arctan</code></td>
    <td><em>x</em></td>
    <td>Arctangent of <em>x</em> in radians.</td>
    <td></td>
    <td>0 &le; <em>atan(x)</em> &le; &pi;</td>
</tr>
<tr><td><code>atanh</code>, <code>arctanh</code></td>
    <td><em>x</em></td>
    <td>Hyperbolic arctangent of <em>x</em> in radians.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>ceil</code>, <code>ceiling</code></td>
    <td><em>x</em></td>
    <td>Smallest number not less than <em>x</em> whose value is an exact integer.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>cos</code></td>
    <td><em>x</em></td>
    <td>Cosine of <em>x</em></td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>cosh</code></td>
    <td><em>x</em></td>
    <td>Hyperbolic cosine of <em>x</em>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>cot</code></td>
    <td><em>x</em></td>
    <td>Cotangent of <em>x</em>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>coth</code></td>
    <td><em>x</em></td>
    <td>Hyperbolic cotangent of <em>x</em>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>csc</code></td>
    <td><em>x</em></td>
    <td>Cosecant of <em>x</em>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>csch</code></td>
    <td><em>x</em></td>
    <td>Hyperbolic cosecant of <em>x</em>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>delay</code></td>
    <td><em>x, y</em></td>
    <td>The value of <em>x</em> at <em>y</em> time units in the past.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>factorial</code></td>
    <td><em>n</em></td>
    <td>The factorial of <em>n</em>. Factorials are defined by <em>n! = n*(n&ndash;1)* ... * 1</em>.</td>
    <td><em>n</em> must be an integer.</td>
    <td></td>
</tr>
<tr><td><code>exp</code></td>
    <td><em>x</em></td>
    <td><em>e</em><sup><em> x</em></sup>, where <em>e</em> is the base of the natural logarithm.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>floor</code></td>
    <td><em>x</em></td>
    <td>The largest number not greater than <em>x</em> whose value is an exact integer.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>ln</code></td>
    <td><em>x</em></td>
    <td>Natural logarithm of <em>x</em>.</td>
    <td><em>x</em> &gt; 0</td>
    <td></td>
</tr>
<tr><td><code>log</code></td>
    <td><em>x</em></td>
    <td>By default, the base 10 logarithm of <em>x</em>, but can be set to be the natural logarithm of <em>x</em>, or to be an illegal construct.</td>
    <td><em>x</em> &gt; 0</td>
    <td></td>
</tr>
<tr><td><code>log</code></td>
    <td><em>x, y</em></td>
    <td>The base <em>x</em> logarithm of <em>y</em>.</td>
    <td><em>y</em> &gt; 0</td>
    <td></td>
</tr>
<tr><td><code>log10</code></td>
    <td><em>x</em></td>
    <td>Base 10 logarithm of <em>x</em>.</td>
    <td><em>x</em> &gt; 0</td>
    <td></td>
</tr>
<tr><td><code>piecewise</code></td>
    <td><em>x1, y1, [x2, y2,] [...] [z]</em></td>
    <td>A piecewise function: if (<em>y1</em>), <em>x1</em>.  Otherwise, if (<em>y2</em>), <em>x2</em>, etc.  Otherwise, z. </td>
    <td><em>y1, y2, y3 [etc]</em> must be Boolean</td>
    <td></td>
</tr>
<tr><td><code>pow</code>, <code>power</code> </td>
    <td><em>x, y</em></td>
    <td><em>x</em><sup><em> y</em></sup>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>root</code></td>
    <td><em>b, x</em></td>
    <td>The root base <em>b</em> of <em>x</em>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>sec</code></td>
    <td><em>x</em></td>
    <td>Secant of <em>x</em>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>sech</code></td>
    <td><em>x</em></td>
    <td>Hyperbolic secant of <em>x</em>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>sqr</code></td>
    <td><em>x</em></td>
    <td><em>x</em><sup><em>2</em></sup>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>sqrt</code></td>
    <td><em>x</em></td>
    <td>&radic;<em>x</em>.</td>
    <td><em>x</em> &gt; 0</td>
    <td><em>sqrt(x)</em> &ge; 0</td>
</tr>
<tr><td><code>sin</code></td>
    <td><em>x</em></td>
    <td>Sine of <em>x</em>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>sinh</code></td>
    <td><em>x</em></td>
    <td>Hyperbolic sine of <em>x</em>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>tan</code></td>
    <td><em>x</em></td>
    <td>Tangent of <em>x</em>.</td>
    <td>x &ne; n*&pi;/2, for odd integer <em>n</em></td>
    <td></td>
</tr>
<tr><td><code>tanh</code></td>
    <td><em>x</em></td>
    <td>Hyperbolic tangent of <em>x</em>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>and</code></td>
    <td><em>x, y, z...</em></td>
    <td>Boolean <em>and(x, y, z...)</em>: returns <code>true</code> if all of its arguments are true.  Note that <code>and</code> is an n-ary function, taking 0 or more arguments, and that <code>and()</code> returns <code>true</code>.</td>
    <td>All arguments must be Boolean</td>
    <td></td>
</tr>
<tr><td><code>not</code></td>
    <td><em>x</em></td>
    <td>Boolean <em>not(x)</em></td>
    <td><em>x</em> must be Boolean</td>
    <td></td>
</tr>
<tr><td><code>or</code></td>
    <td><em>x, y, z...</em></td>
    <td>Boolean <em>or(x, y, z...)</em>: returns <code>true</code> if at least one of its arguments is true.  Note that <code>or</code> is an n-ary function, taking 0 or more arguments, and that <code>or()</code> returns <code>false</code>.</td>
    <td>All arguments must be Boolean</td>
    <td></td>
</tr>
<tr><td><code>xor</code></td>
    <td><em>x, y, z...</em></td>
    <td>Boolean <em>xor(x, y, z...)</em>: returns <code>true</code> if an odd number of its arguments is true.  Note that <code>xor</code> is an n-ary function, taking 0 or more arguments, and that <code>xor()</code> returns <code>false</code>.</td>
    <td>All arguments must be Boolean</td>
    <td></td>
</tr>
<tr><td><code>eq</code></td>
    <td><em>x, y, z...</em></td>
    <td>Boolean <em>eq(x, y, z...)</em>: returns <code>true</code> if all arguments are equal.  Note that <code>eq</code> is an n-ary function, but must take 2 or more arguments.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>geq</code></td>
    <td><em>x, y, z...</em></td>
    <td>Boolean <em>geq(x, y, z...)</em>: returns <code>true</code> if each argument is greater than or equal to the argument following it.  Note that <code>geq</code> is an n-ary function, but must take 2 or more arguments.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>gt</code></td>
    <td><em>x, y, z...</em></td>
    <td>Boolean <em>gt(x, y, z...)</em>: returns <code>true</code> if each argument is greater than the argument following it.  Note that <code>gt</code> is an n-ary function, but must take 2 or more arguments.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>leq</code></td>
    <td><em>x, y, z...</em></td>
    <td>Boolean <em>leq(x, y, z...)</em>: returns <code>true</code> if each argument is less than or equal to the argument following it.  Note that <code>leq</code> is an n-ary function, but must take 2 or more arguments.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>lt</code></td>
    <td><em>x, y, z...</em></td>
    <td>Boolean <em>lt(x, y, z...)</em>: returns <code>true</code> if each argument is less than the argument following it.  Note that <code>lt</code> is an n-ary function, but must take 2 or more arguments.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>neq</code></td>
    <td><em>x, y</em></td>
    <td>Boolean <em>x</em> != <em>y</em>: returns <code>true</code> unless x and y are equal.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>plus</code></td>
    <td><em>x, y, z...</em></td>
    <td><em>x</em> + <em>y</em> + <em>z</em> + <em>...</em>: The sum of the arguments of the function.  Note that <code>plus</code> is an n-ary function taking 0 or more arguments, and that <code>plus()</code> returns <code>0</code>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>times</code></td>
    <td><em>x, y, z...</em></td>
    <td><em>x</em> * <em>y</em> * <em>z</em> * <em>...</em>: The product of the arguments of the function.  Note that <code>times</code> is an n-ary function taking 0 or more arguments, and that <code>times()</code> returns <code>1</code>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>minus</code></td>
    <td><em>x, y</em></td>
    <td><em>x</em> &ndash; <em>y</em>.</td>
    <td></td>
    <td></td>
</tr>
<tr><td><code>divide</code></td>
    <td><em>x, y</em></td>
    <td><em>x</em> / <em>y</em>.</td>
    <td></td>
    <td></td>
</tr>

<caption class="top-caption">Mathematical functions defined
in the "Level&nbsp;3" text-string formula syntax.</caption>

</table>


 <p>
 * Parsing of the various MathML functions and constants are all
 * case-insensitive by default: function names such as <code>cos</code>,
 * <code>Cos</code> and <code>COS</code> are all parsed as the MathML cosine
 * operator, <code>&lt;cos&gt;</code>.  However, <em>when a {@link Model} object is
 * used</em> in conjunction with either
 * <a href='libsbml.html#parseL3FormulaWithModel(java.lang.String, org.sbml.libsbml.Model)'><code>libsbml.parseL3FormulaWithModel(String, Model)</code></a> or
 * <a href='libsbml.html#parseL3FormulaWithSettings(java.lang.String, org.sbml.libsbml.L3ParserSettings)'><code>libsbml.parseL3FormulaWithSettings(String, L3ParserSettings)</code></a>, any identifiers found in that model will be
 * parsed in a case-<em>sensitive</em> way.  For example, if a model contains
 * a {@link Species} having the identifier <code>Pi</code>, the parser will parse
 * &quot;<code>Pi</code>&quot; in the input as &quot;<code>&lt;ci&gt; Pi
 * &lt;/ci&gt;</code>&quot; but will continue to parse the symbols
 * &quot;<code>pi</code>&quot; and &quot;<code>PI</code>&quot; as
 * &quot;<code>&lt;pi&gt;</code>&quot;.
 <p>
 * As mentioned above, the manner in which the 'L3' versions of the formula
 * parser and formatter interpret the function &quot;<code>log</code>&quot;
 * can be changed.  To do so, callers should use the function
 * <a href='libsbml.html#parseL3FormulaWithSettings(java.lang.String, org.sbml.libsbml.L3ParserSettings)'><code>libsbml.parseL3FormulaWithSettings(String, L3ParserSettings)</code></a> and pass it an appropriate {@link L3ParserSettings}
 * object.  By default, unlike the SBML Level&nbsp;1 parser implemented by
 * <a href='libsbml.html#parseFormula(java.lang.String)'><code>libsbml.parseFormula(String)</code></a>, the string
 * &quot;<code>log</code>&quot; is interpreted as the base&nbsp;10 logarithm,
 * and <em>not</em> as the natural logarithm.  However, you can change the
 * interpretation to be base-10 log, natural log, or as an error; since the
 * name 'log' by itself is ambiguous, you require that the parser uses
 * <code>log10</code> or <code>ln</code> instead, which are more clear.  Please refer to
 * <a href='libsbml.html#parseL3FormulaWithSettings(java.lang.String, org.sbml.libsbml.L3ParserSettings)'><code>libsbml.parseL3FormulaWithSettings(String, L3ParserSettings)</code></a>.
 <p>
 * In addition, the following symbols will be translated to their MathML
 * equivalents, if no symbol with the same <code>SId</code> identifier string exists
 * in the {@link Model} object provided:
 <p>
 * <table border="0" width="95%"
       class="centered text-table normal-font alt-row-colors">
 <tr>
     <th align="left" width="60">Name</th>
     <th align="left" width="250">Meaning</th>
     <th align="left">MathML</th>
 </tr>
<tr><td><code>true</code></td>   
    <td>Boolean value <code>true</code></td>
    <td><code>&lt;true/&gt;</code></td>
</tr>
<tr><td><code>false</code></td>   
    <td>Boolean value <code>false</code></td>
    <td><code>&lt;false/&gt;</code></td>
</tr>
<tr><td><code>pi</code></td>   
    <td>Mathematical constant pi</td>
    <td><code>&lt;pi/&gt;</code></td>
</tr>
<tr><td><code>avogadro</code></td>   
    <td>Value of Avogadro's constant stipulated by SBML</td>
    <td><code style="letter-spacing: -1px">&lt;csymbol encoding="text" definitionURL="http://www.sbml.org/sbml/symbols/avogadro"&gt; avogadro &lt;/csymbol/&gt;</code></td>
</tr>
<tr><td><code>time</code></td>   
    <td>Simulation time as defined in SBML</td>
    <td><code style="letter-spacing: -1px">&lt;csymbol encoding="text" definitionURL="http://www.sbml.org/sbml/symbols/time"&gt; time &lt;/csymbol/&gt;</code></td>
</tr>
<tr><td><code>inf</code>, <code>infinity</code></td>   
    <td>Mathematical constant "infinity"</td>
    <td><code>&lt;infinity/&gt;</code></td>
</tr>
<tr><td><code>nan</code>, <code>notanumber</code></td>   
    <td>Mathematical concept "not a number"</td>
    <td><code>&lt;notanumber/&gt;</code></td>
</tr>

<caption class="top-caption">Mathematical symbols defined
in the "Level&nbsp;3" text-string formula syntax.
</caption>
</table>

 <p>
 * Again, as mentioned above, whether the string
 * &quot;<code>avogadro</code>&quot; is parsed as an AST node of type
 * {@link libsbmlConstants#AST_NAME_AVOGADRO AST_NAME_AVOGADRO} or
 * {@link libsbmlConstants#AST_NAME AST_NAME} is configurable; use the version of
 * the parser function called <a href='libsbml.html#parseL3FormulaWithSettings(java.lang.String, org.sbml.libsbml.L3ParserSettings)'><code>libsbml.parseL3FormulaWithSettings(String, L3ParserSettings)</code></a>.  This Avogadro-related
 * functionality is provided because SBML Level&nbsp;2 models may not use
 * {@link libsbmlConstants#AST_NAME_AVOGADRO AST_NAME_AVOGADRO} AST nodes.
 <p>
 * For more details about the parser, please see the definition of
 * {@link L3ParserSettings} and <a href='libsbml.html#parseL3Formula(java.lang.String)'><code>libsbml.parseL3Formula(String)</code></a>.
 <p>
 * @see <a href='libsbml.html#parseL3Formula(java.lang.String)'><code>libsbml.parseL3Formula(String)</code></a>
 * @see <a href='libsbml.html#parseL3FormulaWithSettings(java.lang.String, org.sbml.libsbml.L3ParserSettings)'><code>libsbml.parseL3FormulaWithSettings(String, L3ParserSettings)</code></a>
 * @see <a href='libsbml.html#formulaToL3StringWithSettings(org.sbml.libsbml.ASTNode, org.sbml.libsbml.L3ParserSettings)'><code>libsbml.formulaToL3StringWithSettings(ASTNode, L3ParserSettings)</code></a>
 * @see L3ParserSettings
 */ public
 static L3ParserSettings getDefaultL3ParserSettings() {
    long cPtr = libsbmlJNI.getDefaultL3ParserSettings();
    return (cPtr == 0) ? null : new L3ParserSettings(cPtr, true);
  }

  
/**
 * Returns the last error reported by the 'L3' mathematical formula parser.
 <p>
 * If the functions <a href='libsbml.html#parseL3Formula(java.lang.String)'><code>libsbml.parseL3Formula(String)</code></a>,
 * <a href='libsbml.html#parseL3FormulaWithSettings(java.lang.String, org.sbml.libsbml.L3ParserSettings)'><code>libsbml.parseL3FormulaWithSettings(String, L3ParserSettings)</code></a>, or <a href='libsbml.html#parseL3FormulaWithModel(java.lang.String, org.sbml.libsbml.Model)'><code>libsbml.parseL3FormulaWithModel(String, Model)</code></a> return <code>null</code>, an error is set internally.
 * This function allows callers to retrieve information about the error.
 <p>
 * @return a string describing the error that occurred.  This will contain
 * the input string the parser was trying to parse, the character it had
 * parsed when it encountered the error, and a description of the error.
 <p>
 * @see <a href='libsbml.html#parseL3Formula(java.lang.String)'><code>libsbml.parseL3Formula(String)</code></a>
 * @see <a href='libsbml.html#parseL3FormulaWithSettings(java.lang.String, org.sbml.libsbml.L3ParserSettings)'><code>libsbml.parseL3FormulaWithSettings(String, L3ParserSettings)</code></a>
 * @see <a href='libsbml.html#parseL3FormulaWithModel(java.lang.String, org.sbml.libsbml.Model)'><code>libsbml.parseL3FormulaWithModel(String, Model)</code></a>
 * @see <a href='libsbml.html#getDefaultL3ParserSettings()'><code>libsbml.getDefaultL3ParserSettings()</code></a>
 */ public
 static String getLastParseL3Error() {
    return libsbmlJNI.getLastParseL3Error();
  }

  
/** * @internal */ public
 static void SBML_deleteL3Parser() {
    libsbmlJNI.SBML_deleteL3Parser();
  }

}
