{- git-annex test data types.
 -
 - Copyright 2011-2017 Joey Hess <id@joeyh.name>
 -
 - Licensed under the GNU GPL version 3 or higher.
 -}

{-# LANGUAGE CPP #-}

module Types.Test where

import Test.Tasty.Options
import Data.Monoid
import qualified Data.Semigroup as Sem
import Prelude

import Types.Command

data TestOptions = TestOptions
	{ tastyOptionSet :: OptionSet
	, keepFailuresOption :: Bool
	, fakeSsh :: Bool
	, internalData :: CmdParams
	}

instance Sem.Semigroup TestOptions where
	a <> b = TestOptions
		(tastyOptionSet a <> tastyOptionSet b)
		(keepFailuresOption a || keepFailuresOption b)
		(fakeSsh a || fakeSsh b)
		(internalData a <> internalData b)

instance Monoid TestOptions where
	mempty = TestOptions mempty False False mempty
#if ! MIN_VERSION_base(4,11,0)
	mappend = (Sem.<>)
#endif

type TestRunner = TestOptions -> IO ()
