# Voice Notes|deepin-voice-note|

## Overview

Voice Notes is a simple memo software with texts and voice recordings. With it, you are able to record your daily life and work in MP3 format or texts. 

## Guide

You can run, exit, and create a shortcut for Voice Notes in the following ways.

### Run Voice Notes

1. Click the Launcher icon ![deepin_launcher](../common/deepin_launcher.svg) in the Dock to enter the Launcher interface.
2. Locate Voice Notes![deepin_voice_note](../common/deepin_voice_note.svg) by scrolling the mouse wheel or searching "voice notes" in the Launcher interface, and click it to run.
3. Right-click ![deepin_voice_note](../common/deepin_voice_note.svg), and you can:
   - Click **Send to desktop** to create a desktop shortcut.
   - Click **Send to dock** to fix it in the Dock.
   - Click **Add to startup** to add the application to startup, and it will automatically run when the system starts up.

> ![notes](../common/notes.svg) Notes: If Voice Notes has been fixed in the Dock by default, you can click ![deepin_voice_note](../common/deepin_voice_note.svg) in the Dock to run it.

### Exit Voice Notes

- Click ![close](../common/close_icon.svg) on the Voice Notes interface to exit Voice Notes.
- Right-click ![deepin_voice_note](../common/deepin_voice_note.svg) in the Dock, and select **Close All** to exit.
- Click ![icon_menu](../common/icon_menu.svg) on the Voice Notes interface, and select **Exit** to exit.

### View Shortcuts

On the Voice Notes interface, press **Ctrl** + **Shift** + **?** on the keyboard to view shortcuts. Proficiency in shortcuts will greatly improve your efficiency.

![1|hotkey](fig/d_hotkey.png)

## Manage Notebooks

### Create Notebooks

- Click **Create Notebook** to create a new notebook when there is none in Voice Notes.
- Click **Create Notebook** under the notebook list to create a new notebook. 

>![tips](../common/tips.svg)Tips: You can change the notebook order by dragging the notebook in the notebook list. Click the ![icon](../common/view.svg) icon to hide the notebook list and click the icon once again to display it.

### Rename Notebooks

The notebook created will be automatically saved as **Note (n)**. You can rename it in the following steps. 

1. On the Voice Notes interface, right-click a notebook.
2. Select **Rename**.
3. Enter the file name.
4. Click in the blank area on the interface, or press the **Enter** key on the keyboard to rename it.

![0|rename](fig/d_rename.png)

### Delete Notebooks

1. Select a notebook on the Voice Notes interface.
2. Right-click, and select **Delete** or press the **Delete** key on the keyboard.
3. Click **Confirm** in the pop-up prompt box.

## Manage Notes

### Create Notes

1. When a notebook is created in Voice Note, a text is also created by default. Click the ![add](../common/circlebutton_add2.svg) icon under the notes list to create more new notes.
2. Right-click a notebook or note and select **New Note** to create a new note.

![0|new](fig/d_create1.png)

#### Add Texts to Notes

1. Select a note in the note list, place the cursor in the right column and click to enter the text notes.
2. Select the texts and set the style (e.g. the font color and size) in the pop-up text toolbar.

![text_input](fig/d_txt_input.png)

#### Add Voices to Notes

1. Select a note on the Voice Notes interface and click  the ![record_normal](../common/record_normal.svg) icon  in its right column to start recording.

2. Click the ![finish](../common/finish_normal.svg) icon to finish recording.

>![notes](../common/notes.svg) Notes: Click the![pause](../common/pause_red_normal.svg) icon to pause recording during the recording process, and click ![record_normal](../common/record_normal.svg) again to resume recording. The maximum recording time is 60 minutes.  

3. Click the![play_blue_normal](../common/play_blue_normal.svg) icon to listen to the playback after the recording is completed.

![0|Recorder](fig/d_recorder2.png)

#### Add Pictures to Notes

You can add pictures to notes in one of the following ways:

- Click the ![icon](../common/pic.svg)icon  to import pictures from File Manager.
- Drag the picture to the right column directly.
- Copy and paste the picture to the the right column directly.

![pic](fig/picture.png)

### Rename Notes

1. Double-click the notes or right-click the notes in the notes list to select **Rename**.
2. Enter the new name in the text box. 
3. Click the blank area in the interface or press the **Enter** key on the keyboard to rename the notes.

### Search Notes

1. In the search box located in the top center area of the Voice Notes interface, you can click ![search](../common/search.svg) to enter keywords.
2. Press the **Enter** key on the keyboard to fast locate it.
3.  Click ![0|close](../common/close_icon.svg) in the search box  to clear the current keywords or cancel the search. 

### Move Notes

Select a text note or multiple text notes with **Ctrl/Shift** in the notes list and move the notes as needed in the following ways:

- Drag the notes to another notebook.
- Right-click to select **Move**, select a notebook in the pop-up dialogue and click **Confirm** to move the text notes in the selected notebook.

![0|move](fig/d_move.png)

### Stick Notes on Top

1. Right-click a note in the note list.

2. Select **Sticky on Top** to place the notes on top.

   Right-click the notes and select **Unstick** to undo the former operation.

### Save Notes

1.  Select a text note or multiple text notes with **Ctrl/Shift** in the notes list.
2.  Right-click, and select **Save as HTML** or **Save as TXT**.
3.  Save the notes to the storage device in the chosen format.

> ![notes](../common/notes.svg) Notes: 
>
> - If you select **Save as TXT**, only the text notes, the the recording time and duration of the voice notes are saved rather than the voice content and pictures in it. 
> - If you select **Save as HTML**, only the text notes and pictures rather than the voice contents can be saved.

![0|save](fig/d_save_notes.png)

### Save Voices Recording

1.   Select a voice note or multiple voice notes with **Ctrl/Shift** in the notes list.
2.   Right-click, and select **Save voice recording** to save the voice notes selected in MP3 format.

>![tips](../common/tips.svg) Tips:  You can also right-click a voice file in the voice notes and select **Save as MP3** to save it in the storage device.

![0|save](fig/d_savevoice.png)

### Delete Notes

1.   Select a notes or multiple notes in the notes list with **Ctrl/Shift**.
2.  Right-click, and select **Delete** or press the **Delete** key on the keyboard.
3.  Click **Confirm** in the pop-up prompt box.

### Delete Voice Recording

1.  Select a voice file on the Voice Notes interface.
2.  Right-click, and select **Delete** or press the **Delete** key on the keyboard.

## Main Menu

On the main menu, you can set audio source, check privacy policy, switch window themes, view help manual, and get more information about Voice Notes.

### Settings

You can set up audio source from **Internal** and **Microphone** options.
1. On the Voice Notes interface, click ![icon_menu](../common/icon_menu.svg).
2. Set up audio source:
   - Select **Internal** source, and only system built-in sound will be recorded. 
   - Select **Microphone** source, and only microphone sound will be recorded. 

### Privacy Policy

1. On the Voice Notes interface, click ![icon_menu](../common/icon_menu.svg).
2. Click **Privacy Policy** to view the relevant content on privacy policies.


### Theme

The window theme provides three theme types, namely Light Theme, Dark Theme, and System Theme.
1. On the Voice Notes interface, click ![icon_menu](../common/icon_menu.svg).
2. Click **Theme** to select one theme.

### Help

1. On the Voice Notes interface, click ![icon_menu](../common/icon_menu.svg).
2. Click **Help** to view the manual of Voice Notes.

### About

1. On the Voice Notes interface, click ![icon_menu](../common/icon_menu.svg). 
2. Click **About** to view the version and introduction of Voice Notes.

### Exit

1. On the Voice Notes interface, click ![icon_menu](../common/icon_menu.svg).
2. Click **Exit** to exit Voice Notes.
