{ -*- buffer-read-only: t -*-

  Copyright 2015-2018 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in nodes_specification/components/ ,
  - and regenerate include files by running
    nodes_specification/x3d-nodes-to-pascal/x3d-nodes-to-pascal.lpr .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetConvex: boolean;
    procedure SetConvex(const Value: boolean);
    function GetCreaseAngle: Single;
    procedure SetCreaseAngle(const Value: Single);
  public
    procedure SetColorIndex(const Value: array of LongInt);
    procedure SetColorIndex(const Value: TLongIntList);
    property Convex: boolean read GetConvex write SetConvex;
    procedure SetCoordIndex(const Value: array of LongInt);
    procedure SetCoordIndex(const Value: TLongIntList);
    property CreaseAngle: Single read GetCreaseAngle write SetCreaseAngle;
    procedure SetNormalIndex(const Value: array of LongInt);
    procedure SetNormalIndex(const Value: TLongIntList);
    procedure SetTexCoordIndex(const Value: array of LongInt);
    procedure SetTexCoordIndex(const Value: TLongIntList);

{$endif read_interface}

{$ifdef read_implementation}

{ TIndexedFaceSetNode ----------------------------------------------- }

procedure TIndexedFaceSetNode.SetColorIndex(const Value: array of LongInt);
begin
  FdColorIndex.Send(Value);
end;

procedure TIndexedFaceSetNode.SetColorIndex(const Value: TLongIntList);
begin
  FdColorIndex.Send(Value);
end;

function TIndexedFaceSetNode.GetConvex: boolean;
begin
  Result := FdConvex.Value;
end;

procedure TIndexedFaceSetNode.SetConvex(const Value: boolean);
begin
  FdConvex.Send(Value);
end;

procedure TIndexedFaceSetNode.SetCoordIndex(const Value: array of LongInt);
begin
  FdCoordIndex.Send(Value);
end;

procedure TIndexedFaceSetNode.SetCoordIndex(const Value: TLongIntList);
begin
  FdCoordIndex.Send(Value);
end;

function TIndexedFaceSetNode.GetCreaseAngle: Single;
begin
  Result := FdCreaseAngle.Value;
end;

procedure TIndexedFaceSetNode.SetCreaseAngle(const Value: Single);
begin
  FdCreaseAngle.Send(Value);
end;

procedure TIndexedFaceSetNode.SetNormalIndex(const Value: array of LongInt);
begin
  FdNormalIndex.Send(Value);
end;

procedure TIndexedFaceSetNode.SetNormalIndex(const Value: TLongIntList);
begin
  FdNormalIndex.Send(Value);
end;

procedure TIndexedFaceSetNode.SetTexCoordIndex(const Value: array of LongInt);
begin
  FdTexCoordIndex.Send(Value);
end;

procedure TIndexedFaceSetNode.SetTexCoordIndex(const Value: TLongIntList);
begin
  FdTexCoordIndex.Send(Value);
end;

{$endif read_implementation}
